
#ifndef __CONSTANTS_H__
#define __CONSTANTS_H__

#define CURRENT_RUN_HISTORY "xffm%cxffm.runlist.2.dbh"
#define CURRENT_GO_HISTORY "xffm%cxffm.golist.2.dbh"
#define CURRENT_WORKDIR_HISTORY "xffm%cxffm.workdir.2.dbh"

/*#define D(x) {printf(x);fflush(NULL);}*/
 #define D(x)
#define ACTIVATE_BOOK	0X01
#define ACTIVATE_LOCAL	0X02
#define ACTIVATE_SMB	0X04
#define ACTIVATE_APPS	0X08
#define ACTIVATE_TRASH	0X10
#define ACTIVATE_FSTAB	0X20
#define ACTIVATE_FIND	0X40

#define __VY_FN__(y) ((strlen(y)<2 || !strchr(y,'/'))?abreviate(y):abreviate(strrchr(y,'/')+1) )
#define __VX_FN__(y) ((strlen(y)<2 || !strchr(y,'/'))? y:strrchr(y,'/')+1)
#define __AB_FN__(x) ((1)?__VY_FN__(x->path):__VX_FN__(x->path))
#define FILENAME(x) (x?( (x->path && strlen(x->path))?__AB_FN__(x):" " ):"null entry!")

#define NO_ICON -1

/* subtype: */

#define __XF_NETWG	0x01
#define __XF_NETWS	0x02
#define __XF_NETSHARE	0x03
#define __XF_NETPRINT	0x04
#define __XF_NETIPC	0x05

#define __NFS_TYPE	0x10
#define __PROC_TYPE	0x20
#define __CDFS_TYPE	0x40

#define __NETDIR	0x100
#define __NETHIDDEN	0x200
#define __NETREADONLY	0x400
#define __NETFILE	0x800

#define __SAMBA_SERVER	0x1000

#define  __IN_TERM	0x4000000
#define  __CUSTOM_ICON	0x8000000



/* type: */

#define TR_COPY		0x01
#define TR_MOVE		0x02
#define TR_LINK		0x04

#define GOTO_WAIT 	0x01
#define CALLBACK_WAIT	0x02
#define MONITOR_WAIT	0x04
#define REFRESH_WAIT	0x08
#define INPUT_WAIT	0x10
#define FIND_WAIT	0x20


/* this is arbitrary : */
#define MAX_ARGS 128

#define __MASK		0xffffffff
/* hex  . */
#define __XF_UNKNOWN	0x01
#define __XF_FIFO      	0x02
#define __XF_CHR       	0x03
#define __XF_DIR       	0x04
#define __XF_BLK       	0x05
#define __XF_REG       	0x06
#define __XF_LNK       	0x07
#define __XF_SOCK      	0x08
#define __XF_WHT       	0x09
#define __XF_FND	0x0a
#define __XF_RPM_CHILD	0x0b
#define __XF_TAR_CHILD	0x0c
#define __XF_FSTAB	0x0d
#define __XF_MASK	0x0f	/* no available type   */
/* hex : */
#define __NETWORK_TYPE	0x10
#define __LOCAL_TYPE	0x20
#define __FIND_TYPE	0x30
#define __BOOKMARK_TYPE	0x40
/*#define ___TYPE	0x50*/
#define __TRASH_TYPE	0x60
#define __FSTAB_TYPE	0x70
#define __APP_TYPE	0x80

#define __TREE_MASK	0xf0	/* more TREE types available */
/* hex .: */
#define __DUMMY_TYPE	0x100
#define __ROOT_TYPE	0x200
#define __EXPANDED	0x400
#define __LOADED	0x800
/* hex :: */
#define __SORT_SIZE	0x1000
#define __SORT_TIME	0x2000
#define __SORT_UID	0x3000
#define __SORT_GID	0x4000
#define __SORT_MASK	0x7000	/* 0 more SORT types available */
#define __TYPE_SUBSORT  0x8000

/* hex | */
#define __SORT_DESC	0x10000
#define __BROKEN_LNK	0x20000
#define __HAS_HIDDEN	0x40000
#define __SHOW_HIDDEN	0x80000

/* hex |. */
#define __DIR		0x100000	/* includes links to dirs */
#define __EXE		0x200000
#define __NOWRITE	0x400000
#define __NOACCESS	0x800000

/* hex |: */
#define __SIZE_M	0x1000000	/* slightly bigger 24 pt. */
#define __SIZE_L	0x2000000	/* even bigger 36 pt. */
#define __SIZE_XL	0x3000000	/* even bigger (not used now) */
#define __SIZE_MASK	0x3000000

#define  __MOUNTED	0x4000000
#define  __INCOMPLETE	0x8000000
#define  __CUT		0x10000000
#define  __ERASED_SPACE	0x20000000
#define  __SHOW_IMAGES	0x40000000 

/* hex |.: */
/*#define  __AVAILABLE	0x80000000 */



/******************************************************/

#define IS_IMAGE(x)	(strstr(x, ".tif") || strstr(x, ".TIF") ||  \
			 strstr(x, ".png") || strstr(x, ".PNG") || \
			 strstr(x, ".GIF") || strstr(x, ".gif") || \
			 strstr(x, ".JPG") || strstr(x, ".jpg") || \
			 strstr(x, ".JPEG") || strstr(x, ".jpeg") || \
			 strstr(x, ".XPM") || strstr(x, ".xpm") || \
			 strstr(x, ".pm") || strstr(x, ".PM") || \
			 strstr(x, ".bmp") || strstr(x, ".BMP")) 


#define SORT_OPTIONS 		(__SORT_MASK|__SORT_DESC|__TYPE_SUBSORT)
#define INHERIT_OPTIONS 	(__SHOW_HIDDEN|__SIZE_MASK|SORT_OPTIONS|__TREE_MASK|__SHOW_IMAGES)
#define INHERIT_TYPE(x,y)       x |= ((y)& INHERIT_OPTIONS)

			  /*(x)==__XF_NETPRINT || 
			  (x)==__XF_NETIPC || */
#define IS_NETTHING(x)   (((x)&__XF_MASK)==__XF_NETWS || \
			  ((x)&__XF_MASK)==__XF_NETSHARE || \
			  ((x)&(__NETDIR|__NETFILE)) \
			 )

#define IS_FILE(x)	(!IS_DIR(x) && \
		(IS_XF_REG(x) || \
		 IS_XF_FIFO(x) || \
		 IS_XF_LNK(x) || \
		 IS_BROKEN_LNK(x) || \
		 IS_XF_SOCK(x) ||\
		 IS_XF_TAR_CHILD(x)) \
		)
#define IS_PATH(x) (IS_DIR(x) || IS_FILE(x))


/* hex  . */
#define IS_XF_UNKNOWN(x)	(__XF_UNKNOWN == ((x) & __XF_MASK))
#define IS_XF_FIFO(x)		(__XF_FIFO == ((x) & __XF_MASK))
#define IS_XF_CHR(x)		(__XF_CHR == ((x)  & __XF_MASK))
#define IS_XF_DIR(x)		(__XF_DIR == ((x)  & __XF_MASK))
#define IS_XF_BLK(x)		(__XF_BLK == ((x)  & __XF_MASK))
#define IS_XF_REG(x)		(__XF_REG == ((x)  & __XF_MASK))
#define IS_XF_LNK(x)		(__XF_LNK == ((x)  & __XF_MASK))
#define IS_XF_SOCK(x)		(__XF_SOCK == ((x) & __XF_MASK))
#define IS_XF_WHT(x)		(__XF_WHT == ((x)  & __XF_MASK))
#define IS_XF_FND(x)		(__XF_FND == ((x)  & __XF_MASK))
#define IS_XF_FSTAB(x)		(__XF_FSTAB == ((x)  & __XF_MASK))
#define IS_XF_NETWG(x)		(__XF_NETWG == ((x)  & __XF_MASK))
#define IS_XF_NETWS(x)		(__XF_NETWS == ((x)  & __XF_MASK))
#define IS_XF_NETSHARE(x)	(__XF_NETSHARE == ((x)  & __XF_MASK))
#define IS_XF_NETPRINT(x)	(__XF_NETPRINT == ((x)  & __XF_MASK))
#define IS_XF_NETIPC(x)		(__XF_NETIPC == ((x)  & __XF_MASK))

#define IS_XF_RPM_CHILD(x)	(__XF_RPM_CHILD == ((x)  & __XF_MASK))
#define IS_XF_TAR_CHILD(x)	(__XF_TAR_CHILD == ((x)  & __XF_MASK))

/*#define SET_XF_UNKNOWN(x)	(x) &= (__XF_MASK^__MASK); (x) |= __XF_UNKNOWN*/
#define SET_XF_UNKNOWN(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_UNKNOWN)
#define SET_XF_FIFO(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_FIFO)
#define SET_XF_CHR(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_CHR)
#define SET_XF_DIR(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_DIR)
#define SET_XF_BLK(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_BLK)
#define SET_XF_REG(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_REG)
#define SET_XF_LNK(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_LNK)
#define SET_XF_SOCK(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_SOCK)
#define SET_XF_WHT(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_WHT)
#define SET_XF_FND(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_FND)
#define SET_XF_FSTAB(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_FSTAB)
#define SET_XF_NETWG(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_NETWG)
#define SET_XF_NETWS(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_NETWS)
#define SET_XF_NETSHARE(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_NETSHARE)
#define SET_XF_NETPRINT(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_NETPRINT)
#define SET_XF_NETIPC(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_NETIPC)
#define SET_XF_RPM_CHILD(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_RPM_CHILD)
#define SET_XF_TAR_CHILD(x)	(x) = (((x)&(__XF_MASK^__MASK)) | __XF_TAR_CHILD)

/* hex  : */
#define IS_NETWORK_TYPE(x)	(((x) & __TREE_MASK) == __NETWORK_TYPE)
#define IS_LOCAL_TYPE(x)	(((x) & __TREE_MASK) == __LOCAL_TYPE)
#define IS_FIND_TYPE(x)		(((x) & __TREE_MASK) == __FIND_TYPE)
#define IS_BOOKMARK_TYPE(x)	(((x) & __TREE_MASK) == __BOOKMARK_TYPE)

#define IS_TRASH_TYPE(x)	(((x) & __TREE_MASK) == __TRASH_TYPE)
#define IS_FSTAB_TYPE(x)	(((x) & __TREE_MASK) == __FSTAB_TYPE)
#define IS_NFS_TYPE(x)		(((x) & __TREE_MASK) == __NFS_TYPE)
#define IS_PROC_TYPE(x)		(((x) & __TREE_MASK) == __PROC_TYPE)
#define IS_CDFS_TYPE(x)		(((x) & __TREE_MASK) == __CDFS_TYPE)
#define IS_APP_TYPE(x)		(((x) & __TREE_MASK) == __APP_TYPE)

#define SET_LOCAL_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __LOCAL_TYPE)
#define SET_NETWORK_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __NETWORK_TYPE)
#define SET_FIND_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __FIND_TYPE)
#define SET_BOOKMARK_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __BOOK_TYPE)
#define SET_TRASH_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __TRASH_TYPE)
#define SET_FSTAB_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __FSTAB_TYPE)
#define SET_NFS_TYPE(x)		(x) = (((x)&(__TREE_MASK^__MASK)) | __NFS_TYPE)
#define SET_PROC_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __PROC_TYPE)
#define SET_CDFS_TYPE(x)	(x) = (((x)&(__TREE_MASK^__MASK)) | __CDFS_TYPE)
#define SET_APP_TYPE(x)		(x) = (((x)&(__TREE_MASK^__MASK)) | __APP_TYPE)

/* hex  .: */
#define IS_NETDIR(x)		((x) & __NETDIR)
#define IS_NETHIDDEN(x)		((x) & __NETHIDDEN)
#define IS_NETREADONLY(x)	((x) & __NETREADONLY)
#define IS_NETFILE(x)		((x) & __NETFILE)
#define SET_NETDIR(x)		(x) |= __NETDIR
#define SET_NETHIDDEN(x)	(x) |= __NETHIDDEN
#define SET_NETREADONLY(x)	(x) |= __NETREADONLY
#define SET_NETFILE(x)		(x) |= __NETFILE


#define IS_SAMBA_SERVER(x)	((x) & __SAMBA_SERVER)
#define IS_ROOT_TYPE(x)		((x) & __ROOT_TYPE)
#define IS_DUMMY_TYPE(x)	((x) & __DUMMY_TYPE)
#define IS_EXPANDED(x)		((x) & __EXPANDED)
#define IS_LOADED(x)		((x) & __LOADED)

#define SET_SAMBA_SERVER(x)	(x) |= __SAMBA_SERVER
#define SET_ROOT_TYPE(x)	(x) |= __ROOT_TYPE
#define SET_DUMMY_TYPE(x)	(x) |= __DUMMY_TYPE
#define SET_EXPANDED(x)		(x) |= __EXPANDED
#define UNSET_EXPANDED(x)	(x) &= (__MASK^__EXPANDED)
#define SET_LOADED(x)		(x) |= __LOADED
#define UNSET_LOADED(x)		(x) &= (__MASK^__LOADED)

/* hex  :: */
#define IS_SORT_NAME(x)		(((x) & __SORT_MASK) == 0)
#define IS_SORT_SIZE(x)		(((x) & __SORT_MASK) == __SORT_SIZE)
#define IS_SORT_TIME(x)		(((x) & __SORT_MASK) == __SORT_TIME)
#define IS_SORT_UID(x)		(((x) & __SORT_MASK) == __SORT_UID)
#define IS_SORT_GID(x)		(((x) & __SORT_MASK) == __SORT_GID)
#define IS_TYPE_SUBSORT(x)	((x) & __TYPE_SUBSORT)

#define SET_SORT_NAME(x)	(x) &= (__SORT_MASK^__MASK)

#define SET_SORT_SIZE(x)	(x) = (((x)&(__SORT_MASK^__MASK)) | __SORT_SIZE)
#define SET_SORT_TIME(x)	(x) = (((x)&(__SORT_MASK^__MASK)) | __SORT_TIME)
#define SET_SORT_UID(x)		(x) = (((x)&(__SORT_MASK^__MASK)) | __SORT_UID)
#define SET_SORT_GID(x)		(x) = (((x)&(__SORT_MASK^__MASK)) | __SORT_GID)

#define SET_TYPE_SUBSORT(x)	(x) |= __TYPE_SUBSORT
#define UNSET_TYPE_SUBSORT(x)	(x) &= (__TYPE_SUBSORT^__MASK)
#define TOGGLE_TYPE_SUBSORT(x)	(x) ^= __TYPE_SUBSORT

/* hex  | */
#define IS_DESCENDING(x)	((x) & __SORT_DESC)
#define IS_ASCENDING(x)		(!((x) & __SORT_DESC))
#define IS_BROKEN_LNK(x)	((x) & __BROKEN_LNK)
#define HAS_HIDDEN(x)		((x) & __HAS_HIDDEN)
#define SHOWS_HIDDEN(x)		((x) & __SHOW_HIDDEN)

#define SET_DESCENDING(x)	(x) |= __SORT_DESC
#define TOGGLE_ASCENDING(x)	(x) ^= __SORT_DESC
#define SET_ASCENDING(x)	(x) &= (__MASK^__SORT_DESC)
#define SET_BROKEN_LNK(x)	(x) |= __BROKEN_LNK
#define SET_HAS_HIDDEN(x)	(x) |= __HAS_HIDDEN
#define SET_SHOWS_HIDDEN(x)	(x) |= __SHOW_HIDDEN
#define TOGGLE_SHOWS_HIDDEN(x)	(x) ^= __SHOW_HIDDEN
#define UNSET_SHOWS_HIDDEN(x)	(x) &= (__SHOW_HIDDEN^__MASK)

#define SHOWS_IMAGES(x)		((x) & __SHOW_IMAGES)
#define SET_SHOWS_IMAGES(x)	(x) |= __SHOW_IMAGES
#define TOGGLE_SHOWS_IMAGES(x)	(x) ^= __SHOW_IMAGES
#define UNSET_SHOWS_IMAGES(x)	(x) &= (__SHOW_IMAGES^__MASK)

/* hex |. */
#define IS_DIR(x)		((x) & __DIR)
#define IS_EXE(x)		((x) & __EXE)
#define IS_NOWRITE(x)		((x) & __NOWRITE)
#define IS_NOACCESS(x)		((x) & __NOACCESS)

#define SET_DIR(x)		(x) |= __DIR
#define SET_EXE(x)		(x) |= __EXE
#define SET_NOWRITE(x)		(x) |= __NOWRITE
#define SET_NOACCESS(x)		(x) |= __NOACCESS

/* hex |: */
#define IS_SIZE_S(x)		(((x) & __SIZE_MASK) == 0)
#define IS_SIZE_M(x)		(((x) & __SIZE_MASK) == __SIZE_M)
#define IS_SIZE_L(x)		(((x) & __SIZE_MASK) == __SIZE_L)
#define IS_SIZE_XL(x)		(((x) & __SIZE_MASK) == __SIZE_XL)

#define SET_SIZE_S(x)		(x) &= (__SIZE_MASK^__MASK)

#define SET_SIZE_M(x)		(x) = (((x)&(__SIZE_MASK^__MASK)) | __SIZE_M)
#define SET_SIZE_L(x)		(x) = (((x)&(__SIZE_MASK^__MASK)) | __SIZE_L)
#define SET_SIZE_XL(x)		(x) = (((x)&(__SIZE_MASK^__MASK)) | __SIZE_XL)

#define IS_INCOMPLETE(x)	((x) & __INCOMPLETE)
#define SET_INCOMPLETE(x)	(x) |= __INCOMPLETE
#define UNSET_INCOMPLETE(x)	(x) &= (__INCOMPLETE^0xffffffff)
#define TOGGLE_INCOMPLETE(x)	(x) ^= __INCOMPLETE

#define IS_CUSTOM_ICON(x)	((x) & __CUSTOM_ICON) /* subtype use APP type */
#define SET_CUSTOM_ICON(x)	(x) |= __CUSTOM_ICON /* subtype use APP type */

#define IS_IN_TERM(x)		((x) & __IN_TERM) /* subtype use APP type */
#define SET_IN_TERM(x)		(x) |= __IN_TERM /* subtype use APP type */

#define IS_MOUNTED(x)		((x) & __MOUNTED) 
#define SET_MOUNTED(x)		(x) |= __MOUNTED 
#define UNSET_MOUNTED(x)	(x) &= (__MOUNTED^0xffffffff)
#define TOGGLE_MOUNTED(x)	(x) ^= __MOUNTED

#define IS_CUT(x)		((x) & __CUT)
#define SET_CUT(x)		(x) |= __CUT
#define UNSET_CUT(x)		(x) &= (__CUT^0xffffffff)
#define IS_ERASED_SPACE(x)	((x) & __ERASED_SPACE)
#define SET_ERASED_SPACE(x)	(x) |= __ERASED_SPACE
#define UNSET_ERASED_SPACE(x)	(x) &= (__ERASED_SPACE^0xffffffff)


/* hex |.: */


/****  preferences flag (view and preferences) *****/
/* views: */

#define SHOW_SIZE	0x01
#define SHOW_DATE	0x02
#define SHOW_GID	0x04
#define SHOW_UID	0x08
#define SHOW_MODE	0x10

#define SHOW_MM		0x20
#define SHOW_TB1	0x40
#define SHOW_TB2	0x80
#define SHOW_F		0x100
#define SHOW_TITLES	0x200

#define QUICK_HIDE_MASK	(SHOW_TITLES|SHOW_MM|SHOW_TB1|SHOW_TB2|SHOW_F)

/*#define HIDE_LOCAL	0x400
#define HIDE_NETWORK	0x800*/

#define ICON_VIEW 	0x1000
#define DEFAULT_VIEW 	0x2000
#define SMALL_VIEW 	0x4000
#define DETAILED_VIEW 	0x8000

#define HIDE_WASTE_B	0x10000
#define VIEW_MASK	0x1ffff

/* preferences: */

#define PREFERENCE_MASK	0xfff00000

#define DRAG_DO_COPY	0x100000
#define ENABLE_GTK_CLICK	0x200000
#define RSH_X_SSH	0x400000
#define RSYNC_X_SCP	0x800000

#define SHOW_DOT 	0x1000000
#define IMAGE_PREVIEW	0x2000000
#define ENABLE_AUTO_T	0x4000000
#define ENABLE_MONITOR  0x8000000

#define FILETYPE_SUBS	0x10000000
#define CUSTOM_HOME	0x20000000
#define AUTOSCROLL	0x40000000
#define ENABLE_RESIZE_FONTS	0x80000000



#define BIT_MASK	0xffffffff

#endif /*__CONSTANTS__*/
