// This file contains all FOX functions redefinitions (FOX hacks for various purposes)

#include <X11/Xft/Xft.h>


// Hack to display a tooltip with name, size, date, etc.
// We were asked about tip text
long FXTreeList::onQueryTip(FXObject* sender,FXSelector sel,void* ptr)
{
	if(FXWindow::onQueryTip(sender,sel,ptr))
		return 1;

	if((flags&FLAG_TIP) && !(options&TREELIST_AUTOSELECT)) // No tip when autoselect!
	{
		FXint x,y;
		FXuint buttons;

		getCursorPosition(x,y,buttons);
		FXTreeItem *item=getItemAt(x,y);
		if(item)
		{
			//!!!! Hack to display a tooltip with name, size, date, etc.
			FXString string;
			
			// Root folder
			if (item->getText()==ROOTDIR)
				string=_("Root directory");
			
			// Other folders
			else
			{
				// Get user data pointer
				FXString str=(FXchar*)item->getData();
			
				// Add name, type, permissions, etc. to the tool tip
				FXString name=str.section('\t',0);
				FXString type=str.section('\t',1);
				FXString date=str.section('\t',2);
				FXString user=str.section('\t',3);
				FXString group=str.section('\t',4);
				FXString perms=str.section('\t',5);
				FXString deldate=str.section('\t',6);
				FXString pathname=str.section('\t',7);

				// Compute root file size
				unsigned long long dnsize;
				char dsize[64];
				dnsize=::dirsize(pathname.text());
				snprintf(dsize,sizeof(dsize)-1,"%llu",dnsize);
				FXString size=::hSize(dsize);
				if (deldate.empty())
					string=_("Name: ")+name+"\n"+_("Size in root: ")+size+"\n"+_("Type: ")+type
						   +"\n"+_("Modified date: ")+date+"\n"+_("User: ")+user+" - "+_("Group: ")+group
						   +"\n"+_("Permissions: ")+perms;
				else
					string=_("Name: ")+name+"\n"+_("Size in root: ")+size+"\n"+_("Type: ")+type
						   +"\n"+_("Modified date: ")+date+"\n"+_("Deletion date: ")+deldate+"\n"+_("User: ")+user+" - "+_("Group: ")+group
						   +"\n"+_("Permissions: ")+perms;
			}
			//!!!! End of hack !!!
			
			sender->handle(this,FXSEL(SEL_COMMAND,ID_SETSTRINGVALUE),(void*)&string);
			return 1;
		}
	}
	return 0;
}


//
// Hack of FXDCWindow
//

// Hack to take into account non UTF-8 strings
void FXDCWindow::drawText(FXint x,FXint y,const FXchar* string,FXuint length)
{
    if (!surface)
        fxerror("FXDCWindow::drawText: DC not connected to drawable.\n");
    if (!font)
        fxerror("FXDCWindow::drawText: no font selected.\n");

    XftColor color;
    color.pixel=devfg;
    color.color.red=FXREDVAL(fg)*257;
    color.color.green=FXGREENVAL(fg)*257;
    color.color.blue=FXBLUEVAL(fg)*257;
    color.color.alpha=FXALPHAVAL(fg)*257;

    // !!!! Hack to draw string depending on its encoding !!!
    if (isUtf8(string,length))
        XftDrawStringUtf8((XftDraw*)xftDraw,&color,(XftFont*)font->font,x,y,(const FcChar8*)string,length);
    else
        XftDrawString8((XftDraw*)xftDraw,&color,(XftFont*)font->font,x,y,(const FcChar8*)string,length);
    // !!!! End of hack !!!
}



//
// Hack of FXFont
//

// Hack to take into account non UTF-8 strings
#define DISPLAY(app) ((Display*)((app)->display))
FXint FXFont::getTextWidth(const FXchar *string,FXuint length) const
{
    if (!string && length)
        fxerror("%s::getTextWidth: NULL string argument\n",getClassName());

    if (font)
    {
        XGlyphInfo extents;
        // This returns rotated metrics; FOX likes to work with unrotated metrics, so if angle
        // is not 0, we calculate the unrotated baseline; note however that the calculation is
        // not 100% pixel exact when the angle is not a multiple of 90 degrees.

        // !!!! Hack to evaluate string extent depending on its encoding !!!
        if (isUtf8(string,length))
            XftTextExtentsUtf8(DISPLAY(getApp()),(XftFont*)font,(const FcChar8*)string,length,&extents);
        else
            XftTextExtents8(DISPLAY(getApp()),(XftFont*)font,(const FcChar8*)string,length,&extents);
        // !!!! End of hack !!!

        if (angle)
            return (FXint)(0.5+sqrt(extents.xOff*extents.xOff+extents.yOff*extents.yOff));

        return extents.xOff;
    }
    return length;
}



//
// Hack of FXTextField
//

// Function taken from the FXTextField class and hacked to get standard background
// when the text field is disabled or is not editable
long FXTextField::onPaint(FXObject*,FXSelector,void* ptr)
{
    FXEvent *ev=(FXEvent*)ptr;
    FXDCWindow dc(this,ev);

    // Draw frame
    drawFrame(dc,0,0,width,height);

    // !!!! Hack to get standard background if disabled or if not editable
    if (!isEnabled() || !isEditable())
        dc.setForeground(baseColor);
    else
        dc.setForeground(backColor);
    // !!!! End of hack

    // Draw background
    dc.fillRectangle(border,border,width-(border<<1),height-(border<<1));

    // Draw text, clipped against frame interior
    dc.setClipRectangle(border,border,width-(border<<1),height-(border<<1));
    drawTextRange(dc,0,contents.length());

    // Draw caret
    if (flags&FLAG_CARET)
    {
        int xx=coord(cursor)-1;
        dc.setForeground(cursorColor);
        dc.fillRectangle(xx,padtop+border,1,height-padbottom-padtop-(border<<1));
        dc.fillRectangle(xx-2,padtop+border,5,1);
        dc.fillRectangle(xx-2,height-border-padbottom-1,5,1);
    }
    return 1;
}



//
// Hack of FXSplitter
//

#ifndef MIN_PANEL_WIDTH
#define MIN_PANEL_WIDTH 100
#endif

// This function is taken from the FXSplitter class
// and hacked to set a minimum splitter width when moving splitter to right
// It replaces the normal function...
void FXSplitter::moveHSplit(FXint pos)
{
    register FXint smin,smax;
    register FXuint hints;
    hints=window->getLayoutHints();
    if (options&SPLITTER_REVERSED)
    {
        smin=barsize;
        smax=window->getX()+window->getWidth();
        if ((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smax-=window->getDefaultWidth();
    }
    else
    {
        smin=window->getX();
        smax=width-barsize;
        if ((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smin+=window->getDefaultWidth();
    }

    // !!!! Hack to limit the width to a minimum value !!!
    smax=smax-MIN_PANEL_WIDTH;
    split=pos;
    if (split<smin)
        split=smin;
    if (split>smax)
        split=smax;
    // !!!! End of hack
}



//
// Hack of FXRegistry
//

// !!!! Hack to change the defaults directories for config files and icons

#define DESKTOP        "xferc"
#define REGISTRYPATH   "/etc:/usr/share:/usr/local/share"

// Read registry
bool FXRegistry::read()
{
    FXString dirname;
    register bool ok=false;


    dirname=FXPath::search(REGISTRYPATH,"xfe");
    if (!dirname.empty())
        ok=readFromDir(dirname,false);

    // Try search along PATH if still not found
    if (!ok)
    {
        dirname=FXPath::search(FXSystem::getExecPath(),"xfe");
        if (!dirname.empty())
            ok=readFromDir(dirname,false);
    }

    // Get path to per-user settings directory
    dirname=FXSystem::getHomeDirectory()+PATHSEPSTRING LOCALPATH;

    // Then read per-user settings; overriding system-wide ones
    if (readFromDir(dirname,true))
        ok=true;

    return ok;
}


// Try read registry from directory
bool FXRegistry::readFromDir(const FXString& dirname,bool mark)
{
    bool ok=false;

    // Directory is empty?
    if (!dirname.empty())
    {
        // First try to load desktop registry
        if (parseFile(dirname+PATHSEPSTRING DESKTOP,false))
        {
            FXString nn=dirname+PATHSEPSTRING DESKTOP;
            ok=true;
        }

        // Have vendor key
        if (!vendorkey.empty())
        {
            if (parseFile(dirname+PATHSEPSTRING+vendorkey+PATHSEPSTRING+vendorkey,false))
            {
                FXString nn=dirname+PATHSEPSTRING+vendorkey+PATHSEPSTRING+vendorkey;
                ok=true;
            }
            // Have application key
            if (!applicationkey.empty())
			{
                if (parseFile(dirname+PATHSEPSTRING+vendorkey+PATHSEPSTRING+applicationkey,mark))
                    ok=true;
			}
        }

        // No vendor key
        else
        {
            // Have application key
            if (!applicationkey.empty())
			{
                if (parseFile(dirname+PATHSEPSTRING+applicationkey,mark))
                    ok=true;
			}
        }
    }
    return ok;
}


// Write registry
bool FXRegistry::write()
{
    FXString pathname,tempname;

    // Settings have not changed
    if (!isModified()) return true;

    // We can not save if no application key given
    if (!applicationkey.empty())
    {
        // Changes written only in the per-user registry
        pathname=FXSystem::getHomeDirectory()+PATHSEPSTRING LOCALPATH;

        // If this directory does not exist, make it
        if (!FXStat::exists(pathname))
        {
            if (!FXDir::create(pathname))
                return false;
        }
        else
        {
            if (!FXStat::isDirectory(pathname))
                return false;
        }

        // Add vendor subdirectory
        if (!vendorkey.empty())
        {
            pathname.append(PATHSEPSTRING+vendorkey);
            if (!FXStat::exists(pathname))
            {
                if (!FXDir::create(pathname))
                    return false;
            }
            else
            {
                if (!FXStat::isDirectory(pathname))
                    return false;
            }
        }

        // Add application key
        pathname.append(PATHSEPSTRING+applicationkey);

        // Construct temp name
        tempname.format("%s_%d",pathname.text(),fxgetpid());

        // Unparse settings into temp file first
        if (unparseFile(tempname))
        {

            // Rename ATOMICALLY to proper name
            if (!FXFile::rename(tempname,pathname))
                return false;

            setModified(false);
            return true;
        }
    }
    return false;
}



//
// Hack of FXPopup
//

// The two functions below are taken from the FXPopup class
// and hacked to allow navigating using the keyboard on popup menus
// They replace the normal functions...

// !!!! Global variable control keyboard scrolling on right click popup menus !!!!
extern FXbool allowPopupScroll;

void FXPopup::setFocus()
{
    FXShell::setFocus();

    // !!!! Hack to allow keyboard scroll on popup dialogs !!!!
    if (allowPopupScroll)
        grabKeyboard();
}

void FXPopup::killFocus()
{
    FXShell::killFocus();

    // !!!! Hack to allow keyboard scroll on popup dialogs !!!!
    if (allowPopupScroll)
    {
        if (prevActive)
            prevActive->setFocus();
        else
            ungrabKeyboard();
    }

}


//
// Hack of FXStatusLine(translation hack)
//

// Status line construct and init
FXStatusLine::FXStatusLine(FXComposite* p,FXObject* tgt,FXSelector sel):
        FXFrame(p,FRAME_SUNKEN|LAYOUT_LEFT|LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 4,4,2,2)
{
    flags|=FLAG_SHOWN;
    status=normal=_("Ready.");
    font=getApp()->getNormalFont();
    textColor=getApp()->getForeColor();
    textHighlightColor=getApp()->getForeColor();
    target=tgt;
    message=sel;
}


//
// Hack of FXReplaceDialog (translation hack)
//

// Taken from the FXReplaceDialog class

// Padding for buttons
#define HORZ_PAD      12
#define VERT_PAD      2
#define SEARCH_MASK   (SEARCH_EXACT|SEARCH_IGNORECASE|SEARCH_REGEX)

// File Open Dialog
FXReplaceDialog::FXReplaceDialog(FXWindow* owner,const FXString& caption,FXIcon* ic,FXuint opts,FXint x,FXint y,FXint w,FXint h):
        FXDialogBox(owner,caption,opts|DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE,x,y,w,h,10,10,10,10, 10,10)
{
    FXHorizontalFrame* buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH|PACK_UNIFORM_HEIGHT,0,0,0,0,0,0,0,0);
    accept=new FXButton(buttons,_("&Replace"),NULL,this,ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    every=new FXButton(buttons,_("Re&place All"),NULL,this,ID_ALL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,6,6,VERT_PAD,VERT_PAD);
    cancel=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    FXHorizontalFrame* pair=new FXHorizontalFrame(buttons,LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0, 0,0,0,0);
    FXArrowButton* searchlast=new FXArrowButton(pair,this,ID_PREV,ARROW_LEFT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    FXArrowButton* searchnext=new FXArrowButton(pair,this,ID_NEXT,ARROW_RIGHT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXHorizontalSeparator(this,SEPARATOR_GROOVE|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
    FXHorizontalFrame* toppart=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 10,10);
    new FXLabel(toppart,FXString::null,ic,ICON_BEFORE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y|LAYOUT_FILL_Y|LAYOUT_FILL_X);
    FXVerticalFrame* entry=new FXVerticalFrame(toppart,LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0);
    searchlabel=new FXLabel(entry,_("Search for:"),NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    searchbox=new FXHorizontalFrame(entry,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 0,0);
    searchtext=new FXTextField(searchbox,26,this,ID_SEARCH_TEXT,TEXTFIELD_ENTER_ONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 4,4,4,4);
    FXVerticalFrame* searcharrows=new FXVerticalFrame(searchbox,LAYOUT_RIGHT|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
    FXArrowButton* ar1=new FXArrowButton(searcharrows,this,ID_SEARCH_UP,FRAME_RAISED|FRAME_THICK|ARROW_UP|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    FXArrowButton* ar2=new FXArrowButton(searcharrows,this,ID_SEARCH_DN,FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    ar1->setArrowSize(3);
    ar2->setArrowSize(3);
    replacelabel=new FXLabel(entry,_("Replace with:"),NULL,LAYOUT_LEFT);
    replacebox=new FXHorizontalFrame(entry,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 0,0);
    replacetext=new FXTextField(replacebox,26,this,ID_REPLACE_TEXT,TEXTFIELD_ENTER_ONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 4,4,4,4);
    FXVerticalFrame* replacearrows=new FXVerticalFrame(replacebox,LAYOUT_RIGHT|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
    FXArrowButton* ar3=new FXArrowButton(replacearrows,this,ID_REPLACE_UP,FRAME_RAISED|FRAME_THICK|ARROW_UP|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    FXArrowButton* ar4=new FXArrowButton(replacearrows,this,ID_REPLACE_DN,FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    ar3->setArrowSize(3);
    ar4->setArrowSize(3);
    FXHorizontalFrame* options1=new FXHorizontalFrame(entry,LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
    new FXRadioButton(options1,_("Ex&act"),this,ID_MODE+SEARCH_EXACT,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXRadioButton(options1,_("&Ignore Case"),this,ID_MODE+SEARCH_IGNORECASE,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXRadioButton(options1,_("E&xpression"),this,ID_MODE+SEARCH_REGEX,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXCheckButton(options1,_("&Backward"),this,ID_DIR,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    searchlast->setTipText("Ctrl-B");
    searchnext->setTipText("Ctrl-F");
    searchlast->addHotKey(MKUINT(KEY_b,CONTROLMASK));
    searchnext->addHotKey(MKUINT(KEY_f,CONTROLMASK));
    searchmode=SEARCH_EXACT|SEARCH_FORWARD;
    current=0;
}


//
// Hack of FXSearchDialog (translation hack)
//

// Taken from the FXSearchDialog class
FXSearchDialog::FXSearchDialog(FXWindow* owner,const FXString& caption,FXIcon* ic,FXuint opts,FXint x,FXint y,FXint w,FXint h):
        FXReplaceDialog(owner,caption,ic,opts,x,y,w,h)
{
    accept->setText(_("&Search"));
    every->hide();
    replacelabel->hide();
    replacebox->hide();
}


//
// Hack of FXInputDialog (translation hack)
//

// Taken from the FXInputDialog class
void FXInputDialog::initialize(const FXString& label,FXIcon* icon)
{
    FXuint textopts=TEXTFIELD_ENTER_ONLY|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X;
    FXHorizontalFrame* buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
    new FXButton(buttons,_("&OK"),NULL,this,ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXHorizontalSeparator(this,SEPARATOR_GROOVE|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
    FXHorizontalFrame* toppart=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 10,10);
    new FXLabel(toppart,FXString::null,icon,ICON_BEFORE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y|LAYOUT_FILL_Y|LAYOUT_FILL_X);
    FXVerticalFrame* entry=new FXVerticalFrame(toppart,LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0);
    new FXLabel(entry,label,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    if (options&INPUTDIALOG_PASSWORD)
        textopts|=TEXTFIELD_PASSWD;
    if (options&INPUTDIALOG_INTEGER)
        textopts|=TEXTFIELD_INTEGER|JUSTIFY_RIGHT;
    if (options&INPUTDIALOG_REAL)
        textopts|=TEXTFIELD_REAL|JUSTIFY_RIGHT;
    input=new FXTextField(entry,20,this,ID_ACCEPT,textopts,0,0,0,0, 8,8,4,4);
    limlo=1.0;
    limhi=0.0;
}



//
// Hack of fxpriv (clipboard management)
//

#include <X11/Xlib.h>

// These two functions are hacked to reduce the timeout when the owner app of the clipboard has been closed

// Send request for selection info
Atom fxsendrequest(Display *display,Window window,Atom selection,Atom prop,Atom type,FXuint time)
{
    // !!!! Hack here to reduce timeout !!!!
    FXuint loops=10;
    XEvent ev;
    XConvertSelection(display,selection,type,prop,window,time);
    while (!XCheckTypedWindowEvent(display,window,SelectionNotify,&ev))
    {
        if (loops==0)
        {
            //fxwarning("fxsendrequest:timed out!\n");
            return None;
        }
        FXThread::sleep(10000000);  // Don't burn too much CPU here:- the other guy needs it more....
        loops--;
    }
    return ev.xselection.property;
}

// Wait for event of certain type
static FXbool fxwaitforevent(Display *display,Window window,int type,XEvent& event)
{
    // !!!! Hack here to reduce timeout !!!!
    FXuint loops=10;
    while (!XCheckTypedWindowEvent(display,window,type,&event))
    {
        if (loops==0)
        {
            //fxwarning("fxwaitforevent:timed out!\n");
            return FALSE;
        }
        FXThread::sleep(10000000);  // Don't burn too much CPU here:- the other guy needs it more....
        loops--;
    }
    return TRUE;
}


// The four following functions are not modified but are necessary here because the previous ones are not called directly

// Read property in chunks smaller than maximum transfer length,
// appending to data array; returns amount read from the property.
static FXuint fxrecvprop(Display *display,Window window,Atom prop,Atom& type,FXuchar*& data,FXuint& size)
{
    unsigned long maxtfrsize=XMaxRequestSize(display)*4;
    unsigned long tfroffset,tfrsize,tfrleft;
    unsigned char *ptr;
    int format;
    tfroffset=0;

    // Read next chunk of data from property
    while (XGetWindowProperty(display,window,prop,tfroffset>>2,maxtfrsize>>2,False,AnyPropertyType,&type,&format,&tfrsize,&tfrleft,&ptr)==Success && type!=None)
    {
        tfrsize*=(format>>3);

        // Grow the array to accomodate new data
        if (!FXRESIZE(&data,FXuchar,size+tfrsize+1))
        {
            XFree(ptr);
            break;
        }

        // Append new data at the end, plus the extra 0.
        memcpy(&data[size],ptr,tfrsize+1);
        size+=tfrsize;
        tfroffset+=tfrsize;
        XFree(ptr);
        if (tfrleft==0)
            break;
    }

    // Delete property after we're done
    XDeleteProperty(display,window,prop);
    XFlush(display);
    return tfroffset;
}


// Receive data via property
Atom fxrecvdata(Display *display,Window window,Atom prop,Atom incr,Atom& type,FXuchar*& data,FXuint& size)
{
    unsigned long  tfrsize,tfrleft;
    unsigned char *ptr;
    XEvent ev;
    int format;
    data=NULL;
    size=0;
    if (prop)
    {
        // First, see what we've got
        if (XGetWindowProperty(display,window,prop,0,0,False,AnyPropertyType,&type,&format,&tfrsize,&tfrleft,&ptr)==Success && type!=None)
        {
            XFree(ptr);

            // Incremental transfer
            if (type==incr)
            {
                // Delete the INCR property
                XDeleteProperty(display,window,prop);
                XFlush(display);

                // Wait for the next batch of data
                while (fxwaitforevent(display,window,PropertyNotify,ev))
                {
                    // Wrong type of notify event; perhaps stale event
                    if (ev.xproperty.atom!=prop || ev.xproperty.state!=PropertyNewValue)
                        continue;

                    // See what we've got
                    if (XGetWindowProperty(display,window,prop,0,0,False,AnyPropertyType,&type,&format,&tfrsize,&tfrleft,&ptr)==Success && type!=None)
                    {
                        XFree(ptr);

                        // if empty property, its the last one
                        if (tfrleft==0)
                        {
                            // Delete property so the other side knows we've got the data
                            XDeleteProperty(display,window,prop);
                            XFlush(display);
                            break;
                        }

                        // Read and delete the property
                        fxrecvprop(display,window,prop,type,data,size);
                    }
                }
            }

            // All data in one shot
            else
            {
                // Read and delete the property
                fxrecvprop(display,window,prop,type,data,size);
            }
        }
        return prop;
    }
    return None;
}


// Retrieve CLIPBOARD selection data
void FXApp::clipboardGetData(const FXWindow* window,FXDragType type,FXuchar*& data,FXuint& size)
{
    FXID answer;
    data=NULL;
    size=0;
    if (clipboardWindow)
    {
        event.type=SEL_CLIPBOARD_REQUEST;
        event.target=type;
        ddeData=NULL;
        ddeSize=0;
        clipboardWindow->handle(this,FXSEL(SEL_CLIPBOARD_REQUEST,0),&event);
        data=ddeData;
        size=ddeSize;
        ddeData=NULL;
        ddeSize=0;
    }
    else
    {
        answer=fxsendrequest((Display*)display,window->id(),xcbSelection,ddeAtom,type,event.time);
        fxrecvdata((Display*)display,window->id(),answer,ddeIncr,type,data,size);
    }
}


// Get dropped data; called in response to DND enter or DND drop
bool FXWindow::getDNDData(FXDNDOrigin origin,FXDragType targettype,FXuchar*& data,FXuint& size) const
{
    if (xid==0)
    {
        fxerror("%s::getDNDData: window has not yet been created.\n",getClassName());
    }
    switch (origin)
    {
    case FROM_DRAGNDROP:
        getApp()->dragdropGetData(this,targettype,data,size);
        break;
    case FROM_CLIPBOARD:
        getApp()->clipboardGetData(this,targettype,data,size);
        break;
    case FROM_SELECTION:
        getApp()->selectionGetData(this,targettype,data,size);
        break;
    }
    return data!=NULL;
}

