/*
 *	xeno_style_fill.h
 */

#ifndef XENO_STYLE_FILL_H
#define XENO_STYLE_FILL_H

#include "xeno_style.h"

void		xeno_gradient_set_unrealize		(XenoGradientSet *gradient_set);
void		xeno_gradient_set_realize		(XenoGradientSet *gradient_set,
											 GtkStyle		*style);

GdkPixmap *	xeno_gradient_get				(GtkStyle		*style,
											 GdkWindow		*window,
											 GtkStateType 	state_type,
											 GtkWidget		*widget,
											 gint			width,
											 gint			height);

void		xeno_gradient_color				(const GtkStyle *style,
											 GtkStateType	state_type,
											 gfloat			f,
											 XenoColor		*dst);

void		xeno_style_fill_background		(GtkStyle		*style,
											 GdkDrawable	*drawable,
											 GtkStateType	state_type,
											 GdkRectangle	*area,
											 GtkWidget		*widget,
											 gint			x,
											 gint			y,
											 gint			width,
											 gint			height);

void		xeno_style_fill_base			(GtkStyle		*style,
											 GdkWindow		*window,
											 GtkStateType	state_type,
											 GdkRectangle	*area,
											 GtkWidget		*widget,
											 gint			x,
											 gint			y,
											 gint			width,
											 gint			height);

#if XENO_GTK2
void		xeno_style_real_fill_background	(GtkStyle		*style,
											 GdkDrawable	*drawable,
											 GtkStateType	state_type,
											 GdkRectangle	*area,
											 GtkWidget		*widget,
											 gint			x,
											 gint			y,
											 gint			width,
											 gint			height);

void		xeno_style_real_fill_base		(GtkStyle		*style,
											 GdkWindow		*window,
											 GtkStateType	state_type,
											 GdkRectangle	*area,
											 GtkWidget		*widget,
											 gint			x,
											 gint			y,
											 gint			width,
											 gint			height);
#endif

#endif /* XENO_STYLE_FILL_H */

