#!/bin/sh

# A script to create an installation ramdisk (initrd) and copy
# the appropriate GuestOS (DomU) kernel in the default location
# for SUSE.
#
# To configure XenMan properly:
#
#     1. Ensure that the install-initrd package is installed.
#        (available on your OpenSUSE 10.1 installation media)
#
#     2. Execute the script
#        e.g. >./create_ramdisk-suse.sh
#
#     3. If you haven't already, make a copy of the default
#        SUSE config (xenman.config.suse) and rename the copy 
#        xenman.conf.
#
#     4. Run XenMan and create a domain. 
#

TGT_DIR="/var/cache/xenman/yast_install"
KERNEL=`uname -r`

mkdir "$TGT_DIR" > /dev/null 2>&1

/usr/sbin/mkinstallinitrd "$TGT_DIR"/initrd.default
if [ $? -ne 0 ]; then
  echo "ERROR: Could not create ramdisk"
  echo "Check:"
  echo "   1. the install-initrd rpm package is installed"
  echo "   2. the directory /var/cache/xenman exists"
  echo "   3. you have permission to create files in this directory"
  exit 1
fi

cp /boot/vmlinuz-$KERNEL "$TGT_DIR"/vmlinuz.default
if [ $? -ne 0 ]; then
  echo "ERROR: Could copy $KERNEL from /boot directory"
  exit 1
fi


echo
echo "*** IMPORTANT REQUIREMENT ***"
echo "-----------------------------"
echo "XenMan requires python-paramiko to be present"
echo "for SSH based remote host management."
echo "Download it from http://www.lag.net/paramiko"
echo "if you don't have it already installed"
echo