/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.IOException;
import java.util.List;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.ProcessRegistry;
import jde.debugger.Protocol;
import jde.debugger.command.DebugCommand;
import jde.debugger.command.DebugCommandFactory;

public class Jdebug
extends Thread
implements Protocol {
    public static final Integer debuggerID = new Integer(-1);
    public static Jdebug theDebugger = new Jdebug();
    private JDE jde = JDE.getJDE();
    private ProcessRegistry procRegistry = ProcessRegistry.getRegistry();

    protected Jdebug() {
    }

    public void init() throws IOException {
        this.jde.init();
    }

    public void run() {
        List command = JDE.getJDE().nextCommand();
        while (command != null) {
            Integer proc_id = Integer.valueOf(command.get(0).toString());
            Integer cmd_id = Integer.valueOf(command.get(1).toString());
            String cmd_name = command.get(2).toString().toLowerCase();
            List arguments = command.subList(3, command.size());
            try {
                DebugCommand cmd = DebugCommandFactory.theFactory.createCommand(proc_id, cmd_id, cmd_name, arguments);
                cmd.start();
            }
            catch (JDEException ex) {
                this.jde.signal(proc_id, "error", "Error occurred while executing " + cmd_name + ". Error: " + ex);
            }
            command = JDE.getJDE().nextCommand();
        }
    }

    public static Jdebug getTheDebugger() {
        return theDebugger;
    }
}

