/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/*
** Declarations for the filesystem repository implementation
*/

#ifndef _DAV_XDELTA_REPOS_H_
#define _DAV_XDELTA_REPOS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "apr.h"

#include "httpd.h"
#include "http_log.h"
#include "http_config.h"
#include "http_protocol.h"	/* for ap_set_* (in dav_xdelta_set_headers) */
#include "http_request.h"       /* for ap_update_mtime() */

#include "mod_dav.h"

extern module AP_MODULE_DECLARE_DATA dav_xdelta;

extern const dav_hooks_repository dav_hooks_repository_xdelta;
extern const dav_hooks_liveprop   dav_hooks_liveprop_xdelta;
extern const dav_provider         dav_xdelta_provider;
extern const dav_liveprop_group   dav_xdelta_liveprop_group;

const char *dav_xdelta_fspath (const request_rec *r);

void dav_xdelta_gather_propsets (apr_array_header_t *uris);
int  dav_xdelta_find_liveprop   (const dav_resource *resource,
				 const char *ns_uri, const char *name,
				 const dav_hooks_liveprop **hooks);
void dav_xdelta_insert_all_liveprops (request_rec *r, const dav_resource *resource,
				      dav_prop_insert what, ap_text_header *phdr);

#ifdef __cplusplus
}
#endif

#endif /* _DAV_XDELTA_REPOS_H_ */
