/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: xdfs_edsio.cc 1.1 Sun, 03 Dec 2000 22:01:25 -0800 jmacd $
 */

#include "xdfs_cpp.h"
#include "xdfs_edsio.h"

#include <errno.h>

/* Declarations. */

static void print_spaces (guint n) { guint i; for (i = 0; i < n; i += 1) g_print (" "); }


/* initialize this library. */

gboolean
xdfs_edsio_init (void)
{
  static gboolean once = FALSE;
  static gboolean result = FALSE;
  if (once) return result;
  once = TRUE;
  serializeio_initialize_type ("ST_XdfsState", ST_XdfsState, (gboolean  (*) ()) &unserialize_xdfsstate_internal, (gboolean  (*) ()) &serialize_xdfsstate_obj_internal, (guint (*) ()) &serializeio_count_xdfsstate_obj, (void (*) ()) &serializeio_print_xdfsstate_obj);
  serializeio_initialize_type ("ST_XdfsInstruction", ST_XdfsInstruction, (gboolean  (*) ()) &unserialize_xdfsinstruction_internal, (gboolean  (*) ()) &serialize_xdfsinstruction_obj_internal, (guint (*) ()) &serializeio_count_xdfsinstruction_obj, (void (*) ()) &serializeio_print_xdfsinstruction_obj);
  edsio_library_register (10, "xdfs");
  result = TRUE;
  return TRUE;
};

/* XdfsInstruction Count
 */

guint
serializeio_count_xdfsinstruction (guint32 offset, guint32 length, guint32 output_start) {
  guint size = sizeof (SerialXdfsInstruction);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdfsinstruction_obj (SerialXdfsInstruction const* obj) {
  return serializeio_count_xdfsinstruction (obj->offset, obj->length, obj->output_start);
}

/* XdfsInstruction Print
 */

void
serializeio_print_xdfsinstruction_obj (SerialXdfsInstruction* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("offset:uint = ");
  g_print ("%d\n", obj->offset);
  print_spaces (indent_spaces);
  g_print ("length:uint = ");
  g_print ("%d\n", obj->length);
  print_spaces (indent_spaces);
  g_print ("output_start:uint = ");
  g_print ("%d\n", obj->output_start);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* XdfsInstruction Serialize
 */

gboolean
serialize_xdfsinstruction_internal (SerialSink *sink, guint32 offset, guint32 length, guint32 output_start)
{
  if (! (* sink->next_uint) (sink, offset)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
  if (! (* sink->next_uint) (sink, output_start)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdfsinstruction_obj_internal (SerialSink *sink, SerialXdfsInstruction* obj)
{
  return serialize_xdfsinstruction_internal (sink, obj->offset, obj->length, obj->output_start);
}

gboolean
serialize_xdfsinstruction (SerialSink *sink, guint32 offset, guint32 length, guint32 output_start)
{
  if (! (* sink->sink_type) (sink, ST_XdfsInstruction, serializeio_count_xdfsinstruction (offset, length, output_start), TRUE)) goto bail;
  if (! serialize_xdfsinstruction_internal (sink, offset, length, output_start)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdfsinstruction_obj (SerialSink *sink, const SerialXdfsInstruction* obj) {

  return serialize_xdfsinstruction (sink, obj->offset, obj->length, obj->output_start);
}

/* XdfsInstruction Unserialize
 */

gboolean
unserialize_xdfsinstruction_internal_noalloc (SerialSource *source, SerialXdfsInstruction* result)
{
  if (! (* source->next_uint) (source, &result->offset)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
  if (! (* source->next_uint) (source, &result->output_start)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdfsinstruction_internal (SerialSource *source, SerialXdfsInstruction** result)
{
  SerialXdfsInstruction* unser;
  (*result) = NULL;
  unser = (SerialXdfsInstruction*) serializeio_source_alloc (source, sizeof (SerialXdfsInstruction));
  if (! unser) goto bail;
  if (! unserialize_xdfsinstruction_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdfsinstruction (SerialSource *source, SerialXdfsInstruction** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_XdfsInstruction) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_xdfsinstruction_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdfsState Count
 */

guint
serializeio_count_xdfsstate (guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions) {
  guint size = sizeof (SerialXdfsState);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdfsstate_obj (SerialXdfsState const* obj) {
  return serializeio_count_xdfsstate (obj->src_buffer_files, obj->src_buffer_size, obj->total_version_count, obj->unique_version_count, obj->unencoded_size, obj->literal_size, obj->control_size, obj->patch_size, obj->patches, obj->literals, obj->cluster_versions, obj->cluster_compressed_size, obj->cluster_uncompressed_size, obj->policy, obj->flags, obj->cluster_max_versions);
}

/* XdfsState Print
 */

void
serializeio_print_xdfsstate_obj (SerialXdfsState* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("src_buffer_files:uint = ");
  g_print ("%d\n", obj->src_buffer_files);
  print_spaces (indent_spaces);
  g_print ("src_buffer_size:uint = ");
  g_print ("%d\n", obj->src_buffer_size);
  print_spaces (indent_spaces);
  g_print ("total_version_count:uint = ");
  g_print ("%d\n", obj->total_version_count);
  print_spaces (indent_spaces);
  g_print ("unique_version_count:uint = ");
  g_print ("%d\n", obj->unique_version_count);
  print_spaces (indent_spaces);
  g_print ("unencoded_size:uint = ");
  g_print ("%d\n", obj->unencoded_size);
  print_spaces (indent_spaces);
  g_print ("literal_size:uint = ");
  g_print ("%d\n", obj->literal_size);
  print_spaces (indent_spaces);
  g_print ("control_size:uint = ");
  g_print ("%d\n", obj->control_size);
  print_spaces (indent_spaces);
  g_print ("patch_size:uint = ");
  g_print ("%d\n", obj->patch_size);
  print_spaces (indent_spaces);
  g_print ("patches:uint = ");
  g_print ("%d\n", obj->patches);
  print_spaces (indent_spaces);
  g_print ("literals:uint = ");
  g_print ("%d\n", obj->literals);
  print_spaces (indent_spaces);
  g_print ("cluster_versions:uint = ");
  g_print ("%d\n", obj->cluster_versions);
  print_spaces (indent_spaces);
  g_print ("cluster_compressed_size:uint = ");
  g_print ("%d\n", obj->cluster_compressed_size);
  print_spaces (indent_spaces);
  g_print ("cluster_uncompressed_size:uint = ");
  g_print ("%d\n", obj->cluster_uncompressed_size);
  print_spaces (indent_spaces);
  g_print ("policy:uint = ");
  g_print ("%d\n", obj->policy);
  print_spaces (indent_spaces);
  g_print ("flags:uint = ");
  g_print ("%d\n", obj->flags);
  print_spaces (indent_spaces);
  g_print ("cluster_max_versions:uint = ");
  g_print ("%d\n", obj->cluster_max_versions);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* XdfsState Serialize
 */

gboolean
serialize_xdfsstate_internal (SerialSink *sink, guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions)
{
  if (! (* sink->next_uint) (sink, src_buffer_files)) goto bail;
  if (! (* sink->next_uint) (sink, src_buffer_size)) goto bail;
  if (! (* sink->next_uint) (sink, total_version_count)) goto bail;
  if (! (* sink->next_uint) (sink, unique_version_count)) goto bail;
  if (! (* sink->next_uint) (sink, unencoded_size)) goto bail;
  if (! (* sink->next_uint) (sink, literal_size)) goto bail;
  if (! (* sink->next_uint) (sink, control_size)) goto bail;
  if (! (* sink->next_uint) (sink, patch_size)) goto bail;
  if (! (* sink->next_uint) (sink, patches)) goto bail;
  if (! (* sink->next_uint) (sink, literals)) goto bail;
  if (! (* sink->next_uint) (sink, cluster_versions)) goto bail;
  if (! (* sink->next_uint) (sink, cluster_compressed_size)) goto bail;
  if (! (* sink->next_uint) (sink, cluster_uncompressed_size)) goto bail;
  if (! (* sink->next_uint) (sink, policy)) goto bail;
  if (! (* sink->next_uint) (sink, flags)) goto bail;
  if (! (* sink->next_uint) (sink, cluster_max_versions)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdfsstate_obj_internal (SerialSink *sink, SerialXdfsState* obj)
{
  return serialize_xdfsstate_internal (sink, obj->src_buffer_files, obj->src_buffer_size, obj->total_version_count, obj->unique_version_count, obj->unencoded_size, obj->literal_size, obj->control_size, obj->patch_size, obj->patches, obj->literals, obj->cluster_versions, obj->cluster_compressed_size, obj->cluster_uncompressed_size, obj->policy, obj->flags, obj->cluster_max_versions);
}

gboolean
serialize_xdfsstate (SerialSink *sink, guint32 src_buffer_files, guint32 src_buffer_size, guint32 total_version_count, guint32 unique_version_count, guint32 unencoded_size, guint32 literal_size, guint32 control_size, guint32 patch_size, guint32 patches, guint32 literals, guint32 cluster_versions, guint32 cluster_compressed_size, guint32 cluster_uncompressed_size, guint32 policy, guint32 flags, guint32 cluster_max_versions)
{
  if (! (* sink->sink_type) (sink, ST_XdfsState, serializeio_count_xdfsstate (src_buffer_files, src_buffer_size, total_version_count, unique_version_count, unencoded_size, literal_size, control_size, patch_size, patches, literals, cluster_versions, cluster_compressed_size, cluster_uncompressed_size, policy, flags, cluster_max_versions), TRUE)) goto bail;
  if (! serialize_xdfsstate_internal (sink, src_buffer_files, src_buffer_size, total_version_count, unique_version_count, unencoded_size, literal_size, control_size, patch_size, patches, literals, cluster_versions, cluster_compressed_size, cluster_uncompressed_size, policy, flags, cluster_max_versions)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdfsstate_obj (SerialSink *sink, const SerialXdfsState* obj) {

  return serialize_xdfsstate (sink, obj->src_buffer_files, obj->src_buffer_size, obj->total_version_count, obj->unique_version_count, obj->unencoded_size, obj->literal_size, obj->control_size, obj->patch_size, obj->patches, obj->literals, obj->cluster_versions, obj->cluster_compressed_size, obj->cluster_uncompressed_size, obj->policy, obj->flags, obj->cluster_max_versions);
}

/* XdfsState Unserialize
 */

gboolean
unserialize_xdfsstate_internal_noalloc (SerialSource *source, SerialXdfsState* result)
{
  if (! (* source->next_uint) (source, &result->src_buffer_files)) goto bail;
  if (! (* source->next_uint) (source, &result->src_buffer_size)) goto bail;
  if (! (* source->next_uint) (source, &result->total_version_count)) goto bail;
  if (! (* source->next_uint) (source, &result->unique_version_count)) goto bail;
  if (! (* source->next_uint) (source, &result->unencoded_size)) goto bail;
  if (! (* source->next_uint) (source, &result->literal_size)) goto bail;
  if (! (* source->next_uint) (source, &result->control_size)) goto bail;
  if (! (* source->next_uint) (source, &result->patch_size)) goto bail;
  if (! (* source->next_uint) (source, &result->patches)) goto bail;
  if (! (* source->next_uint) (source, &result->literals)) goto bail;
  if (! (* source->next_uint) (source, &result->cluster_versions)) goto bail;
  if (! (* source->next_uint) (source, &result->cluster_compressed_size)) goto bail;
  if (! (* source->next_uint) (source, &result->cluster_uncompressed_size)) goto bail;
  if (! (* source->next_uint) (source, &result->policy)) goto bail;
  if (! (* source->next_uint) (source, &result->flags)) goto bail;
  if (! (* source->next_uint) (source, &result->cluster_max_versions)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdfsstate_internal (SerialSource *source, SerialXdfsState** result)
{
  SerialXdfsState* unser;
  (*result) = NULL;
  unser = (SerialXdfsState*) serializeio_source_alloc (source, sizeof (SerialXdfsState));
  if (! unser) goto bail;
  if (! unserialize_xdfsstate_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdfsstate (SerialSource *source, SerialXdfsState** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_XdfsState) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_xdfsstate_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}
