/* -*-Mode: C;-*-
 *
 * Copyright (C) 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el,v 1.10 2001/05/15 23:34:05 jmacd Exp $
 */

#include "edsio.h"

#include <errno.h>

/* Declarations. */

static const char* Edsio_StringInt_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_StringErrno_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_HandleString_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_HandleInt_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_StringStringString_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Int_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_String_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_StringString_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Handle_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Source_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_IntInt_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Errno_event_field_to_string (GenericEvent* ev, gint field);
static void print_spaces (guint n) { int i; for (i = 0; i < n; i += 1) g_print (" "); }


/* initialize this library. */

gboolean
edsio_edsio_init (void)
{
  static gboolean once = FALSE;
  static gboolean result = FALSE;
  if (once) return result;
  once = TRUE;
  eventdelivery_initialize_event_def (EC_EdsioFopenReadFailedValue, EL_Error, EF_None, "FopenReadFailed", "${0}: Fopen read failed: ${1}", & Edsio_StringInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioFopenWriteFailedValue, EL_Error, EF_None, "FopenWriteFailed", "${0}: Fopen write failed: ${1}", & Edsio_StringInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioMunmapFailedValue, EL_Error, EF_None, "MunmapFailed", "${0}: Munmap failed: ${1}", & Edsio_HandleInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioMmapFailedValue, EL_Error, EF_None, "MmapFailed", "${0}: Mmap failed: ${1}", & Edsio_HandleInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestFaultValue, EL_Warning, EF_None, "DigestFault", "${0}: Message digest computation fault", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestNotFinishedValue, EL_Error, EF_None, "DigestNotFinished", "${0}: Message digest value requested too early", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestNotComputedValue, EL_Error, EF_None, "DigestNotComputed", "${0}: Message digest computation was not requested", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestComputationLateValue, EL_Error, EF_None, "DigestComputationLate", "${0}: Message digest computation begun late", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioFwriteFailedValue, EL_Error, EF_None, "FwriteFailed", "${0}: Fwrite failed: ${1}", & Edsio_StringErrno_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioFreadFailedValue, EL_Error, EF_None, "FreadFailed", "${0}: Fread failed: ${1}", & Edsio_StringErrno_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioFseekFailedValue, EL_Error, EF_None, "FseekFailed", "${0}: Fseek failed: ${1}", & Edsio_StringErrno_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioHandleHasNoLengthValue, EL_Error, EF_None, "HandleHasNoLength", "${0}: Handle length not known", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIllegalDigestValue, EL_Error, EF_None, "IllegalDigest", "${0}: handle_digest_compute() applies only to writeable handles", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIllegalUnmapValue, EL_Error, EF_None, "IllegalUnmap", "${0}: Illegal unmap: page not mapped", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIllegalMapUnmapFirstValue, EL_Error, EF_None, "IllegalMapUnmapFirst", "${0}: Illegal map: unmap previous page first", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIllegalMapSeekValue, EL_Error, EF_None, "IllegalMapSeek", "${0}: Illegal map: required seek", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIllegalSeekValue, EL_Error, EF_None, "IllegalSeek", "${0}: Illegal seek", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidHandleModeValue, EL_Error, EF_None, "InvalidHandleMode", "${0}: Invalid ${1} operation requested", & Edsio_HandleString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidPageValue, EL_Error, EF_None, "InvalidPage", "${0}: Requested invalid page number", & Edsio_HandleInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioHandleClosedValue, EL_Error, EF_None, "HandleClosed", "${0}: Handle already closed", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioMissingMessageDigestValue, EL_Error, EF_None, "MissingMessageDigest", "No such message digest: ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioGModuleErrorValue, EL_Error, EF_None, "GModuleError", "GModule: ${0}: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioUnregisteredLibraryValue, EL_Error, EF_None, "UnregisteredLibrary", "Unregistered library: ${0}", & Edsio_Int_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestStringLongValue, EL_Error, EF_None, "DigestStringLong", "${0} string too long: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDigestStringShortValue, EL_Error, EF_None, "DigestStringShort", "${0} string too short: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidHexDigitValue, EL_Error, EF_None, "InvalidHexDigit", "Invalid hex digit ${0} in context: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidStreamChecksumValue, EL_Error, EF_None, "InvalidStreamChecksum", "Incorrect stream checksum", NULL);
  eventdelivery_initialize_event_def (EC_EdsioPersistenceUnavailableValue, EL_Error, EF_None, "PersistenceUnavailable", "Persistence is unavailable in host ${1} for property ${0}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioPropertyNotSetValue, EL_Error, EF_None, "PropertyNotSet", "${0} property not set", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioWrongDataTypeValue, EL_Error, EF_None, "WrongDataType", "Wrong property data type: received ${1}, expected ${2}", & Edsio_StringStringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioWrongHostTypeValue, EL_Error, EF_None, "WrongHostType", "Wrong property host type: received ${1}, expected ${2}", & Edsio_StringStringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioNoSuchHostTypeValue, EL_Error, EF_None, "NoSuchHostType", "Unregistered host type: ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioNoSuchPropertyTypeValue, EL_Error, EF_None, "NoSuchPropertyType", "Unregistered property type: ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioNoSuchPropertyValue, EL_Error, EF_None, "NoSuchProperty", "Unregistered property: ${0}", & Edsio_Int_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDuplicatePropertyNameRegisteredValue, EL_Warning, EF_None, "DuplicatePropertyNameRegistered", "Property name registered twice (ignored): ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDuplicateHostTypeRegisteredValue, EL_Error, EF_None, "DuplicateHostTypeRegistered", "Property host registered twice: ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioDuplicatePropertyTypeRegisteredValue, EL_Error, EF_None, "DuplicatePropertyTypeRegistered", "Property type registered twice: ${0}", & Edsio_String_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidIntegerSignValue, EL_Error, EF_None, "InvalidIntegerSign", "${0}: expected an unsigned integer: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIntegerOutOfRangeValue, EL_Error, EF_None, "IntegerOutOfRange", "${0}: integer out of range: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidIntegerStringValue, EL_Error, EF_None, "InvalidIntegerString", "${0}: not an integer: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIncorrectAllocationValue, EL_Error, EF_None, "IncorrectAllocation", "${0}: Incorrect allocation", & Edsio_Source_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioHandleEofValue, EL_Error, EF_None, "HandleEof", "${0}: Unexpected EOF", & Edsio_Handle_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioSourceEofValue, EL_Error, EF_None, "SourceEof", "${0}: Unexpected EOF", & Edsio_Source_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidChecksumValue, EL_Error, EF_None, "InvalidChecksum", "Checksum verification failed", NULL);
  eventdelivery_initialize_event_def (EC_EdsioMissingChecksumValue, EL_Error, EF_None, "MissingChecksum", "Missing embedded checksum in base64 encoding", NULL);
  eventdelivery_initialize_event_def (EC_EdsioInvalidBase64EncodingValue, EL_Error, EF_None, "InvalidBase64Encoding", "Invalid base64 encoding", NULL);
  eventdelivery_initialize_event_def (EC_EdsioOutputBufferShortValue, EL_Error, EF_None, "OutputBufferShort", "Output buffer is too short", NULL);
  eventdelivery_initialize_event_def (EC_EdsioUnexpectedTypeValue, EL_Error, EF_None, "UnexpectedType", "Unexpected serial type", NULL);
  eventdelivery_initialize_event_def (EC_EdsioUnexpectedLibraryTypeValue, EL_Error, EF_None, "UnexpectedLibraryType", "Unexpected serial library type: expected ${0}, received ${1}", & Edsio_IntInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioUnregisteredTypeValue, EL_Error, EF_None, "UnregisteredType", "Unregistered serial type: library=${0} number=${1}", & Edsio_IntInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioTimeFailureValue, EL_Error, EF_None, "TimeFailure", "Time failed: ${0}", & Edsio_Errno_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioGetTimeOfDayFailureValue, EL_Error, EF_None, "GetTimeOfDayFailure", "Gettimeofday failed: ${0}", & Edsio_Errno_event_field_to_string);
  serializeio_initialize_type ("ST_Test", ST_Test, &unserialize_test_internal, &serialize_test_obj_internal, &serializeio_count_test_obj, &serializeio_print_test_obj);
  serializeio_initialize_type ("ST_GenericTime", ST_GenericTime, &unserialize_generictime_internal, &serialize_generictime_obj_internal, &serializeio_count_generictime_obj, &serializeio_print_generictime_obj);
  serializeio_initialize_type ("ST_EdsioString", ST_EdsioString, &unserialize_edsiostring_internal, &serialize_edsiostring_obj_internal, &serializeio_count_edsiostring_obj, &serializeio_print_edsiostring_obj);
  serializeio_initialize_type ("ST_EdsioBytes", ST_EdsioBytes, &unserialize_edsiobytes_internal, &serialize_edsiobytes_obj_internal, &serializeio_count_edsiobytes_obj, &serializeio_print_edsiobytes_obj);
  serializeio_initialize_type ("ST_EdsioUint", ST_EdsioUint, &unserialize_edsiouint_internal, &serialize_edsiouint_obj_internal, &serializeio_count_edsiouint_obj, &serializeio_print_edsiouint_obj);
  edsio_library_register (6, "edsio");
  result = TRUE;
  return TRUE;
};

/* EdsioUint Count
 */

guint
serializeio_count_edsiouint (guint32 val) {
  guint size = sizeof (SerialEdsioUint);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_edsiouint_obj (SerialEdsioUint const* obj) {
  return serializeio_count_edsiouint (obj->val);
}

/* EdsioUint Print
 */

void
serializeio_print_edsiouint_obj (SerialEdsioUint* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("val:uint = ");
  g_print ("%d\n", obj->val);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* EdsioUint Serialize
 */

gboolean
serialize_edsiouint_internal (SerialSink *sink, guint32 val)
{
  if (! (* sink->next_uint) (sink, val)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiouint_obj_internal (SerialSink *sink, SerialEdsioUint* obj)
{
  return serialize_edsiouint_internal (sink, obj->val);
}

gboolean
serialize_edsiouint (SerialSink *sink, guint32 val)
{
  if (! (* sink->sink_type) (sink, ST_EdsioUint, serializeio_count_edsiouint (val), TRUE)) goto bail;
  if (! serialize_edsiouint_internal (sink, val)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiouint_obj (SerialSink *sink, const SerialEdsioUint* obj) {

  return serialize_edsiouint (sink, obj->val);
}

/* EdsioUint Unserialize
 */

gboolean
unserialize_edsiouint_internal_noalloc (SerialSource *source, SerialEdsioUint* result)
{
  if (! (* source->next_uint) (source, &result->val)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiouint_internal (SerialSource *source, SerialEdsioUint** result)
{
  SerialEdsioUint* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialEdsioUint));
  if (! unser) goto bail;
  if (! unserialize_edsiouint_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiouint (SerialSource *source, SerialEdsioUint** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_EdsioUint) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_edsiouint_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* EdsioBytes Count
 */

guint
serializeio_count_edsiobytes (guint32 val_len, const guint8* val) {
  guint size = sizeof (SerialEdsioBytes);
  ALIGN_8 (size);
  size += val_len;
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_edsiobytes_obj (SerialEdsioBytes const* obj) {
  return serializeio_count_edsiobytes (obj->val_len, obj->val);
}

/* EdsioBytes Print
 */

void
serializeio_print_edsiobytes_obj (SerialEdsioBytes* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("val:bytes = ");
  serializeio_print_bytes (obj->val, obj->val_len);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* EdsioBytes Serialize
 */

gboolean
serialize_edsiobytes_internal (SerialSink *sink, guint32 val_len, const guint8* val)
{
  if (! (* sink->next_bytes) (sink, val, val_len)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiobytes_obj_internal (SerialSink *sink, SerialEdsioBytes* obj)
{
  return serialize_edsiobytes_internal (sink, obj->val_len, obj->val);
}

gboolean
serialize_edsiobytes (SerialSink *sink, guint32 val_len, const guint8* val)
{
  if (! (* sink->sink_type) (sink, ST_EdsioBytes, serializeio_count_edsiobytes (val_len, val), TRUE)) goto bail;
  if (! serialize_edsiobytes_internal (sink, val_len, val)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiobytes_obj (SerialSink *sink, const SerialEdsioBytes* obj) {

  return serialize_edsiobytes (sink, obj->val_len, obj->val);
}

/* EdsioBytes Unserialize
 */

gboolean
unserialize_edsiobytes_internal_noalloc (SerialSource *source, SerialEdsioBytes* result)
{
  if (! (* source->next_bytes) (source, &result->val, &result->val_len)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiobytes_internal (SerialSource *source, SerialEdsioBytes** result)
{
  SerialEdsioBytes* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialEdsioBytes));
  if (! unser) goto bail;
  if (! unserialize_edsiobytes_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiobytes (SerialSource *source, SerialEdsioBytes** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_EdsioBytes) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_edsiobytes_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* EdsioString Count
 */

guint
serializeio_count_edsiostring (const gchar* val) {
  guint size = sizeof (SerialEdsioString);
  ALIGN_8 (size);
  size += strlen (val) + 1;
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_edsiostring_obj (SerialEdsioString const* obj) {
  return serializeio_count_edsiostring (obj->val);
}

/* EdsioString Print
 */

void
serializeio_print_edsiostring_obj (SerialEdsioString* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("val:string = ");
  g_print ("%s\n", obj->val);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* EdsioString Serialize
 */

gboolean
serialize_edsiostring_internal (SerialSink *sink, const gchar* val)
{
  if (! (* sink->next_string) (sink, val)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiostring_obj_internal (SerialSink *sink, SerialEdsioString* obj)
{
  return serialize_edsiostring_internal (sink, obj->val);
}

gboolean
serialize_edsiostring (SerialSink *sink, const gchar* val)
{
  if (! (* sink->sink_type) (sink, ST_EdsioString, serializeio_count_edsiostring (val), TRUE)) goto bail;
  if (! serialize_edsiostring_internal (sink, val)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_edsiostring_obj (SerialSink *sink, const SerialEdsioString* obj) {

  return serialize_edsiostring (sink, obj->val);
}

/* EdsioString Unserialize
 */

gboolean
unserialize_edsiostring_internal_noalloc (SerialSource *source, SerialEdsioString* result)
{
  if (! (* source->next_string) (source, &result->val)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiostring_internal (SerialSource *source, SerialEdsioString** result)
{
  SerialEdsioString* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialEdsioString));
  if (! unser) goto bail;
  if (! unserialize_edsiostring_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_edsiostring (SerialSource *source, SerialEdsioString** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_EdsioString) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_edsiostring_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* GenericTime Count
 */

guint
serializeio_count_generictime (guint32 seconds, guint32 nanos) {
  guint size = sizeof (SerialGenericTime);
  ALIGN_8 (size);
  ALIGN_8 (size);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_generictime_obj (SerialGenericTime const* obj) {
  return serializeio_count_generictime (obj->seconds, obj->nanos);
}

/* GenericTime Print
 */

void
serializeio_print_generictime_obj (SerialGenericTime* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("seconds:uint = ");
  g_print ("%d\n", obj->seconds);
  print_spaces (indent_spaces);
  g_print ("nanos:uint = ");
  g_print ("%d\n", obj->nanos);
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* GenericTime Serialize
 */

gboolean
serialize_generictime_internal (SerialSink *sink, guint32 seconds, guint32 nanos)
{
  if (! (* sink->next_uint) (sink, seconds)) goto bail;
  if (! (* sink->next_uint) (sink, nanos)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_generictime_obj_internal (SerialSink *sink, SerialGenericTime* obj)
{
  return serialize_generictime_internal (sink, obj->seconds, obj->nanos);
}

gboolean
serialize_generictime (SerialSink *sink, guint32 seconds, guint32 nanos)
{
  if (! (* sink->sink_type) (sink, ST_GenericTime, serializeio_count_generictime (seconds, nanos), TRUE)) goto bail;
  if (! serialize_generictime_internal (sink, seconds, nanos)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_generictime_obj (SerialSink *sink, const SerialGenericTime* obj) {

  return serialize_generictime (sink, obj->seconds, obj->nanos);
}

/* GenericTime Unserialize
 */

gboolean
unserialize_generictime_internal_noalloc (SerialSource *source, SerialGenericTime* result)
{
  if (! (* source->next_uint) (source, &result->seconds)) goto bail;
  if (! (* source->next_uint) (source, &result->nanos)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_generictime_internal (SerialSource *source, SerialGenericTime** result)
{
  SerialGenericTime* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialGenericTime));
  if (! unser) goto bail;
  if (! unserialize_generictime_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_generictime (SerialSource *source, SerialGenericTime** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_GenericTime) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_generictime_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* Test Count
 */

guint
serializeio_count_test (guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d) {
  guint size = sizeof (SerialTest);
  ALIGN_8 (size);
  {
    gint i;
    size += 8; /* alignment */
    for (i = 0; i < b_len; i += 1)
      {
        size += sizeof (guint32);
      }
  }
  ALIGN_8 (size);
  {
    gint i;
    size += 8; /* alignment */
    for (i = 0; i < c_len; i += 1)
      {
        size += serializeio_count_generictime_obj ((c[i])) + sizeof (void*);
      }
  }
  ALIGN_8 (size);
  {
    gint i;
    size += 8; /* alignment */
    for (i = 0; i < d_len; i += 1)
      {
        size += serializeio_count_generictime_obj (& (d[i]));
      }
  }
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_test_obj (SerialTest const* obj) {
  return serializeio_count_test (obj->b_len, obj->b, obj->c_len, obj->c, obj->d_len, obj->d);
}

/* Test Print
 */

void
serializeio_print_test_obj (SerialTest* obj, guint indent_spaces) {
  g_print ("{\n");
  print_spaces (indent_spaces);
  g_print ("b:(array uint) = ");
  g_print ("{\n");
  {
    gint i;
    indent_spaces += 2;
    for (i = 0; i < obj->b_len; i += 1)
      {
        print_spaces (indent_spaces);
        g_print ("%d: ", i);
          g_print ("%d\n", (obj->b[i]));
    }
  }
  print_spaces (indent_spaces);
  indent_spaces -= 2;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("c:(array (ptr GenericTime)) = ");
  g_print ("{\n");
  {
    gint i;
    indent_spaces += 2;
    for (i = 0; i < obj->c_len; i += 1)
      {
        print_spaces (indent_spaces);
        g_print ("%d: ", i);
          serializeio_print_generictime_obj ((obj->c[i]), indent_spaces + 2);
    }
  }
  print_spaces (indent_spaces);
  indent_spaces -= 2;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("d:(array GenericTime) = ");
  g_print ("{\n");
  {
    gint i;
    indent_spaces += 2;
    for (i = 0; i < obj->d_len; i += 1)
      {
        print_spaces (indent_spaces);
        g_print ("%d: ", i);
          serializeio_print_generictime_obj (& (obj->d[i]), indent_spaces + 2);
    }
  }
  print_spaces (indent_spaces);
  indent_spaces -= 2;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("}\n");
}

/* Test Serialize
 */

gboolean
serialize_test_internal (SerialSink *sink, guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d)
{
  {
    gint i;
    if (! (* sink->next_uint) (sink, b_len)) goto bail;
    for (i = 0; i < b_len; i += 1)
      {
        if (! (* sink->next_uint) (sink, (b[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* sink->next_uint) (sink, c_len)) goto bail;
    for (i = 0; i < c_len; i += 1)
      {
        if (! serialize_generictime_internal (sink, (c[i])->seconds, (c[i])->nanos)) goto bail;
      }
  }
  {
    gint i;
    if (! (* sink->next_uint) (sink, d_len)) goto bail;
    for (i = 0; i < d_len; i += 1)
      {
        if (! serialize_generictime_internal (sink, (d[i]).seconds, (d[i]).nanos)) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_test_obj_internal (SerialSink *sink, SerialTest* obj)
{
  return serialize_test_internal (sink, obj->b_len, obj->b, obj->c_len, obj->c, obj->d_len, obj->d);
}

gboolean
serialize_test (SerialSink *sink, guint32 b_len, guint32 const* b, guint32 c_len, SerialGenericTime* const* c, guint32 d_len, SerialGenericTime const* d)
{
  if (! (* sink->sink_type) (sink, ST_Test, serializeio_count_test (b_len, b, c_len, c, d_len, d), TRUE)) goto bail;
  if (! serialize_test_internal (sink, b_len, b, c_len, c, d_len, d)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_test_obj (SerialSink *sink, const SerialTest* obj) {

  return serialize_test (sink, obj->b_len, obj->b, obj->c_len, obj->c, obj->d_len, obj->d);
}

/* Test Unserialize
 */

gboolean
unserialize_test_internal_noalloc (SerialSource *source, SerialTest* result)
{
  {
    gint i;
    if (! (* source->next_uint) (source, &result->b_len)) goto bail;
    if (! (result->b = serializeio_source_alloc (source, sizeof (guint32) * result->b_len))) goto bail;
    for (i = 0; i < result->b_len; i += 1)
      {
        if (! (* source->next_uint) (source, &(result->b[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* source->next_uint) (source, &result->c_len)) goto bail;
    if (! (result->c = serializeio_source_alloc (source, sizeof (SerialGenericTime*) * result->c_len))) goto bail;
    for (i = 0; i < result->c_len; i += 1)
      {
        if (! unserialize_generictime_internal (source, &(result->c[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* source->next_uint) (source, &result->d_len)) goto bail;
    if (! (result->d = serializeio_source_alloc (source, sizeof (SerialGenericTime) * result->d_len))) goto bail;
    for (i = 0; i < result->d_len; i += 1)
      {
        if (! unserialize_generictime_internal_noalloc (source, &(result->d[i]))) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_test_internal (SerialSource *source, SerialTest** result)
{
  SerialTest* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialTest));
  if (! unser) goto bail;
  if (! unserialize_test_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_test (SerialSource *source, SerialTest** result)
{
  SerialType t = (* source->source_type) (source, TRUE);
  if (t != ST_Test) { edsio_generate_void_event (EC_EdsioUnexpectedType); goto bail; }
  if (! unserialize_test_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

void
edsio_generate_errno_event_internal (EdsioErrnoEventCode _code, const char* _srcfile, gint _srcline)
{
  EdsioErrnoEvent *_e = g_new0 (EdsioErrnoEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->ev_errno = errno;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Errno_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioErrnoEvent* it = (EdsioErrnoEvent*) ev;
  switch (field)
    {
    case 0: return g_strdup (g_strerror (it->ev_errno));
    default: abort ();
    }
}

const EdsioErrnoEventCode EC_EdsioGetTimeOfDayFailure = { EC_EdsioGetTimeOfDayFailureValue };

const EdsioErrnoEventCode EC_EdsioTimeFailure = { EC_EdsioTimeFailureValue };

void
edsio_generate_intint_event_internal (EdsioIntIntEventCode _code, const char* _srcfile, gint _srcline, int library, int number)
{
  EdsioIntIntEvent *_e = g_new0 (EdsioIntIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->library = library;
  _e->number = number;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_IntInt_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioIntIntEvent* it = (EdsioIntIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_int_to_string (it->library);
    case 1: return eventdelivery_int_to_string (it->number);
    default: abort ();
    }
}

const EdsioIntIntEventCode EC_EdsioUnregisteredType = { EC_EdsioUnregisteredTypeValue };

const EdsioIntIntEventCode EC_EdsioUnexpectedLibraryType = { EC_EdsioUnexpectedLibraryTypeValue };

void
edsio_generate_void_event_internal (EdsioVoidEventCode _code, const char* _srcfile, gint _srcline)
{
  EdsioVoidEvent *_e = g_new0 (EdsioVoidEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const EdsioVoidEventCode EC_EdsioUnexpectedType = { EC_EdsioUnexpectedTypeValue };

const EdsioVoidEventCode EC_EdsioOutputBufferShort = { EC_EdsioOutputBufferShortValue };

const EdsioVoidEventCode EC_EdsioInvalidBase64Encoding = { EC_EdsioInvalidBase64EncodingValue };

const EdsioVoidEventCode EC_EdsioMissingChecksum = { EC_EdsioMissingChecksumValue };

const EdsioVoidEventCode EC_EdsioInvalidChecksum = { EC_EdsioInvalidChecksumValue };

void
edsio_generate_source_event_internal (EdsioSourceEventCode _code, const char* _srcfile, gint _srcline, SerialSource* source)
{
  EdsioSourceEvent *_e = g_new0 (EdsioSourceEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->source = source;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Source_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioSourceEvent* it = (EdsioSourceEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_source_to_string (it->source);
    default: abort ();
    }
}

const EdsioSourceEventCode EC_EdsioSourceEof = { EC_EdsioSourceEofValue };

void
edsio_generate_handle_event_internal (EdsioHandleEventCode _code, const char* _srcfile, gint _srcline, FileHandle* handle)
{
  EdsioHandleEvent *_e = g_new0 (EdsioHandleEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->handle = handle;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Handle_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioHandleEvent* it = (EdsioHandleEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_handle_to_string (it->handle);
    default: abort ();
    }
}

const EdsioHandleEventCode EC_EdsioHandleEof = { EC_EdsioHandleEofValue };

const EdsioSourceEventCode EC_EdsioIncorrectAllocation = { EC_EdsioIncorrectAllocationValue };

void
edsio_generate_stringstring_event_internal (EdsioStringStringEventCode _code, const char* _srcfile, gint _srcline, const char* msg, const char* arg)
{
  EdsioStringStringEvent *_e = g_new0 (EdsioStringStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->msg = msg;
  _e->arg = arg;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_StringString_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringStringEvent* it = (EdsioStringStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->msg);
    case 1: return eventdelivery_string_to_string (it->arg);
    default: abort ();
    }
}

const EdsioStringStringEventCode EC_EdsioInvalidIntegerString = { EC_EdsioInvalidIntegerStringValue };

const EdsioStringStringEventCode EC_EdsioIntegerOutOfRange = { EC_EdsioIntegerOutOfRangeValue };

const EdsioStringStringEventCode EC_EdsioInvalidIntegerSign = { EC_EdsioInvalidIntegerSignValue };

void
edsio_generate_string_event_internal (EdsioStringEventCode _code, const char* _srcfile, gint _srcline, const char* name)
{
  EdsioStringEvent *_e = g_new0 (EdsioStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->name = name;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_String_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringEvent* it = (EdsioStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->name);
    default: abort ();
    }
}

const EdsioStringEventCode EC_EdsioDuplicatePropertyTypeRegistered = { EC_EdsioDuplicatePropertyTypeRegisteredValue };

const EdsioStringEventCode EC_EdsioDuplicateHostTypeRegistered = { EC_EdsioDuplicateHostTypeRegisteredValue };

const EdsioStringEventCode EC_EdsioDuplicatePropertyNameRegistered = { EC_EdsioDuplicatePropertyNameRegisteredValue };

void
edsio_generate_int_event_internal (EdsioIntEventCode _code, const char* _srcfile, gint _srcline, int num)
{
  EdsioIntEvent *_e = g_new0 (EdsioIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->num = num;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Int_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioIntEvent* it = (EdsioIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_int_to_string (it->num);
    default: abort ();
    }
}

const EdsioIntEventCode EC_EdsioNoSuchProperty = { EC_EdsioNoSuchPropertyValue };

const EdsioStringEventCode EC_EdsioNoSuchPropertyType = { EC_EdsioNoSuchPropertyTypeValue };

const EdsioStringEventCode EC_EdsioNoSuchHostType = { EC_EdsioNoSuchHostTypeValue };

void
edsio_generate_stringstringstring_event_internal (EdsioStringStringStringEventCode _code, const char* _srcfile, gint _srcline, const char* name, const char* recv, const char* expect)
{
  EdsioStringStringStringEvent *_e = g_new0 (EdsioStringStringStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->name = name;
  _e->recv = recv;
  _e->expect = expect;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_StringStringString_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringStringStringEvent* it = (EdsioStringStringStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->name);
    case 1: return eventdelivery_string_to_string (it->recv);
    case 2: return eventdelivery_string_to_string (it->expect);
    default: abort ();
    }
}

const EdsioStringStringStringEventCode EC_EdsioWrongHostType = { EC_EdsioWrongHostTypeValue };

const EdsioStringStringStringEventCode EC_EdsioWrongDataType = { EC_EdsioWrongDataTypeValue };

const EdsioStringEventCode EC_EdsioPropertyNotSet = { EC_EdsioPropertyNotSetValue };

const EdsioStringStringEventCode EC_EdsioPersistenceUnavailable = { EC_EdsioPersistenceUnavailableValue };

const EdsioVoidEventCode EC_EdsioInvalidStreamChecksum = { EC_EdsioInvalidStreamChecksumValue };

const EdsioStringStringEventCode EC_EdsioInvalidHexDigit = { EC_EdsioInvalidHexDigitValue };

const EdsioStringStringEventCode EC_EdsioDigestStringShort = { EC_EdsioDigestStringShortValue };

const EdsioStringStringEventCode EC_EdsioDigestStringLong = { EC_EdsioDigestStringLongValue };

const EdsioIntEventCode EC_EdsioUnregisteredLibrary = { EC_EdsioUnregisteredLibraryValue };

const EdsioStringStringEventCode EC_EdsioGModuleError = { EC_EdsioGModuleErrorValue };

const EdsioStringEventCode EC_EdsioMissingMessageDigest = { EC_EdsioMissingMessageDigestValue };

const EdsioHandleEventCode EC_EdsioHandleClosed = { EC_EdsioHandleClosedValue };

void
edsio_generate_handleint_event_internal (EdsioHandleIntEventCode _code, const char* _srcfile, gint _srcline, FileHandle* handle, int page)
{
  EdsioHandleIntEvent *_e = g_new0 (EdsioHandleIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->handle = handle;
  _e->page = page;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_HandleInt_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioHandleIntEvent* it = (EdsioHandleIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_handle_to_string (it->handle);
    case 1: return eventdelivery_int_to_string (it->page);
    default: abort ();
    }
}

const EdsioHandleIntEventCode EC_EdsioInvalidPage = { EC_EdsioInvalidPageValue };

void
edsio_generate_handlestring_event_internal (EdsioHandleStringEventCode _code, const char* _srcfile, gint _srcline, FileHandle* handle, const char* op)
{
  EdsioHandleStringEvent *_e = g_new0 (EdsioHandleStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->handle = handle;
  _e->op = op;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_HandleString_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioHandleStringEvent* it = (EdsioHandleStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_handle_to_string (it->handle);
    case 1: return eventdelivery_string_to_string (it->op);
    default: abort ();
    }
}

const EdsioHandleStringEventCode EC_EdsioInvalidHandleMode = { EC_EdsioInvalidHandleModeValue };

const EdsioHandleEventCode EC_EdsioIllegalSeek = { EC_EdsioIllegalSeekValue };

const EdsioHandleEventCode EC_EdsioIllegalMapSeek = { EC_EdsioIllegalMapSeekValue };

const EdsioHandleEventCode EC_EdsioIllegalMapUnmapFirst = { EC_EdsioIllegalMapUnmapFirstValue };

const EdsioHandleEventCode EC_EdsioIllegalUnmap = { EC_EdsioIllegalUnmapValue };

const EdsioHandleEventCode EC_EdsioIllegalDigest = { EC_EdsioIllegalDigestValue };

const EdsioHandleEventCode EC_EdsioHandleHasNoLength = { EC_EdsioHandleHasNoLengthValue };

void
edsio_generate_stringerrno_event_internal (EdsioStringErrnoEventCode _code, const char* _srcfile, gint _srcline, const char* name)
{
  EdsioStringErrnoEvent *_e = g_new0 (EdsioStringErrnoEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->name = name;
  _e->ev_errno = errno;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_StringErrno_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringErrnoEvent* it = (EdsioStringErrnoEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->name);
    case 1: return g_strdup (g_strerror (it->ev_errno));
    default: abort ();
    }
}

const EdsioStringErrnoEventCode EC_EdsioFseekFailed = { EC_EdsioFseekFailedValue };

const EdsioStringErrnoEventCode EC_EdsioFreadFailed = { EC_EdsioFreadFailedValue };

const EdsioStringErrnoEventCode EC_EdsioFwriteFailed = { EC_EdsioFwriteFailedValue };

const EdsioHandleEventCode EC_EdsioDigestComputationLate = { EC_EdsioDigestComputationLateValue };

const EdsioHandleEventCode EC_EdsioDigestNotComputed = { EC_EdsioDigestNotComputedValue };

const EdsioHandleEventCode EC_EdsioDigestNotFinished = { EC_EdsioDigestNotFinishedValue };

const EdsioHandleEventCode EC_EdsioDigestFault = { EC_EdsioDigestFaultValue };

const EdsioHandleIntEventCode EC_EdsioMmapFailed = { EC_EdsioMmapFailedValue };

const EdsioHandleIntEventCode EC_EdsioMunmapFailed = { EC_EdsioMunmapFailedValue };

void
edsio_generate_stringint_event_internal (EdsioStringIntEventCode _code, const char* _srcfile, gint _srcline, const char* name, int err)
{
  EdsioStringIntEvent *_e = g_new0 (EdsioStringIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->name = name;
  _e->err = err;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_StringInt_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringIntEvent* it = (EdsioStringIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->name);
    case 1: return eventdelivery_int_to_string (it->err);
    default: abort ();
    }
}

const EdsioStringIntEventCode EC_EdsioFopenWriteFailed = { EC_EdsioFopenWriteFailedValue };

const EdsioStringIntEventCode EC_EdsioFopenReadFailed = { EC_EdsioFopenReadFailedValue };

