/*
    XCruise - A directory browser
    Copyright (C) 1999  Yusuke Shinyama <euske@cl.cs.titech.ac.jp>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 *  XCruise version 0.2
 *  by Yusuke Shinyama (euske@cl.cs.titech.ac.jp)
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define true True
#define false False

/* #define DEBUG */


/*  Constant definitions
 */
#define PathLen		1024
#define FileNameLen	256

#define CurrentSize	100.0
#define GalaxyPoly	32
#define Poly8R		8
#define Poly16R		80
#define Poly32R		800
#define ViewR		40
#define WormPoints	20
#define MaxStars	1024
#define MaxLinks	256

#define RootColor	0
#define PlanetColors	4
#define NoReadPlanet	1
#define GalaxyColors	2
#define NoReadGalaxy	1
#define WormholeColors	1
#define NoReadWormhole	1
#define CurrentColors	(1+PlanetColors+NoReadPlanet+GalaxyColors+\
			 NoReadGalaxy+WormholeColors+NoReadWormhole)
#define TheColors	(CurrentColors*2)
#define NameFonts	4

#define CursorSize	20
#define MeasureUnit	4
#define MeasureSize	400
#define MeasureHeight	32


/*  Type definitions
 */
typedef struct _Point3D {
    double  x;
    double  y;
    double  z;
} Point3D;

typedef struct _ZStar {
    union _star*   s;
    int     z;
} ZStar;

enum {
    T_Planet   = 0,
    T_Galaxy   = 1,
    T_Wormhole = 2
};

enum {
    S_OK       = 0,
    S_NoRead   = 1
};

typedef struct _starinfo {
    char    name[FileNameLen];	/* set by getDirectory */
    int     type;		/* set by getDirectory */
    int     stat;		/* set by getDirectory */
    Point3D px, py;
    Point3D pos;
    Point3D perspos;
    double  r;
    double  dist;
    int     col;
    union _star* parent;
} starinfo;

typedef struct _planetinfo {
    starinfo info;
    unsigned long size;		/* set by getDirectory */
} planetinfo;

typedef struct _galazyinfo {
    starinfo info;
    int	    expanded;
    int	    marked;
    char    path[PathLen];
    Point3D oldpos;
    double  oldr;
    int     nst;
    union _star* children;
    int     nview;
    struct _ZStar*  view;
} galaxyinfo;

typedef struct _wormholeinfo {
    starinfo info;
    char    linkpath[PathLen];
    Point3D wpt[WormPoints];
} wormholeinfo;

typedef union _star {
    starinfo   i;
    planetinfo p;
    galaxyinfo g;
    wormholeinfo w;
} star;


/*  Variable declarations
 */
extern	Display* disp;
extern	Colormap cmap;
extern	int	colorize;
extern	int	screenWidth;
extern	int	screenHeight;
extern	int	screenSize;

extern	long	rgbWhite;
extern	long	rgbBlack;
extern	GC	defaultgc;
extern	GC	alrtgc;
extern	GC	stargc[TheColors];
extern	GC	namegc[NameFonts];
extern	GC	infogc;
extern	GC	meangc;
extern	GC	bggc;
extern	GC	cursorgc;
extern	XFontStruct* namefont[NameFonts];
extern	XFontStruct* alrtfont;
extern	XFontStruct* infofont;
extern	XFontStruct* meanfont;
extern	int	namesize[NameFonts];

extern	star	universe;
extern	star*	curzone;
extern	star*	stpswin;

extern	int	lnupdate;
extern	int	numlinks;
extern	wormholeinfo* curlinks[MaxLinks];
extern	star	starbuff[MaxStars];
extern	Point3D	zerop;
extern	double	cirx[GalaxyPoly], ciry[GalaxyPoly];
extern	XRectangle meanhclip;
extern	XRectangle meanvclip;

extern	Point3D	viewp;
extern	Point3D	forwardv, rightv, upperv;
extern	double	vspeed;

extern	double	accel1,	accel2;
extern	double	diraccel;
extern	int	delayticks;

extern	Window	mywin;
extern	Pixmap	myscreen;

extern	int	viewallflag;
extern	int	consoleflag;


/*  Prototype Declarations
 */

/* in draw.c */
void alert(char* s, int ypos);
void drawCursor(int cx, int cy);
void drawInfo(int titleflag);
void drawMeasure(int rot1, int rot2);
void redrawScreen(void);
void drawWormholes(void);
void drawTheUniverse(void);

/* in task.c */
void iniTask(void);
void eventLoop(int titleflag);

/* in zone.c */
void expandGalaxy(galaxyinfo* s);
void collapseGalaxy(galaxyinfo* s);
void cleanupGalaxy(galaxyinfo* s);
void checkSwitch(void);
void updateLink(void);


/*  Macro definitions
 */
#define cstrlen(x)	(sizeof(x)-1)
#define xalloc(x)	malloc(x)
#define xfree(x)	free((char*)(x))

/* dirty! */
#define MeasurePosX	((screenWidth - MeasureSize - MeasureHeight) / 2)
#define MeasurePosY	((screenHeight - MeasureSize - MeasureHeight) / 2)

#define inValid(x,y,r)	(-screenWidth/2 < ((x) + (r)) || \
			 ((x) - (r)) < screenWidth/2 || \
			 -screenHeight/2 < ((y) + (r)) || \
			 ((y) - (r)) < screenHeight/2)

/* vector operation */
#define product(v1,v2)	((v1).x*(v2).x + (v1).y*(v2).y + (v1).z*(v2).z)
#define vlength(v)	sqrt((v).x*(v).x + (v).y*(v).y + (v).z*(v).z)
#define formalize(v)	{ double l=vlength(v); \
                          (v).x /= l; (v).y /= l; (v).z /= l; }
#define multiply(v, c)	{(v).x *= c; (v).y *= c; (v).z *= c;}
#define curt(x)		pow(x, 1.0/3.0)

