#ifndef  _TBOX_H_
#define  _TBOX_H_

#include "proto_decl.h"

#define TB_SPACE 10
#define TB_MAP    1
#define TB_UNMAP  2

typedef struct _rgb {
  unsigned long pixel;
  char rrggbb[7];
  char c1, c2;
  int x;
} rgb ;

typedef struct _TBox {
	Window		frame, title, main, ctr, ok;
	unsigned long 	fg, bg, ts, bs;
	GC		gc;
	XFontStruct 	*font;
	int		height, width, b_width, b_height;
	int             t_height, t_width;
	int             str_x, str_y;
	char            title_text [128];
	int             stat;
} TBox;
TBox trombines_box;
FCT (void, DisplayTrombines, () );

FCT (void, ConfigTrombinesBox, (int width, int height) );
FCT (void, DisplayTrombines, () );
FCT (int, ExposeTrombinesBox, (XEvent *ev) );
FCT (void, InitTrombinesBox, () );
FCT (int, ButtonTrombinesBox, ( XButtonEvent * ev ));

#define GetTrombinesBoxFrame() (trombines_box.frame)


/* XPM */
static char *bp_16gray[] = {
/* width height ncolors chars_per_pixel */
"110 150 16 1",
/* colors */
"  c #A5A5A5",
". c #9B9B9B",
"X c #8F8F8F",
"o c #6D6D6D",
"O c #656565",
"+ c #F2F2F2",
"@ c #232323",
"# c #151515",
"$ c #828282",
"% c #767676",
"& c #585858",
"* c #F5F5F5",
"= c #424242",
"- c #CDCDCD",
"; c #0C0C0C",
": c #B3B3B3",
/* pixels */
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++++++++++++++----:$:++::++++++++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++++++++-.o&O%$oO&@@@&&&&$:-:  ++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++++*--:%=@@#&$o=@;#;#@O$.=@@@@=o  ++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++:$=@;;;;##;;@#;###@@==@;;;;;;;@==oX :+++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++ =;;;;;;;;;;;;#####@#@@#;;;;;;;;#@#@=&o--++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++X=;;;;;;#;###;;;###;#@######;;;;;;#;##;##@&:+++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++=;;;;;##;#####;####;;;#######;;;;;;###;;@@=#=$++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++O#;;;#;;;########################;;;;#;#;###@##@= *+++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++* =;;;;#;#;;#;;####@###;############;###;#####;;#@#;@ +++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++.O@;;;;;;;;###################;#########;#;#######;#@##=++++++++++++++++++++++++++",
"++++++++++++++++++++++++++-$&@;####;##;#;#########################@####;######;;;#@;@:++++++++++++++++++++++++",
"+++++++++++++++++++++++++ &=;;##;;;########@############@##########@##########@#;;###@%+++++++++++++++++++++++",
"++++++++++++++++++++++++ o#;;###;#######@##############@############;###########;;####;&++++++++++++++++++++++",
"+++++++++++++++++++++++$=#;;##########@@##########################################;#@@@;$+++++++++++++++++++++",
"++++++++++++++++++++++ =#;###;##@####@#################@###################@######;;#@#;@-++++++++++++++++++++",
"++++++++++++++++++++++O@@########@##@########@###########@#########@##@############;##@#;=*+++++++++++++++++++",
"+++++++++++++++++++++.##@@@#;##@###@###@##########;######@@####@#############@@#####;##@;@-+++++++++++++++++++",
"++++++++++++++++++++o#;@@@####@###@####@####@###########@#####@####@@@########@##########;o+++++++++++++++++++",
"++++++++++++++++++*&;###@###@#@########@###@##################@######@########@#####;####;@ ++++++++++++++++++",
"+++++++++++++++++-@;;#@@####@@#;#@###@@###@@#@#@#######@####@@#####@@@########@@###########=:*++++++++++++++++",
"++++++++++++++++:@;##@##@#@@@####@##@##@#@@#@#@###@#@#@###@@#@@###@@@@####@###@@####;#####@@=-++++++++++++++++",
"++++++++++++++++=@#@@@#@@@#@###@@##@##@##@#@@@@@@#@####@@@@#@@##@#@@@@@####################@;@*+++++++++++++++",
"++++++++++++++++&@##@##@@#######@#@####@####@@#@#@#@@#@##@@@@@@@#@@@=@#########@@##########@#=$+++++++++++++++",
"+++++++++++++++o@@#@@@@####@#@@@@#@@#@###@@#@##@#@##@###@@#@@@@@@@@=@@####@#@@#@##@#########;@X+++++++++++++++",
"++++++++++++++%@@##@@##@#@@@@@@@@@@@@@###@@##@###########@@@@#@@===@@@@##@#@@#@@@@#######;##;;X+++++++++++++++",
"++++++++++++++&#@#@@####@@@#@@=@@=@@@##@@###@##########@@@@@@#@===@@=@#@@@@##@@@@##@#@######;;@:++++++++++++++",
"+++++++++++++:=###@####@@@@@@@@@@@@@@@#@@@########;#;#@=@@@@@@@===@@@@#@@@##@@@@@@#########;;;;=++++++++++++++",
"+++++++++++++%=;#@##;##@@@=@@@@@@@@@##@@@@@########;@===@=@@@@====@=@@@@@##@@=@@@@@#@#####;#;#;;o+++++++++++++",
"++++++++++++:X####;#;#@=@@@=@###@#####@@@@@####;##;#=&=@=@@==@&=@=@@#@=@@@@@==@@@=@#@######;#;;;;o++++++++++++",
"++++++++++++:=;;#;;##@@@@==##########@@@@###;;#;#;@&&&&&@=&&@====@@@@===@@===@@@=&=#########;;;;;@$+++++++++++",
"++++++++++++o;#;;;;##@=@@@@######;###@@@####;#;;;@&Ooo===O&=@=&=@@##=&=@===@=@@=O&=@#@########;;;==:++++++++++",
"++++++++++++@@#;####@@@@@@@#####;###@##########@=OXX$O&&O&@@=&==@#@&&&&O&&====&&&&&@#########;;#;@=&++++++++++",
"+++++++++++ @@#;##;#@@#@@@##;##;#;#######;;;@=&&X  X$$$$&@#&o&@@#=OOOo$$&&&&&&&&O&&=#########;#;;#o= +++++++++",
"+++++++++++X##;#@###@@@@@##;##;;#;##@@##@@&Ooo$.:   .XXO@@%%O==&&OO%XXX$oO&ooO&OO&&@#@@#####;##;;;==o+++++++++",
"+++++++++++=###@@##@@@@@##;##;#;;#@@@@==&oX%%.       $=@@o%oO&$$%%$XXXXX%oO%%O&OOO=#@=@#########;;;==-++++++++",
"++++++++++ @#@#@@###@@@@##;#;;#;@&OOO&&Oo$X.::: XX$O====%$$$$XX.X$$$$XXX%%%$%ooOO&=@=&@;#######;#;;@= *+++++++",
"++++++++++ =##@@#####@=@;;#;;#;#%X.XXX.. :::::  Xo&===O%$$XXXX..XX$$$$$$%$$%$o%%oO&O&&@#########;#;;& ++++++++",
"++++++++++-@#@@@@#@##@###;;##;=$:  . :: ::::: : X$%o%$$X..XX.  .XXX$%$%%%%$%$%%ooOo%%&###;#####;##;;=$*+++++++",
"+++++++++*:#@@#@##@#@@#;;;;;;&  .   .: :  :: :  .XX.X.X....X.....X.$$%$$$$$$%%%%oo%$o=;#########;;;;=.++++++++",
"++++++++++-@@##@####@#@=@#@=$.:      : : : :   .....X.X..........XXX$$$$$$%$%$%%%%$$%&##########;#;;%+++++++++",
"++++++++++-@#########@&$$O%. .        :::  :     ..X.X.. ....  ..XXXXX$XX$%$$%%%%o$$$%@###@@###;;;;;&+++++++++",
"++++++++++X###;@#@##@=$.. .  .        ::  : :   .......         ..XXXXXXX$%$$$$%%%$$$%=@@@#@###;##;;=+++++++++",
"++++++++++&;#####;##@&......      .  ::::: ::    .       :  .    ..X.X.XX$$$$%%$%%$$%%=@#@@####;;;;;@+++++++++",
"++++++++++@###;#@;##@OXX ... ....  .  ::::::          :::  :       ..XXXX$X$$%$$%%$$$%&=#@#######;##&+++++++++",
"+++++++++*@######;;#@%XX............  :::::: ::      :::: :  :      ..XX$X$$%%$%%%$%$%&=#########;;@-+++++++++",
"++++++++++=@#;##;;;;=$X...XX..$%$%$XX.:::: :  :     : :::: :: ::  : ..X$O$$o&o%%%%%$%%o=#########;;@*+++++++++",
"++++++++++=@;;###;;;=XXXXXXX.X%o&oOOOo%$. :      :     :: :      :  .X%o&&&O&&Oo%$%%%%O&#########;;=++++++++++",
"++++++++++=@;;###;;;&XXX.XXX%&&=@@@@#@#@=&%XX       .      ....XXX$o&===@=@&&==&o%%%%%o&@######@##;@++++++++++",
"++++++++++&#;;###;;;OXX.XXX%=@@@@@###;###;=&$X.....      ...XX%%$O==#@###@@=&==@=O%o$%oO@#;#######;@++++++++++",
"++++++++++=;;;;###;#$XXXXX=@@@@@@@##@####@@@o%$$$$XX.  ...XX$$O&&@###;####@@===@@@&O%%oo=#####;@@##@-*++++++++",
"++++++++++O#;;###;;@XXXXXO@@@#@=@@====@@##@==Oo%%o$$X...%o%oOOO=@@@@@###==@#@@@@@@@@ooo%=@;###;#@#;=-+++++++++",
"++++++++++&;#;;##;;@.XX$&@===&==@==$&@@@@@@@=@$$@@@@====@@@@@&===@=@@===&&==&===O&@@&Oo%o@####;;##;@-*++++++++",
"++++++++++@;;;;;#;;&.X%&===&O&====OooOooO&&&&&====&=O$$$&==&&==@======&O%%%O&&&&OoO==&%%%=;#;;;#;;;@-+++++++++",
"++++++++++=;;;;;;#;O.X$o===o%%$X. XXX$%oOOOO&&&===&&%$XX&=@========&&O%%$$XX$%O%O&&==&o%$o#;;;;;;#;#-*++++++++",
"++++++++++&;==@;;;#o XX%&@&%$XXX...XX$o&&&O&&&&&===&O&=&=======&==&===&Oo%%$$$%oO&====o%%o;;#;;;;;#@:*++++++++",
"++++++++++.%$X%=;;;OXX%&&o$$X$XX..X$&&&==@==&=&=&&$$@====O&=&======@========&O%%oO&&O=&$%O%&;;#;;;;@-+++++++++",
"++++++++++.OOX.%@;;=$XO&$$XXXXXX%&=@#@@@=@@==&=&&O%oOoo&&&=&=&====@=@@@#;;@@=&&o%oOOoo==O$ &;#@@;;;#++++++++++",
"++++++++++&@=&X.&@#=%%&%XXXXXXO=@=@@@#@@=@=@==&&oO&%&&O&&O=&&======@o&==;@@@=@==oooooo#;;%.@##@@=#;;++++++++++",
"+++++++++:===&$%o=@&=#=XXXXXX&@@@&=@@;==&&@@==&o%OOO&%X$%o=&o&&&=@@O:&@@#@@=O@@@=OOO&&==o$o@#@@@=#;@++++++++++",
"+++++++++X@=&%X$o==&;;=$$$X$=@@=%$@@@#@#O$==@=%$$O&o.....$==ooO&@=&$..@@@@@&o=@@==O&&O=OX$o=;@=@;;=:++++++++++",
"+++++++++%@=O$XXo@=XXO=Oo%$O=@==%$O##@@@$%&&&O%$$=&$ ....X&=OoO&&OOO$.O===&%oO=====&OoO&X$o=;@=@;@-+++++++++++",
"+++++++++o@=%X.X=@O. X&oO&&&=&&&O%$&&&&o$%%$$$$$%=o.. ...X=@o%ooOOOo$%%$%%$%ooO&==&O%$OoX$%=#@&@;X**++++++++++",
"+++++++++%==$X .##%..$O$o&&&O%%%%$$XXXX$$%%$$$X O@oX .....O@=oooOO&O%%$$$X$X%%O&&&O%$$&OX$$=#@O=#-++++++++++++",
"++++++++-%==%...;#%..$oXXoOO%$$X  :  .$$$$$$XXXX@=$X...XX$o==&%ooooo%%%$$$$$ooOOOo%$XX&O$$$=#@$&%+*+++++++++++",
"+++++++++o==$X.$;;%..XO.X$%%%$XX.   ..XXXXXX...$=&X$....X$oO&=$%%$%$$$X$$$%%%%%%%$$$X O$$$$=#=$$:+++++++++++++",
"+++++++++$&=%. X;;$...O$XXXX$$$X. :  ...... . .OO$$X...XX%%OO&O$$$$XXX.X....XXX$$XXX :%$$X$=#=%$++++++++++++++",
"+++++++++ &&%..$=#%...%o....X$XX. :::     .   &&o$XXX.XX$%oo&&&oX$XXX..    ...XXX.X.- $$$$$=#=$%++++++++++++++",
"++++++++++o&o...&@$X..X$.   .XX. : : :    .. XO%%$$$X..XX$ooO&O&$XXX.... ......... - $X$X$X=@=%%-*++++++++++++",
"++++++++++XO$X.$%&%......   .... ::: : :: ..Xo$%%$$X.X..X$ooO&OO&$.X. . . ....X.. -:$XX$$$X&#=oo-+++++++++++++",
"++++++++++:%$..Xoo$.XX.... ::   ::: : :::: .o%%%$XX.     .%%O&&OOOoX...   ..XX.X$O$$X$$$$$$&=oOO:*++++++++++++",
"+++++++++*-$$..X%%XXX... .X$   ::::::::::   $%o$XX.::: :: $%oo&&Oooo%$XXXXX$$%%%OoXXX$X$$$$o%$O&:+++++++++++++",
"++++++++++* $..XoXX..X..   $$%%$. .XXX$%OOOOOO$.. .:::: ::X$%oOO&O$$%oo%oooo%%$X..XX$$$$$$$$X$&&:*++++++++++++",
"++++++++++*:XX.$oX..X...  ::: oo%%%Oo%OOOOO&O%X.....     X$%$%oOOOo$$$$$$$X$$$....XXX$X$$$$$X$O% +++++++++++++",
"+++++++++++-XX.X$X......   :::  XX$$$$X.X$%%$X...XXXX...X$%o%%%oOO$$. ...XXXXXX..XX$$$$$$$%$X%o%:+++++++++++++",
"++++++++++++$X.X$XXX...    ::::  ... ::: X$%$.... XXXXXXX$oO$$$o&O%$. : : :  ...XXX$$$$$$$%$$%%$:+++++++++++++",
"++++++++++++ ...$XX.... .    ::: ::::::: X%%..$&@@&$X$XX$O&=%$$%&OO$X  : : :  ..X$$$$$$$$$%%%%$$-+++++++++++++",
"++++++++++++:X. .XXX.....     ::::::::: X$$$XX=;;;;=$%%%&;;;@o$$O&O%X.        .XX$$%$$%$$$%%oo$$-+++++++++++++",
"++++++++++++-:   .XX. .. ..  : :::: :  X$$$XX%@;;;;=o&&&@;;;;#O%%OOO%X.     ....X$$$%$%$$%%%%%%$:*++++++++++++",
"+++++++++++**   ..XX.... ...  :    :  .X$XXX$o#;;;o$o&&&O=;;;;&OooO&o$..    ..XX$$$%$$$$%%$%%%%$-+++++++++++++",
"+++++++++++++-  ..XX.X.....     :     XXXX.XXO===O..%OOOOO@##@&&%%oOO$X. . ..XX$$%%%%%$$%%o%%%$$-*++++++++++++",
"++++++++++++++ ...XXXX.X....         ..X. ..$oO$XX.. .$X.X%o&&&&%$$oo%$X....XXX$$$$$%$%$%%Oo$$%.*+++++++++++++",
"++++++++++++++  ....X........   .    .X..  .X%O%$X   . ..X$oO=&O%$X$%$X....XXXX$%%$%$$$$%%%oo%$-++++++++++++++",
"++++++++++++++-..  XXXXX...... . .  ..X......XXX$.  .   ..X$%o%$$$XXX$X..XX.$X$%$%$$%$%%%%X:O$++++++++++++++++",
"+++++++++++++++:...XXXX..XX.. .  .  ........XXXXX.  ..  ..X$$%%$$XX$$XX.XXXX$X$$%%$$$%%%%%X**+++++++++++++++++",
"+++++++++++++++*-:X::XXX.X.......   .. ..X.XXXXX.  ..X   ..X$$%$$$X$XXX..XXX$$%%%%%%%$%%%%:+++++++++++++++++++",
"+++++++++++++++**++++.XXX........    . ..XXXXXXX . .X$.X..XXX$$$$$$$$XX..XX$$$$%%%%%%%%%$%-+++++++++++++++++++",
"++++++++++++++++++++*:XXXX.X.....   ....XXXXXXX..   X$$..XXXX$%$$$%%$$X...X$$$$$%%%$%%%%%%++++++++++++++++++++",
"+++++++++++++++++++++-XXX......... ...XXX$XXX....  .X$$. .XX$$$$$$%o%%$X..$$%$$%%$%%$%%%%$++++++++++++++++++++",
"+++++++++++++++++++++*XXXX..X........XXX$$XX...... XX$X....XX$$$%$%oOoo%X.X$%%$%$%$%%%%%oX++++++++++++++++++++",
"++++++++++++++++++++++.XXX.X......XXXXX$$XXXXXXX.X.XXXX.XXXXX$$%%%%oOoo%XXX%%%$$$%%%%%%%o.++++++++++++++++++++",
"+++++++++++++++++++++*:XXXXX.....XXXXXX$$$$XX$X$$%%%X$XX$$%o$$%$$oOOoOo%$XX$%%$$%$$%%%%%o:++++++++++++++++++++",
"++++++++++++++++++++++-XXX.X..X.XXX$X$$$$$$%%%ooooOOOOoOo&&OOo%oOOOOoo%$$$X$%%$$%%%%%%%oo-*+++++++++++++++++++",
"++++++++++++++++++++++* XXXXX.XXXXXXXX$$$%O&&O&&&&&==&&==========&&&O%$$$$$X%%$%%%%o%%ooX**+++++++++++++++++++",
"+++++++++++++++++++++++:$XXXXXXXXXXXXX%O====&&&&===@==========@=@@=@&O$X$XXX$%$$$%%%%%oo +++++++++++++++++++++",
"++++++++++++++++++++++*-$XXXXXXX...XX$==@==&OOo%$%%%$$$$X$$$oOO==@==@@o$X$X$$%$%%%%%oooo-+++++++++++++++++++++",
"+++++++++++++++++++++++*XXXXXXXX.X.X$O=&oOOo%$$XX.X$XXX$X$$$%%%oo%%%o=&o$X$$$%%%o%%%ooO%+*++++++++++++++++++++",
"++++++++++++++++++++++++.$X$XXXX.XXX%O$X$X$$%$XXX.XXX$XXXXX$XX$$%%%$X$%$$$XX%%%%o%%%ooOX++++++++++++++++++++++",
"++++++++++++++++++++++++-$$$$$XXX.XX$XXXXXXXXXXX...XXXXXX.XXX$$$$%%$$$$X$$X$ooooo%%%ooO ++++++++++++++++++++++",
"+++++++++++++++++++++++++.$$X$$$XXXXXXX.XXXXXXX$$$$%$$$$$%$$$%$$$$$$XX$$$$$%ooOoOooooO& ++++++++++++++++++++++",
"+++++++++++++++++++++++++-%$$$XXXXXXXXX..XX.X$$$ooOOOoOoo%%%%$$$$X$XXX$$o%%%oOOooOoOOO&:*+++++++++++++++++++++",
"++++++++++++++++++++++++++X$$$$$$$$$$XX.....XX$$%%%o%o%o%%%$$$XXXXXXX$%oOOOOOOOOOOOOoOo:++++++++++++++++++++++",
"++++++++++++++++++++++++++ $$$$$$$%%$$XXX.XXXXXX$X$$%ooo%%$$XXXXXX$$$%%oOO&OO&&OO&O&OOo-++++++++++++++++++++++",
"+++++++++++++++++++++++++++X$%%$$%%%%$$XXX.X..XXX$X%%OOoo%$XXXXX$$%%$oo&&&&&&&&&&O&&&OO-++++++++++++++++++++++",
"+++++++++++++++++++++++++++.%%%%%$%%%%%$$$XXX..X$X$%$ooo%$$XXXX$$%%%oOOO&&&&&&&&&OOOOoo-++++++++++++++++++++++",
"+++++++++++++++++++++++++++-%%%%%%%%%%%%%$X$XXXX$$$$$$$XXXX.XXXX$%%oOoOO&&&&&&&&&&&OooO+++++++++++++++++++++++",
"+++++++++++++++++++++++++++*X%%%%%%%o%%%%%$$XX$XXX.X.X... ..XXXX$$%OOooO&&&&&&&&&&&Oooo+++++++++++++++++++++++",
"++++++++++++++++++++++++++++.%%%%%%o%%%%%%$$$$XX..  ....  ...XXX%$%oOOO&&&&O&&=&&OOoooOX::::--++++++++++++++++",
"++++++++++++++++++++++++++++:$%%%$$%%%$%$%%$$X$... ...... ..X.X$$$%oOO&&&&&&&&=&&OOoooo=#@@===$-*+++++++++++++",
"+++++++++++++++++++++++++++++X$%o%%%%%%%%%$$$XXX.  ........XXXX$%%%oO&&&&&&&==&&ooooOOO=;;##@=&$*+++++++++++++",
"+++++++++++++++++++++++++++++X$$oo%%%%%oo%$$$XXX...... ....XXX$$$%oO&&&=&=====OOoooOoOO@;;;@==&o++++++++++++++",
"+++++++++++++++++++++++++++++:%$$oOooooo%%%%%$$XXX.X.   XXXX$$$%%%OO&&&&=====Ooo%ooo&OO&;;;@==&%++++++++++++++",
"+++++++++++++++++++++++++++++-$$$%oOOooo%%%%%$$$$XXXXX..X$$X$ooo&O&&&=======O%oooooO&O&=@;@==&&X++++++++++++++",
"++++++++++++++++++++++++++++++$$$%oOO&OOOOO%oo%%$%$$$%$$$%%%%oOO=&&=&===@@=OooooooOO&&&=@#@=&&& ++++++++++++++",
"++++++++++++++++++++++++++++++.$$$%oOO&&OO&OOOo%%Oooo%$oooOooOO&==&===@@==&OOo%oooO&&O&=#@==&&=:++++++++++++++",
"++++++++++++++++++++++++++++++:$%%%%oOO&&&&&OO&OOOOOOOOO&&&O&=====@=@@@==&OoOOoooOO&O&=@@@===&&:++++++++++++++",
"++++++++++++++++++++++++++++++-$%$%%%%O&&&===&&=&&&=&========@=@@@@@@===&OOooO&ooOO&&O=#@=&=&=&X++++++++++++++",
"+++++++++++++++++++++++++++++++$%$%%%%ooO&===@==@==@@=@@=@@@@@@@@@=@===&OOOOOooOoO&O&=#@==&===&o-+++++++++++++",
"+++++++++++++++++++++++++++++++ %$%%%%%oOO&===@@@@@@@@@@@@@@@@@@@@@====&&OOOOooOooO&&@@======&&O$+++++++++++++",
"+++++++++++++++++++++++++++++++-%$$%%%%oO&O&&===@=@=@@=@@@@@@@@@@=@==&&&OOOOOOOoOOOO@@=======&&OOo-+++++++++++",
"++++++++++++++++++++++++++++++++%$%$$%%oOOO&&&===@@@@@@@@=@@@=@=====&&&OOoOOOOOOoOO=@@======&&&&Oo%. :++++++++",
"++++++++++++++++++++++++++++++++$$$$%$%%%%oO&&====@=@=@@@@@=@@=@==&&&&&&oOOOOOOOOO&@@=======&=&&oOO%@;;;.+++++",
"++++++++++++++++++++++++++++++++X$$$$$$$$%%oO&&===@@@@@@@@@@=@====&&&&O&OOOOOOooO&@@=========&&&OOoO=;;;=+++++",
"+++++++++++++++++++++++++++++++*:%$$$$$X$$%oOO&====@@@@@=@@=@===&==&&&&&&&O&OOOOO@@@====@===&&&=&&=;;;;;;.++++",
"++++++++++++++++++++++++++++++++-$$$X$$XX$%%oO&&==@@=@@@@=======&=&&&&&&&&O&OOOO=@@========&&&&&=@;;;;;;;#$+++",
"++++++++++++++++++++++++++++++++X%%$$X$X$$$$$%O&====@@=@=@===&&&&&&&&&&&&&&&OO&=#@=========&=&&@##;;;;#;;;;@++",
"+++++++++++++++++++++++++++++++-&%$$$XXX$$$$$%oO&=========&&&&&&OOO&OOOOOO&O&&=@@====@===&&&&&@@##########;;=+",
"+++++++++++++++++++++++++++++++&=%%$$$$XX$$$$$%o&O&====&&OOOOOOOooOOOOOOOOO&%=@==========&&&=@;###;#########@@",
"++++++++++++++++++++++++++++++$&=O$$$$$$$$X$X$%%oO&&&O&OoooooooooooooooooOOO&=@==&==@==&&&&=@#########@#####@@",
"++++++++++++++++++++++++++++*-&===$$$$%%$$X$X$%%oOOO&Oo%%$%%%%%%%%o%%oooooO&==&&======&&&&=#;#####@#@####@@#@#",
"+++++++++++++++++++++++++++++$===&$$$%o$$$X$$$$%oO&&OO%%$$%%$$$$$$%%%%%ooO&==========&&&&=##;######@##@#@#@@##",
"+++++++++++++++++++++++++++*.=&===$$X$o%%$$$$%%%%&&&O%%%oo%$$$$X$$$%%%%%o&==&=&=====&&&&=#######@@@##@#@#@#@@@",
"++++++++++++++++++++++++++++&&====o$$$$$o%$$$%%%OO&&O%%%%o%$$$$$XX$$$$%%O&=&&======&&&&=;#######@###@#@@#@#@#@",
"+++++++++++++++++++++++++++.======&$$$$$%%%%$%%o&&=&O%%%$$$$$XXXXXX$$$%o=&&&&==@===&&O@;######@@##@@@@##@#@@@@",
"+++++++++++++++++++++++++++&=&===@=$$XX$$%%%ooOO&=&&Oo%$$$$$XXXXXXX$X%oO&&&&=====&&&&=;######@###@#@@#@#@##@#@",
"++++++++++++++++++++++++++%=&======o.XXX$%%%Oo&&===&oo%%%%$$XXXX.X$$$%O&O&&&====&O&O@######@###@#@@#@#@@@#@@@@",
"+++++++++++++++++++++++++-&&&=====@& .XXX$%oOO&=&&&Oo%%%$$$XXXX..XX$$oOO&&&==@=&OO&@########@#@#@@#@#@#@#@@@@@",
"+++++++++++++++++++++++++X===&===@@=..X.X$$%&&&&=&&O%%%$$$$$XX...X$$o&OO&==@=&&OO&#;####@#@##@#@##@#@#@###@@@@",
"++++++++++++++++++++++++-&==&=====@@XX.XXX$%O&&=&&Oo%%%%$$XXXX..XX$oOOO&&====&OO&@#######@##@##@@##@#@#@@@@@@@",
"++++++++++++++++++++++++o=====&==@@@$XX.XX$$%o&&&&OO%%$$XXXXX...X$oO&&&=====&O&=;######@#@###@@#@#@#@@@@@@@#@@"
};
/* XPM */
static char *bp_256[] = {
/* width height ncolors chars_per_pixel */
"110 150 256 2",
/* colors */
"   c #BD945D",
" . c #8C6F44",
" X c #CBA66E",
" o c #050D12",
" O c #131F23",
" + c #1A1C20",
" @ c #C4C8A9",
" # c #CD9F66",
" $ c #111721",
" % c #272D26",
" & c #CD9E5C",
" * c #121618",
" = c #957846",
" - c #9B7742",
" ; c #674930",
" : c #A16A3E",
" > c #0D1013",
" , c #5D4630",
" < c #A56338",
" 1 c #1C231B",
" 2 c #52472F",
" 3 c #A68246",
" 4 c #B7925A",
" 5 c #B87644",
" 6 c #846D3F",
" 7 c #503D2D",
" 8 c #B18E54",
" 9 c #12141B",
" 0 c #4C6D43",
" q c #402C27",
" w c #1B1F1D",
" e c #685537",
" r c #000313",
" t c #DCF9EE",
" y c #C9B37F",
" u c #81653F",
" i c #10161C",
" p c #CB9A60",
" a c #322523",
" s c #0A1016",
" d c #080A14",
" f c #C8A36A",
" g c #BD9252",
" h c #8D693A",
" j c #121421",
" k c #2A2828",
" l c #0F141E",
" z c #B9844E",
" x c #A78850",
" c c #D3A86E",
" v c #8E6F3E",
" b c #5C412E",
" n c #BC9454",
" m c #A47B43",
" M c #14191C",
" N c #C79A62",
" B c #7A633E",
" V c #232824",
" C c #0B101D",
" Z c #8F7542",
" A c #5C4931",
" S c #976A40",
" D c #8E6941",
" F c #D1A365",
" G c #6A5838",
" H c #A47F46",
" J c #A07742",
" K c #B06F3E",
" L c #8F5C38",
" P c #9B7447",
" I c #8F7945",
" U c #AC8551",
" Y c #957041",
" T c #7B5A38",
" R c #D7EDDE",
" E c #D2DBC2",
" W c #A67B4B",
" Q c #755632",
" ! c #66352A",
" ~ c #121920",
" ^ c #7B452E",
" / c #74693E",
" ( c #0E131C",
" ) c #294633",
" _ c #41372D",
" ` c #7A5E3A",
" ' c #BC985D",
" ] c #67412E",
" [ c #A6814E",
" { c #181E1F",
" } c #A77E45",
" | c #B68E57",
".  c #8C623B",
".. c #0E191F",
".X c #101521",
".o c #A37041",
".O c #957447",
".+ c #0C111D",
".@ c #3A3D29",
".# c #1B2025",
".$ c #AC7E4D",
".% c #7C5735",
".& c #A3814E",
".* c #171C21",
".= c #8C663E",
".- c #13161D",
".; c #B18855",
".: c #C49B61",
".> c #A07441",
"., c #875C39",
".< c #08131C",
".1 c #B1874B",
".2 c #AC8250",
".3 c #060D1A",
".4 c #181E25",
".5 c #AC7F46",
".6 c #B78B54",
".7 c #8D6538",
".8 c #997B47",
".9 c #C49D64",
".0 c #495C37",
".q c #9D7041",
".w c #967144",
".e c #AC8349",
".r c #9D814E",
".t c #C68F52",
".y c #141C24",
".u c #C68B52",
".i c #745133",
".p c #324E34",
".a c #BB8C51",
".s c #AFB391",
".d c #9C5936",
".f c #0C121C",
".g c #3E5B39",
".h c #C79956",
".j c #875735",
".k c #96703D",
".l c #9D8047",
".z c #83683E",
".x c #0E1621",
".c c #83623E",
".v c #34472F",
".b c #252627",
".n c #4C3629",
".m c #0F1318",
".M c #07101A",
".N c #8E7342",
".B c #906F44",
".V c #C49756",
".C c #745D39",
".Z c #D0A46F",
".A c #6B5C3A",
".S c #8D6B41",
".D c #DFFCF1",
".F c #141B20",
".G c #141920",
".H c #B78853",
".J c #AC8B52",
".K c #D3AC75",
".L c #AE693D",
".P c #BF9A5E",
".I c #948C58",
".U c #BD925C",
".Y c #141923",
".T c #191A1E",
".R c #4E633E",
".E c #332E27",
".W c #BB8F50",
".Q c #131722",
".! c #111920",
".~ c #0F171E",
".^ c #6B4D33",
"./ c #B78B4C",
".( c #C1844C",
".) c #B47F49",
"._ c #6E7646",
".` c #121B24",
".' c #96633C",
".] c #A27B4B",
".[ c #D6B27E",
".{ c #AC7B41",
".} c #B7914F",
".| c #9E7B47",
"X  c #A07749",
"X. c #A67645",
"XX c #0D171F",
"Xo c #B68D4E",
"XO c #0D131F",
"X+ c #262327",
"X@ c #CD9954",
"X# c #BC7E4A",
"X$ c #1C2427",
"X% c #201F21",
"X& c #835033",
"X* c #26392A",
"X= c #141C1F",
"X- c #19151A",
"X; c #9C7748",
"X: c #292823",
"X> c #0D1018",
"X, c #25241F",
"X< c #AB9A67",
"X1 c #4F5131",
"X2 c #CA9354",
"X3 c #847344",
"X4 c #375637",
"X5 c #BB8F59",
"X6 c #C89F69",
"X7 c #C89E5F",
"X8 c #B28B50",
"X9 c #0E161C",
"X0 c #836239",
"Xq c #B7884B",
"Xw c #B38551",
"Xe c #1C2323",
"Xr c #BF9056",
"Xt c #333129",
"Xy c #53422E",
"Xu c #6B5235",
"Xi c #101621",
"Xp c #0F1420",
"Xa c #473D2C",
"Xs c #0E101F",
"Xd c #0B141C",
"Xf c #987440",
"Xg c #805C39",
"Xh c #AC874D",
"Xj c #B3844A",
"Xk c #C2945C",
"Xl c #423527",
"Xz c #C0965A",
"Xx c #C69356",
"Xc c #755738",
"Xv c #363625",
"Xb c #181F22",
"Xn c #C29352",
"Xm c #1E1C1E",
"XM c #AD7644",
"XN c #C08B50",
"XB c #0B161F",
"XV c #C49861",
"XC c #0D1317",
"XZ c #622722",
"XA c #CFA86F",
"XS c #0C0D16",
"XD c #181F25",
"XF c #CBA26B",
"XG c #070511",
"XH c #BAA46E",
"XJ c #121B1F",
"XK c #332A25",
"XL c #12171F",
"XP c #BC894F",
"XI c #635033",
"XU c #796238",
/* pixels */
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t t t R @ R E.s.I @.D.D.s.s t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D EX<._XI.A I._._.RX1 1 1 > 0.R G.A.I.s E @.s.s R t t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E R.s._.@Xv 1 1.g.I._Xa 1 o 1 > >XK 0.IX<X1 * 1 1 *.p._.s.s t t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.s.I.v 1XG oXG o > * dXC 1XJ > *X- * 1 1.@.gX* r o oXG >XG o 1XvX1 /.I.s @ R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.sX1 >XGXG > > o o >.< s s s *XC M > 1 1 w 1 w o dXS > o o > o o > * 1 1X1X1._ @ R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX<.v >XGXG > > > > * >XCX9.M.3XS i MX9 oXC { MX= M 9 M.m > o d o o > * * * > o 1 *X,X1.s t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX1 oXG > o > >.m >X9 i M *XX.< 9.-.G.X CX> s.. i lXX M wXd C s.M sXSXCXCXC * s o 1XvXv 1Xl.I t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t 0X-XG > > >XC sXCXCXB ( 9 (.!..XLXLXL ~.xXOXB (XL.xXO 9.- *.+XpXO.MX>X>X>XdXC *.<XCXC > 1 1 * 1X1.s t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.sXlXGXG o >XCXCXC s sXd.M.m $Xp.G.G O.`.-.x.<XB ( i.GXO (XpXL MXiX=.~X>XOXB.<.+X9X9XL * 9 * > > > 1 o 1.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.DX<.AX, > > > > o s.M sXO ( ( j jXi.X $XL.GXiXL.~XOXp.!.XXL lXOXpXLXL ~.GXO 9X=XL.+X> C.~ i.XXL M M * > > 1 > >X1 R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t E.IX1 1 > > * *XCX> 9X>.MX9XsXL.Q.Q $.X.! *Xi $ ~XBXO.X.Y.F.Q i lXi.. $ $.!Xp.G.4.yXO.m.fXs ( l.!.mXJ 1 > > > 1 1 > 1 @.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.sXIXv > > * * > sX>.- i j l.-.G.` ~.y ~XOXBXi.X.xXiX9XiXi.x.*.*.X l $ $ iXiXi.Q.G.y.*.X.XX9XsXpXL...XX9 iX= > o > > * 1 >._.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.DXH / * o * * *X9 s ( (.f l.~XL.T.#.Y.-.QXiXpXO.Q.YXi.xXOXXXX.x.*.y jXO.x.QXXXp jXiXi.G...x j.Q jXOXpXL.`XL.m {X= > > * > * 1 >.R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.IXv 1 o > * 1 >XJXJ i M.Q...*.y.4.yXLXOXB j.Q.Q $XL jXXXXXi $.yXJ.Y ~XL.Q.X j.Q.Q $Xi.~.Q j.!.!.Q j $ O.Q $.- (.~XBXC > > 1 1 1 >.I t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.DX< 2 * o > 1 > >.+.F w M.T ~X=XD.F i.x l.+Xi j.!.Y.QX9.x 9 i.Q.Q.Q.Y.G M.G.Y j l.Y.Y.-.QXL.Q.Q.Q.y.Q.G j.Q.*.. iXpXp...fXC > 1X, 1 > > E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.DXU 1 1 1 * * *.m 9 ~.*X= l.GXb.* i l ~.Q j j ~.YXi.X.xXi.X.X.XXiXi l.!Xb.F ~.XXp $.Q $Xi.Q.Y.Q.Y.F $.GXL j...F.*.~XXXJXL.f > > *X,X-XG A.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX< 1 1 1X,X,X- CXL.Y.*.`XL.*Xb.`.Q.X.4.*XiXi.T ~.! l jXp jXO.X.Q.QXL.!.4Xe.`.`XL $ M.F.~ $.Y.Y ~.`.xXL.GXi.x.Q.Y O.y ~.Q ~XO.+ s * * 1 o 1 E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D._ > > 1X, 1X- * 9 ~X%.YXL.Q.4.Y.-.Q.Y.#.QXpXi.T.F.-.XXLXL.QX9Xp.Q.X ~.FXbX=XX.Q.-.Q.#.GX9 j.X.F.4.#.QXp.xXO.` j ~.F.#.* i.Q.x.x.<.m * * > >XU t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.AXG >X-X- 1.T.m 9X=Xb.4.X l j.Y j.G.Y.yXD.Q jX=XDXJ.` j $XL.X.x j.XXX.!.Y.FXL l.Q.T.TXD.!Xs.x j.*.#.#.F.~.XXO.x.! j ~X,.FXi jXO.xX> iX= * * oX,.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R 1 o > * 1 1X-.G.T + w.#.`.+.YXbXLXL.YX=XbXD.Y.*.#.4XD.y.QXb.x.Q.Q.Q.Y.QX=.F.G.!XL.*.4 +.#.-.~ l +Xm.b.#.*.QXi.Q.!.!Xp.`.bXbXXXL.XXi ( i M * M * 1Xv @ t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.sX,XG > 1X, 1X-.T +.#X$X$.Y j ~XbXb ~.`.y.*XJ O.QXD.#.4.#Xb.#.yXJ.F.*.y.F ~.*.F.T.*Xb.*.4Xe +XL...G +X%.bX+.Y.G.xXi.*X= j.x.#.# (Xi ~XL.+ l..X= M > 1XvX, E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.DXv 1 1X-X, 1 * wX%Xe.y.#.y $.Q.*.#.Y ~.y ~.YXb.4.Y.4.y.4.# VXe.#.4XbXb {.y.yXJ.*XbXeX$.4.#.#Xb OXb + VX+.EX:.Y j.Q.Q.y.QXi.-XJ.4.`.Q ~.`XOXXXi.~ *XC 1 1 >Xv t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tXIX,X- 1 1 w MXeXe.4XL.*XL M.T.*.4.YXb.* $.FXJ.Y.*.Y.YXeXDX$Xb.#XbXD.y.4.#.y.Y.4.#X$XeX% VXeXb.# + +X+ k q k.TXL.-XL $.X j.G.*X%.`.Q.YXi lXL....XJ *X-X- 1Xv I.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.DX3X, 1 >X,X, w wXe.T j ~.`.* w +X+XDX%.b.4.T.4.` ~.*.#.#.Y.# O.Y.`X=.4.Q.*XD.y O.G +.#.4X$X+X%X$Xe.bXtXK.E.EX+ MXpXL.G.Y +XeXb O.b.4.Q O ~ $XiXL MXLXC * * >Xv x.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D t 6Xv 1 1X-X,X,.FXb.F +.#Xb +.#.b k.b V %.b.#Xe.#.G.F.F.#.4.Y.y.F.Y jXL.Q jXL.x.Q.~Xi.#X+X%X+ k.#.b.b _Xy.EXKXK kXJXJ.YX% +X$.#.`.y kXe.F.y.Q j $Xp ~.- > * > o o.I.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.DXI * 1 >X,X, 9 ~ $.TX% VX%X+.b kXtX* k % k % %.4 j.4.#.4.*.`XJ.`.yXp l l lXpXO.x.Q.b kX+X+ k.#.* kXt bXyXK aXKX+.Y +X%Xe.4.*.TX%X+ k k.*.Y.y.y.Y $ iXiXB *XC > o 1.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D yXv *XC 1Xe * l l lXb.b V V V % k kX$X$X$ % %X$.Q +X$.b.#.G.Q.~Xi.Q.G jXO.+ j.<XB q q a k aX+.4.bXt _Xy 7 aXKXKXe.4X% VX%XL.QX% kXK k kXb.`.y ~.Q.Q...x.f.. > s >XGX1.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D I.@ * * 1.TX>.fXO.* k kX+XtXtX$X$XDXDX$X$X$XD.`XLX$.b %XeXb ~Xi.X.X.xXOXi.+ CXb.n b q q qX+X+XK k _ b 7 _.EXK kX+X% aX%.*.*X+.E q.EX+.#X+Xm.Y.* ~.~ jXL ( ( sXC >XGXG._ t.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D y.IX%XC M ~XBXs.f l.bXtX$.b.@Xt.Y.Q.x.4.4.4.`.xXs.YXe.b V.#XD ~Xp jXB.<.x $.3.Q , ^ 7.nXl a.b 7XtXt , , _ qXKX:XbX% q q k {.# q _Xl.b.4 O.n V.4.#.F.`XXXL lXp.fXCXC o oXG._.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.s.@ r >XC s.3XsXOXbXtXtX$Xt _XD.Y.X $.` $ $.XXp.x.# k.bX=XJ ~XL CXOXOXs.<.< a.^X&Xc.i ]XlXt.%.iXKXt ; b _ aX+.#X$ 7 b _XK aXt.n 7XKX%.# b.%Xl.G.4XJ.x.x.x.X.XXp.+ s > > > 1.I.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.DX3 > * > o sXsXX.x.bXt.b kXt.b.y.Y.X.Q.xXBXsXp j ~X$ VXb ~ $.xXO.<.<XO.3.3X+X& L.'X0XIXt ,Xg T q a 7 , bXtX+Xs.`XyXIXaXt ! 7.nXlXl a q.n.%.%Xy.*.G.`.xXX i jXL $XO.< C > >.@Xl.s.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D RXl 1X- > 9 9XB $.4 %.b.# k.b.!Xi (XXXBXOXs.+ $.` O.*.F.YXL.~XpXOXBXO + a.n.d.)Xh -.,.^.j.,X&.b.b ; ; 7 q aXL a.^.%.^XuXg.^.^ b ] 7 ,.^.^ T.i.^XK.`XJXiXp $.~XX $.+.M.fXC oXvX1XI R.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.DXH aXm * >X-XLXSXp V %.# +X+ + j.+.<XX.fXsXsXsXs.G.T.Y 9XpXO C.3Xs a ! ] ^.6X7X7.W.5.{XM.o.i k.4.^.'.^XK.#.4 qXgXg., D.&X.Xc.i.i.iX&.i Q Q.%.%.iXt.xXXXLXOXX.! i.~.f C.-XC o oXU 2.s.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.I > * > * wX=XO.* k.b {X+.# ~XpXO.Q.x C C.< CXO.Y.*Xm.!.G V q.^ L., h 5X2 c X #X7.UX5 zX0XKX+ D.oXg b.n.iX&.z.= P x | 8 [.'., T.c hXg QXgXg T Q k.QX%.# i.x.x j j.+ ( iX> > o.vX1 / t.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D t.nX- 1 *X% 1.TXs.G.b.#X%X: +XB CXp j C.<.<.3XsX+ k q qXa !.^.= U Y.>Xn X X X fXF fX7.l 7 a q L.o.' TX&.o.2.o SX;.2.; | 8 x.w DXg.q.wX0 QX0X0 TXa +X+.n VXpXB.!XXXO ( lXiX> > o >.@Xl R.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.sX, *X- 1X, wXLXi.FX=X% qXKXs CXsXO.MXs.XXs a.i L.j.j.^X&.j.'.{XqXr.K.K.KX6 8.2 - `Xy.n.n ^.dXM }X. W.; | 4Xj WX .2 [.2.; U P.w SX .w.=.=.c.c T b q 7 ;X$.XXpXp $.QX9XiXO.<X9 s o 1 2X<.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D t f.n > 1 1X, wXp ~.F iX:XlXe C CXs C.3Xs.3X-.LX#XNXN./X#.t.hX7.K.[.[.KXA XX7.5.'X& ! ! ! L <.{.).H./.H.aXz.P.6.1.$ WX; [ HX; Y.]X  J J S v D.z T Q.i.%XIX+XO jXO.x.~Xp l..XdXCXC > >X1.s.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D @X, 1X, 1X, wX9Xb.`.*X,.YXOXO.3 C 9XBXsXZ 5 F & &.hX@ F c c c.[.[.KXAXA y f.W.{Xf h : 3.$./Xz  .;.a.UX6 f  .6.a | WX;X  P P P PX X X Xf.q h.7.c h.q : e..XXXXXp.XXiXLXd.~.fXC ( sXGXl.l t.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D yX, 1X, *Xe.T.-Xb.FXeXeXC.3 C.3.3.3X- ^ & &.h & & & & c c.Z.ZXF.K.K X X X.9XrXjX8.}.}.a.aX5Xk  X5X5  XV 'X5.UX5.6 [ P -X..] WX X X .q.> Y Y h.=.q J hXyXB..XLXXXXXXXL j lXd.fX> o oX1X<.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D @X, 1 1 > 1 *XJ.G.*.4X% a.n qX-X+ ! KX2 F & & & & # FXA c c F.Z.Z.Z.ZXFX6.:.VXk.U.UX5X5.W nXz  .U.UXkXVXVXk.UX5.6.e.| 3 [.2 [X X .] P.w.w.w Y.wX; m :.^.4 $ $ $.Q.Y.Y ~XiXO.MX> >XGX3 E.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D @ a > > * M M.GXL.~Xi q ^.{.> L <XnX@X@ & & & & & #X7XA.KXA.ZXA X.K XX6.9X7 NXVXrX5X5.a gXz.:XVXkXVXkX6X6XVXk.W zXw.2.; 3.2 U W.>X X .> Y.q Y.k m m.{.SXK.G.x.QX$XD.`.`Xi.< s > >XG /.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.I 1 * > > 1 MXJ lXJ.b.n.{.}X@X@X@X@X@.h & & FX7X7X7X6XF.K.KXA X X.Z XXFX6.9XV.9.V    .P.P N # # f.9.:X6X6XVXV.UXwX5 | |.;Xw U } P.> W.| J -.k Y J } mXf.nXDXDXD O OXJ.. lXSXC.< > oXa t.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D QXG 1 * >X=XJ.~ CX=X%Xu./XnXnX@Xn.h.hX@ & & fX7X7X7X7 c.K.K.K.K XXAXA XX7.9 NXVX6.9X6X6 #XF X X X f.9 N.9X6.9XVXk.U 4 | 4.;.; W.$ H.].>.w -.q.q m H J : AX$.#X$XbX=.`Xi ( CXC o > > 1 R.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.DXv > * > >X= M.+ CXX kXgXqXnX@XnX@.h.h.h.hX7.V.9X7 pX6XA.[.[.[.[.K.KXA XXF # fX6X6XF X XXA.KXA F f f #X7X6X6.9X6 NXV  .U | 4.;.&.2 [X  JX  JXf.>X.X. m.q ;XvXDXD.`.!.QXLXOX9 s d * >X0 R.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D t a 1 * * * *XX C CX> a.kXq./X@XnXnXnXnXn n.VXn 4XkXV.9.Z.[.[.[ y.[.K X XXA #XFXFX6XF.Z.K.K.K.K X fXA.ZXA.Z XXFXFX6XHX6.UX<.;.& x.&.&.B PX .>Xf.wX.X. m.> Q _.`.`.. $XL jXO iX9 > >X, @.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D tXl 1 > > * M.f.M s.M.n.{XqXqXnXn./XnXnXn 3X X. P [ x.;   y y y.Z y.ZXF.ZXAXF.ZXF f f X X.K.[.KXA.KXA XXA c.Z.Z.Z.Z.ZX<  .;.r.c.r.OX3.A.z.O.w.w.w.>.>.q.q.7 2...`Xi.XXXXp...-XCXCXGXv t.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D E.n 1 > o * { C.3.3.3 ; 5XqXq.(Xq./.(Xn.1 S hXc.= u T.c ..O W.UX6.ZX6X6 X.Z.ZXF.ZXFX6 f.Z X.K.K.K X f #X6.Z.ZX6XH.ZXHX6.I.O u e e.A B GXIXU D.>Xf.w.q.q.k.7 ,.4XpXBX9XpXX.G.T * > oXl.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.DXI 1 > o.mX=X9.3.3 r.iXqXq.(Xn./XqXq -.iXI 2.E kX$X$.Q.`.YX+ 7 e I.; 4XHX6X6 NX6X6X6.9 NXF.Z.ZX6.:.:Xz gX5 4.; |.O u e 7 _ _ ) _ k e e 2XyXI.z - Y Y.>.k L Q VXXXO.x j $.FXJ * *XGX, t.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D t b 1 o o (XJ..Xs.3.3.7XqXq././.(Xq ZXaXt %.bX%.Q.`.yXO CXs.QXB jXt G.$.2XV.U 4.P.9X6.:X6X7X7 # N  X5.aXw P.O.& uXy _.`.4.`.`.Y.b.b _XI A _Xt.@XU : D J.q h T kXiXOXp $Xp.~XJ 1 * > 1.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D b > >XGXC *Xd C.3 jXMXqXq./Xq.{XIX, 1X,.b k.b +.T.Q +.T (.- +X%X+ q.c P PX..{ WXqXw.UX7X7XVXr.W |XP.$.>. XcXuX+.`.` j.X.x.xXs.`X$X$ _Xa _Xt V kX1 ` Y S v.7Xl.`XsX9XJXCX> {Xe * >Xv E t.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D RXU > > d ( 9XOXB rX+Xq.(./Xq.}XU 1XK a.*X%XKXK a.n b bXl a.T.Q.# a.E ,X0 h.q.k h K.$Xh n.P 4.w 6.O u B.=Xc 7 kX+X+X+.4.`.`.`.@Xa.4.4.bXt.E %X+X$X$ _.'.= h.'.^ + CX9..XsXd.. 1 * >Xv E.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.DXI > * > sX9XB C.3 q.t./Xq J QXv.EXl ].^.n.n.E q b = eX: %XKX+.E.bXtXl q.I.I.# k kXtXl 7 , _XKX+X+ aXt AX1 _ _XtXtXt.E q _ bXc.C ; b , 7 _ b.AXu.E k ,.  S Y.7XK C.XXpXB CX>...m oX, @.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D t 1 > >XG.3.<.<XO.3 AXn.(.k Q bXlXa.i L.^ , ,.n ]Xg.B.=.,.7.7.i.i Q.^.^ , 2 _.n b ] ].j J.5 } ] !.n.^ AXaXa _ _ _ 7 7.n b T., S S.q.%Xc G ;Xu B 6 `.nXa e S - : b C.f.<.3.3.M s >XG 1 E.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.DXlXG o >.M.M CXsXs `X@./.{.7 b.n , D.wX; W z.h &.W./.1.5.> DX0.%.,Xg T Q.i ,.n b ;.j.q.5XPXq ^.nXl A , 7Xy b b b , ;Xu B.B P.] [.2.1.&.B D.B.c.AXI AXyXI.=Xf.oX0.Q.< C.3.3.3 s > > 1 E.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D t Q >XZXZ a.3.3.3XB vX@././ : ;Xt.^ D 3XhXjXoXr.VXn.}Xj J.,.% Q.%XU.i.i.i.i ; b.n ].%.C.A AXI b b.n _ b , , , b , , , , AXc. .S.B.q W [X;.w. .c.A 2 AXyXa.= -.> hXsXsXs.3.3 d > > > 1 X.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.P < 5.(.L ! r.3.3 BXN.) Z.C.i.z.).$.e.eXq |X5Xz x.lXI GXu 7 qXl.n ,.^ ] ;.^ ; Q.8 IXt _Xa _Xa._.A A , ,Xy bXy 7 _XtXt _ _.@ _.@ 2 A G.c.q.B.=XgXI A ` AXcXf v /X3.0Xs.M jX> d > oX, @.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D tXn <.d.(.u.L q r r b.)XjXg.^ m [.2.1XjXj.W.1 6.A 2Xt jX+ %.E.EXK a.n b , ;.^X&.cX3 .X&.' < LX&.iX1 A ; ] 7 7 7.n _ qXK.EX$.` j.x.4X$Xa eXc.=.B.=.c uX3.SX*.v._.IXH.R CX> aXm s >XG 1 R.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D R.dXZXZ.d 5.tX& qXs A < vXc Y./X8XqXqX8Xj.jXyX+ _ %Xb.# i.4 k _ qXK q.n ].^.%.7.%Xg SX&X&.jX& ^.d b AXc , ] b 7.n q q._XI.p.v j %X$XtXt %Xa A.=.= u u u.=.`XO.3._X< %.xXiX% q.nX- o > R.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.[XZXZXZ ^.{.L.d ! k e.gXB 2Xo.6XoXP zXh.i qXKXK.A ) %XtXBXa )XIXc a q.n b.i L.>Xg.,.d ^.LX# 5.L.d b ;.cXcXu ; 7 q a.C y.AX$ k.3X$X$.p /XtX+ kXy u u ` Q G _ 7.B.].=X:.QXmX,XvXZX-XG a.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.(XZXZ.d.L 5 K <.n _XIXs.3Xa.8.& 3.1 H ] q a aX3.I kX$XD CX$X$ / = ; q q ].k m.| BX&.d.VX2.tX2X2 5 ]Xy.= u.c ; q.n.i.rX<X<X$ %.bX$X* e / 7 a a _ b.CXc G T A.CXN [ h qXOX%.n a oXG ; X t.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D R.LXZ ^.d 5.(X#.7 % A./ z ` 2.c.z Y J.,.n a.n !.O.&.A jXJX+XD k.r.OX& ^X&.j.q m.> , ^ 5X@X@X2X2.t.( ^.n `.S., TX&X&.,. .rX< uXa _ _ e.O .Xc ] q.n 7 AXuX0.S.AXc z } hXl.< 1 ]X,XG 1 E t.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.LXZ.d.d 5X@.u ! VXU.V.h.eXu DXg.%.i ; ^ ^ ^X&.c.O.rXc AXI.C.= P.w :.oXM.5.{.$X3.n.d.h pX@X2X2.u.( ] qX3 ..z.=XgXg., SX X .qX. = P W.O D DXc.i b b ; `.w.] B uXj.{.o 7XBX% ^XlXGX< t t.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D E <.dXZ.L.(X@.tX-.< IXn n [X0 H.=X&.^ ^ L.k S.q PX .& |.;.H z.)X .o.oX. W.)Xj.: /.E.d.( pX@X2.tXn.u.% a _X3.=.=.,.,X&., :.o.o W [ U [.2 P.B. Xc.^.i.  Z.].&.A BXq }.o ,.. 1.d.n > E.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D E.L.d.d.L.(X@.uXS.+ YXxXz.e.=Xo.1.'.jX0 -X..$ |.9 X y XX6.UXwXMXMXM.$.) z./XN.a a q 5 zXx p.u.uXN.).d !.n.C.q h S.'.'.' S :.oX.X. W WX  S. X0.,.  DXf H.2.J.A.c.e.$X. 7..Xv < Q v t t.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D E.LXZ.d.L.uX@X# r C P.UXkX8.c.}.} mXf.>.> W.2.;.UX6X6X6Xk.u.H zX#XP.(XPXxXk.V.lXZX&X#X#.u pX2.U zX. :.j.i b =.w.o PX X  W.$.e.5XMXMX .o.q S.q.q.q.| H [.JXH B P } } m b *Xl.{.{ y.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D 5.d.d.L.(X2X#X-Xs.OXr n gX0.8.}.1Xq.1.5.5.$.1.UX6 X XXFXVXVXV.hXxXx.V NXV '.j L KXjX#.uX2.u.uX#.o : L.j.i.C.].]X..$XwXw.6X5 4       4.H.J.;.$ HX8 xXj f @ SX  } [.e 7.m 7 K.{ t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D R.(.d.d.L.uX2X#XZ.T.O n.VXn S 6 g n.hXnXq.5.1XoXV X.K.[XFXF # # & p.h.9 # F.%.j <.{Xj z.uXk.u.( 5 :.'.dX&.j.^.B.2.2XjX8.6Xr.P.9X6.9X6.9 ' | 8.;X8 '  .} @XH } } 3.& 3Xy * ! K K t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D R <.d.d.(.u.uX&XZ.B g.V.V.W WXH.9X7X7 n./.6.U #XA.K.K.ZXA F F F #Xk pX7 U L.' <.{.).).(.u.u zX#XM.' :X&.%.,Xc.].; | 4Xk.:XzXV.9 NXz.P '.U 4 4 ' 'X7 @.s W.2.e [ HXh A w ] < < E t.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D R.L.d.L.u.u 5 <X&.O 4 nXrXn n ' f f fX7 g g.: f.K X X c F F c.Z.ZXxXk U.=X. <.o 5 5.).u.uX2.u z 5.' S., ^.c.,.^.r.; |.P.P.P.hXV NXV ' nXrX5  XHXH @ @.{Xh.2.$.].|.1 G > ! < <.[.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D c.L.L.(X@.( <.d.] n.a.W nXnXn 'XHXAXAX7 fXFXA.K.K c c c X.K.KXAX7XV S.o :.L.{X#.(.t F p p F &.uX. <.'X&X&.,.=Xg . xX<.9 '.9X6X6  .UX5 4 4X< I u.I WXwXh [.5X .| WXu b <.7.d y.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.[.L 5X2X@.( < KXh 8.a gXz.h &.h.J [XHXH XXA.[.K.K.K cXA.[.[ yXHXHXHXM < < 5XP.uX@.[.[ c F c.[.Z.$ :.'.'X&X& L S D.B.B.r.I.;X<X<.I.&.8.O.B . B DXw.; U.e.$ 3.|.|.].k.7.{X&.d y.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.DX@ 5.(X@ 5.L 5.}   gXo gXzX7X7 &.2 H P S.rX<XHX< 8 8X<.I Y L L.d.dX&.d.)XN.t p p.Z.[.[ F c.[.ZXwXM P L.,X&X&.,.oX. :.' S.B D.= D.=.B.O W.;XV  X5.;.$.$ [ [.].r.l.&Xh mX& ^ c.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D c 5.(X@ 5 <./ n n n 4XzXx & &XA c.KXV < h : :.> L.  : L.j.d.dX&X&.d.L.aXxXkX2.uX2X2 F.Z F p.U WXMX  S S. .j.j :XM.)XMXM.$ 5.$.$.$ 5.$.UXHXV   |Xw.2.$ [ H.|.].r.& 8 m.d < X.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D E 5.(X@.( K.(.h n g n.V.h & # F c.[.[ F.h././ K K K K.(XrXq.{.L.L KXqXkXrXnXN.(.(.u.u.u.u.u 5 S.' P.L :.'X&.'X .$.UX6XVXV  .H.6.a.HXw.U.U.U.;.;.2 W [ [.r.&.8 =.r x.q.d.k f.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D R 5 5X@.( 5XqX5.6 n.V.h.h & & F c.K.K F F.h.h.h p.Z.K.[.[ FXP.{.LX#Xk.tX2X@X2.u.(.(.(.u.uX#.o.' L P W.$ :X&.j S.).UXF.K.Z X X.Z XXHXV.U  .;.;.2 W.|X;.r.].&.8 =.8 H.k <.{ y.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.DX@X@X@.( 5 5.}.}.U nXVX7X7X7 & F c c c.K F c.[.[.[.[.[.K &X#.L.L.WXr.)X&X,Xe AXwX#.)X#X# W.,.^ ] S.2 W :X&X&.dXMX5.9 X.Z.Z.K.K X.ZXHXV.U.;.$ W W WX .8X .&X; = I Y :.{.{ @.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.DX@.(X@X@X@.t.} 8 n.PXV.h.V.hX7 # # c.K.[.K c.[.[.[.[.Z N.( 5.LXM.a.( ^ r r r rXa 5 S S : e.x.3Xs k.dXMX  L.j L :Xj  .9 X XX6.Z.ZX6X6XV.U.;.$ WX  WX X;.].l.8 I Z h.7.{Xq @.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D EX@X@X@X@X@.{.} n.9.V.V &.V.hX7 F FXA c c c c c.K.Z #.u 5XM 5X#.( < aXG.3 rXs.^.'X& TX& q.3.3.3.3X+.d S S.,X&.c.o.)XV.9X6X6X6X6XV.U.UX5.2.2 WX X;X;X;.r.8.O.O Z.k <.o.{.[.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D RX@X@X@X@./XqXo n '.V.h p.V.V.h # & c F c F c.Z F pX5 z 5.)XN.( 5.dXZXs rXs <XM.dX& ^X&X& !.3.3.3Xs ^.d D D.,X&.'.) |XV.9X6X6XVXV.U.;.; [.].] P.].|X;.8.O = IXf.k.k :.{ @.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.[X@X@X@X@.{.W n.} n ' nXz.V p N F c # F F F & F p.u.(X#XrXxXP 5.dXZXZ !.d pXP.L.d LX&., D q jX+ q ^X& SX  D., LX..HXk.9 NXVXVX5.H.;.$.] P P P.O P.|.|.8 Z 6 Y.>.>.>.{ E.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D RX@X@X@X@.t./.}.W.}.}X5 n g.h N & # # p & F # pX2XrXN.t N N.u 5.d.d 5.( z  X6X6X5 5X5.U.H.d.d.d ^ ^X& S W.$.'.' :.)XN  XkXk.U |.HXw WX X X  P P.8.8.8Xf 6 u h.>.{ m.}.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.DX@X@X@X@.(.WXo.W g n.V.V n n.:X7 & & N p F & #Xx.uXN.h p p.hX#.L.d.L.$.HX6X6X6XVX6X6.U.U W.dX& ^ ^.dX .$.$ W.o.$X#X5XrXVXkX5.HXw.2X .OX  P PX .8.8.8 Z.N Z.7.7.k.{ @.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.[X@X@X@X@ g.1./X8.} n n gXz.P.h p.:XVXV &X@XkXkXN.t pX2.u pXk.H.H.;.$.UX6X6.UX6.ZX6  .U.;.2 S.d :.L W.$.HXw.$.$.HXrXz |XP.a.$.2.eX  = P.|.|.|.|Xf Z Z I.J y <.{ E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D cX@X@.(.(.1Xq.}.WXn.}.WXz  .VXVX7.h p.h pXk.u.tXVXn.tXx.u.u.uXw.H.HXVX6XH.U.UXHX6X6  X<.$ WX X X X#.$X#.2.$ z.HXrX5.H.HXw [.2 W - P.O.|.8X; J.O.k Z vX< t t t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R EX@.(XA yXo.1.a g.W g n.PXkXk   NX7 & F.h p &X@.u.u.u.H.H.H.;.;XVX6X6XV.UX<X6XHXVXH.U.;.$ PX .L.$.$X#.$Xw.H.aXkXr.HXw.2 [X X .O.w.B Y.w = - ZXfXf h y.D t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.D.D.V.}././.6.h n n nXnXr.h # &X7 p.h pXx.tXP.HX5.H.;X#.U  X6XVXV.;.2.;.U.U.U.;.;.; WX  W W W WXM.$ z.6.VXV.a.;.2 W WX  P.w.B.w.O.O Y.k Z -.k @.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D y.{Xq.a gXz nXzXxXxXnXkX7 & &XkXkXx.VXPXw z.H.H.H.H.UXVX6X6XH.;X .2.;XV.;.;.2.;.2X X  WX  P :.o WXwXrXVX5XwX X  W.|X Xf = = - YXfXf.k.k.k.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E.{././ g n n nXzXzXxXzX2 &.hXrXk.a.H.).$ z.HX5X5  .U.UX6X6XV.;.2.2X<.Z.U.H.;.2X X .2X  W S S SX X .H.UXk.)X..q.|.|.q = - Z.O - =Xf Z v.l t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t././Xq.} n n.}Xr.VXk.VXx.VXn g.6XwXj.$.$Xw |X5.U.U.UXk NXVX5.2.2.;.U.UXk.U.;.; W WX  P PX  D.c.= D P.HX5XwX. : -.8X; I = =XfXf ZXf v v x t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.}Xq.1.} g.}Xr.VXnXnXrXn g.aX8.;X8 W W.$.HXw.H.H.HX5.uX5.u.H.;.;X5.UX5X#.H.HXw.$X  PX  P D.c.c.c D.w UX5X8.o.wXf [.r.8 = = Y Z ZXf v hX<.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t yXq.1./Xo.}Xn.V g nXnXN./.e.2.JXh [X..5.$Xw z.$X# 5 5.L.L.LX#X#Xw.; 5X  :.d W WX X X  D.c.c D.c D.wX  U z W S.k H.&X;.8.8 v Z.k v.k h y.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E./././.}.}.}Xn.W.W.WXq.1XhXh U.eX. m }X. :.L.L.d :.d.d.d.d.d.d.d.d.d.d ^.d L.d S D LX&.c.,.c D.BX .].2 U.e.w v.|X;.O = I.B v.k v h.7 E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D RX@./.1Xo./.W.WXNXqXq.1Xh.JX8.J W P.5.o LX&X&X&X&X&X&X& ^ ! ! ^ ^ ! ! ! ! ! !XZ ! ! !.^X&Xc B.OX X .r [ x [ P P.l.O.O.N.B YXf Z 6 h 3 t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D F.{ 3.}./Xo././././.W.J x.J x.qXU ] 7XZ ^ ^ ^ ^ ^ ! !XZXZ ! ! ! !XZ _ ! ! ! 7 qXZ q q q q ].c [ x.2.2 x x JXf.|.8 =.O Y D Y v v hXH t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t E.{ 3./././XqXjXP g n ' 8 U.5 ! q qXZ ^ ^.d.d :.L 5.L.LX .LX#.$X#X#X#.$.; D.d.d ! !XZXZ.n q q u.r x x.J [.] Z -.8 Z.B Y.B v v hXU E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.{././ 3Xq./Xq.W g g 4.J.|.  ! ^.d.d.d.d.L.LXwX#XV.uX#X#.;X#X#X#X#X#X# 5.L.L S.d.c S P : L 7.^.B.& x.& [.] Y Z.O 6.N.O Y 6 6XU h R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D RX@.{ 3.{.1.5.1Xq.} |.}.J.q.' J.HX#X#X#.L 5 5X#X#.u.uX6X#X#X#.u.u.U.;X# 5.;.$.;.$X  S PX .2.$.B.l.l x.J x =.B v.B 6 .Xf ZX0 6XU.}.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.[ 3 3.1 3.5.e.1Xo 4 8 U [.eX8.W zX#X#XwX#X#.H.uXV.U.u.UX#.u.uX#.U.UX5.;X#.$.$.$X  SX X .$.2 W.&.r.l x HX3.=.S.S.S ..N v 6 6XUX<.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.}.{ 3.{.5.5.eXh.} 8 8.J.6.a.aXN z zX#.;.;X#.$ 5.$X .L.$.LX .L.L.LX .$X X X X X X .$.$Xw.;.$.r.r.r.l Y 6 u.c.z u.z v 6XUXU Q.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D @.{.{ 3 3Xj.e.eXhXh x.JX8.6Xx.u.uXrXrXw.$.$X .d L.cX&.c.'.' D D D D P PX X  W.$.2.$Xw.H.2 WX; . .X3.N.z.c B.zX0X0 u 6XUXU Q y t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.{ m - 3.{ } x 3.&.8.&.;.6XzXzXx.aXr.H.2 W.$ P P D D D.' D D P D PX  WX .;.;.;.;.;.;.; [.O.B B BXU.z u `XU ` u.C /XUXUXU h y.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D F 3 m - m J.l - I.O.| W.eXqX5X5.W.WX5.HXwXw.$.2.2X X  D.d D DX  W.2.;.;.2.;.;Xw W [X .O.B.c.C.C.A.C.C.C.C.CXU.C.A /XUXU.7 @ t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t R 3 3 -Xf - J.8.N.O PX  }Xj.H.6.}XoX5.U.H.;.;.2.;X  D.c.c D DX X .2.;.;.;.$.$X  P P -.S.z.C G G eXu G G.iXu.A.A.A Q Q.7 < @.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.h.kXf.k.k - - I Y.O.w P } }.$./Xo.6.a.U.H.$.$X  PX .'.c.'X X .$.;.;.;.HXwXM.q.w.B.= BXU.C.A e e GXuXu G e G / / GXU.7.7 @.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t @.k Z.k.k v.N Z ..N.N Y Z.qX..5.$ zXw.H.$ W.2X X .; WX .;.;.;.U.U.;.;.H 8.].q.B.z B u u BXu e e.A eXI e e e e GXU.7.7.7 R.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D./.k.k.kXf Z Z.N 6 Z Y.N Y.qX..eXj U.2Xw.;.;.U.;.U.;X6.UX6XV.U.U.H.;.;.;.&.8.B.z BX3.z.C e e G.A e e e GXI e QX0.7.7 h R t.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.}.k v Z IXf I 6 v.O P Z.O.B.]X  W UXw.;.UXV.ZX6XV.UXVXVXVX6XV.UX5 | U [X;.8.O.S / u B GXI G.A.A eXIXIXI e.CXU h.7.7 v.I.s @.s @ E E.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.K.{ v v v.l.8 I.NXf = = =.O.OX  [ [ U 4.UXVX6.U.U.U.U.UX6XV.U.UX<X5 x.&.r.r.OX3.C.C.A GXu e.A eXIXIX1XI.A B.  h.7.7 hX4 O OX* OX*X4._ R t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.D.D.D E.{ 3 Z 6 Z I Z.N.N Z Z Z I.].| [.J.;.;.UX6X6.U.U.UX6.U.U.U.UX5.2 | U.I.r .X3 B B.C e eXI eXIXI A 2 A ` u hX0.7.7.7X0.@ o oXC *Xv.vX4.I.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.}.{.l 6 6X3 Z.N . . 6X3 Z.lX;.& x.J 4.UX<XV.U.UXVX6X6.U.U.U.; U U.&.r.r .X3 B.A e eXIX1 eX1 2 2 2Xg.c D D.S.7.jX0.jXl o.<XC 1.vX4.0._ t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tXA < 3Xf 6 / / 6X3 6 6.N Z.OX3.O.&.I x.;.;X<.;X<X6X6X<X5.;.;X<.2.I.O.OX3X3 / B G eXI A 2 2XaXa ,XU.S.= v.S.7.7.%X0 QXI.3 o oX*.v.g 0._.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t E.{.{.l vXU / / / / 6 . ..N I.O.r.r.r.2.;.H.;.;.;.UXV.;.$ W.2X; . u._.A.A.A e.^XI 2 2 _ _.v 7 B 6.S.S h.' h., Q.% Q ;X, s 1X*X4.0.0.I.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t R.{ 3Xf I ZXU /.A / B B B u .X3 6.NX;.O.OX  WX  P.2.2X .O D.O.B u.c B A e e e 2X1XaXtX* k 7Xg u 6 h.= D.=.,Xg.i.%.^XyX, *X*.v.0 0X4.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t t.}.{Xf.l Z 6XU /XI.A.A /.A B B B u Z.N.c D D D.O.O D D u B u . `Xc e 2 7 eXy _ )Xt kXt _Xc.c.z.z ..S.=. Xg.%.%X& QXl.TX, )X4.g.0.g.s t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D RX@.{Xf.k Z I 6 /.A.R.A GX1XI.A B.C.A BXc `.c B.c T.c A eXcXc e A AXa _ )XtXtXt k k _ A G u.z.c `.z h h. Xg.i.% Q ]X% 1X*.p.g.g.g 0.s.D.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E.{.k - I Z vX3 u.C eX1 2Xa.RXI AXI.AXu.^ , , 7 AXy 7Xy 7 7 _XtXt k k k k kXtXt _Xy G ` u.S uXg `.c.=.c T.%.% QXlXb % )X4.gX4.g.g.I t.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.{.k mXf Z.N Z . / B.A 2Xa _.@.vXt.@ _XtXtX+Xt k kXtXt.bX+ kX$X$ k k k kXt _ _ , e `.c u B u.z.=. .=.,Xg.%.i ] O V )X4.gX4X4X4 0 0 R.D.D.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX7.k.{.k Z I Z.N 6 B ` e A 2 _Xt.E k kXt k k kX$ k k k k kX$ k.b k k kXtXt _ A.^XuXc.c ` `.c.z.=.c.=. .,.%XI.EX$ ).pX4X4.pX4.g 0 0._ t t.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.D.D.D t @.k.{ -Xf I ZX3 6 BXc.A.AXI A _ _XtXt k k k k k k kX$X$.b.b k k kXtXtXt _ , eXcXc.c.c `.cXg.c.cX0.7.,XgXgXK O ) )X4.p.p.pX4.g 0 0._ 0 R.D.D.D.D.D.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t R.{.{.k.{ = = Z 6.c u.C.A eXI A 7 _XtXt kXt k k k k k.b k k kXtXt _ _ 7 e eXuXuXc.c.c.cXg.cXgXg.c.7XgX0 ,X$ % )X4.p ).p.p.g.0 0 0 0._._.s.s @ t t.D.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t R.{.{.{ m J.| Z Y.NX3.S B.A e 2 2Xa _XtXt k k k.b k k k kXt kXtXt 7 A.^XIXuXuXc.C u uXg.c `.c uXg. X0.^.b % )X4.p.p.p )X4.g.g 0 0._ 0._ 0 1 r oXG.s.D.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t./.k.{ 3 m.|.&.l.8 = ..z.C.A A 2 2 _Xt.b k k k.b.b.b k kXtXtXt 7 A A A eXcXcXcXc ` `Xg `Xg.c. .= LXcX+X$ ).p ) ) ) ).pX4.g.g 0.g 0._ 0 0 ) > oXGXv t.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t y.{ m.{ 3 3.& x [X;.B D.c.c.A AXa _ k k kX+.b.b k kXtXt _ _ 7 , A A ]XuXcXc.^XcXc T ` TXg.,.c.,.C %X$X* ).p.p ) ) )X4.g.g.g 0.g 0 0 ) * o o oXG oX<.D.D.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t @.{.k.{ 3 3.r xXh W.8.S D.c GXI 2 _Xt k k k k k kXt _ _ 7 7 A A A , ;.^Xc.i.^.^XcXcXc.%XgXU. Xg qX$X* ) ).p ) ).p.pX4.g 0 0.g.g.pX*.3.< >XC o > o *.I t.D.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.I.k m.{.e.e x.J.&.].l.lXf.w uXu 2 2 _ _XtXtXtXt _ _ 7Xy ,Xc e.^XuXuXcXc.iXcXcXcXcXc.i TXgXg.% _XDX$ ).p.p ).p.pX4X4.g.g.g.g 0 )XB.3.< CXSXC.mXCXC.MXGX, t.D",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E.g Z m J } 3Xh.1 3 H W.l.8 =.zXgXIXI A 7 _ _ _.n b , eXIXu.CXc T B ` `XcXcXg T T T TXg.%.%.i.n VX* ).pX4 ) ).p.pX4.g.g 0 0X4X*Xs.X.xXsXd l iX9 *XJX9.< oX1 t",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R.0X4 v J J H 3 3Xh.2.& H H.&.l.O 6.C.AXI A , , ,.^Xc B ` ` B.C B.c.z.=.c.c.c. Xg.c. ., T.% D.^X$ ).pX4.p ) ) ).pX4.g.g 0.gX4.`Xs.X.Y.XXOXLXX.YXJX9.~ iXC * *Xv",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.I.gX4 / m m m 3.l.| H [ [ [ x.l.O.NX0XU.A e GXcXc u.z 6.SX3 u u D.z.S.=.= D. .=.= D. .c.,.jXc _X*.p.gX4.p ) ).p.g.g 0.g 0X4.4.`.xXs.`.`.Y.Q.!.F.*XL l MX= { 1 1",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t E.0.g.pX1.{.{ 3 - Y.8 m 3Xh.e x.r.w.B.= u.C.CXc.C 6 Y =X;.O ..B.N.O P.w.O D.B S D D D.=.=.c.i _ ).g.gX4X4.p ) )X4.g 0 0 0 ).`Xs.x j.x.x.Q.`.4 ~.` $.F.`XbXb O {.y",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.I )X4.vX4 3 3 3Xf D.O.l H.e x.l.l - Z . B e e.C 6.N.O.8.r = =.8.r H.&.lX;.w Y Y.q Y D.=.,.i b.vX4.g.g.p )X4.pX4 0 0.g.gX4.`.xXs.x.`.Y.Y.`.`.yXD.y.`.4.FXDXbXe ~.*",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX<X4X4.p.pX4 - 3.e J D.O I.8.$ } J.8.O.B.S.CXI e.zX3 I ..S.=.wX;.r.&.] 3 3 3 J P.w.q.q Y.=.% 7.g 0X4.gX4 ) ) )X4 0.g 0 0 ).`XsXs.x.X.X.Y.4.4.y.`.`.y.4XD OXD.*XbXeXe",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t 0X4X4X4.v.v 6 3 3 m.|.8 D.O.].|.] =.w.B u.C eXI B . ..N . D.O.].r.r.& [ [Xh W W.] J.w Y.%XIX1.g.g.gX4 ) ) ).g 0 0.g 0 ).x.X.X.` j.`.Y.Y.4.4.`.y.`.y.#XD O.4Xb +XDX$",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D tX<.vX4X4.p.vX*XI.{X. H.e 3.B.N.O =.8 = . 6.CXI A e.c.N.O =.l.l.r.& [ x.JXhXoXh U [ 3.>Xf.c ;.R.g 0.RX4 ) ) )X4X4.g 0 0 )Xs.`.X j j.Y.Y.4.y.`.4.4X$X$.4.y.`XbXDXDX$.yXb",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D R 0X4.0.vX4.v ).v 3Xj.eXh 3X; Y.O . ..S u `XI 2 A G B.S.O.8.8.8.l [ x.JX8 8.}.} U.2 3 J.'.C.R.R 0 0 ) ) ) ).g 0 0 0 0 )Xs.x.X.x j.`.Y.Y.`.4.Y.Y.4XDX$X$.4.4.4 OXD.4X+ a",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t._X4X4.0X4.v.v.vX*.=.t.}.J.J }.O v .X0 uXcXu , b ; G.z ..N.N Z =.] }Xh U.6.6 8.6.$.$.{.> u.R 0 0 0.g ) ) )X4 0 0 0 0X$.x.X.x.X.`.Y.Y.`.Y.Y.y.4.4X$X$.4.4XDXDXD.YX%X+ aX+",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E.0.0.0X4.v.vX4.v 1 /.h.}.}XoXh.|.B 6 B.C e A , ;XuXU h . = =.8 H xXh.JX8.} | nX8.e.$.> h 0 0 0 0X4X4 ) )X4 0 0 0 0X$.`.`.`.` j.`.Y.Y.4.`.4.4.4X$.4.4.y.4XDXD O.# aX+.Y.#",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t.I.vX4X4.0.g.v.v ) OX1Xn n | g.6 [X  v `XuXI A AXu.A u.B I IX;.| m [.2Xh 8X5 ' '.6.$X..B 0 0 0 0.g ) ) ).g 0 0 0 0.`XsXs.X.`.`.`.`.4.Y.Y.4.4.4.y.4.4.4.4XD O.y.`.4X+X+X+X$",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D E 0.pX4.v.0X4.v.v.v 1XtXh.} g g |.J.lXf B.C ; A.^ G u.z ..N.O.O.| 3XhXw.6 | n '.}.1XM D 0 0._ 0.g.p ) )X4 0 0 0 0X$.`.`Xs.X j.`.`.Y j.Y.4.Y.yXDXD.`.y.y.4.4.4X$X$X+X+X$X+XD",
".D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D.D t 0.v.vX4.v.0.vX4.vX*Xe O.lXP.}.aXo.J.& =.k.= QXc.iXc B.c .Xf m H x.J.}.6 8.} 4 4X8 } . 0 0 0 0X4 ) ) )X4 0 0 0 ).`.xXs.X.` j.`.`.`.4.`.Y.`XD.4X$ O.y.y.4.4.#.b %.b.#X$.4.4X$"
};
/* XPM */
static char *dl_16gray[] = {
/* width height ncolors chars_per_pixel */
"110 150 14 1",
/* colors */
"  c #A5A5A5",
". c #9B9B9B",
"X c #8F8F8F",
"o c #6D6D6D",
"O c #656565",
"+ c #F2F2F2",
"@ c #232323",
"# c #828282",
"$ c #767676",
"% c #585858",
"& c #F5F5F5",
"* c #424242",
"= c #CDCDCD",
"- c #B3B3B3",
/* pixels */
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++++++++++++=+=+=XX.-=+++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++= ..X      .#$%%O$X-=+++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++=-$%%OOo$#X##XXXXX#$#X.... +++++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++&=$%%*%%%%%%OOOo$$$#####XX  - -- =+++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++.%**%****%%%%%%%oOOO%OOo##XX -- X#X-=&+++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++X**%**%************%%%%*%%$###.  ..X.XX+++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++.**********************%***%%O$#XXXX.  ..-&++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++.************@*@*@*@**********%%Ooo##X.X...o =++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++-*********@@@*@*@@*@*@@*@@*@****%%%*%$$OX. -O%%X+++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++%%%***@*@@@*@@*@@*@@@*@*@*@**@*****O%%$O%X -.OO%O.+++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++O***@*@*@@*@@@@@@*@@*@@@*@*@*@**@*%%O%%O$%%$#X#O%%%$=&++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++#*****@*@@*@@@@@*@@@@@@@*@@@@@*@*****%%%OooOoo##O*%**%-++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++ ***@*@*@@@@@@*@@@@@@*@*@@*@*@*@****%*%%o$$#oo$%O$%%%%**-+++++++++++++++++++++++++++",
"+++++++++++++++++++++++++=******@@*@@*@@@@@@@@@@@@@*@@*@**@****%%O$#XX#$#O*O%*%%OO%+++++++++++++++++++++++++++",
"+++++++++++++++++++++++++o%**@@@*@@@@@@@@@@@@@*@*@*@***********%O$X..XX#$O**%*****%%=&++++++++++++++++++++++++",
"++++++++++++++++++++++++#*%*@***@@*@*@*@@*@@*@@@@*@****@*******%O#X --.#X$O*********%+++++++++++++++++++++++++",
"+++++++++++++++++++++++#**%***@@*@*@*@*@*@@*@@*@*@******%*%%%OOo#X.-==- XX$%***@*****.++++++++++++++++++++++++",
"++++++++++++++++++++++-**%%*************@**@@*@******%%O%OOOo$##X.--===== #OO****@@**#++++++++++++++++++++++++",
"++++++++++++++++++++++***O%****%*****@************%%o$$$#$$$#XXX  -===+====XO%**@@** -X=&+++++++++++++++++++++",
"+++++++++++++++++++++$***%**%o$oO%%%%OO%%%*%%%%OOOo#XXX.XXXXX....  -==+=+++=-#O****%=X*%=+++++++++++++++++++++",
"++++++++++++++++++++.*@****$XX###$o$#$###$########XXXX... ......   ====++++++-.O***% #**.&++++++++++++++++++++",
"++++++++++++++++++++******o....XXXXXXXX..XXXX.XXXX......    . ...   ==+=+++=++-#%***$O$O.+++++++++++++++++++++",
"+++++++++++++++++++O@**@@%#.      .             .         - -   .  --===+=+++== O***%*o +=&+++++++++++++++++++",
"++++++++++++++++++.@**@**#  --- -    --------------  --- ---        --====+=++=-$******X=--&++++++++++++++++++",
"++++++++++++++++++*****@O -- --------- - - -  --  --- - - - -       --=====+==+=#%***%*OX-.-++++++++++++++++++",
"+++++++++++++++++ @***@*X---- --- -- --- ------ --- ---- ----      -----======== o%*****O-=$++++++++++++++++++",
"+++++++++++++++++%**@@*o - -------- - ---------------- ---- -       -  -=-===+== $%*****%- %=&++++++++++++++++",
"+++++++++++++++&-****@%.------ - - ------------------ -- -  - -  .    ---=-====--Xo******XXO=+++++++++++++++++",
"++++++++++++++++X*%***$.-- - --- -- -- ------------------- ---      -  ----=-===-.#%**@**o.X=+++++++++++++++++",
"+++++++++++++++&$****OX  ------ ------------------------ - - --         -----==-- #O*****%X-X+++++++++++++++++",
"++++++++++++++++%****$. -- -  -- -  --------------------- -- -         --------=--X$%***@*#-.=++++++++++++++++",
"+++++++++++++++=****%X   - ---- -- --- -------------------- - --          -----=-- $%*****#X#-++++++++++++++++",
"+++++++++++++++X*%**$.  - - -  -- - --------------------- ---- -    .     ------=--XO*****O##X++++++++++++++++",
"+++++++++++++++O***%#    - -- --- ----------------------- - - --           ---=----.O%****O#Xo&+++++++++++++++",
"+++++++++++++++%***%X  -   - -- --  ---------------------- - -- -         - -------.o%***%%o#O&+++++++++++++++",
"+++++++++++++++***%o.     - --- -- -------------------------- - -   .       -------.$O***%%%$%++++++++++++++++",
"++++++++++++++.***%$   - - -- -- ---- --------------------  - -- -    .    - - ---- #O%**%%*o%++++++++++++++++",
"++++++++++++++X@%*%#      - --- - ----------------------- -----     . ..   - -  ---.#%%*%*%%%*=+++++++++++++++",
"++++++++++++++$***%X.   ----  - -- ----------------------- - -   - . .   .  -   -   #%%*%*%%%%=&++++++++++++++",
"++++++++++++++O***OX      - - - ----- -------------------- - - -  . . ..         - .$O**%*%%*O=+++++++++++++++",
"++++++++++++++***%OX.    ---  --  - --- ------------------- - -   . . .  .   -     X$%%*%%*%%$-&++++++++++++++",
"++++++++++++++****%X     -  --- -- - --- ----------------- - - -   .    .  -       XoO***%%*%X-+++++++++++++++",
"+++++++++++++=****%X        - - - ------------------------- -    -              -  Xo%**%**%%$-&++++++++++++++",
"+++++++++++++=*%*@%.      -  - - --- -------------------- --  -      .   .        .XO%%***%*%OX&++++++++++++++",
"+++++++++++++=%**@O.       --- - -- - - ----------------- ----      ..  ... .    ..#o%*****%%%#&&+++++++++++++",
"++++++++++++++****O .       - ---- - -- ---------------- -- - -      ...  . . .....#O%***%**%o$&++++++++++++++",
"++++++++++++++*@*@O ..    ---- -  - --  - ------------- -- - - -    . .. ...... ..X#O%******%$o+++++++++++++++",
"++++++++++++++*@*@o .        --- - -- -- -  -- ---  -- - --  --    ...............X#O*******%o%=++++++++++++++",
"++++++++++++++%*@*O .... ..   -- -- - - -- -  -- --- - --  ---  ...X.X.XX........X.#O*******%o%=&+++++++++++++",
"+++++++++++++&X@*@o ...XX#XX.....        ------ - -- -- -- - -  .XXXXXX#XX.....XXXXX$**@****%OO=++++++++++++++",
"++++++++++++++=**@$ ..X#$o$$##ooo$#X.... .   - ----   ...     ..X###$$$$$#...XXXXXXX$****@**%%%-&+++++++++++++",
"++++++++++++++&*@@$ .X#O%%%%%%%%*%*%%$##XX...  -    ..XXXX#$$$o$OOOOOOO%O$#.XX#X#X#X$*@*@****%%=&+++++++++++++",
"+++++++++++++++$@*# X#%%%*%***********%o$XXX..     .XX###oO%********%%%*%%o#XXX#X#XX#%*@**@****=&+++++++++++++",
"+++++++++++++++X@*X X$O%*%*%***@*@@*@**%o$XXX...  .XX##$o%*****@*********%%O########X*@**@***%*-++++++++++++++",
"+++++++++++++++#@*..X$O%%OOOO%***@*@*@*%%$#XX......XX#$o%%*@@@*@*@*@******%%%o#####XX%@*@*@*@**X++++++++++++++",
"+++++++++++++++=** .X$OOoo$$##X#$oO%%%*%%O$XX..  ...#$o%%*****@********%*%**%%o$$##X.%@*@*@***OX++++++++++++++",
"+++++++++++++++=@*-.X$oo$$$##X....X##$$OOO$XX.    .X#$O%%*%%OOOo$$$oO%%*%**%%%Oo###X %@*@*@*@*.+++++++++++++++",
"++++++++++++++&=*% .X$o$######$$$OOoO$$$oOo#.     XX#o%%%o$#$$###X#$$OO%%%*%%%Oo$#XX O@@*@*@**-+++++++++++++++",
"++++++++++++++&&%*-.X##$#$oO***@***@**%OooO$.     .X$O*%%ooO%%%%OOOooOO%%%%%%%OO$$#X %*@*@*@%%-&++++++++++++++",
"++++++++++++++++$*-.XX##$O*@*@**@@*@****%O$$X  - .X#$%*%O%%*******@***%%%%%%*%%OO$#. %@@*@**%O++++++++++++++++",
"++++++++++++++++X%-.XXX#O****%$***@*%O%**O.#X.   .X#o%*O%****O*@%@@@*@***%*%%%%%O$#X %**@**%*#&+++++++++++++++",
"++++++++++++++++X%- ..X$OO%%%O$$**%%OoOo$X XX.   .X#O%OoO%%%O O*@*@***@***%%%%%OO$#X.%@*@*%**=++++++++++++++++",
"++++++++++++++++#%- . .X##$############X  .XX.  ..X#O%oo$#$Oo#$*%*******@*%*%oooo$#X.O@**%%**+++++++++++++++++",
"++++++++++++++++.%- ...XXXX#XXX##XX##$#X....X   .XX#OOo$$#####XXo%%%%%%*%*%%%oo$$$#X.O@**Oo*o+++++++++++++++++",
"++++++++++++++++=O   ...XXXXXXXXX####XX....X. -  .X#OO$#$$$$##X.XoOoOOO%%%%%oo$$$$#X.%@*%$X*#&++++++++++++++++",
"+++++++++++++++++#      ... . ..X.......  ...-   .X#oo$####$$$##X##$$ooO%%Oo$$#####X.%***O#*-+++++++++++++++++",
"+++++++++++++++++=. .           . ..     ....- - .X#oo##XXX###$#####$$ooo$$####X##XX O@***$%=+++++++++++++++++",
"++++++++++++++++++X          . . .      . ..    ..X$$$##XXX.X###X######$$###XXXXXXXX $@**%oo++++++++++++++++++",
"+++++++++++++++++=.     -   . . .   - -   ...   .X##oo##X....XXXXXXXX##XXXXXXXXXXX#X $***%%X&+++++++++++++++++",
"++++++++++++++++++X.   -     ..   -      ....  ..X#$oo#XXX.......XXXXXXXXXXXXXXXXX##.#**%%%=++++++++++++++++++",
"+++++++++++++++++=X.     -       -- - -  .X.. ..XX$ooo#X.X.... ..X...XXXXXXXXXXXXX##X#%%%%O+++++++++++++++++++",
"++++++++++++++++&=X.            -- ----  .X..   XX#$oo$#......  ...X....X.XXXXXXX###X$%OO%O+++++++++++++++++++",
"+++++++++++++++++=X..     -  - --------.XX.  ....X#$oO$#..       . .X.XXXXXX#X######X#%Oo%#+++++++++++++++++++",
"+++++++++++++++&&=X..       --------- .XX. . . .XX##o%OoX.  -  .   ...XX.XX#XX######X$%%O%-+++++++++++++++++++",
"++++++++++++++++&+#.. ..    ---------.X#X.. .  .XX##$%%%$. ----     ..XXXX##X###$####O%%%%=+++++++++++++++++++",
"++++++++++++++++&=#.... . - ------- XX#XX.     ..X##oOO%%X.  --    ....XXX###X#######%%OO%++++++++++++++++++++",
"++++++++++++++++++#X....   ------- .X#X...      .XX#oOOO%$X. ---    ..XXXX#X#########%O#$o++++++++++++++++++++",
"++++++++++++++++++XX.....   ----- .X#XX.X.. --- .X#$oOoO%o#..--    ...XXXXX##X##$####Oo$o.++++++++++++++++++++",
"++++++++++++++++++#XX....  -- -  .X#XXXX..  --- .X#$oooO%o#X.      ...XXX########$$#$OOo$=++++++++++++++++++++",
"++++++++++++++++++X#X....  --   .X#X.X###..  -- X##$OOOO*oXXX.   . .XXXX##X######$$#o%Oo +++++++++++++++++++++",
"++++++++++++++++++X#XXX..      ..#X. X#O%#X.....X#$oO%%*%$.XXX.  . .XXX######$#$$$$#O*Oo +++++++++++++++++++++",
"++++++++++++++++++X#X....     ..XX. ..Xo%%#XXXXX#oO%****O#XXXX.......X###$$$$$$$$$o$%%OoX+++++++++++++++++++++",
"++++++++++++++++++.$XX....  ...X#..  .X#$Oo$$###oO%**@*%o$XXXXX....XXX##$#$$$$$oooo$%%Oo.+++++++++++++++++++++",
"++++++++++++++++++-$XX.... ...X#X. ..XX##$ooO%%%%**@*%%%o#XXX#XX.X..XX##$#$$$$ooooo$OOoo +++++++++++++++++++++",
"++++++++++++++++++=oXX.......XX#XX...XX####oO%*******%%Oo###XXXXXX.XXX##$$$$ooOOOooooOO$=&++++++++++++++++++++",
"+++++++++++++++++&=oXX.......X##XXX.XX######$O%%%*%%%%OOo$#####XX...X####$oooOoOOoo%OoO &&++++++++++++++++++++",
"++++++++++++++++++=$XX......###XXXXXX####X##$O%OOO%OOOOOo$$$$###XXX.XXX#$$$oOOOoooo%%%o=&&++++++++++++++++++++",
"+++++++++++++++++++$#XXX...XX###X###########$oOooo$Oooooooo$$$##XXX.XX###$$oOOOOOOO*%O=&&+++++++++++++++++++++",
"+++++++++++++++++++##XXX.X.X##XX############$o##$##$oo$oooOo$$###X..XX###$oOOO%OOO$--&++++++++++++++++++++++++",
"+++++++++++++++++++X$XXX....XXXX#$$$$#####XX###XXXX#$$$ooOOOO$$#XX..XXX#$$oOO%OOO%.&&+++++++++++++++++++++++++",
"+++++++++++++++++++-o#XX.X..XXXX#$$$$##XXXXX.X....X#$$$$oOOOOo##XX...XX##$oOOOOOO%=+++++++++++++++++++++++++++",
"+++++++++++++++++++=$#XX......XX#o%Oo$$o$o$##XXXX#$$oooooOoOOo##XX. .XX#$$oO%%OO%$++++++++++++++++++++++++++++",
"++++++++++++++++++++o#XXX.....X##$$$O%%%OOOOOo$$O%%O%%%%%%%%%o$#X... XX#$oOOO%OO%#++++++++++++++++++++++++++++",
"++++++++++++++++++++$$#XX......XXXXXX#$$oooo%O%%%O%%%%%%%%%OO###X.. ..X#$oOOO%%OOX++++++++++++++++++++++++++++",
"++++++++++++++++++++.o##X.......X.XXXXXXXXXXX$###$$o$$$$o$$$#XXX.  .XXX$ooOO%%OOOX&+++++++++++++++++++++++++++",
"+++++++++++++++++++&=o##XXX.........X..X..X..... XXXX##$#$$##XX... .XX##$OOO%%OOO.++++++++++++++++++++++++++++",
"+++++++++++++++++++++#$#XX...........XXXX.XXX..XXXXXX###$$##XX...  .X##$oO%%%%Ooo.++++++++++++++++++++++++++++",
"++++++++++++++++++++&-o##XXX..........XXX#X########X####$##XXXX.. ..XX$$OOO%O%Ooo.++++++++++++++++++++++++++++",
"++++++++++++++++++++++$$#XX......     .XXX#####$##X####$###XXXX....XX#$oOO%%%OOoo.++++++++++++++++++++++++++++",
"++++++++++++++++++++++-o#XXXXXX....  ....XXXX####X#######XXXXXXXX.XX##$oO%%O%%OOO.++++++++++++++++++++++++++++",
"+++++++++++++++++++++++#$XXXXXXX.   .   ...X#XX###X#XXXXXXXXXXX#XXX##$ooO%%%%OOOo.++++++++++++++++++++++++++++",
"+++++++++++++++++++++++-O##XXX.X...       .XX#X###XXXX.X.XXXX####X##$$OOO%%%%%OOo.=+++++++++++++++++++++++++++",
"++++++++++++++++++++++++#o##XXXXX.X.       XXX##XXXX...X.XX#########$oO%%%%%%O%OOX+=&+++++++++++++++++++++++++",
"++++++++++++++++++++++++=$###XXXX.X...-    ....XXXXX...X.XX######$$$oOOO%%%%%%%OOX===+++++++++++++++++++++++++",
"+++++++++++++++++++++++++X$##XXXX.X..       .............XX######$$ooO%%%%%%%%OOO#====&+++++++++++++++++++++++",
"+++++++++++++++++++++++&&-#####XXX... .     ....X.XX..X.XX####$$$ooOOOO%%*%*%%%O%#-==+=+++++++++++++++++++++++",
"+++++++++++++++++++++++++=X$####XXX.  . .   . ...X.XXXXXX#####$$ooOoO%%%%%%%%%O%O#=== =+=&++++++++++++++++++++",
"+++++++++++++++++++++++++-######XXX...... . .  ....XX#XXX####$$ooOOOO%%%%*%*%%%O%X-==.X-===+++++++++++++++++++",
"++++++++++++++++++++++++- OX$$$###XX. .... .. . ..XXX#XX###$$ooOOOO%%%%*%%%%%%OOO.--==#$X-+==&++++++++++++++++",
"++++++++++++++++++++&&&==.%X#$$$$#XX....X... .....XXXXXX##$$oOOO%O%%%%%%*%*%%%%OO.--=+ %*o. +===++++++++++++++",
"++++++++++++++++&&&++--==$%###o$o##XX.X..X.....X.X.X#XX##$$oOO%O%O%%%*%%%*%%%%O%$- -==+-#*%%$.-+=+++++++++++++",
"++++++++++++++++&====----o%$X$$o$o$##XXXXXXXXXXXXXX#####$$oOO%%%%%%%%*%%*%%%%%%%$- ---=++.***%oX+==+++++++++++",
"+++++++++++++++====-.--- $%%X#$oooo$###X#XXXXXXXXX####$$$$OO%%%%%*%*%%*%*%*%%O%*#- --=====X%*%*%#-+==+++++++++",
"+++++++++++&=======  ---XX*%##$$oooo$$####X#XXXX#####$$$oOO%%%*%*%%%**%%*%%%%%%*X- ---=====XoOO%%o -+=++++++++",
"++++++++++===+=---- --- $.**$##$oooOoOoo$###$###$#$$oooOO%%%%%%%%%*%*%%*%%*%%%**X- --==== == ###o$$.-+=&++++++",
"+++++++---===-=-    ---.$ %@o##$oOOoOOOOOooo$o$$ooOOOOO%%%*%%*%*%%*%*%*%*%%%%%**.  ---===X =- X.X.XX.-++=+++++",
"+++++==------=--   -- -X#-*@%##$$OOOOOO%%%%O%OOOO%%%%%****%*%%*%*%*%%*%%%%*%%**%.   --===$$-=- .     . =+==&++",
"++++=-=-.. --==-- X-- -#  *@*o##$oOOOO%O%%%%*%*%*%*%***%*%%*%**%%*%*%%*%%%%%*@%O.X. ---==X#.----------  -==+=+",
"=-===---.X-======.$- --.=.*@*O$$$oOOO%O%O%%%%*%*%*%**%%*%*%*%*%**%*%%*%%%*%***oO XX. -==-.X.-=----=-----  -=+=",
"+==--    X-====== X--=-.=.@**%o$$$OOOOOO%O%%%%*%%*%*%****%*%%****%*%*%%%*%%*@OOo.XXX.--==#$X -==------  ----=+",
"- .XXXX.  =---=--X --=X +X****O$#$$OOO%O%%O%%%%*%*%*%*%*%*%**%*%*%*%%%%%%%**@$O$.#X..--=-#$# --=-=----- ---===",
" -XXX##..=====--.X---=$-=#****Oo$$$oOOoOOOO%%%*%*%%*%*%*%*%%*%*%*%*%%%%%%**@*X%XXXX.. -==$##.---=----  -------",
" - XXXX--======-  -==-#==.*%*%%O$$$$OOOoOoOO%%%%%%*%*%%%*%*%*%**%*%%%%%%***@OX%XXXX.. -=-O#X. ----=--. -------",
"X-XX.X. -===--=- ---= #==X*%%*%Oo$$$$OOOooooOO%%%%%%%*%*%%%*%**%*%%%%%%%**@*.X%..#X..  = O#X. ------  - ----=-",
"X-XXXX -===-==-- =- -$X=-.*OO*%%o$$$$oOOOooooOO%%%%%%%*%*%*%*%%*%%%%%%****@O-$o-.XXX.  =XoXX.. --- X. - ----=-",
".-X...- ==-===----  -O.- #%%o*%%O$$#$$oOOOOOoOOO%%%%*%%%%*%%*%*%%%*%%*%**@*#-O$-...X. --XoX##X  -- ##  -- --=-",
"..XX. --=-=------- --$-= #%%o*O%Oo$#$$$oOOOOOO%%%%*%%%*%*%*%%%%%%%%%%*****%X.%$ X. . . -#$#$o#   .X..X#. -- = ",
"- ...   =-====---- -X$=--.O*$%%O%O$$##$ooO%%%O%O%%%*%*%*%*%*%%%%%%%%%*%*@*#  O..XX.  .--oO$o*$--.#XX. .X##X - ",
"-.XX.- -=--------  =#X==..O*O*%%%Oo$###$ooO%O%%%%%%%%*%%*%%%%%O%%%%%****@O --O- X.X.  - OO$O*$ - X..XX ..XO# #",
"-.X.--X--=====---- =$.=-- %@%%%%OOOo###$$$oOO%%%%%*%*%%%%O%%%%O%%%%%***@*#-=.o= ...X -- O#Xo*#-- ..XXXXXXXXX$X",
"-... -#--------=-  =O-=-  %*O%*%O%Ooo#X##$oooO%%%%%%%%%%%O%OOO%O%%%******X-=X#=...... =.%$Xo*o-- ..XX$##$#XX.X",
" XX.- X-- ------- --$===- *@Oo*%OOOOo$#X##$$oOo%%%%%%%%%OOOOOOO%O%%*****% --#.-..    X=XO$XO*$--- . X%$ooo$o#o",
" X  =.X=--------- --#=--- **O$%%OO%Ooo#####$$$oOO%%%OOOOOoo$ooOO%%******O. -O -. .. - =#O$.O*$------.$Xooooo#o",
"    =X.=-=-===----=..===-.@*O$o*OOOOoo$#####$$$oOoOOOOoooo$ooOO%%*%*%***$. .%.XX. .----XO$X%*o.-- --XX.$$$$o.o",
"    -# =-=-=----. =$ =--=#**O$#%%oOOOO$##X###$$$$ooooo$$oooOooOOO%***%%*X-- $-.XX..-.-=#$#.%*$ -----#X.#$ooOXO",
"   --$-=-=-==-  -  %ooo$.#@*oo$o%$oOOO$#XXXX##$$$$$o$$ooooooo$oO%%%**O%% -=##-.XXXX-.-=Xo#X%*o.-----OX.X#$$o.o"
};
/* XPM */
static char *dl_256[] = {
/* width height ncolors chars_per_pixel */
"110 150 256 2",
/* colors */
"   c #595629",
" . c #CD9059",
" X c #AE824B",
" o c #6C734C",
" O c #4A4D24",
" + c #5F5E32",
" @ c #D0985F",
" # c #AB733E",
" $ c #7E6936",
" % c #CDC9BF",
" & c #C68148",
" * c #D49159",
" = c #D6A372",
" - c #907441",
" ; c #C5C1B7",
" : c #D69E68",
" > c #DA9B62",
" , c #795627",
" < c #EDB98F",
" 1 c #B1743D",
" 2 c #BE844D",
" 3 c #42471F",
" 4 c #806431",
" 5 c #967540",
" 6 c #A2A991",
" 7 c #9A703A",
" 8 c #604E22",
" 9 c #7C5E2D",
" 0 c #8C9578",
" q c #5E6437",
" w c #BC8F58",
" e c #E4AA7C",
" r c #B9753E",
" t c #EDCCB3",
" y c #9A6530",
" u c #BF8851",
" i c #424B22",
" p c #CC9461",
" a c #939B82",
" s c #374621",
" d c #E7AE82",
" f c #726130",
" g c #C08C55",
" h c #D59B63",
" j c #B5A075",
" k c #59481E",
" l c #748160",
" z c #343714",
" x c #DDA878",
" c c #D5A97A",
" v c #D6925A",
" b c #D2E1D0",
" n c #3D4920",
" m c #B4B7AC",
" M c #E4B282",
" N c #C5C4B6",
" B c #B07C45",
" V c #98A38D",
" C c #E0AA7E",
" Z c #866936",
" A c #E1A975",
" S c #C7844B",
" D c #B7864F",
" F c #B6BAA7",
" G c #5D5428",
" H c #796433",
" J c #B07E48",
" K c #E2AE83",
" L c #515126",
" P c #B7B19E",
" I c #A57D47",
" U c #876D3A",
" Y c #8D6A36",
" T c #EAB88E",
" R c #716938",
" E c #A3703B",
" W c #3E441D",
" Q c #443F19",
" ! c #A6A58D",
" ~ c #212E11",
" ^ c #CEA06F",
" / c #A19E7E",
" ( c #BB874F",
" ) c #CA9761",
" _ c #8F7948",
" ` c #B28650",
" ' c #9B7540",
" ] c #CD945A",
" [ c #C57D45",
" { c #3C461E",
" } c #7A6130",
" | c #885B2A",
".  c #F1C09B",
".. c #363C18",
".X c #F6DCCE",
".o c #343A16",
".O c #DA9760",
".+ c #D6975C",
".@ c #716D3E",
".# c #D8C7B7",
".$ c #E8EDE1",
".% c #273313",
".& c #252F11",
".* c #A4834F",
".= c #3C3D17",
".- c #C58C55",
".; c #C5C0AE",
".: c #6A5C2D",
".> c #B7AD93",
"., c #6F5728",
".< c #9E8D60",
".1 c #858D6F",
".2 c #A3AA9D",
".3 c #E5A571",
".4 c #D3955C",
".5 c #565A2D",
".6 c #4E3F18",
".7 c #BF7D45",
".8 c #5A5327",
".9 c #CBC4B7",
".0 c #6C6232",
".q c #574F24",
".w c #DF9861",
".e c #C08A53",
".r c #DAAB7D",
".t c #D69762",
".y c #E1F6EA",
".u c #987946",
".i c #886533",
".p c #E1A570",
".a c #DB9F6A",
".s c #E19C66",
".d c #E4B080",
".f c #C98D55",
".g c #87723F",
".h c #E1AE7D",
".j c #6F5D2E",
".k c #E6AD78",
".l c #AE7841",
".z c #D59964",
".x c #AAB096",
".c c #726534",
".v c #DAA16C",
".b c #37411B",
".n c #DE9C66",
".m c #4A5227",
".M c #755C2D",
".N c #CB8850",
".B c #504D23",
".V c #E1FAF0",
".C c #BBBAAD",
".Z c #4B471E",
".A c #EAB68C",
".S c #2F3313",
".D c #5D5629",
".F c #AD8550",
".G c #F0C39F",
".H c #E5B287",
".J c #D78D55",
".K c #E0A06B",
".L c #B4B4A6",
".P c #4C562C",
".I c #BE7A43",
".U c #515327",
".Y c #A67F49",
".T c #EABF99",
".R c #DFFCF1",
".E c #956935",
".W c #D5CDC3",
".Q c #C7884F",
".! c #ABAC9D",
".~ c #A87841",
".^ c #A17944",
"./ c #635528",
".( c #866230",
".) c #C08048",
"._ c #6E7A57",
".` c #8C9785",
".' c #90703D",
".] c #DA9C68",
".[ c #95814F",
".{ c #B0AF9B",
".} c #A87A44",
".| c #CE9B66",
"X  c #6B5629",
"X. c #715325",
"XX c #EAB388",
"Xo c #C5C9B6",
"XO c #93977B",
"X+ c #D18D55",
"X@ c #AFB4A7",
"X# c #E5FDF3",
"X$ c #B87A43",
"X% c #ADB0A5",
"X& c #92622E",
"X* c #626D44",
"X= c #D4935B",
"X- c #DDA471",
"X; c #ABAA8F",
"X: c #B87E46",
"X> c #EEC09C",
"X, c #A06B35",
"X< c #D69C6A",
"X1 c #D9B084",
"X2 c #CA8B51",
"X3 c #B47842",
"X4 c #CCD7C3",
"X5 c #B88B53",
"X6 c #E5B589",
"X7 c #B9804A",
"X8 c #615225",
"X9 c #C6945A",
"X0 c #D08850",
"Xq c #8D6D39",
"Xw c #444F26",
"Xe c #7D6F3D",
"Xr c #2F3A18",
"Xt c #906632",
"Xy c #2D3816",
"Xu c #D9945C",
"Xi c #C3BBA6",
"Xp c #6E4E21",
"Xa c #3B431D",
"Xs c #565327",
"Xd c #9EA592",
"Xf c #9D9670",
"Xg c #946C39",
"Xh c #EEBD98",
"Xj c #979F8B",
"Xk c #625A2C",
"Xl c #A1753F",
"Xz c #E1D9CD",
"Xx c #C79461",
"Xc c #CE8C54",
"Xv c #7C5B2B",
"Xb c #353F1A",
"Xn c #504F24",
"Xm c #D7E9DA",
"XM c #C0BCB3",
"XN c #E6BB93",
"XB c #D4BC9F",
"XV c #A7743E",
"XC c #51441B",
"XZ c #DA9159",
"XA c #7A6836",
"XS c #B2824C",
"XD c #BAB5A3",
"XF c #BA9561",
"XG c #53552A",
"XH c #E9B182",
"XJ c #C69159",
"XK c #6F5A2B",
"XL c #CF9965",
"XP c #E5AA74",
"XI c #808056",
"XU c #4A4B21",
/* pixels */
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.V.y.yXm b b b bXoXf.1 /.x b.$.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXmX4X; /XfXf j.>.> j j j j.[XI q.5 qXIXf.> b.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V bX;XI q.5 q R.@XIXI.[.[.[.<.<.<.F.< _XI _.<.< j.<XfX; b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R b._.5.m.P.P q.5 q.5.0 R R RXe _.g _.*.[.[.[.[.*XF j j.> jXo.>X;Xo.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R 0.P.m.m.m.P.mXw.m.5.5    Xk  .0Xe R R f.0.cXA.g.[.[XF.< jX1XB j.<XI.< F b.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXf s n.m.m.m.m i nXUXnXUXUXU nXUXU.qXs  Xk    Xs  XkXe.[.[.[XF j jXFXf.<Xf.<XfXm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R a s n.m i i i n { { 3XU {.= {.= {.Z.Z.ZXn.q.qXnXUXCXU  .0XA.g.[.[XF.<XFXF j jXf /Xi.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R / n nXw i n { n { {.b.b.b.b.oXb.b.o.o.o.o.=.o.= { { { n n n  .0 R RXe _.[.[XF.<XF jXf o / b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R F nXwXwXw n { { { WXb.oXyXy.o.oXyXyXyXyXy.o.o.o.o.o.=.b.b.= nXU  Xk.5  Xk.g.[ R.< j j.>.@.P q.1Xm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXm q.P.P s W.b.bXbXyXy.%.%.%.%.%.%Xy.%Xy.%.%Xy.o.o.o.o.o.b {.=.= nXU.U   f  .:.g R  .< j c j.@ R +.@ /.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VX*XwXw nXbXbXrXyXy.%.%.%.% ~.%.%.%.%.%.%.%.%.%.%Xy zXyXy.o.=.= {.=Xn.q  .c.0Xk $.gXk f.g.[.<.[.c.5.5 q._ b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.1 sXw sXbXbXrXy.%.%.%.% ~.& ~.&.%.% ~.&.&.%.%.%.%.%.%Xy.%Xy.o.b.= {.ZXn.U  XkXk $ $ U RXe.@ _.[ R.U.5Xw n.P F.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R 6 n n sXbXbXrXr.%.% ~ ~ ~ ~.& ~ ~ ~ ~ ~.&.&.%.%.%.S.%Xy.%XyXyXy.o.= 3XUXU.U   f $.g 5.[ $Xe.g.5 R -Xk.5.U qXw n.x.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX4XwXw n sXbXrXrXy.% ~.%.% ~ ~ ~ ~ ~ ~ ~ ~.%.%.%.S.%.%Xy zXy.oXb.=.b.=.ZXUXn  .0XA.[ 5.* X.[.g.[ R n.0.0.U.U q.@ q qXm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXm._.5Xw.bXrXrXrXy.%.%.%.%.%.% ~ ~ ~ ~ ~ ~ ~ ~.%XyXy z.=.=.=.=Xb.= n 3 3 W.ZXU.U f.gX5XFXFXF.F.[.[ $XsXn.U.m nXU i.U.U qX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.yXI.5.P n.b.bXrXrXy.%.%.%.% ~.%.&.& ~.&.&.&.&.&.S.SXy..Xb W.= { Q.ZXU.Z.ZXUXnXnXk $ 5XF jX1X1XF.*.* -.:XnXUXU.=.b n n i n.P.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.1.mXw.5 i.b.bXbXrXyXyXrXrXrXbXrXy.SXy.%.%.S.S.S.S z.S.=.=.Z.Z.Z kXsX8X8X8.: f f U.~.* j cXNX4 M jXF.<.gXkXn i n.o n {.=Xw n /.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX;XwXw + + i {Xa.b.bXa { 3 3XaXb.b.=.=.o.o z.S.o.=.=.= Q.Z kX8Xk.:.M f f f $Xq ' 5.*X5X9 cXB t t t tXB ^.*XA.:.U {XbXbXyXy n.PXIXm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXm.5 sXw.0XG O 3 3.5 +  Xn O iXa W Q.Z.Z W Q.= Q 3 Q.Z.Z.q./.M U.' 5.^ ' 5 5 '.~X5X5X5X9 ^ cXB tX4.X t t tXB.< $ +XU.bXyXyXy.m jXDXf b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXIXr.b.mXG O.U.0.g.gXA.cXk.D.DXk.0 HX .:.:./XkX ., H } f 4Xg.^ X.F D w wX5X5 XX5 wX9X9.| ^ jX1 t t.X.X.$.X.X t c.[ RXUXb.b { qXiXfXw.P b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R /.b s s 3 W.q.g.<.F.*.[.u -.g.u.^.^ I I.u '.u I.} J X B J J u.- gX5XJXx ).|X9X9X9X9X9X9.|.| cXBXB t.X.X.X.$X#.$.XXB j R i { {.5.x.[XwXr a.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXm nXb {.bXb WXAXFXxXFXF w w `X5 wX5X5.-Xx wX5 w.e g.e ( 2XS DXxXxXJXxXx ).|.|.| h @ @ ).|X9.|.| cXN t.X.X.$.$.$.$.X.X.T.[.5 i nXwXI RXIX* /.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R oXr s sXbXy.q.FXx ^ c ^ ^ ^ pXLXxXx ^ ^ = ^XL ^.|.|.|.|XL.|.|XLXLXLXLX< =X< :.v.v :.v :.| @.| ^ =X1.T t t.X.X.$.$.X.X.X j RXU n n.P.m.@ jXmXm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R aXr s sXbXr n.u ^ ^X1 c = = = = = = = =.r C.r c.r.r C x x C.r x =X< = x.r C c x cX-.a =X<.+ @ h :.v cXB.T t t.X.X.X.X.X tX1 _XU W n.m.m i.1 tX;.xX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.yXwXb i.b..Xr.c ^ c cX1X1 C c C x x C = x C.r C K.H K K K K K K.h A x = x K K C C x.v.vX<.].t.t h >.v A.hX6.T.G t.X.X.X.X tX>.< +Xw { n.m n RXf.> j.x.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R 6Xy n sXb.SXU.* c cX1 CX1 C C C C C.r x.r.h K K.HX6X1 M K K K M K xX- C C K K K K A A.v.v.].O.t.n >.v A c cXNXB.T.T t t.X t.G jXe   { n i i.U qXoXB _.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.5 s nXbXr.. U ^X1X6 K K K K K K C C C C x.h.H M K.H K K K.d KX6 M x.h d K.H d K KX-X-.v.n.].n.O.t h.a.p = =.hXNXNXB t.G t tX> c.u.0 i { n n n.U.> j.5 b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.;.b.P iXbXrXG w cX1X1 C C K K.H K d A e.d x.hX6 MX1 C M.d.H.H.H.A M K.hXXXX dXX K dX-X-.K.s.n.nXZ *.].n.v :.v AX1X6X6.T.T.#X>.T c.FXe.m 3.b { n nXf.<.0X4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXO.b.P W...Z.g ) = c.r x C K K.H K K C C xXP K M d K K dXXX6X6X6.AXXXXX6XX.H.H d K d eXP.3.3.s.].OXu.O.]X< : : =.r.hX1X6.T.GX>XB CXF _.5 i { { { n o j.<Xi.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXI i.mXa W.cX5.| : = x x C C K K K d.h e A e K K KXH M dXH.HX6 T.A <X6XX.A.A.AXX d dXX dXP.3.s.].w.n.O.OX<X<.v.v c A.r.rXBXN.TXNX1 ^.< R.m n.b { n.mXfXBXf.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.5 OXw.bXU 'X9 : = = A x A C C K d K.k.k.kXH.HX6.HXXXH.H.A.A TXhXN T.AX6 <Xh T.AXXXXXHXX.k.3.s.s.O.O.O.t.t.O.] :X- AX- AX1X1XNXB.H c w.g.5 i { n { nXI.>XfXB.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX4 L.m 3 W fXS.| ^.v x.v.vX- C C C KXHXH.d MXXXX.A TXX.A.A.T <Xh.TXNX6.HX6 < < < < < <XX M e.3.3.s.w.O.O.t.t.+ > > : :.v x.h.rX1XNX1.r ^.u + i { { { n.[.<.[.x.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.< i.U 3.U 7XJ :.v : =.v.K.K x x.d.HXHXHXHXXX6 T < <.TXhXhXhX>. Xh < T T T <XX <XhXh < <XXXHXPXP.K.nXuXZ.w.+.+.t.] : :.vX-.r.r.hX1X6X1 =.F.@.m i n i n.@.<.[Xf.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX* n.mXUXk.}.|X< ^.v.v.a.K.K.p e.hXHXHXHXH TX6X6XN.TXhX>.G.G.G. .G. XhXhX>.  <XhXhXh. .  <XX.k e.K.n.w.wXu *.+.+.z h.v.v = c.hX1X1X1X1 cXFXe.5 n n i.m RXI.<.@X#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R + { O.B.: D.|X<X<X<X<.a.v.K.a e.h MXHXH.A <X6 <.T.T.TX>.G.G.GX>. . . . . . XhXhX>Xh.G. . XX.k.3.3.K.nXuXu.+.+.O.+ h.].v = x.r xX1X1X1 cXFXe.5Xw n i.5 q R.<X*.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.RXm O WXUXn.iXJX<X<.v :X<.K.p.K.pXPXHXXXHXH < < <.T. .G. .G.GX>.G.G.G.G.G.G.G. . .TX>. .G.  < <.k.3.3.K.s.wXZXu.+.+.O h : :.vX- = A.r.r.r.rXF _ R.m n.mXk.U q.g q.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R !.bXUXn.8Xl ].z.]X<X<.a.K.pX-XP.h MXHXHXX < T <Xh.TX>.GX>X>.G. . .G t.G.G. . . X>X>.T. .  <XH.k.3.K.w.s >.w.+XZ.J.+Xu.O :.v = =.v x cX1.r.| _.@.5Xw.m.5.5.U R.5Xm.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V 0Xb O.U./ B ) : hX<.a.vX-.v.K A.k.dXHXH MXXX6 < <.TX>.T.TX>. .G. .G t.G t.G. . X>X>. .G < <XX.k.3.n >.s.w.+XZXZXZ v.+.+.|.v.v.v : : = c cXx.[ q  .m.m.UXk.5 q.mX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.RXI.b OXUX XS @ : h :X<X- AX-.KX- AXP.k.k M M MXXX6XN.T.TX>X>.G.G.G.G.G t t.G.G.G.G.G.G.G.  <XH.k.3.s.w.nXuXZ vXZ v.+.4.+.4 :.v ^ h : = c = ).[ +XG.m.P.m.5.5.5.5X4.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V.@Xa OXU HX5 ).| :.zX< =X-.p.a.a.K.vXPXP.dXH M.k.d T.T.T.TX>.GX>Xh. .G.G.G. . Xh < <.  < <XHXH.K.s.s.n.O vXZ v v *.+.t.+ h :.v :.z ^.v = ^XF _.0.U.m.5.P.5.5   qX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V.P WXU.B f X ) h h.t h.vX-.K.K.K.K.K.pXP.k.k.d.k.kXHXNXN.T.TXNXh.AXN. .G.G.  <.A.AX6 MXH.k.kXP.s.w.w >XZ.JXZ *XZ.J.+.+.4 @ : : ^ =XLX<X<.|XFXe.0XG i.P.5.P.5   _.>.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.y O iXU.Z./X5 @.| @ h hX-.K.K.p.K.p.pXPXPXH.d.kXPXPXHXH.H.A TXhX> < <X>.G. . .  <XXXH.kXPXP.3XP.K >.w.w.w.J.+.+.+.+ v ].+ h : : : ^.z :.| )XFXe q.mXw.P.5.U.U.5.<Xi.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.RX4 W.m 3..X X5 :.|XL.t h.K :.n.p.p.p.pXP.k.k.k.k.k.k.k M M MX6.AXh < TXh < < < < <XHXHXH.kXPXP.K.K.s.s.w >.+XZ.+.+.+.+.+ @ : @.| @.|.| :.|XLX5.@.5.m O.m.m.m.mXk.g jX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.RXo.P.5.b.o.,X9.| h.].z.]X< > >.p.pXPXP.k.kXH.k.k.k.kXHXH.H MX6.HXX <XN <XX.AXXXH.k.k.kXH.kXP.3.3.K.s >.w.w.+.+.+.+.+ >.+ @ @.| @.| :.| :.| ).F R.5.m i.mXw.m.P.5 RXfX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.RX4.P.PXb z }X9.|.| : h.z h h.nX- AXP.k.h.kXHXH M.h.k.dXH M MXH.h d.HXXX6.AXXXX M.kXPXH.k.kXP.K.3.s.s.w.w.+.w.+.JX+.+.+ ] ] ] @ @.| ).|.| ) w.*Xe + O nXwXwXw.P.5 qXIX#X#.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.y 3Xa.b z H ) ).|.| h.z.z >X-X- A.k.d.hXHXHXH M.k M M.HXXXXXX d d.HXHXX.A.AXHXH eXHXXXHXHXP.pXP.3.w.w.+.w.+.+.+X+ ] ].+ ]X9 @X9 ) ) ) )X9 w.Y R.5.m n n.m n.m.5.@ _X#.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V nXb.bXb 4 )Xx ).|.z.z h.aX-X- A.k AXP.hXHXX M.hXH T T.A TX6XXXH < < < TX6XXXH AXHXXXXXXXHXPXPXP.K.s.w > >.+.+.JX2 ] ] ]X9X9X9X9 )X9 )X9 w.^.0XsXw { n.m n n.5 _.@.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.mXbXb.S $ ^Xx ) ) @ h.z.].]X-X- x A A A C.k.kXP.kX6.AX6X6.AXXXX < <Xh.T <Xh.H.H K.AX6XX.k.kXPXPXP.s.+.+.+.+X+X2X2X2X2 ]X9X9X9X9 )X9 wX9X5 I.c.U 3 { nXw n n qXeXk b.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R qXyXr.SXA ^Xx p ] ] @.f ]Xu.zX< =.K.]X- x.p.K.p.p A K K.HXX d.hXHXX.A T TXX K.H.r x MXHXP.kXPXP.K.v *X2X2X2.QX2X2X2.QX2X9X9X9X9X9 w w wX5.*XAXw {.b n i n n qXe qX4.y.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V 0.o...&Xe ^XxX9 g uX:X:X7 u . . .X2.Q @.a.t.+ h h : :.v = A A A x C x.h K C xX-X- @ :.p.K.p.p.a :.+X2 S S.7X: (X: B B (X9X9X9 wX5X5X5.F.F.F.gXw {.b.b { { n q RXkX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.V.WXa...S.g ^XxXJ g.~ 7 y.E E #.l yX, y 7X3.)X2XcX0X2 ] ] @ >.v.vX-.p.p.pX-.v >.+X= . @.+.+.+ > >.+ ] &.lX$XVXV 7 7 7 7 B gX9 wX5 `.F.FX5.F.F.gXw.bXa.b.b.b {.5 qXsXi.y.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.mXy.% _ ^ w ` '.( ,X.X. ,X.Xp 8XpXp k 8Xp ,X, r r [ SX2X+.4 h :.v.K.a.nX=X0X0 S S & &X$XlX,X,XtXtX& 4 | 4 4 4 9., 9 Y X wX5X5 `.F.F.F.F ` _ OXb.b.b.b.b n.5  .UX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXI.& z.[.| w 5 9X. 8 8 8 k kXCXC.6 Q.6.6.6.6.6 , y 1 r & S.NX+.+ h.n > vX0.) S.I r # y |Xp k kXCXCXC k kXC 8XpX8 8X8 9 $ I ` ` X X.F.F `.F.[.m.oXb.b.bXb nXw.mXnXo.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.1.&.b.F.|.F 5.M.,Xp 8Xp 8 k Q.=.= z z z z z.6 kXp y 1 [ & SXc . *.+X=.J.N & r 1X,X& , k.6 Q Q.=.=.=.= Q Q QXCXUXCXnX8XK $.u.Y.Y.Y.Y.Y.Y.F.<.UXrXy.bXbXb.b n.mXn.x.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.1.& QXFXF.F - }.M., 9.( 9 } f k Q.= z z z.6.6.6Xp | y r [X0.N.f . *X=X+X0.7 r EX& |Xp.6 z z z z z z z.=.= W Q.ZXUXU kX8X8 f Y.^Xl.^ I B.FXFXGXyXyXbXr.o.b.b i 3Xf.y.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXo z.B j ^.F.u 4 9.iXt 7 7 ' X.F.^ 7 Y |X.XpXpXpXp , | 1 [X0X+ *.4.t *.JX0.IX,X& |Xp k.6.6.6 z z.=.6XCXCXn k kXUXnXCXnXU.qX8., U 5 '.} X `XF.5XyXyXr.oXbXbXb { q 0.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX4.. k ^XxX5.u Z Y 7 7XV.} X `.- )XxXF ( J EX,X& | | | y rX0.J.+ h : vX0 [ rX,X&XpXpXpXp , , 9 4 Y 7Xl 7 4 }.,X8X8.q k 8 8X8XK 4 U '.~ JX5 jXk.%XrXrXrXy.oXy {Xf.$.y.R.R.R.R.R.R.R.R.R.R.V.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXm W.m cXxX5 - U 7XV.~.} B JXl 7 '.' 4 4.i.(X, y 1 y y y rX2.+ : @ :.+Xc [ r y ,XpXpX&X,XVX, 7Xl I XX:.l 7 7 4 }.,.,.q.qX8./ f }Xq 7.~ XX5 ^.0XyXrXyXy.o.o.=.Z.>X#.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.5.B cXFX5 I 'Xl.~XVXt , 8.6 Q.=.S Q Q z.6 kXp | y |X&X,X0.+ h : h.4Xc.7 # |Xp k |X& y | ,., ,.M 9 4.(XtX& | 9.,.,./X8X8.,., 9 4XqXl XX5 j.:XyXrXrXyXy.oXsXkXB.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXIXn cXx ( D J IXlXv k z.S zXC z.S.= z z Q.6 k kXp | 1X, [.+ :.n > * S.IX,XpXCXp |X.Xp kXCXC Q.=.6 z z.=XC 8Xp.,.,.,.,X8X8X8., f.i 7.^ w ^.5.%XrXrXy.= 3., R.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXf.q cXx ( D DXVXv 8.6.= QX8.u.8.S.....= 8.iXp k kX&X0 r [.J > >.+X+ S 1 YXpXp.( , k k k k.c.Z.o   z.&.S z.=.=XC 8X8X8X8X8.,.,.,.( 7.^ w ^ +XyXr.o..XC./XC.[.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXf   c ).f.f uXV |XvX.., | 4 -.g  Xs G.:.i.E |X& y B.+ & [X2.+ >.+Xc [ #.(.,.M Y |XpXp k 4 j R z.=.S z.= Q z z.=.6 k 8.,.,., 9 9.(Xg.^ wXFXkXyXbXr.Z.,XC.6Xo.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.1X X1 ^.4.4.fX7 B.lXV.~.}.}.Y.u.u.*.* X.~ E 1 u :.+XJ S SX+.+.OX=X0 & #XvXv.(XtXl.lX,Xt Y.*XI.m.U Q Q.B 8 k.Z.=.6XC 8X8., 4Xq Y Y 7.^ `Xx RXrXrXaX Xv.6 8.$.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXf.: cX< *X+.f.Q 2XSX7X7X7 2 2X7.FXS J B.l 1X3 2 ] . ].QX0 @.].t *X2 & 1 | 4 Y 7X, B J.~.~.Y.F.<.g.:Xk.,.,.:., kXC k 8., ,XtXqXg 7 7.}X5XF +Xy...8.i y.6.g.y.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXo 9 ^ :.+ *X+Xc.- u.Q.Q.- u uX7X7X7X7X$X3X: 2X2X2X9 . SX2.a.K.O.+X2.).l.i.(X,XVX, EX,XV # JX5XF.F - Z 4 4 4 H.,.,.,., , 4.E 7 7 E 7.} `XFXk.o.BX .'X:.6.*.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.* )XL @Xu.4X= . p . p * * pXc.N.N.NXcXc.f . @ hXL .X2 *.a.K.n.OX+.)X3XtX& E.l.l.l #X,X, E.lXS.F IXl 7 7 Y Y f ,Xv.(Xt 7X,.~.~XV.~ XX5XF +...Z.6 9 rXp.>.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXzX9 @ ].+ >.t.t.t.O.t.w.t.t vX=X= p *XL.t.z.z.z @ .X2.+.n.v.K >X+ 2 1.EX,XVX:.).).)X$ 1 # # 1.l.l B # #.EXt YXtXt 7XVXV 1X: D.l BXS w ^ RXy.=.6Xp y ,.#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXz.Q.+Xu.O > >.t >.OXuX=Xu v vX= v v.] :.].].zX=.+X+X2.4.n.n.n *X2.) # yX, 1 B.) uX2X2.)X$X3X$X:X:X3X3X$ 1XV 7Xl.lX:X:.).) ( (X: DXS D jXe z Q kX.X& Y.$.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXzX2.+.+.O >.n.s.nXuXZXZX= v *Xu.O.n >.a :.].t.OX=X+X0.J.+ >.4Xc S.I #X, y 1X$ (X2X2X2Xc S & & S.).7.).7.7X$X$X:.).) S.Q.).) ( ( 2X7XS ^XI.=.6Xp , |X5X#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXz S.+.+.O >.n.s.w.wXZXu v vXu.t.s.K.].].] > >.t *X0X0.J.+.+ vXc.7 #X, y y E.7 SX2X+.fXcX+XcXc.Q.Q.Q.Q S &.).).).Q ( (.).) 2 ( uX7 J.YXF.[.6.6XpXp ,.9.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXz &X+.+.+.O.w.n.s.s.w.wXZ.w.w.n.p.K.n.a.a.s.a > *.NX0.JXZX=X+X0.7 # yX& yXV.7X2 SX2 ]X2.+XZ *X0X0.N.NX2.Q S S.Q.Q 2.Q.) 2.).Q (X: J IXF _XpX. ,Xp |Xm.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R t.I.J.+Xu.O.w.w.s.s.w.w.w.w.s.K.3.p.KX-.p.3.a.+X0.NX2XZ.+XZXZX0.) 1X, yX&XV.7X2X2.J *.J.JXuXZXZ.JXc SX2X2X2.Q.Q.Q 2 2.).).)X7XS B B.}.<.uXv.( | |Xq.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXz [.J.+Xu.wXZ.w.w.s.s.s.s.s.s.3.k.kXP e.3.p . S.QX+XZ.+XZXZ.J S [X$ E.E.( y rX2X+.+.+.+.+.wXZXZXZ *X+X2X0 S &.Q.).).7.7.)X:.l.~.}.Y.Y `.u ,Xv y |.u.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXz [X+.JXuXZ.wXZ.w.w.s.s.3.3.3 eXHXH.kXP.KX+.I [X0 vXuXZ v.+X+ & [X$ #XtXv 9X& [.+ >.s.s.s.wXuXuXZ.+ *X+X0 & &X2.7X:X:X:.7X:.lXl.l.}.Y.* 5Xp , | ,.>.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R t [X0.JXZXZXZXZ.w.w.s.3.3.3.3.k dXH.3.s.J.7X$ &X+.+Xu.+X=.+X+.N [X$ #.EXv , , yX0.+.p.pXP.K >.O >.+XZ *X+ S S &.7 rX:.7X$X$XVXV.}.Y I.Y.iX. , |Xp.#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXz.IX2.JXZ.J.JXZ.w.w.s.3.3.3.3.k e.3.wX0.I.7 [ SX+Xu.O.O.O.OX+X0 SX:.~.E | |X. |.7.+.+.v.kX-.K > >.+ * *.JX2.) &.7X: 1X$X:X$XV.~ B.}.Y.Y ,X. | | |Xm.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$ rX0Xc.J.JXZXZ.w.w.s.3 d.3 d.3.3.wX0 [.I SX0X0 ].+.O.].K.].tXc S.7XVXt.(.( | ,X, & ].+.3.p.3 > h.w v *Xc.Q &.).7.7X$X$ B.l.~.~.~.^ I.^ , | #X, y.V.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$.) SXcX0.J.J.J.w.w.3.3.3 e.3.n.w.J [ r.7X0X0X0X=.4.].K dX-.O * S.IXV Y.( y | , y r S.+.K.p.v :.+Xu.JX+X0X2 S.).)X: rX: B.lXVXl.^.^.^.^X&X& E yXF.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.) [XcXc.J.J.JXZ.w.3.s.3.s.s.t * [ r [ [ S.Q SXc @.]X-.H.HX<X0 2 1 EXtX& Y | ,X& r &X2.+ h.a : @.+.JX0X0 S &.7X:.7X$.l.~.~.lXl ' '.[ ' | |X& #.9.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.)X$.NX0X0.JXZXZ.s.3.s.s.].].J [ r [X+ S r 1.I.f.4.O.O = =X=.NX$ # 7Xt | | , 8 y & [ SX+ @ h.+ *.+.JX0 S [X:X$X$.lX: 1.~.~.~Xl 5 5.^ ZX. | y ^.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y 2 r 2X0X0X0.J.w.w.s.w.O.wXZX0 [ [XZXu.N 1 | | E.Q.J *X= pX+ [ #X,.EXvX.Xp 8XpX, S & &.QXc @.+ ] *X+ S & [ r 1 1 1.~XV.~XVXl 7 5Xq.u HXp | y jX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX# 2 1.Q SX0.JXZ.w.w.wXu v *X0 [ [XZXZ.tX+ [ y , , 1 & & 2 S & 1.EX&.,.6 QXC kXv r & S & &X2 * ]X+X+X0 S [.7 r 1XV EX,XlX,X, 7 7XgXq.u.,Xp |X&XF.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R p #.).N.N . .XZ.t.O.t *Xc [ [X0XZ.w vXc.N rX,X&X&X, E E # 1 y |Xp.Z.= QXCX.X&X, [ S &.7 &X+XcX2X+Xc S [.I.l EX, EX, 7 7 7 Y YXqXq - ,X.X& y.<.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX1X, 2.-.-X+ .X= . p ..N.N.I.I.N *XZ pX0.)X3 1X, yX&X& , , , , k Q.= Q kX. , y r [ S &.7 [.QX2.Q .Xc.).7X$ 1X,XVXlX, 7 7Xq Z Z $ Z.'.iXv y y.>.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.# y 2 uXc p . . . * . S [.I.) SX0X+Xc S.I.IX3X3 E y.(Xp 8 k.6.6 Q.Z kX  , | y 1 rX$.7.).7 &.)X2XcX2 2X:X$ 1XVX,X, y 7Xt 4 4 $Xe U Z.iXtX& EXz.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.W yX7.eXc . . p *Xc.f.7 r.I & [X0X+ S [.IX3X3X3X7.l 7 |XpXp 8./././X Xv | 9X&XV.l 1 rX3X:X:.)X2X2.Q SX$X$ 1 1X,X,XtX&.( Z 4 $ $ U.M |X& , j.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXzX,XS u.- . . . ..-.) 1 r.I.7 & [ [.).IX3 #X3X$ J.} 7.i.M } H 9 } 9 } 4.i.( yX,X,X,XV 1 1.l.).Q.Q.- (.)X:.lXV E 7 Y.( 9 4 $ $ UXeX.XpXp 5Xz.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$ E J D 2.-.- ..-.Q.I # rX7.).IX3 rX3X3X3X3X3X3.}.~ 7.i.i Z.' Y.'.i Y Y YXtXt y.EX,X,X,XV.~X: (.QX2 ( DX:.lXVXlXgXt 9 9 4 }XA $ H 8X. U.9.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y #.} ` 2.e.-.-.f.QX$X3.).)X: r 1 1 1 1X3X3X3X3X3.} E Y.^.^.^.^.^ EXg.EXgXtXtX&.(Xt 7 7.~.lX: (X2 g.QX: J.lXl 7Xg 4 4 9 9 }.c f _.>XB.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.y wXlXS 2.e.-Xx ..- 2X7 D 2X$ E E E # #X3X3X3X$X7X7 J JX7XSX7 2XS.~ E.EXg.E.i.(.( 4 Y.E.~.~ X (X9.f g ( X.}Xl 7Xq.( 9 9 } H.c., /.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.>X, JXS u.-.- ..- g g g 2.lX,.EX, E.l BX3X7.7 2.e.-.eXx . p . uX3XV EXg 7 Y.(Xv 4 4XtXl B D (X9X9X9X5XS XXl 7Xq.i } 9 }XA } fXo.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VX#.W y.}XS.e.-.f . pXJXJ 2X7 #X&XvXvX&X,X,X,X,X,X, #.lX$ u.N 2.lX,.EXtXtXtXt Y.i.( 4 4 Y.^ B ( gX9 )X9.eXS.}.^Xg.i 4.M f }.c.:.g.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$X,.}XS u.-Xc . pXxXJ (X:X3XV 7 7X& ,X. , | | | |X& yX, yX& | , | ,X.X..,X X.XK.,., ZXl.} ( gX9 )X9 g X I 7 Y Z.M f.j f HXK.[.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.y E ' JX7.e.-XJ . .Xx.- uX7 2 2 uX7X3 EX, y y yX& | | , | , , ,X.X.X..,X.X X  f 4.i ' I B DX9 ) )X9X9XS.^Xg Y }.c.M.j f R.MXf.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXxXg.^ J D.-.-.-XJ pXJ.f gXx.e u.e u u.N & [ [.).I # # # r # E.E EXg 7 7.'.'.' ' I `X5 ( w ) @X9 w g X.~.' Y 4 f.j.: HXA 4Xf.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXz.E '.} `X5XJ.fXJ .XxXJXJ .XJ.-.Q.-.-.-.- .Xc .X+ p.J.t.t.NX7X7X7 J IXV.^ ' 'Xl X DX5X9X9.| )X9 u D.YXlXg.i } f.j.:.cXA.iXf.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.YXg X ` D gXJXJXJ.- .XJXx . ..Q.- u 2 S.N.Q [.-.N.-.- 2 2 2 2 D J.}.} EXlXl.Y BX5.e.-X9.| ) wX5 J.~ 7 Y 4 f.:.j.: f $ ZXfX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.VXBXt.^XS D.e.-XJXJ.-XJ . . p . ..f.NX7.IX7.I JX3 # # # #X3X7X7 J.} IXVXlXl.~X: D.e (X9X9.| )X9 (.YXl.' 4 }.j.jXK.0 H $ Z j.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$.' 7.YXS (.-XJXJXJXJX9 ] @ @.z p.f gX7X7X$ J.l.} # #.}X7X3 J #.}.} #.~.l J (X7 D (X5X9X9XJX5 X I 'Xq 4.M.:.j.:.jXA $ ZXf.V.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VX#.>Xg I ` ( ( w.e g.fX9 ].4.z.z p p p.-.eX7 DXSX7.} #.^ J J.}X3 J.Y B JXS D ( ( D DX5 g g.e D.YXl.' UXA f.:.:.:.jXA $.i j.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.V.$.u '.F ( 2 ( ( u u.f ] @ @XL @ pXL p . g DXSX7XS J.Y JX7 JX3X7X7X7 D D ( ( 2XS X X D D D B I 'Xq $ }.jXk.:.: f H 4 YXf.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RXi 4 IXSXS D u g g.eXJ . @.| h.tXLXLXL p.eX7X7 J J J JXS 2.eXJ g g g g ( DX: X X.Y.Y X X.^XlXq $ H.0.jXkXkXk.0 } 4.i j b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.y.[Xq J J XX5 (X5 g g.- ].|.| : h.zX< pXxX7X7X$ JX7X7XS 2.-Xx.-.-.-.eX7 B.~.} I I I.Y.^ ' 5 Z } f.:Xk.5.:Xk.j.M }.(.<.$X4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.#Xq.^.Y X `X5X5X5 g (XJX9 ) : :X<X<X< pXxXx.- u u 2 2 g.-XxXJ.f.- gXS X.} I I.^.^ 5 7 5 Y $ f.jXkXk  XkXk.j.j } }.<.W bX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX#XF.'.^.Y.F DX5X5 w g.- ) ) h.|X< ^X< p p .Xx.-.N.-.-XJX9X9XJXJ.f DXS.* I.^ I.u.u 5XqXq $ H.0.:.D.DXk.DXkXk.M 9 9XI %.9.WX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX#Xi.^.^.*.Y X XX5X5 gX9 ) ) )XLXLXLX< pXx p p.-.-.f.- g.- g g.- wXS X.Y I.^.u 5 5Xq Z $XA f.0.0.D    .D./.:Xv 9Xv.1 ;.W.#Xm b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX#.#.F.u.u.Y.Y.Y `X5X5X9 ) ) ] ) ) pXLXLXx p p ..-.Q.e ( u ( ( u D J I I.Y.u.'.g U $ $ $ R.0XkXk.D.D  .D./XKXvXv ,.<XM.W.#.{ bXm bX#.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.$.C.[.u.[.u.[ I.Y DX5 wX9 ) ]X9 ] pXLXL p p.t p.-XJ.- ( ( JXS (XS J.^ I.^ 5 - U $XA H R.0.0Xk.D.D  .D  ./XK.MXv.jXfXM % t / 0.{X4 bX4.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.yX@X; $.*.[ - _.u I X DX5X9 ) )X9XJ ] )Xx p p p pXx . g (XS J DX5 J I.^ -.'.g $ $XA.c f.0XkXk.D.D.D    .8X XK.M.( } / mXMXzXzXI l.1X;Xm b b.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX#X#.RXm N /.j.<.[ _.g - 5.Y `X5 w ).-XJ.eXJX9 p p pXxXx.-XJ.eX5 DXSX5 ` I.^ 5.' ZXA.c.c.0 f.0 +Xk +  Xk.D     G.:XKXv | $XjX%XM %.X !.P.P oXd.! b bX4X4.R.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.RX#X#X#.V.yXiXMXMXo.1X .[.< _.gXq.g.^.Y `X5 w g g g.e gX9XJXJ.- g.- gX5XSXSXS ` XXl 5 5 UXA f.:.0.:.0Xk +.DXG  .DXG G.DXkX .M.MXv.g.LX; m ;.W.$.#XIXw.PX*._Xj mXmX4.R.R.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.VXz b %XM.C.CXD.L oXk -.*.[.g.g.g U 5 I XXS D D ( ( D D (.e gX5 (X5XS.Y.Y.} I.^ 5.' U $.0.0.5Xk + +.D  .5XG.5  XsXG G.:.:.j.MXp o.C.!X@.C.9Xz.$.X !Xw s.P.P oXjXm bX4.R.R.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.VX#.V.y %.WXz.W m.2X@ m.L ! l./ f.<.[.g.gXeXe $ 5.^ I J XXSXS ` D DX5 ( ` D ` I I X ' '.u -XqXA.c.:Xk  .D.5  .8  XGXs.8.8Xs GX8./.,.MXKXCXIXM.!X% m ;.WXz.WXzXO.P.P.P.PX*.1X%Xm bX4.R.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.V.V.RXzXz.W %.W.W ;.2.2.CX% mXOXOXG.q.*.[ _.gXe.gXe $.' '.u I.Y.Y X XXS ` ` X X.Y.^.^.^ 5 - U Z $ f.:.D  .D.DXG    XG.UXsXsXs 8.8X8./XK.,X .=Xf m.2X% m ;.WXz.W ; %.`._._X*.P q._Xd ;Xm b.R.R.R.R.R.R.R.R",
".R.R.R.R.R.R.V.V.y.y %.WXzXm.WXM m m m.2X% mX@X% o /XG z.[.<.[.gXeXeXe $XAXAXe.g 5.u.^.^.u.^.^.uXl ' 5.'Xq U $ $.c.:.D.D  .5.5.DXk.5  XGXnXG  .8.8X8././.,X .qXaXO.L.2X@ mXM.9Xz.W.! ; %.2.`.` l l._ l aXMXmXm.R.R.R.R.R.R.R",
".R.R.R.R.R.V.V.{ P %.W % % ; % m.2.2.2X% mX@X@Xj._.!.P.&Xe.*.[ _Xe R RXe R H f f H $ UXqXqXq.' -Xq Z 4 $.c.c.0.:.DXGXG.5      .D.5  Xs.U LXs.8 GX8X XpX8X X8.6.m /.!.2X% mXM ;.W.W.`X% ;XM.2.`.`.`Xj 0 0 a.L.yXm b.R.R.R.R.R",
".R.R.R.R.yXm ;XM.{.{.C.L m ;XM m.2 V.2X% mX% m 0.1 PXw.&X .[.[ _.g.@ R R RXA.0XkXk.:.: f f f f } f fXk.:./.DXs LXnXnXsXG  XG.PXsXsXs.U.U   G GX8./X.X8X.X  Q O.5XjXdXdX%.LXM ;.W.W._ l m % m.2.2.2X%X%.2 !XdX% ;.yXm b.R.R.R",
".V.VXmXm b.C.9XM ! a.! mXM ; %XM mXd.`X@X%.2 m.1X;.! s.&.Z U.[.[.gXe R R.c R f.0.:Xk.D    Xs  Xs.8XsXnXnXn O.B.B L.UXsXGXs L.UXGXsXnXsXs G G.8./.,X8XpX  k.. qX* V aXj.2 PXM ; % % a.1.`XMXM mX%X% m m.L mX%X%.!X@XM bXm b.R",
" b.;.W.W %.C.L.{XdXOX% ; % % %X4 %.2._X@X@X%.CXO.# /XrXr...j.u _ _Xe H.c R.0.0.0.0.0.0.D  XGXsXn.U.qXnXnXn.U.mXn.UXsXGXGXs L L LXs.q.U.8X8 GX8X X XpX8 8.= 3 o oXd.`XOXj.2XD ; % ;XO 0.2X%XM ;XM mXMXMXM mXM mX%.2X%.C ;Xm.R",
"Xm.9.9XM.L 6 !.2.! 0 ; % %.W %.W.W V.` m m % P /XzXjXrXbXa G U - _.gXA R R.0.0.0 +.0.0 + +      XGXs.q LXG.U LXnXnXsXsXsXG.B O OXn L.q.q.8./.:X XpX8 8XC.&X* o._Xd 0.` aXj PXM % ;.1 l.`X%XM % ;XMXM.C mXM mX%.! m mX@ mXm.R",
"XM.> V.`.` a 0 V !X; %.9 ; ; ;XM m.`.! m m.WXO !.X aXbXw W.q H -.u _.gXA R R.c.c +.0 +.: +  XGXsXGXGXG L LXn LXnXnXs.U.8.q L O.B.q.8.q.8X8.,X X X X8 k.=.S lX* l.`.`.`.`Xj PXM.# ;.1 l l.2XMXM ;XMXM m m mX%.!.!.C mXMXMXm.R",
" !XD.` 0.1.1.1Xj !.;.W %.9 ; ;.CXj.1XM m.C.WXI PXz 0 s.PXU.B.0 U -.u -.gXA R R.@ R R.c +Xk + G  XGXsXG.qXs.UXs.qXsXs.8XsXs.q L L L.q.8./.MXKX X X  k.6.S 3.`.P.`.`.1.`XjXd !XD %XM l l.`XjX%XMXMXMXMXM.C.L ! !XD mX@.CXMXm.R",
" / N V.`.`.`.`.!XD.W.W %.9 % %XMXd.2XM m %.;XI.;Xz.` W + L.B.: $ - - -.gXA R RXe.@.@Xe.0.0Xk.D.D +  .8.8Xs.U G.8Xs.8XsXs L.qXn L.q.8X8.,.j.,X X. 8.Z z.& oXO.PXj.`.`.`.`.2 ! P % m._ l.`.`.2 mXM m mXD.C.! !.!.L.{.L m mXm.R",
".<X@.` a.`.`Xj.{Xi.W.9.9.;.;XMXD.! m m m % j.<.#Xz a s + +.B.: f U _ - -.g R.c R RXeXe.@ R.0Xk +Xk +Xk G    Xs   GXsXsXs.qXn.B.q.q 8X X X X XpX XC.6.S.=.`XOX*.2.`.`.`.`Xd.!.! %.2._ l.`.`.2X% m.C P P P ! !.{.!.{.L.{X@Xm.R",
"XfX%.` 0XO.` 6.{.9.W.#.9.# %.;.!.!XM m.2XM oXfXiXi a O q.c.BX .j $.g.u _ 5 U R RXAXe.@XeXe.c.c.0.j.:Xk./.D G.8Xs.8.8  Xs.q.8.q.q./X X X X8XpX8 kXC.=.S.@.L.[ oX%.`.`.`.`XdXd P ;.`._.`.`.`Xd.2X% mXD !XOXj.!X%.{.{.{ P FX4.R",
" /X%.`XjXjXd.x.>.#.;.9.9.9 ; ;XDXM m.2Xd.L R /XD !.1 + + o.BXKXK H.g -.u -.gXe R R.cXAXAXe $.c.0.:.:.DX .D  ./ G.8.8.8.8.q.8X8./.:X X XpX ./ kXC Q z Q.1.! o._ mXj.2Xd.`Xj !.!XMXO._.1.` l.`Xd.!.{ PX;.1XI !.!.{ F.{.LX@Xo.R",
" / V.`.` a 6 P.>.W.9.9.;.;Xi P PXMX@.2 m.LXIXi.9.{.1 +XGXIXC.M.M.M U -.u.[ -.'Xe.c H.c f.c.c f.j./ GX8.D./ G G G.8 G.q.qX8X X X XKX X X  8 8 k Q Q z.5Xf !./ l.2.`.2Xj.2.2Xj.!.CXI._.1 l o.1Xd.2.2XOXO aXjXf.1 /.x.! P.xXo.R",
" F.2 a aXj.xX;.>.;.;.;.9.9 NXD.L mX%.2 mXfXI.9.;.>XjX*.=XIXsX  }.j H.g.u.[.u -XeXeXA.j.:.j.j.0.jXKX ./.8.8X8.8.q.q.q GX8X XK.jX XKXKX X Xp k  .6 z.BXI ! PX*Xd.`.`.`Xj.2.2XjX%.LXeX*._._Xw lX%X%Xj.1 0XO ! 6 / 0XI.1 a 6X4.R",
".LXj.`.` V F !Xi.;XiXiXiXiXiXD.C mX%.2Xo.1.<.W.; ! /X*...@.8./.M.j } U 5.*.[.u.'.gXe H.j.:Xk.:X .:./././X8.qXs 8 8X8./X XKXKXKXK., ,.,X .q k.Z Q.S.@.!XM.>.@XM.2.`.`.`XjX%.2 PX%.@ o lX* s lX%X%.2.` a a 0 0 ! V /.1 o l.x.R",
" m a a a.x F.1XiXo.#.;.9.9Xi m m m.2.2XoXI /.WXM.>.2 q.. +.8X8.M } } 4Xq.^.*.*.u - - $ R H.:X ./X8 8 G.8 G G././.j.M.:.jXK.M.M.M.M.,X X8 kXC.6 Q zXI PXi ! o ;.2Xj.2.`.`.2.!XM.!X* l.1 l s.1 mX%.2XdXj a 0 0 0.1 aXOXO 0XI.R",
".C V VXj.xX%XI.>.>.>Xi.;.;.;XM.C m.2.2XoX* P %XiX;.!.PXb.0 + k.M.M } }.iXq.^.F.Y.u.u.g U $XA f.jX .D GX8X X .:.: f H.j f.M }.M.M.jXKXp 8XC.Z.6 Q QXfXD.9.<.<XM.2Xj.2XjXjXdXd ;Xj + l.` o s l m mX% / a a.` l.1 l l l 0XO a.R",
".2 0 a V F.xXfXi.>.>.>.> P P.C mX@.2 FXiXI.9 %.; PXdXwXr oXe kX  H } } 4Xq 5.*.F.Y I _ - U $XA f.:XKX X X XK.jXK } 4 4 4 4.( }.M.MX XpXC.ZXCXC Q + !XD ;.[XjXM.2Xj.2.2.2 !Xj ;.`X* l.`._Xr l m m.L.!XjXd 0.P l._ o._._._.1.R",
".2 0 VX;.9 /Xf.;.;XiXDXiXD P.C mX@.2.C.{XIXo.9.;XDXd sXrXe _./ 8 H H.M 9 YXg ' J.Y.*.u - -.g Z H H f.M.j f f H H.i Y YXqXq Z 4 }XKXp k k kXC.ZXa o /.>.> o !X%.`.2.2.`X%X%.> ;XO q l.` o s lX% m P P P.CXj l.`._ o._ oX*.1.R",
"X%Xd 6.x NXf /.#Xi.;.;.9.; N mX@X@X%X4 / /.W %.;XDXjXr...@ _.g 8 H $ }.M.i Y ' I.}.* I.u.u - -.' $ $ 4 H $ Z Z Z Y YXqXq Z.i 9.M.,X8 8 k k.Z.qXaXI / ! ! +Xd.`.`.`.2.2X%.!.L ;.1 o l.`X* s._ !.L P P P.CXO.1Xd l._._._._ a.R",
".2 6.xX;.;XI.>.;XB.;.9.9.;.; mX%.2.2 ;XI.> %Xo.; %.1Xr s.@ _ _.j.: U $ } }.i 7.}XS `.* I.u 5 - -.'Xq UXq Z YXg.' YXt.i $ 4 Z.(.(.M./ 8 k.Z 8 qXwXO PXM ! o m.`.`.`.`.2X%XjXM.9Xf._ lXj + s l.! mXD P.CXi.1.1Xd.1 l._._X* 0.R",
".xX; 6.>XiXI.>.;.;XB.;.9.;.C.2.2.2.x.2.5 o oX* oXj.1Xr.PXeXe _.gX .'Xq Z H 4Xq.}.FX5 `.F X.^ - -.'.'XqXq.'.'.'Xq Y.EXt YXqXg Y.(.M 8 k.q.6 R q.PX;XD ;.< lXMXj.`.`.`.`.LXOXM %.1._XI.`.P s._ /.L.L PXD.> R.1 V.` l l._._ a.R"
};
/* XPM */
static char *lf_16gray[] =
{
/* width height ncolors chars_per_pixel */
"110 150 16 1",
/* colors */
"A c #A5A5A5",
"B c #9B9B9B",
"C c #8F8F8F",
"D c #6D6D6D",
"E c #656565",
"F c #F2F2F2",
"G c #232323",
"H c #151515",
"I c #828282",
"J c #767676",
"K c #585858",
"L c #F5F5F5",
"M c #424242",
"N c #CDCDCD",
"O c #0C0C0C",
"P c #B3B3B3",
/* pixels */
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFL",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFPPPPNPFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNPPBBCBBCBBPPPFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNNACBPNPNNFNFFFNNABIDJCIIIICBBANPPNFFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNNPCIAABPPNFFPPBIDDJCCCABACBABAPNNNFFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNPNPPPBJJBCCCBACIDKDCACCCCCBCCCBPAPNNNFFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNPNPNNPBBAAAAAADKBJDDKEDEDJIJKEEEKKKEDDJICBNNNFFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNPPBBCCCIICJDEDJCDMKMMMMKJIDKEKKKMKMMMKKKDIJCBANFFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNPPBIDKKKMMMMMMMMKMEKMGMMMMIKMKKMMMMMMKMMMMMKKJCBCNFFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNNACDMMMMMMMGGMGGGGMKMGGMGGMMMMMMMMMMGMMMMMMMMMMKJABANFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFPIKMMMMMMMGGGGGGGGHHGHMGGGGGGGGGGGGGGGGGGGGGMGGMMKJBBANFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFIKMMKMMGGGGGGHHGGHGOOOOHGHHHGGGGMGGGGGGGGGGMGGMGMGMMIABANFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFNNBEKKMKGMGGGGHGHGHHHOOOOOOHHHHOHGHGGGHHGMGGGGGMMMGMMGGMKCBAAFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFFFFNNABEMMMMGMGGGGGHGGHHHHHOOOOOOOOOOOOOOHHHHHGHGMGMGGGGMGMMMGMIBAPFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFNFFBBJKKMMMGGMGGGGGGGHHOOHOOOOOOOOOOOHOOOOOOOHHGGGGMGMGMMGMGMGMGMCAPAFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFCJEEKMKMMGMGMGMMGGGGGHHOOOOOOOOHOOOOOOOHHOOOOHHHHGGGGMGGGGGMMGMMGECNBPFLFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFPBBDIKMMMGGGMMMMGGMGGGHHOOOOOOOHOOOOOOOGOHOOOOOOGGGGGGGMGMGGGGMGMMMDPPPFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFABDKMGGGGMGMMGGMGGGGGGHGHHOOOHOHOHHHGOOOOOOOOOOOHGGGGGGHGGGMGGMMGMGMCPPNFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFPBDKMGGMGMGMGGMMGMGGGGGGHHOOOOOOHHGMGHOHOOOOOOOOOGGHHHHGHHHGMGGGGMMGMDAPNFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFBJKEGMGGMGMGMGMMMMGGGGHHOOOOOOOOOHMGGGOOHHOOOOOHOOOHHHGGHHGHOGGGGGGMGKIANFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFACJKMMGGMGGGMGMMGMGGGGHHHOOOOOOOOOGGGGGHHOOOOOOOHGGHHHGGHHHGOOOGGGGGMGMEBPNFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFCDKMGMGGGGMMGMGGGGGGHOHOOOOOOOOOOHGGGHGGHHOOOHHHHOHOHOHGGGOHHOHHHGGGGMGMJPNFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFCCJMMMGGGGMGGGGGGMGGHHHOOOOOOOOOOHGGMGHOMGHHHHHHHOOOHHHHHGMGOOOOOHHGGMGMMKAPFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFJBAEMMGGMGGMGGMGGMGOOOHOOOOOOOOOOOOGGMGGHGGGHHHOHHOGGGGHHHHMGOOOOHOOHHGMMMMCNFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFCABIMGGGGGGMGGMGGGHHHHHHHOOOOOOOOOOHHMMGGGHGGHHOHHHOHHGGGGGHGGHOHHHHHHHGGGMMIPFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFPIEMGGGGGMGGMMGGHHHGGGGHHHOOOOOOOOHHGGGGGGGGGGHOOHHHHHOGHGGGGGHHHHGGGGHHGGMMIAFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFCIEKGGGGGMGMGMGGGHGHGHHHGHOOOOOOHHHGGGGMMMMGGGGHHOOHHHGGHGGGGGHHHHHGGGGGHGGGGJAFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFDIKGGGGHGGMGMGGGGHHHHHGHGHHOOOOOGGGGMMMKMKMGGGMGGHHHGHHGGHGGMGHHHHOHHGGGGGGGMMCNFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFECKGGGGHHGGGMMGGGGHGGGGGGGHHHHOHGGGMMKDDDJDKKKGKMGGGGGGHHGGGGGHGHOOOOOHHGGGGGMMJAFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFBIMGGGGHHGMGMGGGGGGGGGGGMGGGGHHGGMMKJIIIIJIIDEKMMMMMGGGGGGHGGGGGHGOOOOHOHHGHGMGMDCPFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFBMMGGGHHGGGMGGGHHHGGGGGMGGGGHMGMMKDIICCCIIIIDJEMMMMMMMGMGMGGGGGGHHHHOOOHHGHGGGGMMEPFFFFFFFFFFFFF",
"FFFFFFFFFFFFFCEGGGGGHGGGMGGGHHHHGHGGGGMGMGMMGKJIICCBCCICCCIIJEMMMMMMGGMGMHGGGGHHHHHHHOOOHHHHGGKMCFFFFFFFFFFFFF",
"FFFFFFFFFFFFPEMMGGGGHGGMGGGHHOOHGGGMGGMGMGGMEIIICBBBBCCCBCCIIDKKKKMMMMGMMGGGGGGHHOHHHHHHHOHHGHMKKAFFFFFFFFFFFF",
"FFFFFFFFFFFNBMMGGGGHGGGGGGHGOOHHGHGGMGMGGMKDICCCBBBBBBCCBCCICJEKEEKKKMGMMGGGGMGGHHOHHHHHOHOHHGGMKINFFFFFFFFFFF",
"FFFFFFFFFFFPEMGGGGGGGGGGGHGHOOHHGGGMMGMGMKDICCBBBBBBBBCCBBBCCIJKJEMEKMMMMMMMGGGGOGOHHHHGHHGHHGGGMKAFFFFFFFFFFF",
"FFFFFFFFFFNIMMGGGHGHGGGHOHGOOOHGGMMMMGGMKJICBBBBBABAABCBBBBBCCJKIJEEEKMMMMGMGGGGHOHHHOHHGHGOHHGGGDJNFFFFFFFFFF",
"FFFFFFFFFFPKMGGGHHHGHGHHOOHOOHGGMMMMGGMKICBBBBBBBAAAAACBBBBBBCJEICJDEEEMMMMMGGHGHHHOHHHHOHHHHHHGGMDIPFFFFFFFFF",
"FFFFFFFFFFCMGGGHHHHHHOOOOOOOOHGMMMGMGMEICBBBBBBAAAABAABBBBBABIIEICCIDEDEKMMGGGGHHHGHGHHHHHOHHHOGGGMIPNFFFFFFFF",
"FFFFFFFFFNEMMGGHHOOGHOOOOOOOHGGGMGMGMDICBBBABABBAAAAAAABAAABCCIECICIIDDEKKMMGGGGHHHHHHOHHGOHHOOGGGGDJNFFFFFFFF",
"FFFFFFFFFPMMGGHOOOHHOOOOOOOOHGMMMMGMDICBBAAABAAAAAPAAAACAAAABCCKCCCCCIJDEKKMKGGGGHHHHHHOHHHHOHHHHGMGKANFFFFFFF",
"FFFFFFFFNIMGGHHOOOHOOOOOOOOGGMGMGMKJCBBAAAAAAAAAPAAPAPAABAABBCCKICCCCCIJEKEKMKGGHHHHHHHOGHHOHHGHHGGMMCPFFFFFFF",
"FFFFFFFFPKGGGGHOOHHOOOOOOOOMGGGGMEDIBBBAAAAAAAAAAAAAAAAABBABBCCECCCCCCCIJEEEEMMGGHOHGHGGHHGOOHHHHGGMMIPNFFFFFF",
"FFFFFFFNJMMGGHOOOHOOOHHOOOGGGGMKEJICBBABABABAAAAAAAPAAAAABAABBCEICICCCCIIJEKEEKMGHHHHHHHOHHOHOOHGGGGMKPPFFFFFF",
"FFFFFFFCMMGGGHHHHHHGGGGGGMMMMKEDIICBBBBAAAAAAAAAAAAAAAAABABABBCJICICCCIIIIJKKEEKMMGHOHHHOOGGHOOHHHGGEKKANFFFFF",
"FFFFFFFBMGGGGGHOHHGGGGGMMMMMKEJIICBBBBAABAAAAAAAAAAAAABAABBBABBDIBJDCICICIJJEKKEMMMGHHHHOHHHHOOHHHGGMJCKAFFFFF",
"FFFFFFPDMGMGGGHHOHGGGGMMKMMKKDIICCBBBBBBAAAAAAAAAAAAAAAABABBABCJDIDJCIICIIIIJEEKKMMMGGGHOOHHOOOOOOOHMDACIPFFFF",
"FFFFFFAMMGGGGGGGGGGGMMMMMMKKDIIICBBBBBBBBBBBBBABBBABAABABAABBBCIEIIICIIICIIIJJDEKKKKMMGGHOOHOOOOOOHHHKECBCFFFF",
"FFFFFFDMGMGGGMGGGGMMMMKKEDJDJICCCBCBBBCBBBBBBABBABBBBBBBBBBBBBCIDIIIIIIIIIIDIJJDDEKKKKMGGGOGGHOOOOOHGKJEAPFFFF",
"FFFFFNKGMGGHMGGGGGMMMEDDJJIJIIICCCBCBBCBBBBBBBABBBBBBBBBBABBBCCIJIICCCICIIIJJIJJDDEEKKMMMGHGMGOOOOOHHMPJBPFFFF",
"FFFFFAKMGGGGGGGGGMMMKEDJJJIIIICCCCBCCCCCBCBBBBBBABBBBBABBABBBCCCIIIIIIIIIIIIIJJJJDEEKKMMGGGGMGHOOOOOHGKBBPFFFF",
"FFFFFCMGMGGGMGGGGGGMMEDJJJICCIICCCCCCCCCCCCCCCBBBBBBBABBBBBBBBCCIJCCIICCIIIIIJIJJDEEKKMMMGGGGGGHHHOOOHGKAFFFFF",
"FFFFPJMGGGGGMGGGGMMMKEJJJJIIICICCCCCCCBCCCCCBCCCBBBBBBBBBBBBCCCIIIIIIIIIIIIIJIIJJDDEKKMMGMGGMGGGHOOOOHGMIPFFFF",
"FFFFPEGMGGHMGGGHHGGMKEDJJIICICIICCCCCCCCCCBBCBBBBCBBBBBBBABBBCCCCCIIIIIIIIIIIIIJJDEEEKMMMGGGGMGHGOOHHHHGKAFFFF",
"FFFFAKMGGGGGMGHHHGMMKKJJJIIICIICICCCCCCCCBBBBBBBBBCBCBBCCBBBCCCCCCICCIIIIIIIIJJJJEEEEKMMGMGGGMGHGHOOHHHGMCPFFF",
"FFFNIMGGGHGGGGHOHGMKKEDJJIIIIIIICICCCCCBCBBBBBBBBBBCBCCBBBBCBCCBCCCICIIIIJIJJIJJDDEEKKMGMGGGGMGGGHHHOHHGGDPPFF",
"FFFPDMGMGHGGGGOOHGMKKDDJJJIJIIIICCCICCBCBBBBBBAABBBBBBBBCBBBBBBCCCCCCIIIIIJIJJJJDDEEKKMMGGGGMGMGGOHHHHHGGKCPFF",
"FFFPKMGGGHGMGHOHHGMKKDDJJJJJJIICIICCCCCCCBBABAAAABBABABBAABBCCBBBCCICIIIIJJJJJJJDDEEKKMMMGGGGMGHGGOHHHHHGMCAFF",
"FFFAKMGGGHGGGHOOHGKKDDDDJJJJJIIICCCCCCCCBBBBBAABABAAAABAAAABBCCCCCCICCIIIIJJJJDDJEEKEKMMGGGMGGGHGGHOOHGGGGEPFF",
"FFFCMMGGGHGGGOOOOMKEEDDDDJJJIIIICCCCCCCCCBBBBBBBBABABAABBABBCCCBCCCCICIIIIIJJDDDDEEEEKMMMGGGGGHHHGHHHHHHGGMBFF",
"FFFIMGGGGHGHGOOOOGKEEDDDDJJIIIIICIICICCBBCBBBBCCBBBABBABBBBBBBCCBCCCCCCIIJIJJDDEDEEKEKKMMGGMGGGHOGGHHHHHGGKIPF",
"FFFDMGGGHHGGHOOOHMEEEEDEDJJJIJIIIIIIIICCCCCICCCCCBBABBBCCBBCBBCBCCBCCCCIIJJJJJDEEEEEKKKMMGGMGGGHHHHHHOHGGGKCAF",
"FFFEMGGHHHHHOOOOHMEEEEEEJJJJDJIIIJDEEKKKEEEJJIIICBBBBCBCIIIIIICCICCCIIJIJJDEDJDEEEKEKKKMMGGGMGGHOHHHHHHHGGMCPF",
"FFFKMGHGHHHHOOOOHKDKEEDDDDEEKDDJIJDKKKKKMKEDJJJICCCCCCCCIIIJJDEEEDJJJIIIIJDEEDDDEEKKEKMKMGGMGGGHHHHHOOOHGGMJPF",
"FFFKMGGHHHOHOOOOHMEKDEDEDDEDJJIICIIJEKKEEEKDDJJIICCCIICIIJDDDEKKKKKKDJIJJDDEEDEEEEKKEKKMMGGGGGGHHOGOOOOHGGMKBF",
"FFFJGGGHHOHHOOOOGMEKDEDDDEEDIICICCIIDKKMMKKEEEJJICBBBCIJDEEEEEEEKEEDJIIIJDEEEEKEEEKKKKKKMMGGHGHOOOOHOOOOHGGMIF",
"FFFIMGGGOHHOOOOOGKKEDEJJEEDJIIJKMMMGGGGKKKKEEDJIICBCCCIJDEDDEEKMMMMKKEEJJIJJDEKKEEEKKKMKMMHHGHHOOOOOOOOHHGMKCF",
"FFFCMGGHHGHOOOHHGMEEEDJJJJJIJKGMKGMEIGKJKDEEDDDJICCBCIIJDEDDDKMKKEGMMGGGMKDJDDEEKEDKKKKKMGGHGOGOOOOOOOHOHGGKAF",
"FFFIMGGGHGOOOOHHGKEEEDDJJJIJMGMKCMMMMMKAIDDJDEDJIICCCIJDKKDDEKKKIIMKEGGMMGKKDDDEEDEKKKKMKMGGGOHOOOOOOOOOHGGEAF",
"FFFBGMGGHHHOOOHGGKEEDDJJJJDEMMKDIJMMKKKCJJECIDEDIICCIIDEKKDDDEKDACMKGMMKJGGMKJDDDDEEKKKKMGGHGOHOOOOOOOOOHGGEAF",
"FFFAMMGGHHHOOOOHGKEDDJJIIJDEKKEDJJJJJIJIJJICCJDDJICCIIDKKEIIJDDDJIEEDKKDDKMGKKDJDDDEEKKMMMGHHOHOOOOOOOOHHGMKAF",
"FFFPMGGGHGHOOOOGGKEDJIIIJJEDJDEDJJIICBCIIICCCJEDIICCIIEKKEIIIIIIIJJIDJDEKKMKKKEDDJIDEKMKKGHHOOOOOOOOOOOHHGGKAF",
"FFFPEMGGGGOOOOOGGKEDJIIIJDJIIJDDJIJIIIIIIIICIJEDIICCIJDKKDICCIIIIIIIJDDDEKEEEDEDJIJJDEKKMMHHHOOOOOOOOOOOGGGKPF",
"FFFFDMGGGHHOOOGHMKEDJICCCCICCIIIJJIJIICCBCIIIDDJIIICIJDEKEJIICCICIIJIIJJDDDJJJJJIIIJJEKKMMHHHHOOOOOOOOOOHGMKAF",
"FFFFCMGGGHHHOOGHGKEDJICBCCCCCCCCICICCBBBCCIIJEEJJIICIIDEKEDJICCCBBCCIIJJIJIIIIIICIIIJEKKMGGHHGOOOOOOOOHHHGGDAF",
"FFFFAMGGGHHHHOHHMKEDJICCCCCCCCCCCCBBBBBBCCIIDDEJIICIIJDEKEDDJICBCBBCCCICIIIIIJICCCIIJEKKMMHHHHOOOOOOOHHGGGGIFF",
"FFFFFDGGGGHHGOGHMKEDJICCICCCCBBBBBBBBACCCIIJJDDJIICIIJDEEKEDJCCCBBBBBCCCCCCCIIIICCCIDEKMMGGHHGOOOOOOHHGHGGKIFF",
"FFFFFCMGGGGHGHGHMKEDJICICCBCCCCBBBBBBCCCCIJJDDDJIIIIJDEEKEEDJIIIBBABABABCCCCICICICIJJEKMMMHOHHOOOOOOOHGGHGKIFF",
"FFFFFBKGMGHHGHHGGEDJJIICCCCBCBCBCBBCCCCCIIJJJDDDJIIJJDEKEEEDDICICCBBABBBBCCCCCCCCIIIDEKMMMHOHOOOOOOOOGGHGGKCFF",
"FFFFFFIMGGHGHHHHMEEDJIIICCCBCCCBBBCBCCCCIJJJDEDDJJIJDEEKEEDDDIIIICCCBBBBBBCCCCCCIIIJEKKMMGHOOOOOOOOOOHHHHMKBFF",
"FFFFFFACMGGHGHHGGEDDJJICCCBCBBBBCCBCCCCIIIIJDEDDDJIJDEKEEEDEDJICICCCBBBBBCBCCCCCIIIDEKMMMGGOOOOOOOHOHGHHHMKBFF",
"FFFFFFFFCMGGGGHGMKDDDIIICCCCCCBCCBCBCCCCIIJDEEDDJJIJJEKKKDDJJIICICCCCCBBBBCCCCCCIIJDEKKMMGHOOOOOOGGOOMOHGDIAFF",
"FFFFFFFFAEGGGHGGMKDDDDJICCCCCCICCCBCBCCCCIJDKEJJJIIJJEKKKEJJIIICCCCCCBBCBCCCICCIIJDDKKMMGGHOOOOOOGHOHMOHMICFFF",
"FFFFFFFFFIGGGGGHMKDDDEDIIICICICCCBBCBBCCCIJKEDJIIIIIJEKKKKDJIIICCCCCBCBCCCCCCIIIIJDEKKMMMGOOOOOOHHOOHGOGKCFFFF",
"FFFFFFFFFFMMGMMMMKDDDDJIICIIIIICBBBBBCABCIDEEJICICCIIDKKMKEJICBCCCCCBCCCCIIIIIIIJDEEKKMMGGGOOOOOHGGGGHHMCFFFFF",
"FFFFFFFFFFMMMDEEJEDDDJJIIIIIIICCCCBBBBBBIJEEEJICBAACJDKKMKKDICCBBCCBBBCCCIIJJIJJJDEKKKMMMGGHOOOHGGMMGHGJFFFFFF",
"FFFFFFFFFFKMJIJIJEDDDDJIIIJIIICCBCBBBACCIJEEEJIBBAPBIDKKKMKEDCCBBBBBCCCCIIIJDJJJJEKKKMKMMGGHOOOHGMGGOGDCFFFFFF",
"FFFFFFFFFIEEJIIIJEDDDDJJJIIIIICCCCBBBBCIIDDEEDICCCBCIDKKKKKEJICCBBBBCBCCIJJJDJJDDEEKKKMMMMGGGHGGMMGHGDFFFFFFFF",
"FFFFFFFFFJDDJICCIEEDDDJJJJJJIICCCBBBCCIIIEDDKEJJIIIIDKKEKKKEJJICBBBBBCCCIJJJDDDJEEKKKKMMMMGMGMMMKMGGEFFFFFFFFF",
"FFFFFFFFIDKKEIIIJEEDEDJDJJJJIIICCCBBIIJICDEDMMJJJIIJEKKEEKMDJJIICCBCBCCIIJJJDDEDEEEKKKMKMMGMMMEEEMGMFFFFFFFFFF",
"FFFFFFFJDDKGMIIIJJEEEDJDJJJJIICCCCCCIIJICJKKKMDJJJJJDMGKEKKIIIJICBBBBCCIJJJJJDEEKEKKKKMMKMMMMEDDJMMEFFFFFFFFFF",
"FFFFFFFFAIJKMKIJJJEEDDDJJIJJJIICCCCIJIICIIJKKKMJEEEDMGIMKMKIIIIICCBBCCCIIJJJDDEEEEEKMKMKMMMMKDJDKMKFFFFFFFFFFF",
"FFFFFFFFFFFCJEJIJJEEEDDJJJJJIIICCIIIIICIIIJJEKMKEKKKMKDKMKJIIICCICCCBCIIJJDDDDEEEKEKKMKMKMKDKDDEMKFFFFFFFFFFFF",
"FFFFFFFFFFFFCJJIJEKDEDDJJJJJJIIICIIIICCIIIJJEKKKMKMMMKKKEDDIIIICICCCCIIIJJDEDJDDEKKKMKMKMMEDKDKKGEFFFFFFFFFFFF",
"FFFFFFFFFFFFIDIJJDEEEEDJDJJJJIICIIIIICIIIIJJJEEEKEKKMKKEDDJIIICCICCCCCIIIJDEDDDEEEEKKMKMKMKDKKMGMDFFFFFFFFFFFF",
"FFFFFFFFFFCEEKJIIDKDEDDDJJJJIIIIIIIIIIIJJIJJJJJJEDEEDEEJDDJJIIIICICCCCIIIDDDDJDEKEKMKKMKMKGGGMMGKFFFFFFFFFFFFF",
"FFFFFFFFFPBEMKDJDEMDDEDJJJJJIIIIIIIIIIJIIIJIJJIJJDDJJJJJJDJJIIIIIIICCCCIIJDEDDDDEEEKMMKMMKOHHGMMFFFFFFFFFFFFFF",
"FFFFFFFFFFADMMKDEKKDEDDDJJJJIIIIIIIIIJIJIIIIJJCIIIIIIIJIJDJJJJIIIIICCCIIIJDEDDEEEEKKKKMKMMOHHHMKEFFFFJIFFFFFFF",
"FFFFFFFFFFFBKGMMMMMKDEDDJJDDIIIIIJJJJJIIIIIIIICCICIICIJIIIIIJIIIIIJIIIIIIJDEDDEDEKKKMKKMKMOOHGMMKMMMKKCFFFFFFF",
"FFFFFFFFFFFAIMMGGGGEJEDDDJJEJIJIIJJJIIIJJIJJEJICCICCCCJIIIJIIIIIIIJJIIIIIIDEEDEDEEKKKMKKMMOOGMMGGGGGGEBFFFFFFF",
"FFFFFFFFFFFFCKKMGGGKJDDDJJJDDJJIJJJJIJIJJDEEKEKDICIJDDDJJIIJIIIJIJJDJIIIIJDEEDDEEEKKKKMMKGOOHHGMGGGGMJFFFFFFFF",
"FFFFFFFFFFFFADMMMGGMIEEDDJJJIJIIJJJIIJJDKKKKKKKKEJEKEEKKEDDJIJIJIJJDJIIIJJDEEEEDEKEKKMKKEGOOOOHGGGGGMCFFFFFFFF",
"FFFFFFFFFFFFFCEMMMGMJEEEDJJJIJIIIJIIJDKMMMMMMMMKKKKMKMKMKMKEDJJIIIJDJJJIJDDEEDDDEEKKKKMMKGOOOOOHHHGKIFFFFFFFFF",
"FFFFFFFFFFFFFFIJDKMGJEEDDJJIJIIIIIJIDEKKKKKEEEKKMKKMKMMMMMMMKDDJIIJJJDJJJDDDEDDDEKKKKKKKMOOOOOOHGGMJBFFFFFFFFF",
"FFFFFFFFFFFFFFFCIEMGDDDEDJJJJJIIIIIIEEEEKKKEEEDDEEEEEEKKKKMMMMKEJIJJJDJJJJDEEEDDEKKKMKMKMOOOOOGMMKIBFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFJKMMDEEDDJIJJICIIIJDJDDEEEKEEDDDDEDDDEKKKKMMKMKEDIDJJJJJDDDEEDEEKKKKKMKGOOOGGMMMKFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFJKMEDDEDDJJJIIICIJJJJJDJDDDDDDJDDDDEKEKKKKEEEEEEDDJJJDJDDEEDEEEKKKKMKMHOOOOGHGGKFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFJKKDEDDJJJDIIIJIJJJJJJJJJIJIIIIIIIJDDEEDDDDDDDDDJIIJJJDDEDEDEEKKKKMKMOOHHGGGGMEFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFIJMDEEEDJJDJIIIIJJJJJJJIJJDDDKEDDDJIJJDDDJJJJDDDJIIJJDEEEDEEEKKKKMKKGHHHGGGMMMFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFCKEEDDDDJDJJIIIJJJJJJJJJDDDEKKKKKEEJDDJJDJJJEDJJIIJDDEEEDEEEKKKKKMKGGGGGGGGMJFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFJDEEDDDJDJJJIJJJJJJJDDJDDDEEEEEEEEEEDDJJJJDDDJIJJJDDEDEDEDKKKKMKMKMMMMMKMDIFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFIDEEDJJDDDJJIJJJDDDEDJJDDEEEEEEDDDEDDJJJJDDDJJIJDDEEEEEEEEKKKKMKMMMMKEEJIFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFJEDDDDJJJJJJIJJJDDDJJJJJDDDEEEDJJDJJJDDDDEDJJJJDDEEEEEEEKKKKMKKMMMMKKFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFIDEDDDDDJDJJJJJJDDDDJJIJJJJJJJJJJJJJJDDDDDDIJJJDEEEEEEEKKKKKMKMEKMMKKFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFIEEDDDDJJJJIJJJDDJJJJJIIIICIIIJIJJJJDDDJJJIJJDDEEEEDEKEKKKMKKKDDKKKFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFIDEEDDDDDJJIJJIDJJJJJJIIIIIIIIJIJDJJDDDDJDJJJDEEEEEEKEKKKMKEKMIJEEFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFIJEDDDDDDJDJJJJJJJJJJJJIIIIIJIIJJJDJDDEDJJJDDDEEEEEDEKKKMKKEKECIJFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFFCJEEDDDDDDDJJJJIJJJJJJIIICIJJIIJJJDJDDJJJDJDEEEEEEEDKKKKMEEKKCCIIFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFCBIEEDDEDEKDDJJDJJJDJJJCICCCIIIIJJDEJDJJJJJDDEEEEEEEEKKKMEDEKJBCIIFFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFFBCCEEEDEEEEEDDJDDJDDJJDICCCCICIIIJDEDDJDJJDDEEEEEEEEKEKMKDDKDACCCIIFFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFFFBABBIEKEDEEEEEEDDJDDDJJDJICCICIIIJDDEEDDJDEDEDEKKEKKKEKMKDJKJABCCCCIIFFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFFAAAABBBDKKEEEEEKEDDDDDEEEJDJIIIIIIIDDEEDDDDEEEDEEKEKEKEKMKEJEIABBCCCCICIFFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFFFAPPAAABACEKKEEEEEEEDDDDDEEJJDDDJJDDDDEEEEDEEEEEEEEEKKEEKKKDJECAABBBCCCCCCCFFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFFFNPPPPAAABAADEKKEEKEEEEEEEDEEEDDDEJDDDEEEKEEEEKEKKEEEKKEKKKKDJDIPABBBBCCCICCCCFFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFFFPNPPPPPPAAAAABDDEKEEEEKEEEEEEKKEEEEDEEEEEKKEEEEEKEKKKKKEKKKKDDECPAAABBBCCCCCCCCBFFFFFFFFFFFFFFF",
"FFFFFFFFFFFFFPNNPPNPPAPAAAAPPJJDEKEEEEKEEEEEDEKKEEDEEEKEEKEEEEEKKEKKKKEKEEJJDAPAAAABBBBCCCCCCCCBAFFFFFFFFFFFFF",
"FFFFFFFFFFFPNNPPNPPPPPPAAAAAPADJDDEEEEKKEKKEEKKKEEEEKEEEKEKEEKKEKKKEEEEEEDJIAPPAAABABBBCCCCCCBCCCCBAFFFFFFFFFF",
"FFFFFFFFNNPNPPNPPNPAPAPPPAAAPPAJJJDEEEKKKKKKKKEEKKKKKKKKEKKKKKKKKEKEEEEEJJIPPPAAAAAABBBBBCCCBBCCCCCCCBBFFFFFFF",
"FFFFFFNPNPNPPPPPNPPPPPPPPAAAPPPAJJJDDEEKKKKKKKKKKKKKKKKKKKKKKKKEKEEEEEEDIBPPPAAAAAAABBBCBCCCBBBCBCCBCCCCBPFFFF",
"FFFFPNPNPPNPNNPNPPAAPPPPPAAAAPPNBDIJJDEEEKKKKKMKMKMKMKKKKKKKKKKEEEDEEEDIANPPPAAPAAAAABBBBBCCBBBBCBCCCBCBCCAPFF",
"FFFPPPPPNPNPNPNPNPAPPPPPPAAAAAPPPBDJIDDEEKKKKKKMKMKKKKMKKKKKEEEEEEEEEJCPNPPAPAPAAAAABABBBBCBABBBCCBCBCCBCBBBAA",
"PPPPNPNPNNPNPNNPPPAAPPPPPAAAPAPPNPBDIJJDDEEKKKKKKKKKKKEKEKEEEEDEDDEEIPNPPAPPPPPPPAAABABBBBBBAABBBBBBCBBBABAAAP",
"PPPPPNPNPNNNPNPNAAPPPPNPPAAAPPPPPPNBDJJJJDDDEEEKEEEEEEEEDDDDDJDJJKEBNPPPPPPPPPPPPAAAAABBBBCAABABBBCBBBBBAAAPPP",
"PPPNPPNPNPNPNNPPPAPPPPPPAAAAAPPPPPNPCDJJJJJJJJDDDDDDDDJJJJJJJIJDKIPPNPPPPPPPPPPPPAAAABABABBAAAABBBBBBBAAAAPAPP",
"PNPPNPPPNPNPNPPPAPPPNNNPPAAAPPPPPPPNNBJDIJJJJJIJJJJJJIJIIIIIJJEDPNNPPPPPPNPNPPPPPPAAAABAABAAAAAABBBAAAAAAAAPPP",
"PPNPNPNPNPNPNPPAAPPNPPNNPAAAAPPPPNPPPNPJJJIIIIJIJIIIIIIIIIIJJJBNNNPPPNPNPNPNPNPPPPAPAAAABAPPPAPAPAAAPPPAPAPPPP",
"NPNPNPPNPNPNPPPAPPNPNNPPPAAAAPPNPPNPNPNPIDJIIIIIJIJIIIIIIIDEBNNNPPPNPNNPNNPNPPPPPPPPAPAAAPNPPPPPPPPPPPPAAPPPPP",
"PNPNNPNPPPNPNPPAPPPPPNPNPAPAAPPPNPNPPNNNPBIJIIIIIJIIIICIJJBPNNNPPPNPNNPNNPNPPPPPPPPPAPAAPNPPPNPNPPPPPPPPAPPPNP",
"NNNPNNPNPNPNPAPPPNPNPNPNPPAAPAPPPNPNNPNNNNPAJIJJJJJIIIJCBNNNNPNPNNNNPNNPNPPPNPPPPPPPPPPPPNNNNNNPNPPPPPPAAPPPPP",
"NPPNPNPNPNPPPPPPPPPPNPNPPPPAAAPPPPNPNNPNNNNNPCJDDEJDICANNNNNNNPNNNPNNNNPNPNPPPPPPPPPPPAPPNPPNPNPNPPPPPAAAPPPPP",
"NPNNPNNNPNPPPPPPNPNPNPNPPPPPAPAPPNPNPNNNNNNNPNPBIJBAPPNNNNNNNNNNPNNNPNPNPPPPPNPPNPNPPPANPNNNPNPNAPPPPPPAPPNPNP",
"PNNPNNPNNPNPNPPPPNPNPNPNPPPPPAAPPPNPNNPNNNNPCCNPPAPPAPNNNNNNNNPNNNNNNNNPNPNPNPPPPPPNPAPPNPNPNNNPPAPNPPPAPPPPPP",
"NNPNNPNNPNNPPPNPNPNPNNNNPNPPPPPAPPPNPNNNNPNDMJICCCBACANNNNNPNNNNNPNPNPNPNPPNPPNNNPNPAPPNNNNNNPNNPAAPPPPPPPPPPN",
"NPNNNNPNNPPNPPPPNPNPNNPNNPPNPPAPPPPPPNPNPNCMMGGGGGMKCIPNPNNNPNNPNNNNPNPNPNPPNPNPPNPPAPNNNNNNNNPNPPAAPPPAPPAPPP",
"NPNPNPNNPNPPPPNNPNPNNNNNPNPPPPPPPPPNPNPNNPMGGGGGGGGGMMBNNNPNNNNNNPNPNPNPPNPNPNNNNPPAPNNPNNPNPNNNPPAPAPNAPPPPNP",
"NNPNNNNPNPPPNPNPNPNNPNPNNPNPNPPPPPPPPPNPPKGGGMGGGMGMMKENNPNPNPNPNPNNPNPNPNPNPNPNPNAPPPNNNNNNNNPNPPAAAPPPNPNPPP",
};

/* XPM */
static char *lf1_16gray[] = {
/* width height ncolors chars_per_pixel */
"110 150 16 1",
/* colors */
"  c #A5A5A5",
". c #9B9B9B",
"X c #8F8F8F",
"o c #6D6D6D",
"O c #656565",
"+ c #F2F2F2",
"@ c #232323",
"# c #151515",
"$ c #828282",
"% c #767676",
"& c #585858",
"* c #F5F5F5",
"= c #424242",
"- c #CDCDCD",
"; c #0C0C0C",
": c #B3B3B3",
/* pixels */
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++++++++--:  ...  :---+++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++++---:oO&&&&====&=Oo%$$$X-+-:X---+++++++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++*-::$oO&===@@@@=@@@=@@=&&&O  XXOOO%X.--+++++++++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++-..$&==@@@@@@###@@;#@@=@=@=o$%%=&=%%o%$X--++++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++*-:..O==@@@@@###;;;#####@@@=@@@&o&====&&&$$%X:-++++++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++--:X==@@@=@@@#;;;;;;;;;@@;@@@@@@=&=@====&&=&OOo -++++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++: .o==@@@@@@@@;;;;;;;;;;##;@@##@@#==@@@=@===&&&%$.-+++++++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++: $O==@@=#;##;##;;;;;;##;#;#;#@#@@;#@#@@@@====&%$%%X:++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++:.X%==@@###;;;;###;;;;;;##@;####;;;#;;#=@=@@@=@&&==&O%$--+++++++++++++++++++++++++++++",
"+++++++++++++++++++++++:.Xo&@@@@@@###@@@@##;;;;;;;#;#;@;;;;;;;#@@@@==@=@=@===&%$:-*+++++++++++++++++++++++++++",
"++++++++++++++++++++++-:.%=@=@@#@@@@@@@@@##;;;;;##;;;;;;;;;;;;;;#@@@@@@@=@=@==O$X -+++++++++++++++++++++++++++",
"+++++++++++++++++++++--.o=@=@@@@@@@@@@###;@#;;;;;;;;;;;;;;;;;;;####@@#@@@@@@@==&o$:-*+++++++++++++++++++++++++",
"++++++++++++++++++++*-XO==@@@=@@@@#;#;#;##@#;;;;;;;;;;;;;;;;;;###;#@##@@@@@@@@@==oX$++++++++++++++++++++++++++",
"+++++++++++++++++++++:o=@@@@@@@@#####@@@#@@;;;;;;;;;;;;;;;;;;;;;;;#@@@@@@@=@@@@@==o$:+++++++++++++++++++++++++",
"++++++++++++++++++++-$%@==@@@@###@@@@@@@@@@;;;;;;;;;;;;;;;;;;;;;;#;;#;@@@@@@@@@@@@=O%-++++++++++++++++++++++++",
"+++++++++++++++++++-:$===@@@@@####@@@=@=@##;;;;;;;;;;;;;;;;;;;;;;;;;;;;@@@@@=@#@@@==&.++++++++++++++++++++++++",
"+++++++++++++++++*-:X==@@@@@@@@@@@#@@@@@@##;;;;;;;;;;;;;;;;#;;;;;;;#;#@@@@=@@@@;##@==O:+++++++++++++++++++++++",
"++++++++++++++++++-%==@@@@@@@@@@#@@@@@=@@#;#;;;;;;;;;;;;;#@@@;;;;;;;;;##@@=@=@=@###===X-++++++++++++++++++++++",
"++++++++++++++- -.&==@@=@@@@##@#;;;#@@@@@#;;#;;;;;;;;;;;;@@=#;;;;;;;;;##@##@@@#=@@@@=&& -+++++++++++++++++++++",
"+++++++++++++-.X.X==@@@@@##@#@###;;#;####;;;@@;;;;;;;;;;;#@@@##;;;;;;;##@;;#@@@@@@@@@==%:-*+++++++++++++++++++",
"+++++++++++++..:X&=@@@@##@#####@@#;;;@@@;#;;##;;;;;;;;##@@@=@@@@;;;;@#;#@#;;@@;@@@@@@@@&.--+++++++++++++++++++",
"++++++++++++:$.o==@@@@@#####;#@@@##;##@@##@;##;;;;;;;##@=&=@===@@#;;;#;;@@#;;@#;@@##@#@@&%:+++++++++++++++++++",
"+++++++++++-O&&=@@@##@##;#;;##@@#@@###@#@#@@;;;;;;;;#@@==&&=&O&==@#@#@@@@@@#;@#;##@###@@==o:++++++++++++++++++",
"+++++++++++$&==@@@@#;##;;;;;;@#@@@@#@@@@@@@@###;;;#@@@=OO&&Oo%O===@@@@@@@@@@#;####@###@#@==X-*++++++++++++++++",
"++++++++++-%==@@@@##;#;;;;;;##@@@@@@@@@@@@@#@@@##@@===&ooO%%%ooOO===@@@@@=@##;#@;;#@####;==O:+++++++++++++++++",
"+++++++++-:&==@@##@#;;;;;;;###@@@@@@@@@=@=@@#@@@@=&&&=O%%%%%%o%oOO&=@@@@@@@@###;#;;##;;#@@==%-++++++++++++++++",
"++++++++*-O==@@##;##;;;;;;;;;#@@@@=@@=@@=@@@@@===OO&o%%$$$$$%%$%%O=&==@=@@@@@##;;;;;;###@@=OX:++++++++++++++++",
"++++++++-%==@@###;;#;;;;;;;;;#@@@==@=========&==&%%$$$$$$X$$$$$$$o&O&=@@=@@#@#@#;#;;;###@@@=%.-+++++++++++++++",
"++++++++ &=@@#@;;;;;;;;;;;;;;@@@@@@====&==&&OOOo%$XXXXXX$$XXXX$$$o&O&==@=@##;@###;;;;;;#@@@=OX-+++++++++++++++",
"+++++++-%=@@@@#;;;;;;;;;;;;;;@@=@=@=&&&&&OOo%$$$X....X..XXXXXXX$$%Ooo&=@=@@######;;;;#;###@@&.X-++++++++++++++",
"+++++++-&==@@#;;;;;;;;;;;;;;@@@@=@=&OOOo$$$$$$X$.. . ... ..XXXXX$%o%%O===@######;@#;;#####@@=$X:++++++++++++++",
"+++++++O=@@@@#;;;;;;;;;;;;;#@@@===&Oo%$$$XXXXXX..        ....XXX$%%%%%&=@=@####;##@#@##;;##===.:++++++++++++++",
"++++++-&=@@@@#;;;;;;;;;;;;;@@@=@==O%$$$XXX....X         .. ...XX$%%%$$o&==@@##;##@###;;;;;;@@=%:-+++++++++++++",
"++++++.=@@@@##;;;;;;;;##;;##@@@==&%%$XX..  . .   :::::     ...XX$$%$$%$O==@=@@###@@;;;;;;;;@@@=$:+++++++++++++",
"++++++&=@@@@#;;;;;;;;######@@@@=&O%$X...    ..         :  . ..XX$$$$$$%oO==@@@@@@@##;;;;;####@=$:--+++++++++++",
"+++++.=@@@@###;;;;;;#####@@@@@==&%$$.X.    ..   :  :   ::   ...X%$$$$$$%o&==@@@@@@@@#####;#;;#@%-***++++++++++",
"+++++&==@@#@#@#;;;;##@##@@@@@==&O%$XX.. . ...     :       .   .XoX$$$%$$%&&===@@@@@#####@#;;;;#= +*+++++++++++",
"++++:=@@@##@@@@;;###@@#@@=@====o%$$$X......     :           ...Xo$$$$%$%%o&&==@@@@@@@;####;;;;#@=.-*++++++++++",
"++++&=@@####@##@@@@@@@@==@@@==O%$$$X$.X...             .  .  .XXo$X$$$$$%%o&&&===@=@@##@#@#;#;#@=&:+++++++++++",
"+++:=@@######@@@@==@==@==@===&o%$XXXXX......      .    .    ..XX%$$$$%$%$%%o&&=&==@@@#;@@@@#;;;;==:-*+++++++++",
"+++%@@#@####@@@@========@@===%%$XXXX..X.X...   ....... ..   ..XX%$%%$%$$%$%oo&&&====@@;@@@@=;;;;#@%+++++++++++",
"+++O@@#@@;;@@@@@@==========&&%$$XXXXXX.X.. .  . .. .. ..  ...XXX%%$%$%$$%%$%oOO&&&===@@@==@=@;;;#@=$++++++++++",
"++:=@#@@#;;@@@@@@====&&oo&&OO%$XXXXXXXXX... .. ..  .... .. ..XXX$%$%$%$%$%%%%oOO&&&===@#==@@@@;##@@=.-++++++++",
"++.=#@@@#;#=@@@@===&&OOoOOooo%$XXXXXXXXXX..XX... .... ..  ..XXX$$$$%%%$$%%$%oooO&&&==@=#@&=@@##;##@%.-*+++++++",
"++%@@@@#;;@@@#@@@@==&OOoOo$%%$$XXX$$XXXXXXXXXX............ .XXXX$$$%%%%%$%$$%%oO&&====@@@==@@#@##@@&.+++++++++",
"++%@@@@#;;@@@@@@@@==&Oo%o$%%$$$XXX$XXXXXXXX.X............ ..XXX$$$$$%$%$%$%$%%ooO&&===@@@=@=@;;#@;#=$+++++++++",
"++&=@@#;;;@@@#;@@==&&o%%%$%$$$$$X$$$X$XXXX.......X.XXX..X...XXXXX$$$$%$%%$%%%%oO&&&=@=@#@=@@@#;####@&-++++++++",
"++==@@@###@@#;;@@==&&O%%%%%$$%$$$XX$XXXXX..........X.XXX....XXXXX$$$$$$$%$%%%%oOO&&&=@@@@@@==##@#@#@& ++++++++",
"++==@@@;#@@#;;;@@=&&Ooo%$o%%$%$X$X$XXXX.X....    ......X.....X..XXX$$$%$%$%%%%oOO&&===@@@@@@@@;#@#@@=%-+++++++",
"++==@@#;##@#;;;@==&&Ooo%oo%%%$$$$XX$XX....  .   .  ..... ...X.XXX$$$X$$%$%%%%o%OO&&==@@#@@@@@@###@#@@&-+++++++",
"++==@##;;##;;;;@@=&OOoOOo%%%%%$$X$$XXXXX....      . .... ....XXXX$$$$$$$%%o%oo%o&&O==@@#@@###@@;;#@@@=X+++++++",
"++@@@######@;;;#=&&OOooooooo%%$$$XXX$XXX.....  .   ........X.XXXXX$$X$$$%%oooOoo&&&&==@#@@@##;@#;###@=X-++++++",
"+*=@@##;;###;;;;=&&OOooooo%%$%%$$$$X$XX.......X... ... X......XXX$X$$X$$$%%ooOOOOO&&==@##@@##;;;###@@&X-++++++",
"++=@@#;;#@@#;;;#=&OOOoOOoo%%%%$$$$$%$$XXXXXXXXXX.......XXXXX.X..XXXXX$$$%o%ooOOO&&&&==@#;@@##;;#;###@=X-*+++++",
"++@@##;;###;;;;@=O&OOOOOoooo%%$%$%OO&&&OOOo%$X$X...X...X$X$$$$$%%$$$$$$$%OOOoO&OO&&&==@;;@@;;;;;;;###=:-*+++++",
"++@@#@;#;##;;;;@&O&OOOOOooOO&Oo%%oO&&=&=&&Oo%%$$X.XXXXX$$%%%o&&=&OoOo%%%%oO&OOO&&&O&==@#;@#;;;;#;;;##=.**+++++",
"+*@@@##;;;;;;;;@&&OOOoOOoOOOoo%$X$$oOOOOOOOoo%$$$$XX$$$$%%o%o&&&&&&&O%%O&&O&O&&&&&&&==@;;@;;;;;;#;;;#=$+++++++",
"++@@##;;;#;;;;;@&&&OOOoOO&&O%$XXXXXX$%OOOOOOoo%$$XXXX$$oOOOOOOOOOOo%$XX$%&&O&&&&&&&=&==;;;;;;;;;;;#;#@$+++++++",
"++=@@##;;#;;;;#@=O&OooOO&Oo%$$$$$$%oO&&&&OoOOo%$XX..XX%oOOOOoOOOOo$XXXX$$%OO&&&&&&&&==@#;;;;;;;;;#;;#=$+++++++",
"++=@@#;;###;;;#@&&OOoOoOOo%$%%O&====@@===&OoOoo%$X.XX$%o&&OoO&=&=====&&O%%ooO&&&O&&&===;;;;;;;;;;;##;=.+++++++",
"++=@##;;;#@;;;@@=&OOOoooo%%%&=@@=@@&=@=O&&OOOOOo$XXXX$%O&&OO&=&&==@=##@@=&OOoO&&&&&=&=@#;;;;;;;;;;###= +++++++",
"++@@@##;###;;;;@&OOOOooo%%O&=@=&%=@@==$.&&%$ooOo%$XXX%O&=&OOO&& $=@@@=O=@@=&oOOOO&&&===@;;;;;;;;;;#@@=:+++++++",
"+*=@@##;##;;;;#=&OOOo%%%oo&===&OO&&&&&o%O&OX$oOO%$XXX%O=&O%%&&o$$=&===$O@@==&OOOOO&&&=@#;;;;;;;;;;#@=&-+++++++",
"++=@@##;;##;;;#@&&Ooo$$%%OOO&&&OOO%o$%%%%$$XX%OO%$XX$%O=&%$$o%%ooooOOOO&==@&&&Oo%o&&===##;;;;;;;;#;@@%-+++++++",
"+*&@@@@;###;;##=&OOoo$$%oO%%%oo%%%$$$$$%%$XXXoOO$$XX$%o=&%X$X$%%$$$OoOO&&&O&OOo%%oO&&=@##;;;;;;;;##@=$*+++++++",
"++%=@@#####;;##==OOo%$X$$%$$$$%%%%%%$%$$$$$X$OOo$$$X$%O&&O$$$$$$$$$%%%ooOo%%%o%$$%o&=&=;;;;;;;;;;#@@=.++++++++",
"+* &=@@####;#;#=&&Oo%XXX$$X$XXX$$$$$$XX.XX$$oOOo$$$$$%O&&&o%$XXX.$$%$%%%%$%$%$$X$%o&&==#;;;;;;;;##@=&-++++++++",
"+++X==@###@;;#@==&Oo$XXXXXXXXXXXXXX.....XX$$OoOo%$$$$%O&&&O%%XXXXXXX$$$$$$$$$$X$$$o&&==#;;;;;;;;#@#=X+++++++++",
"+++-&=@@###;;##==&Oo$$$XX$XXXXXXX... ...$$$%oOOo%$X$$%O&&&&o%$X..XXXXXXX$X$%$$$XX$o&===##;;;;;;#@@@X-+++++++++",
"++++.=@@#@@;##@@&&Oo%$XX$XXXXXX..X.XXXXX$$%oooOo$$$$%oO&&&&o%$$X......XXXX$$$$XX$$o&&==#;;;;;;#;@@o-**++++++++",
"+++++$=@@@####@==&Oo$X$$XXXXXX.XXXXXXXXX$$%%ooOOo%$%oO&&&&OOo$$$XX......XXX$$X$X$%o&===#;;;;;;#;#=.*++++++++++",
"++++++O@@@@####=&&O%%$$XX.XXXX.XXXXXXXX$$%o%oOOOOo$%OO&&&&OOo%$$$XXX.X..XXXXXX$X$%O&==@@;;;;;;#;@o++++++++++++",
"+++++++=@=@@##@=&&O%%$$XXXXXXX..XX.XX$XX$%%%OOOOoo$%o&&=&&OOOo$$$$XXX....XXXXXX$$%O&==@#;;;;#;##=+++++++++++++",
"+++++++o@@@@#@@==&Ooo%$$XX$X.XXX.X.XXXX$X$%o&&OOoo%%oO&=&&OOo%$$$X$XXX.XXX.XXXX$%oO&===@;;;;##;@&+++++++++++++",
"+++++++ ==@@@@@=&&&ooo$X$X$XX$XX.....XXXX$oO&&Oo%%$%o&&&=&Oo%%$$$XXX.X.XXXXXXX$%%O&&==@#;;;;#;;=++++++++++++++",
"+++++++:&====@==&&OOOo%$$$$$$XXX.....X.XX$O&&&o%%$$$%O&==&&o%$$XX$X.X..XXXX$X$$%oO&&==@#;;;;;#@&++++++++++++++",
"+++++*-X&=&&===&&&OOo%%$$$$$$XX... ... .X%O&&O%$$$X$$oO===&o$XXXXXX..X.XX$$$$$$%O&&&==@;;;;##=o+++++++++++++++",
"++++++*+o=ooo%o&&&&Oo%%$$%$$$XX....  ..X$OOO&O%$. :.$oO====&o$X.XX.....X$$$%%$%oO&&===@;;#@==&++++++++++++++++",
"++++++++*&%%$$%&&&&Ooo%$$$%$$XXX..   X$$%oOO&&%XX.: $%O=&==&o$XX.....XXX$$$%o%%O&&&===@;;=&=&%++++++++++++++++",
"++++++++.X$$$$$O=&&Ooo%%%%%$$XX... .XX$%%oooOOo$$XXX$o&&=&&&o%$XX....XXX$%%%%ooOO&====@@@&ooO%*+ +++++++++++++",
"++++++++++$$$$$&&&&OOoo%%%%$$XXXX.XX%oo%$OOo&&Oo%$$$oO=&&&=&%oo$X....XX$$%%%ooOO&&&====#@&$oOo++X+++++++++++++",
"++++++++++%%$%o%&&&&Ooo%%o%%$X$XXX$$oo%$$O&&=@Oooo$%O&@=O&=O$%o%$X...XX$%%$%%OOO&&====@@=O%o&%+$$+++++++++++++",
"++++++++++$%%%%X&&&&OOooo%%$$$XX$$$oo%$$$%&&&o=ooOOOO===&==O%$%$$X..XXX$%%%%oO&O&&&====@=OoOO$o=$+++++++++++++",
"++++++++++oOoo$$O&&&Ooooo%o%$$$$$%oo$$$$$%o&&O==oO&&&@&O===%$%$$$XXX.X$$$oooooOO&&=======Oo&==@&*+++++++++++++",
"++++*--:.O==&O%O=&&&OOooo%%%$$$$%o%$$X$$%o$%O&&=&&=&@=&&=&o%%$$$$$XXXX$$%%oOooOO&&====@&&OO@@@=$:+++++++++++++",
"++++-:$o&&=@@=@@@O&&&ooooo%$%$$oo%$$X$$%$%%%oOOO=====&&&Ooo%$$$X$$XXXX$$%%ooooOO&&=====O&&@@@==OX-*+++++++++++",
"++++-...=&==@@#;@&&&OOoo%%%%$$oo%$$$$%%$%$%%%oOoOOO&OOOooOo%%$$$$$$$X$X$%ooOOoO&&&=====@@#;@@@=&:**+++++++++++",
"++++-++ &=@=@@@#@&&&OOoooo%$%%%%$%$$$%%%$%$%%%%%OoOo%OOo%%o%%$$$$$$$X$$$%%OOooO&&&====@;;;#@@== -*++++++++++++",
"++++++++X======@@=O&OOoo%o%$%%$%$%$$%%%$%$$$%$$$$$$$$%%%%%o%%%%$$$%$X$$$$%oOOO&o&&===&@;;;#@=& ***++++++++++++",
"+++++++++$=====@@=O&&ooo%%O%%$$%%$%$%%%%$%$$$$XX$$$$X$%%$%%$%%$%%$%%%$$$%%oOoO&O&=====@#@@&&Oo:*++++++++++++++",
"+++++++++$@@@@@@#@O&OOOo%$OOo$$$%%$$%%%%%%%oO%$X$$XXX$$$$$$$%$%%$%%o%%$$$%OOOOO&&&&===#=&=&O=.++++++++++++++++",
"+++++++++:O=@@@@#@o&OOOoo%$%%$$%%$%%O&&&&&&&&O&O%X%ooooo%%%%%%%%%$%oo%$%$ooOOO&O&=====@@====o+++++++++++++++++",
"+++++++++++$&=@@@@&O&OOo%$$$$$X$$$%o&===@=====&&Oo&&O&&&&&&O%%%%%%ooo%%$$oOOOOOO&&&===@@===O +++++++++++++++++",
"++++++++++-$&@=@@@=O&OOo%%$$%$$$%$$oOOO&&=&&&&=&&&&=&========OOo$$%ooOo%%ooOOOOO&&===@#@@==X++++++++++++++++++",
"++++++++++- O===@@=o&OOo%%$$o$XX$$%%%%oO&&&&oOOO&&&O&&&&=====@==o%%ooOo%$%OOOOOO&===&@;@==$-++++++++++++++++++",
"++++++++++*+-.O==@=O&OOOo%$$%%XX$$$%%%oOOOOOOO%%oo%oooO&&=====&=&o%%oooo%ooOOOOO=&=&=@@==%:+++++++++++++++++++",
"++++++++++++++:$O==&&OOOo%%$%%$XX$%%%%%oooooooo%%%%%%oO&&&&&&&OO&Oo%oo%o%ooo&O&&&====@==O *+++++++++++++++++++",
"++++++++++++++++X&=&&&OOo%%$%%$X$$%%%%%%%%%o%%$$$$$$%%o&&&&&OOOOo%o%%$o%oOOOO&O&&=====&&*+++++++++++++++++++++",
"+++++++++++++++++%==&OOOOo%$%%$$$$%%%%%%%%%%%%%%%%$$%%%%ooOOoOOooo%%$$%oOOOOOOO&&&===+++++++++++++++++++++++++",
"+++++++++++++++++ &=&&&Ooo%%%o%$%$%%o%%%%o%%%ooO&&O&OOoooOooOoooOoo%$%%oOOOOO&&&==&=&*++++++++++++++++++++++++",
"++++++++++++++++*-$&&&&OOo%%%o%%%%%%o%%%%%oooooOO&&O&OOOOOOoooooOO%%%%oooOOOOO&&&==@=+++++++++++++++++++++++++",
"+++++++++++++++++*:$&&&&OOo%%%%%$%%%%%%oo%%%o%oOOOOOOOoOOOOooOOoOO%%%%oOOO&O&&&====@=o *++++++++++++++++++++++",
"++++++++++++++++++++$O&O&OO%%%%%%%%%%%%o%oo%%oooOooOOooooOoOoOoOOOo%%%oo&&OOO&&&=====%:+++++++++++++++++++++++",
"+++++++++++++++++++++O&&&OO%o%o%%%%%%%%%%%oo%%ooooooooooooooOOOOOo%%oooOO&O&O&&======X++++++++++++++++++++++++",
"+++++++++++++++++++++%&&&&Ooooo%%%$%%o%%o%o%ooo%%%%%o%%ooOOoOOOoOo%oooOO&&O&&&======O+++++++++++++++++++++++++",
"++++++++++++++++++++$%o&&&OOoooo%%%%%%%o%%%o%o%%%$%%%%%ooOOoOOOOoooooOOO&OO&&&====&o++++++++++++++++++++++++++",
"++++++++++++++++++++X%oO&&OOooooO%o%$%%%%%%oooo$%%%%%%%oOOOOOOOOOooooOOO&O&&=&====O+++++++++++++++++++++++++++",
"+++++++++++++++++++X XOoO&&Ooooooooo%%%%%%oOoo%$$$$%o%%ooOOOOOoooooOOOO&OO&&&=====&:++++++++++++++++++++++++++",
"+++++++++++++++++++  Xooo&&OOOoOoOOoo%%o%ooO%o%$$$$$%$%%oO&OoOooooOOOO&O&O&=====&==::+++++++++++++++++++++++++",
"+++++++++++++++++++: oOo%o&&OOOOOOOooo%oooOO%o%$$$$$%%%%oO&OOoooooOO&&&O&&&&===&&=oX-:++++++++++++++++++++++++",
"++++++++++++++++++*-.O%o%%&&&OOOOoOOOo%o%ooOoo%$$$$%$%%ooO&OoooOOO&O&&&&&&&@==&&&&&X.:++++++++++++++++++++++++",
"++++++++++++++++++---$O%%%o&&&O&OOO&Oooo%oOOO%%%%$%%%o%oO&OOOOOO&&O&&&&&=&=@=&&&&&=$ ::+++++++++++++++++++++++",
"+++++++++++++++++-- :%&%%%%o&&&OO&OOOOoooooo&OoooOoooOOOO&&OoOO&&O&&&&&&===&&OOOO&=$:.::-+++++++++++++++++++++",
"+++++++++++++++----  %&$%$%%O&&&&&&OO&OOOOOOO&OOOOOOOO&&&&&OO&&&&&&&&=&====&OoOOO&@$:.X --++++++++++++++++++++",
"++++++++++++++++:::. %&$%$$$%oO&&&&&&O&OOOOOO&&&&OOO&O&&&&&OOO&&&&=&&=====OoooOOO&@X:.X..--+++++++++++++++++++",
"++++++++++++++-:-:-. o&$$$$$$%oO&&&&&O&OOOO&O&&&&O&O&&O&&&&&&&&&&=&=====&Ooo%oooO==::X..  --*+++++++++++++++++",
"+++++++++++++-+-::: $=&$$$$$X$%OO&&&&&&&&O&&&O&&&&&&&&&&&&&&&&&==&===&=&Oo%%o%%oO==: X    .---++++++++++++++++",
"+++++++++++-:--:::-:&=&%$$XX$$$%oO&&&&&&&&&O&&OO&&&&&&O&&&&&&==&==&&==&O%%%%%%%OO=&: X.::  ...--*+++++++++++++",
"+++++++++- -::-:-::-&&=%$$X$XX$$%oO&&&&&&&&&&&O&&&&&&&&&&&===&==&=&==&O%%$%$$%%o&=X .X  : :....:--++++++++++++",
"+++++--  :::::--:::-o==%$$XXXXX$$%oO&&&&&&&&&&&&&&&&&&=&=&==&=&=&===&&%$$$$$$%%o&&: ..  : : X. ..:--++++++++++",
"+++-::::::-:-:---::-$&=o$$XXXXXX$%%OOO&&&&&&&&&&&&&&&&&&=&=&&=&=&=&&Oo%$%$$$$%%o=.: .. : ::  .. . X.:-++++++++",
"-: :::-:-:::::---::-.==o$$XXXXXXX%$%oOoO&&&O&O&&&&&&&&&&&&&&=&&=&&&&%%$$$$$%%$%O$::... : ::        ...:--*++++",
"-::::::-::::-----: ::&=O$$$XXXXXX$$%%oooOOO&O&O&O&OO&&&&&&&&&&&&=&Oo%$$$$$$$%%o%:: .. : :::     :::..  .---+++",
"+:-::-:-::-:-:----::-&=o%XXXXXXXXX$$%oo%%o%oooooooooOOoOoOOOO&&&OO%%$$$XX$%$%$o -:..   :::::     :::..:::  --+",
"-:::::-:-:::--:--:::-$=O$$XXXXX.XXX$%%o%%%%$$$%%$%%%%%%%%%ooOOOOOo%$$XX$$$$$$%X-: ..  :::::     ::-:   ::::  -",
"+:-::-:---:---:---::-:&&$X$XXXX..XXX$$%%%%$%$$$$$$$%$%$%%%ooOO&Oo%$%$XX$$$$$%$:::..   :::::: :: :::-   :::   -",
"-::::::::-:-:-----:::-X&%XXXXXXXX.XXX$$$%$$$$XX$X$$$$$%$%%oOOOOo%$$XXXX$$$$$$ -: .   :::::: ::  ::-:: .:::::.-",
"+::-:-:----::-:---:::--oOXX$XXXX..XX$$$%$%$XX$$XXX$$$$$%%oooOOo%%$$XXX$$X$$$.-:      :::::::::: :::--:  :-:: -",
"-:::::::---::-----::::-:O$XXXXXXX...XX$$$$$$XX$X$$X$$$$$%%ooooo$$XXXX$XX$$X -:    : ::-:::::::: ::::::  ::-: -",
"+:::::-:-----::---::::--.%XXXX.X.X..XXXXXX$$X$X$$$$$$$%%%%oo%o%$XXXXX$X$X$ -::  :  ::-::::::--:::-----: :-:-:-",
"+:::-:::-:--:-:----::-:--.%X..X..XX..XXXX$X$$XX$$$X$$$$%%%%%o%$XXXXXXXXXX --:   :::::-:::::::-: ::----: ::--:-",
"-:-::-:-:--:-:-----::::---.$X...X....XXXXXXX$X$$$X$X$%%%%%%%%$XX.X.XXX$X:-::: ::::::-::::::--:::::----:: :-:-+",
"+::-::----:---------:::::--.XX.........XXXXX$X$X$X$$$$$%$%$$$$XX.X.XXX :-::  ::::::::-::: ::--: :::----::::---",
"--::-:-:-:::-:-:----::-:-:--:.X.... . ..XXX.XXXX$$$$$$$$$$$$XXX....XX:--::  ::::-:---::::::----:::-----:::---+",
"+-:::-:------:-------:::-:---- ..     ....XXXXXX$X$$$$$$$$XXXX..... :-::    :::-::--:-:::-:-----::------: ---+",
"-:-:::-:-:----:------:::----:--: ..    ....X..XXXXXX$XXXXXXX..... :--::  :::-:----::---::::----:::-----::::--+",
"+-:-:-:---:::----:----::::---::--:       ....X...XX.XXXX..... .  --::   :::-:---:-::-:::-:------: ------::---+",
"+::------:-:-::--------:::----::---:        ......... . ... . ::-:::  ::---:-:---::-:::::-------:::------::--+",
"+:-::--:---:-:-:---------:-----:::----::   .    ...   .    ::--::   :--:---------::-::---:----:--::------:---+"
};
/* XPM */
static char *lf_256[] = {
/* width height num_colors chars_per_pixel */
"110 150 249 2",
/* colors */
".. c #c39063",
".# c #433224",
".a c #a67f4d",
".b c #885729",
".c c #8e4b2f",
".d c #9b6a35",
".e c #c59b72",
".f c #968b68",
".g c #24170c",
".h c #573d1d",
".i c #856433",
".j c #8ca4aa",
".k c #051715",
".l c #6c5e42",
".m c #a8cacc",
".n c #946c45",
".o c #87664c",
".p c #292114",
".q c #bed6d1",
".r c #020c08",
".s c #865220",
".t c #8d4b1d",
".u c #b4794d",
".v c #a06b36",
".w c #0b110a",
".x c #c08b5c",
".y c #856543",
".z c #89571c",
".A c #a2734f",
".B c #8d5937",
".C c #adcdcd",
".D c #a06a43",
".E c #0d170f",
".F c #845f2e",
".G c #d1875c",
".H c #8e5d24",
".I c #99afb6",
".J c #869ba0",
".K c #cb8156",
".L c #22312a",
".M c #a4bbc4",
".N c #9a5d33",
".O c #433c30",
".P c #acd3cf",
".Q c #845c3b",
".R c #a2713e",
".S c #6b5940",
".T c #be7349",
".U c #cfebe4",
".V c #544430",
".W c #0e0c09",
".X c #99906d",
".Y c #b96b44",
".Z c #ac7641",
".0 c #877858",
".1 c #2a170a",
".2 c #8c6232",
".3 c #362919",
".4 c #0b1b13",
".5 c #d18e58",
".6 c #040f0c",
".7 c #38463f",
".8 c #7c6743",
".9 c #d19365",
"#. c #9ebbc4",
"## c #6e746a",
"#a c #050203",
"#b c #7a5d41",
"#c c #a67f5f",
"#d c #5e726e",
"#e c #42260a",
"#f c #835936",
"#g c #7d583a",
"#h c #bb794c",
"#i c #0b140c",
"#j c #987e5b",
"#k c #834215",
"#l c #7a704e",
"#m c #321e0e",
"#n c #79572c",
"#o c #8d5e39",
"#p c #292726",
"#q c #1d160d",
"#r c #cb9162",
"#s c #333933",
"#t c #a39376",
"#u c #28261b",
"#v c #94562c",
"#w c #7d5d33",
"#x c #5b4a2c",
"#y c #7b4a10",
"#z c #18201f",
"#A c #291d12",
"#B c #b37347",
"#C c #68431b",
"#D c #96aab5",
"#E c #201c13",
"#F c #010e05",
"#G c #ae6b42",
"#H c #524b44",
"#I c #a27440",
"#J c #515f5a",
"#K c #8c6b48",
"#L c #846c4a",
"#M c #a88f6a",
"#N c #021409",
"#O c #5f5540",
"#P c #887651",
"#Q c #615e4f",
"#R c #472004",
"#S c #6e481d",
"#T c #b7dbd8",
"#U c #76431b",
"#V c #ac5c39",
"#W c #2f302b",
"#X c #6a533a",
"#Y c #a15b38",
"#Z c #2e2c2a",
"#0 c #684d38",
"#1 c #a99a7b",
"#2 c #95724d",
"#3 c #5d4c37",
"#4 c #21201d",
"#5 c #54350d",
"#6 c #9d6537",
"#7 c #7c3d10",
"#8 c #ab7348",
"#9 c #7a4e2f",
"a. c #171c13",
"a# c #8a8a70",
"aa c #010704",
"ab c #422b0f",
"ac c #c47950",
"ad c #291107",
"ae c #c5dfd8",
"af c #513721",
"ag c #2f261a",
"ah c #b1c8cb",
"ai c #a36540",
"aj c #43453e",
"ak c #7e572c",
"al c #abbec5",
"am c #8a6b3b",
"an c #9c7350",
"ao c #956532",
"ap c #010b07",
"aq c #0f1f18",
"ar c #8d6634",
"as c #532c05",
"at c #000506",
"au c #9cb5c0",
"av c #8a7048",
"aw c #240b05",
"ax c #76593b",
"ay c #04170d",
"az c #c88b5a",
"aA c #966440",
"aB c #dffcf1",
"aC c #a1784e",
"aD c #666756",
"aE c #7a7663",
"aF c #bd854f",
"aG c #2f2a20",
"aH c #7a6142",
"aI c #16170e",
"aJ c #835c2d",
"aK c #d99b71",
"aL c #645940",
"aM c #b37945",
"aN c #946b37",
"aO c #a5c2c5",
"aP c #212012",
"aQ c #bc865b",
"aR c #070a09",
"aS c #aa733c",
"aT c #835f3a",
"aU c #945c2d",
"aV c #2f3530",
"aW c #a7c6ca",
"aX c #967953",
"aY c #513f2d",
"aZ c #795226",
"a0 c #353f39",
"a1 c #956031",
"a2 c #844c1d",
"a3 c #a5b5be",
"a4 c #aaa598",
"a5 c #1f1109",
"a6 c #28221f",
"a7 c #1f2720",
"a8 c #373127",
"a9 c #897f5d",
"b. c #090707",
"b# c #02080a",
"ba c #c38054",
"bb c #d38e67",
"bc c #7a482a",
"bd c #af8654",
"be c #958662",
"bf c #9bb0c1",
"bg c #957141",
"bh c #a6c2cf",
"bi c #a1785a",
"bj c #956741",
"bk c #ab7850",
"bl c #b0d5d2",
"bm c #341606",
"bn c #9b6d4a",
"bo c #000101",
"bp c #434c46",
"bq c #6e340a",
"br c #875533",
"bs c #785338",
"bt c #170907",
"bu c #3b1f06",
"bv c #a98868",
"bw c #021106",
"bx c #172014",
"by c #443112",
"bz c #282c28",
"bA c #1d1910",
"bB c #693d12",
"bC c #a06e48",
"bD c #b27f53",
"bE c #17110a",
"bF c #b27e49",
"bG c #768071",
"bH c #9a6d38",
"bI c #7a8e8c",
"bJ c #4f554e",
"bK c #b5d6d3",
"bL c #ac7843",
"bM c #06201a",
"bN c #a17742",
"bO c #bb8055",
"bP c #6e4e27",
"bQ c #977442",
"bR c #97a3a5",
"bS c #bb7f4b",
"bT c #9a6a45",
"bU c #0b2822",
"bV c #c48757",
"bW c #87653c",
"bX c #ac7046",
"bY c #d9f6ec",
"bZ c #a97139",
"b0 c #a66c40",
"b1 c #8e5d2f",
"b2 c #af653f",
/* pixels */
"aBaBaBaBaBbYaBaBaBaBbYaBaBaBaBaBaBaBbYaBaBaBaBaBbYaBaBaBaBaBbYaBaBaBaBaBbYaBaBaBaBaBbYaBaBaBaBaBaBbYaBaBaBaBaBaBaBaBaBaBaBaBbYaBaBaBaBaBaBaBaBaBbYaBaBaBbYaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBaBbYaBaBaBaBaBaBbYaBaBaB",
"bYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaBbYaBbYbYaBaBaBaBaB",
"aBbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBaBbYaBbYaBbYaBbYaBaBbYaBbYaBaBbYaBbYaBbYaBaBbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaB",
"aBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaBaB",
"aBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbY",
"aBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYaBbYbYaBbYaBaBbYaBbYaB",
"aBbYaBbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYblbhbh.P.m.PaBbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYbYaBbYbYbYaBbYaBbYaB",
"bYaBbYbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBaB#Tblbh.j.j.J.J.j.J.j#Dbhbh#TbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYbYaBbYbYaBbYaBaB",
"aBaBbYaBbYbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaB#T#..jbf.m#Tbl#T#TaBbYaBbYbYaBblau.jbI#dbIbIbIbIbIbI.J.J.j#Dbhblbh#TaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYaBbYbYbYaBbYaBbYaB",
"bYaBbYbYbYaBbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYaB.U#Taha3.JbI#D#D#D.MbhblbYbY.mau.JbI#d#dbIbI.JbI#DbRbR.JbR.IbR#Dbh#Tbl.UaBbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYbYbYbYaBbYaBbYbYbYaBbYaBbYbYbYaBbYaBbYbYbYaBbYbYbYaBbYaBbYbYbYbYaBbYaBbYbYbYaBbY#Tbhblbhala3bRbGbG.j.J.J.J#D.j.JbI#d#J#d.JbRbI.J.J.JbI.JbI.JbIbRa3#Dbh#T#T.UbYbYbYaBaBaBbYbYbYbYaBbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYaBbYaBbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBbYbYbYbYbYaBbYaB#Tbh.Pbl#T.Pbh#D.j#DbRbRbR#D#D#d#J.J#d#d#dbp#d#d#J#dbIbIbI#J#d#J#d#JbJbJ#d#d#d#dbI.J#Dbhbl#TbYaBbYaBbYbYbYaBbYbYbYbYbYaBbYbYbYaBbYbYbYbYaBaB",
"aBaBbYaBbYbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBbYaBbYbYbYaBbYaBbYbYbY#T.mau.j.j.J.J.JbIbIbIbG#d#d#d#d.J#dbJbJbJ.7bpaj#JbIbG#d#J#J#J#J#H#H#H#H#H#H#H#J#J#dbI#d.j.jbfbKaBaBbYbYaBbYbYbYaBbYbYbYbYbYaBbYbYbYaBbYaBbYaB",
"bYaBbYbYbYaBbYbYaBbYbYbYbYaBbYaBbYbYbYaBbYaBbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBblbh#..JbI#d#J#JbJaj#s#sajajajajaj#Jbp#dbJ#s#Z#s.Oa0#HbIbJ#H#J#Jaj#Hajaj#H#H#Hajaj#HajajbJ#J##.J.J#D#TbYaBbYbYbYaBbYbYbYaBbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBbYbYbYbYbYaBbYbYbl#..J#dbp.7bpajajaj#s.#a8a8a8#Z#Z#Zaj#Ja0#s#Za8#Za8a8a0aja0a0a0a0#saj#Z.#a0#Z.O.#.Oa8.Oajaj#H#J#dbf.Ja3#TaBaBbYbYbYbYaBbYbYbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYbYaBbYaBbYbYbYaBbYaBbYbYbYaBbYbYbYaBbYaBbYbYbY#.bI#Jbpbpa0.O.O.Oa8a8aGa6#Aa6a6#E#A#4bt#z#z#Z#Z#A#Aaga6#p#Z#Z#Z#Za6a6#p#Z#p#Za8aG#Z.3#Z.O.##Z#Zaj#HbIbRbRbf#TbYbYaBbYaBbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbYaBbYbYbYbYbYaBbI#J.7.7ajaj.Oa8aGag.p#A.g#EbA#4a6.g#qbtbtbtbt#4a6#qbEa5.1a6#A#4#Z#Za6ada6#Z#A.1#A#maGa8.3#p.#.#.##Z.O#HbIbRbRbfbKaBaBbYbYbYaBbYbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYbYaBbYaBbYbYbYbYaBbYaBbYbYbYaBbYaBbYbYbYaBbYbYbYbY.Ubl.j#d#JbJbpaj.Oa8aG#u#A#A#A#E.g#4#z#EaIbt.Wb.b.b.b#bt.gbEbEbtadbAbEa6#Za6bt#qa6.3#Aa6ag.3a8a0.O.##Z#Zaj.##Z#Z#H.JbRa3bfaBbYbYaBbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYaBbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYaBaBbYaBbYbYbY#T#T#..J#dbp.7.7a0aVa8aGag.p.p#A.1#A#A#EaIbtbA.Wb.#ab.b.btb.btbtb.bEbtbt.WbtaI.EbtbAbAa6#A.3.#.3a8aG#Z#Za8a8.#aj.O#Z.OajbI.J#Da3aBaBbYbYaBbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYaBbYaBbYbYbYaBaBbYaBbYbYbYaB.j.jbI#dbpbp.7#saV#WaGa8a8.3#mag#m#A.1bE.W.Wa5btb.b.atbtbtbt.Wbtb.#abEawawaRb.b..Wbt.ga5ad#AaG.#.#.3a8a8a8#Z.##Z.O#Z.#.##Zaj.JbRalbfbYaBbYbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYaBbYbYbYbYbYaBbYbYbYaBbYbY.jbI#d#d#J.7bp#Ja0aV#ZaGa8.#a8a8.3.3aga6#AbEa5bE.wb.b.awbtbtawa5btb.b..Wawbtbta5bE#Fb.awbta5bEa5#A#ma6#ma8.#.3.3#Z#p#Z#H#Z#Z#ZaY#Z##.Jal#DahaBaBbYaBbYbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYbYbYaBbYbYbYaBbYbYbY#..j.J#dbI#Jbp.7.LbzaG.3.#ajaYa8a8aG.#aGagaP.ga5.W.Wb..Wbtbtbta5bEbtbEbtbta5bt#4b.a5btbtb.b.aRbE.1a6#A#Aad#m.3.3.3a6.3a6#p#Z#H.O.O#Z#Z##a3a3albYaBbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYbYbYbYaBbYaBbYbYbYaBbYbYbYbYbY#..j#d#d.7.L.L#p#WaGa8.O.Oa8a8.#a8#m#A.g#m#A.1#mada5bE.wbEa5bEa5bta5.g.g.1.WbE.WbtbEbtb.btb.b..W#A#Zada6#Aag.p#A#A.paGa8.3a6#Z.#.O.O.##H.Ja3alaeaBaBbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYaBbYaBbYaBbYbYbYbYbYaBbYbYbYaBbYbY.P.j#d.7a0.LbzaGaGa8a8.#a8a8a8a8.O.3.3ag.3bm#mbm.1.g.Wb.bwaa#ab.adbt.#.##mad.WbEbEbt.Wbtbtbta5bEbta6#A.1bE#q.g.1.g#qawa6#sag.3a6#Z.O#Z.##Z##bfa3.qbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYbYbYbYaBbYbYbYbYbYaBbYbYbYbY.j#d#d#d.Lbz#ZaG.#a8a8.3a8a8.#.O.O.O.3.3.pbm.1bE.Wb.b.aa#a#ab.btbt.1.#.#ag.1a5btbEa5bwb.btbtbtbEbEb.btada5.g.p.1.g#q.p#qbE#A#m#mag#p#Z.#.##HbI#DahaBaBbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYbYaBbYaBbYbYbYbYbf.J#d#Ja0#W#Z.3aGag.3.3.#.##s.Oa8.Oa8#m#A#E.g.gaI#F#aaa#ab.btawb.bt#m.##m.3#m.1a5.WbEbtbtbta5btad.1.1awa5a5#AaG.1bEa5.gbEb.btada6#maga6.##Z.##dbRbh#TaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYaBbYbYbYbYbYaBbYaBbY.j#d#J.7aVaVa8agag.3a8a8.#.3.#ag#Zagag#m#q.wbEbE.wb.btbta5bt.Wbtawbm#m.3bmadad#mbmawbtbEbtawawadawbEa5adadawa5agaGbxa5#qbEbta5a5ad.1.p#Z#Z.#.##H##bh.qaBaBaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYaBbYaBbYbYbYbY.J.J#dbp.7aVaG#u.p.3.3a8.3.3agaga8a8aP.gbEbE.wbtb.aaaab.btbtbt#abtadbmab.##mawawby#ebmawa5adada5awa5awawadadawbt#qa6#s.3.wb.btbtbta5a5.gag.##Z.#.O#JbfbhaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYbYbYbYaBbYbYbYbYbYaBbY.J.J#D#d.7aV#WbzaG.3.3.3.3.3.3.3#u.Oa7.W.WbE#q.Wb.b.b.#abtaabob.btbtaw.1byaf.3#maw#mbubmbm.1btaw.1awawad#A#m.1.1a5a5.1a8agbE.W#Fbta5btbEbE.g.3.#.Oaj#H.JahaBaBaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYbYaBbYaBbYbYbYbYbYaBbYbY.j.jbf#da0.L.La7aGaGaGa8.3a8a8.3#uaPaIa5a5a5.g#qada5.wb.b.#aaa#ab.awawadbmbyaf#mbubmbmbubmbmawbtawada5.W.1.gagag#m#m.g.1ag.ga5bEa5bEa5a5.waIa5.1#Z#Z#s#HbIbhaBaBbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYaBbYbYbYbYbYaBbYaBbYbYbYaB#.bI#d.7.LbUa7aG#uaG.#.3a8.O.3#uaI#q.g#m#A#A#Aad.gbE.Wb.aab.aabtawawawbmbu#R#ebu#Rbububmbubmada5btaw.gawa5btaw.1bm.p#m#m#m.p.1a5bE.gag.3#u.ga5awaga8.O#Z.JbfbYaBbYaBbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYbYaBbYbY.JbI#d.7.LaqbxaGaPa8.#.3.#.#aGagaPaI.1.1#A.gaw.1.1.ga5bt.Waabtb..1adadbmbu#Ras#5asbqasbu#Rbububmawbtbtadadbmbm.3.1.1.3#m.##m.1.1a5a5a5bA#ua8ag#Aadada6#Z.####DaBbYaBbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYaBbYbYbYbYaB#dbIbp.L.Lbxa7bxa6.#.3aG.O.3aP.3.L#qa5.g.g.1.1.1.1.1awbta5b.btawbmbu#R#RasbqbB#U.c#9bqasasbu#Cbubmadawad.1adbm#m#mad#m.3.3.3ada5a5a5awbEbE#q#uag#m#m#ma6.##H.JahaBaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYaBbYbYbYaBbYbY#dbI#J.L.L#paPaIaIaG.3ag.O.O.p#m.p#Aa5#maG.1#m#m#m#m.gadawawawbmbu#R#Rbq#U.caAaAaA.DaA.s#7#y#R#Casas#R#Rbu#ebmbmbmbmbmbm#m.3a5bua5a5btbtbtbEbEa..p.p#A#m.##Z#H##bhbYaBbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYbYbYbYaBbYbYbY.jbI.7bU.L#zbx#EbE.pa8.3.#.#.p.paP.p.1#m.1#m.3.#.3.3#m#m.1adbm#RabasbB.cbT.A.AbkbLb0bkbCa1.H.zasbqbBasbBasbm#R#R#Rbmbmab#m.1bu.1.gbmbtbtbt.WbEbEbEaIbx.g.p.#.#.O##.JbhbYaBbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYaBbYaBbYaBbYbYbYbYbY.j#J.L.L#p#4a.a.#E.3a8a8.3#m.p.g#q.g#m#m#m#m#m.#.#.#.3.1bmaf#Ras#C.c#YbkbD#caQbdbLbXbD.u.vb0.Hbqbqbqbqasbqas#Ras#Rasbu#mby.1#mbma5adadawbE.W.wbE#q.g#q.1#Aa6a6aj#H#dbfaBbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYbYbYaBbYaBbY.J#J.L.L.La7#4bA.pa6aGa8a8#m.1aP#i#i.g.1bububu#m.3.#.3.3.3afafbq.caibibkaQaQ..aQaQbFbDbOaF#8#8bN.Has#y#7#Ubqasas#e#5ab#ebmbm#mbu#m.1a5awadawa5a5bEbtbEa5a5#qbA#A#p#HbJ.JbYaBbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYbYbYaBaBbYbYbYbh#d.7aV.L#p#4bA#qagaGa8.3aP.g.1.wbE.w.1.1bm.3.##e#e#eaf.##eaf#7.c.AbibO.G.......xaQbDaQ.x.xbFbDbF.va2bc.b#k#7#7bqbqas.has#ebu#m#mby.1.1a5a5ad.1ada5ada5a5bEbt#Eada6#s#J#JbfbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYaBbYbYbYbYaBbY#T.j.7.L.La7#ua.a.#uaP.3.3#ubx.1aP.wbta5bm.1bubu.#asasabaf#R#5#U#YbkbObDaQbb....#r....bdaF.x.xbFbFbF.R.2a2.H.z#7#y#yasbqas#5asab#m#m.##m#mawawbta5a5.ga5a5bEa5bE.w.gad#paj#JbI#TaBaBbYbYbYbYaBbYbYaBbY",
"bYaBbYbYbYbYbYaBbYbYbY#.#da0aVaG#4bx#4aGaP.p.3#maPaIbu.g.Wbtad.1bmbu#ebB#5asas#Rasbc#YbD#caQ..bb..#r..#r#r..bF.xaz.x.xaFbdbLbg.t.v#v#k.H.z#7asbqbB#5af.3ab#e#mbua5.1awbE.1aI.g.g.1.g.1bE#q.ga6#p#H#JbfaBbYaBbYaBbYbYbYaBbYaB",
"aBaBbYaBbYaBbYbYbYbY#T.J.7.L.La7bxbAa6#E#A.p.1.g#ia5.1bEbEawadbu#R#5asbBas#R#Rbq.cb2#caQ..bbbb..bb.9.e.9.e#raF#r.x..#raF.xbdbQ.t.abZ.z.t#v.t#7bqbqbBafbybyab.1.1adawa5bE#i.wa5.g.g.g.1aIbE.g#A#A#p#d###TbYaBbYbYbYaBbYbYaBbY",
"aBbYbYaBbYaBbYbYbYbYbh#Ja0aVa7aPbAaIa.bA.g.1a5a5.WbEa5.wawawbm#RasbqbBasas#Rbq.cbXaQbV........#r.e.9.9.e.9.eaF.x..#r...5.xbdbH#v.abFbZ.v.H.H.z#7bqbBbBasbubu.1bm.1.gadbE.ga5.gbEa5aIa5.1bEbEa5bma6.O#d.J#TaBbYaBbYbYbYaBbYaB",
"aBbYaBbYaBbYaBbYbYbY.J.7.L.Lbxbx#iaIaIa5.g.w#N.Waabt.W.Wawbm#RasbBbqasas#Rbq#v.YaQ....#r#r..bb#r.9.eaK.9.e.e#r.....e..#r..bdbZ.N.AbDaFbZ.N.Hao.z#k#7bqas#Rbubuada5.1ada5.1#qa5.ga5a5.wa5a5a5bE#m.3a6#HbIbfbKaBbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbY.P#d.7.La7bx#iaI.w#i#Aa5.W.W#Fb.b.b.btbmbm#Rbq#5asas#Rbq#V#GaQ...ebb...e.9#r.eaKaK.eaK.eaK.9...e#r.e...xbF.a#vbdbDbdbSbZ.va1.H.t#kbqbqasbmbu#mawadad.1.1awbEa5.g.1bEbEa5.W.Wa5#ma6#p##bIblbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYaBbYbYbh.7.L.Lbxbx#i#NbwaIbEbE.wbwb.b.b.btawbm#Rasbqbqasas#U#YbkaQ..#r.e.e.e.e.e.eaK.eaKaK.eaK.e.e...e.e.9.e.ebdbd.zbDbFbVaFbSaM.va1.z.t.zbqbqasbm.1bu.1adadadadbE.Wa5.1a5aIbEaIaIa5#q#A#Z#p#Hbf#TbYaBaBbYbYaBbY",
"bYaBbYbYaBbYbYbY.PbI.7.La7aq.Ebw.w.WbEbE.wb..w#F.W.Wbt#Rbuasasasasbq#k.Dbd.....e.eaK.e.e.e.e.eaKaKa4aKaKa4aK.e.e#r.e.e#r..bdbd.tbdbFaQ.xbObdbFbZ.H.t.z#y#ybqasbm.gawa5a5a5.1a5bE.1a5.1bw.waIaPbAbE#A#p#Haj.JbhaBbYbYbYaBbYaB",
"aBbYaBbYbYbYaBbY.P#J.L.La7bx.4#N.wbEa5b.#FbE.W.Waab.ad#5bubm#Rasbq.z.v.u.x..#r.9.e.eaK.e.eaK.e.eaKaKaKa4aKaK.e.e.e.e.e#r#r.xbd.zaFbSbObVbOaFbdbLbZ.z.z.z.H#ybq#e.3awbt.1.g#q.1.1.g.g.1#ibE.w#iaPbE.p#paj#Z.Ja3bhaBaBbYbYaBbY",
"bYaBbYaBbYbYbYbl#d.7.L.La7.4#ibE.Wa5bE.WbEa5ada5btadbmbm#Rasbq#y.z.vaMaQ...e#r.ebb.e.e.e.e.e.eaK.eaKaKaKaKa4aK.e.e.e.9.e....bdaUbkbDbO.xaQaFbFaMbZbZ.z.z.z.z#ybq#eadadada5bE.1.1bta5.gbEbEbEbw#q.p.1a6#Z#H#Jbh.CaBaBbYaBbYaB",
"aBbYaBbYbYbYbY.j#J.L.L.L#ua..Ea.aI#EbE#mbubu.1bu#e#5#5bqbq#y.HaobZbFaF..#r#r.9.e.eaK.eaK.e.e.e.eaKa4aKaKaKaKaK.e.e#r.e.e.e.ebd.vbDaQ#8bObObDbFbFaMaSbZ.z.t.z.z#ybBasbuadawa5a5a5btbEaP#ua5bw.Wa5#q.g#A#p#JbJ#dbfbhaBaBbYaBbY",
"bYaBbYbYbYbYbY.J.7.L.LaG#u#E.E.WaIa..g#ebubu#e#5#5#ybBbq#y.z.vbZbFbd.xaz..#r.e.9.e.e.e.eaK.e.e.eaKaKaKa4.eaK.e.e.e.e..#r.e.e..#6#8..b0aibObFbFbFbSaMbZ.v.z.z.z.z#ybqbqbubmada5a5bEbE#qbEa5.w.w.w#q#i.ga6#HbIbI#JbhaBbYaBbYaB",
"aBbYaBbYbYbY.P#d.L.L.L#uaP#4#EaI.W#q.1bubu#eas#y#y#5bB#y.z.H.ZbFbFaF.xaz..#r..#r.e.eaK.e.e.eaK.eaK.eaKaKaK.e.e.9.e.e#r.e.e..bd#I#Y.a.Nb2aQbFbFbFbFaMaSbZbZ.z.z#y#y#y#5asasbubua5bE.wbEa5bE#F.waabw.WbE#q#Z##bfbIbIbhbYaBaBaB",
"aBaBbYbYbYbY.j.7a0#WaG.p#4aGa6#4.p#A#eby#5#5bBbB#5#y.z#y.daSbLbFaF.x.xaz..az.x....bb.e.ebba4.e.e.ebb.e.e.e.e.9.e.e.9.e...e..aQ#IaU.Z.ZbLbdbF#8bFbFaMbFbZbZbZ.v.H.z#y#y#ybqbB#ebuadbw#Fa5bEaaaab.#Fb.a5#qa6#H##bIbR#DaBbYaBbY",
"aBbYaBbYbYbYbI.LaVaV#ua7aG#Wa6a7aGagby#5#5#y#y.z.z.ibH.HbZbNbdbFbdaF.5aF.x.x.x.x.x.x.....ebb.ebb.e..#r......#raz#r.........xbObL.vaMbFbLbFaMbF.ubFbFbL.vbZbZ.v.v.H.H.z.z#y#y#5bybu.gbE.3.3bEbtb.#Fb..WbAa6bJ#d###Da3aBaBbYaB",
"bYaBbYbYbY.P#Ja0#s.La7.pa8#W#p#p.pa8.h.hbB.zamamambNbNbNbNbNbFaFbdaFbd.5aF..aF.........ebb.e.e..#r..#r...9..#r.e#r#r#r....bVbO.ubZ.ZaMbDbFaMbFbFbLbL#8bZaSbZ.v.d.dao.H.z#y#y.hafbybua5#Z.O#ubEbwaaaRb.bAbt#Ha3##bRbhaBbYaBaB",
"aBaBbYaBbY#.bp.LaV.Lbx#uaV#Za6#4#4.#by#5#y.FaNaNbQbQbN.abF.abFbdaFbd.5bd.xaFbdaF.x.x......aQbb.e#r..#r..#r......#r.9..#r..azbVbO#G#BbFbFaMbFbFbFbF.Z.Z#8aSb0bZ.v.dao.H.F.z#S#C.h.#.3aIaG#s#Z.g.W.w.wbw.6.E#p#JbRbRa3aBaBbYaB",
"bYaBbYbYbY.J.7aVaVbxbxaGaVbz#u#uag.3#5.h#y.zaraNaNbHbL.a.abFbFbdaFbdbdaFbdaFaFaFaFaFbabSacbabVbV....#r#r#r#r....#r#r.e..azbVbabS#Bb2bObSaMbFbFbLbFbLbLbN.Z.R#I#IbH.d.H.F.F#y#xafby.3#A#ZaV#Z#A#qa5a5.w.wb.#4#Z#J#DaBaBbYaBaB",
"aBbYaBbY.P#d.7.La8bxaP#W#s#ua6.p.ga8af#5#y.HaNaNbQbNbNbFbF.abFbFbdaFbdaFaFaFaFaFaFbVaFbVbVbVbVbV.xbVaz.x....#r..#r#r.....xaFaF#haM#B#BaMbLbFbFbFbLbLbNbL.Z.Z#I#IbHaoa1.F.z#y#5.hby.3aG#p#W#W.1.pbEbEbw.waR.W#zajbIbfaBaBbYaB",
"bYaBbYbY#.#d#saGaGaq.p#WaVa6.pbx#qbuby#C#y.zaNbQaNbN.abF.abFbFbFbFbdaFbdaFaFaFaFaFbVazbVbVazazazazazaz.5.x#r#r.x.x#r#r..bVbVba#hbSba.uaMaMaMbLbLbLbLbLbLbNaS#I.R.Ra1b1.F.F#S#Cbyaf.3.3#Z#pa8#ubx#mbw.WaI.E.W#4a6#dbfaBbYaBaB",
"aBaBbYaB.j#J.La8a7bx#uaV#W#ua.#ia5bu#5#C#y.FaNbQbQbNbNbFbNbFbNbFbFbdbFaFaFaFaFaFaFaz#razazaz#r..az.5azazaFazazaF.5az..#r.xaFbVbVbSbO.ubSbFaM.ZbLbLbLbLbL.ZbL.R.RbHa1.B.i.FaZ#Cbyby.3ag#ZaG#sa7#EaPaI.w.wbE.4a.#4#s.JbhaBaBbY",
"aBbYbY.PbI.7.L#u#ubxaP#Wa7aP.wbwaIby#5#S.z.zaNaNbNbNbNbNbFbZbNbFbFbFaFbdbdaF.x.x.x..az#r#r...e#r#r..az.xazaF.5aF.5azaz.xaQbVbVbVbVaQbObFbFbFbL.Z.Z.RbLaS.RaS.v#6aNa1.2.F#n#S#Cby.#by.p#u#Za0aGa7aPbE#q#i.WbA.W#4#Z#dbhbhbYaB",
"aBbYbY.P#d.7.L#uaPbxaP.La7a7#F.W.g#e.h#y#y.iambQbQbNbNbNbNbNaSbFbd.abdbFaFaF.x.xaz.....e...e.e.e.9....#r..#r..azaz#r#r......az.xaQaQbdaFbDbFaMbL.Z.Zb0aS.R.v.R.vaN.2.2.baZ#y#C#5.3#m.pag#Za0#ZaG#u.wa5aPaI.EbA#Aa6bJ.Ja3aBaB",
"aBbYbY#.#Ja0.L#ubxbxaPaj#zbx#FbxaIby.hbP.i.iamaNaNbQbQbNbZbNbNbFbdbFaFbdbd.xbd.x.x.....e.e.eaK.e.e.e.9.e.e#r.e...e.e.e....bv.....xaQbDbDbDbFbLbL.ZaS.R.R.v.R.vbHaN.2.F.F.zaZ#5.hby#m.3aga6a0#ubAaG#q.WbEaI#q#Ea5a6#H.JbfaBaB",
"aBaBbY.j#J.L.L#ua7bxbx#Wbx.E.rb.a5ab#S#n.i.iaNamambQaNaNbNbNaFbFbdbFbdaFbdbdaF.x.....e.e...e.e.eaK.e.e.eaK.e.e.eaK.e.e.eaQ.xbv..bvaQbDbDbDbDbFbF#8#Ib0.v.vbH.dbjaN.2.H.s.F#S#S#5ab.1.3a8#4a8#4#q#4bz#ibE.wbA#E#4#4#Z#dbfaBbY",
"bYbYbY.j.7#s.La7aP.4aPbxa6#i#F#FaIby#S.i.i.iamamamambQbNbFbNbN.abdaFbdbdaFbd.xbd...x.....e.e.eaQbb.ebb.e.eaK.e.e.e.ebb.e..aQaQaQ..aQaQbDbObDbF.u.Z#8#8.R.d.daoa1aN.2.HaJ.FaZ#y#5bybu.pa8aGaGa.#q.w#WaIbE.g.WaIbta6#p#H#DaBaB",
"aBaBbYbI.7.L.Lbx#ubxaP.p#4#N.Waaa5by#n.i.i.i.i.iambQbQbNbNbNbFbdbdbdbdbdbdbd..#M....#M...eaQaQaQaQ.e.e.e...e.e.....ebv.e....aQbvaQaQaQbOaQbObO.u#8bXbX#I#6bHa1b1#ob1aJaJ.F#y#S#C#5abaP#sa8#ubx.wbt#4aPaIbEaIbE#Ead#Z#HbIbfaB",
"bYbYbY#da0.La7bx#q#q.pbAaq.6#F#F#q#C#n.F.i.iam.iamaNbQbNbNbNbN.a.abN.a.abdbdbd#Mbd#cbD#c#cbvbObOaQbbbb.ebb.e.e..#c....bv..bv..bv..bv..bvaQaQbDbD#8b0.D.D.DbT#ob1#o.FaJakaJaZbP#C.hab.p#saG#pbxbEbEaIaPbEaI.wbE#4.3#ZbJbI#DbY",
"aBbYbY#d.LbUbUbMbx.E#qbA#i.waabwad#C.i#n.i.i.i.iambQamaNbHbNbN.abN.aam.i.i#n#naJ#f.BaA.D#Gbk.A.ubObvbb..aQbvaQ#c#hbkbk#c#c#caQ#c#c#cbvbdbk.AbC.AbCai.Na1aAbHaN.2#faTaJ.bak#yaZ#Sby.3#u#W#Zbza7bAa5bAbEaI#i#iaI#Ea6#p#HbRbfaB",
"bYbY.U#d.7.LbUbxayay#iaI.w.wb.bw.1#x.l.i#n.i.iamamam.i.i.iambQbQbQ#Pam#wbP#Sa2bP#Sa2braA.DbC#GbkbdaQaQaQbDbaaQbO#8.ZbC.DbjaA.B.B.BaA#2bnbn#c#c#cbC.D#6#v.N#oaAar.2aJakakaJaZ#S#S.hbu.p#WaGa6#u#qbE.g#i#qbw#ibwbta6#Z#Z##a3aB",
"aBbYbY#dbU.LbUbx.4aI.EaI.wb.#Fb.bm#x.i#n.i.l.i#lamam.iambQbQa9#M.Xbda9avbW#waZaJaJbrak.2#o#6#Ib0bFbDbdaQbD.ubFbFaS.RaNbjbW#w#9bc#9ak#9#9.obnanan.nbj#ob1b1#ob1.2.F#wakaZ#naZ#S#S#CbyaPaG#u#4#u.wbEbE.gbwbwbwbw#q#4#Zaj#JbfbY",
"aBbYbY#d.L.LbUaq.4#i#ibE.wb.#Fbwbu#x#n#n.i.i#l.iam.i.iambQbebd.abe.f.aa9.8#XbP.h#S#UaZ.bb1#obH#IbFbd.....xbFbL.v#6b1.B.2#faT#f#fak#f.ybj#2bibebi#2aAbW.2.F.bbrbr#f.iaZaZ#naZ#S#S#xab.paP#qaP#q.w#Nbw.wbE.w.w.w.WbEa6#Z#HbIaB",
"aBbYbYbI.7bUbUbUaybxaIbwbw#F.WbE.3#x.F.F.i#l#l#l.i.iam#Pa9.a#P.l#x#x.O#s#W#ma8#0bc#9#9#f.i#obg#IbDaF.x.xaQbDbL.R.db1#obW#o#faZ#U#CaY.V#H#O.l.o#PaX#j#2bjbW#o.bak.F#f#waZakaZ#S#S#xbyaP.g.p#E#qbEbwbwb..wbwbt.WbE#qa6a8#H.JbY",
"bYbY.U.Ja0.L.Laq.4bx.EbwaR.waI#E#m#x.i.l.iam#PbQ#P#Pa9bQ#P#xbya8bJ.La0#JbG#W#HbG#g.o.QaTambWam#I.abF.x.xaFaM.ZbHa1b1bW.n#Kbcbcbc#0#Qa8a0.7#Aa6.3#3bs.oavambW#fakak.i.iaZaZaZaZbP.hbyaPaP.pbE.gbE.W#Fbtb.aa.w.W.wa5a6#Z#J#DaB",
"aBbYbYbI.L.L.LbMbMaP.4#N.6#i.E.g.3bP#w.i.8#lam#lbQ#PbQ#PbPbyby.lbIbpbpa0a0#H#JbRbe.0.obi.y#oar.daSbFaFaFaFbL.va1brak.y#K#g#g#9bcbIbG#HbJ#dbx#Za8.#.##C#9#K#KbWaT#obW.i#naZaZ#SbP#x.#aPaPaG.Wa5.w#Fb.bE#Fb.#F#F.wbEa6a8#dbfbY",
"bYbY.U.j.7.L.LaqbUbxayay.raabA#q.3#X#w.8.iam#PbQ#P#Pam.i#5bB.Q#Pa#bGbpbp#QbJ#H#tan.o.o#caCbW.iaoaSaMbSaFbFaS#6#vaZ.c.oaA.B.o.cbna4bIajbJ#Waj#s#Q.0#R#ebqbc#L#Kam#KbWaT#n#nbPaZ#S#xbyaPaI.p#F#q.wbwbwbw.wbw#Fbw#i.Wa6#p###DaB",
"aBbYbY.j.7.L.LbUbxaqaq.6aa.r.W#4.3bc#wam#lambQbebQbQ.i.i.z#n#g.o.o.0.0aEbia#bibibibn#cbDbdbQ.i#6aSaMacbSbSaSaU.ta2.QbibibCaA.o.obi#jaE.oaD.S#0aE.o#9#5asa2bram#KbW#KambW#wakbc#S.h.#aP#qbE#FaIbwbwbw.wbw#F.WbwbA.Ea6#ZaD#DaB",
"aBbYbY#..7a0bUa7aq#z.4.6b##i.W#E.3#0.iambQ#P.a.abQaN.iaNav.y.o.oanbibibv#t#t#tbi.Abi#c#Mbd#2b1.NbZaM.KbS.TbZ.N#kbcaAbibDbibibibibibi.obibnaEbi.obcbcbc#7.c.b#fbWbjbn#2am.iaZ#S#S#Cby.1#qbEaaaabwbwbwbw#FbwaR.6aIbAa6#Z#Q#DaB",
"aBbYbY#.#J.L.LbUa7#zayayaR#NaI#4.3bc.QavbQ.a.abebQaNbN.a.a#2#Kbn.obibibibibvbi#cbibO#cbd.aav.2.v.YaMacacbSbZ.N.z.s#obibvbv#cbkbibibibvbibi.o.o.o.o.cbs.B.B.B#objbnaCaCbgbWaJa2bP#C.#.gaIaI#ib.#Fbw.W#F#F.w#Fbw#q#4#4#Z#JbfbY",
"bYbYbYbY#d.7.La7bUaq.4#i.6.w#E#E.#bsaTambQ.abdbdbd.a.abd#c.a.Aananan.obibi#cbvbv#tbv#c.abQar.2b2aS.T.TbSaMb2.v#v.s.BbT.A#c#cbv#cbvbibibibibi.obi#Y.o.oanan#2bQbCaC.A.AbCbg.i.s#S#C.ha5bEbA.paab.#F#Fb.#Fbw#iay.W#qa6#Z#Q#DaB",
"aBaBbYbY.J.7bU.LbUbxay.E.6aI#E#q.##9.QambQ.abd#Mbdbd.Xbdbd#Mbd#c#c#c#cbvbv#ta4#t#1bvaCaCbgar.2ai#B.T.TacaM#G.N#v.sb1aAbTbibvbvbva4bv#t#cbibibibnbi.A.AbibiaXaX.abdbd.a.AbHb1aZ#U#Cby.1bEaI#maabwaab.bw.WbwayayaI#z#Z#Z###DaB",
"bYbYbY.U#..7.La7bUbM.Ea..k.k#E#AafbPaTambQ.abdbdbdbd#Mbd#Mbd#M#Mbdbvbv#1bva4#t.ebv#c.abNamarb1ai#B.Tac.T#Bb0.N#v.b.ca1aAbnbvbv.e#t.e#1#1bv#cbi#cbibibibi#jaXaXbdbvbdbDbNbH.Ha2#S#Cby.1bEaIaPaa#Fbwbwbw#i#i.4.E#4#z#p#ZbIbYaB",
"aBaBbYbY.U#dbU.L.LbUaqa.a6.W#Aa5.#bs.Q.nbQ.abd#M.a#Mbd#M#Mbd#M..#M.e.e.e.e.ebvbv#c#cbkbgbgar#o.D#B#hac.T.Zb0.N.B.c#v.NaAai#c#cbva4a4bba4bv#1bvbvaQbvaQ#c#c.a.abdbdbdbd#8bHa1aZ#y.h#5.1bE#q.p#Fb.#FaIbw.waya.aP#Eaqa6#HbIaBbY",
"aBbYbYbYbYbIa0.L.LbUaqbAa6bEa6#A.#bsaHambQ.abd.abdbd#M#Mbd#M..#M.e.ebv.ebvbvaQaQbObk.Dbgbg.2#6.DbX.T#h.T#GaiaUbr#v.c.B#Yaibk#cacbvbba4bba4bba4.ebvaQbvbv#cbd#cbDbdbd.aaCaNb1a2#U.hby.g.waIaPaa.Wbwbwbw.w.waq#u#E#z#Z#H.JaBaB",
"aBbYbYbYbY.j#J.L.LbUbUbx#E.4.g#A.##g.y.nbg.a.abdbdbd....#M..#M..#M...eaQbbacbvbObibk.DbgaNaraoaib2.Y.Y#Gai#Y#v.c#v#v#Y#Ybn.Y#c#cacbvbbbba4bb.e.ebv..bvaQbdbDaQbdbDbD.abCao.b#UbB.h#5#qbwaI.w#F.W#F.w#Fbw#ia.bxbA#4#Z#Q.JbYbY",
"aBbYbYbYbYbYbI.7.LbUbMaqaqa.#Ead.#aH.8.ybgbN.abdbd#M..#M.x.xaQ......aQaQaQaQbObD#8bC.DbQaN.2a1#Y#V.Y.T#G#V#v#v.b.B.B#Y#Y#Ybiacacbiacbvbvbb#tbbbv.e..aQaQbvaQaQbObDbk#8.D.N.b#ybB.hbya5aRaIbwaabw#F.w.W#F.wbx.EaI#4#Z#d.JbYaB",
"aBaBbYbYbYbYaubI.7bUbUbMbxaq.E#A.#.l.oavbgbN.abFbd...x.x..#M..#M..aQaQ.GbvbObObDbk.AaCbgar.B.N#Y#Vb2.Yb2#Y.B.c.b.c.N#Y#Y#Yaiacbiacacbbacbbbbbvbb.eaQbbbvaQbOaQbDbFbk#8#6b1a2#UbB#5ab.gbw.w#Faa.W#FbEbEbwaI#uay.EaI#H#J#DbYaB",
"aBbYbYbYbYbYbY.U.J.7bUbU#z#za.#Aaf.S#L.ybgbCbkbDaQaQbdaQ.x..bv..aQ....aQ.KaQbObObDbk#8bjbrb1#6#V#Vb2#B#Gai#v.b.s.c.BaiaibC.Ybiacacacac.K#cbb.ebbbbbbaQaQbOaQaQbObk#8.DaAbrbc#UbB#5bua5bw.w#FaaaIbw#ubx#i.E.OaR#z#z#dbI#DaBaB",
"aBbYaBbYbYbYbYbY#.#J.La7bxbx#u#Aaf.S.o.yamaA#GbkbdbdbdaQaQbDaQaQbv.GaQ.GaQ.GaQbObDbk.Db1.b.B#V#G.Y.Y.Y#Gai.c.ca2.c.Baiai.Ybiacacac.Kac.Kbbbvbbbvbbbv.K#cbObObO.u#8.R#6a1.bbc#U#5#5#m#i#Nb.b.aa.w.w#uaI#iaI.O#Na.#sbI.JbYbYaB",
"bYaBbYbYbYbYbYbYbY#d.L.La7a7#u#maf#Q#l.ybW.BaibkbDbO#cbObDbObDbOaQ.e...Kbb.GaQaQaQbkbjbr.caAbXbX.Y#B.T#B#G#Ya2bcbc.cai.Ybi.Tacbibbacacbbacacbbbbac.KacacbObObD.ubXb0.N.B.c#U#UbBabbubE.W.W.Waa.w#i.g.w.w.Ea7aR#4#d.JbYaBbYaB",
"aBaBbYbYbYbYbYbYbYbYa0.LaV.O.#af.V#b#l.o.yaAaibibkbDbDbkbkbkbDaQaQbb......bbbb..aQ.AaNbra1aibkbOaQaQbObObX#Y#9#k#U.c.cb2bi.Kbbacbb#c.Kbbbb#cbb#cac#cacbi.Ybi.YbXbXai#v.c.bbcbB#5#5bu.1bE.w.waabEa5.1#u#uag.E.EajbIbYbYaBaBbY",
"bYaBbYaBbYaBbYbYaBbY.7bp#H#l.8.o#2#QaD#L.y#KanaCbk.Abkbk.ubiacaQbbbvaQbbbb...e..bDbn.B.F.BbCbibbbba4aKbvbXaA.c#k#7#k.c#Yac#cbbbvbbbbbb#cbbbbacbbbv.Yac.Yb2.Y.A#GbC#Y.B.bbc#U#UbBaf#e.1.gaa.w.w#qag.3.#a8#u.6#ZbIbYaBaBbYaBaB",
"aBbYaBbYbYbYbYaBbYaB#Jbp#l.f.0anaXaH#l.o#L.nbnaCaC.AbXbi.u.ubOaQaQbbbb.ebb.eaQbObibT#ob1.Bbn#cbvaKa4aKa4.TaA.c#k#k#k.c.c#Vacbbbvbbbbbbbbbb#cbbacac.Ybi#V#Vai.Yaibn.B.c.sa2#U#Cafaf#ebm.g.W.wbEadabafa8aPay#Z##bIaBbYaBaBbYaB",
"bYaBbYbYbYaBbYbYbYbIaD#JaEbebi#jaX#b#l#l.y#K.nbnaCbk.A#8bkbkaQaQ.KbvbbbbbvbbbO.u#8bj#o.ibr.oac#cbvbb.eaQ.A#o.c#9.c#k.c#Y.Ybibibba4bbbbbvbbbbbvacbi.Y#Vb2#V#Vbnai#Y.cbra2bc#Ubc#CaYby.3bubm.1.1buafafa8.E#p##aBbYaBaBaBbYaBaB",
"aBaBbYaBbYbYbYbYbYbI#d##.0#c#cbvanaxaD#l.8#K.n#2bC.DbC.DbXbDbObOaQbbbvbb.KaQ.Ybkbk#oaAbWaZbr.obibi#cbibiaAbrbsbr.c.cbc.o#V.Yacacbbbbbbbbbbbibbbiac.Ybi#Vbi#Vaiai.B.Bbr.sbcbc#CaY.V.#byafasasafbPbs.VaPaPaDaBbYaBaBbYaBaBbYaB",
"bYaBbYbYbYaBbYbYbI#d#JbJ#bbi#c#cbn#baH#l.y.y#K.nbTbT.DbCbXbk#cacbvbObbbb#c.Y.Y.Y#caA#famby#0biaibibibibn.Q#9#9#g.c.cbc#Vbi#Vbi.Ybbbvbbbvbbbbac.Ybi#V#Vai#V.c#Y#Y.c.Bbr.saZ#Sbc.V#3aY.##5#5#U.Q#b.yby#E#HaBaBaBbYaBbYaBbYaBaB",
"aBbYaBbYbYbYbYbI#d#dbpaV.Obibibi#2#PaDaD.o.yav.nbQbnbCbC#8bk.ubOaQaQaQ#c.Y.Y.Aac#c.Aak#n#S#U.o.o.obibnbn.oabafbcbr.cbcbibi.Y.Ybiacbbbbbbbbbiac#c.Ybi.Ybi#V.o.c.c.Bbrbr.sbcbc.h#3#x.Vafbqbc.can.o.oa8bpaDaBbYaBaBaBbYaBbYaBbY",
"bYaBbYbYaBbYbYbY#DbIbI#J.7.S#jaXanaXaD.8aH#L#Kav#2bQbQbCbCbkbO#caQaQbOac.Yb2acbkbDbkbj#9.c#0bc.o.obs.c.o#Cafbnbc#7bc.cbibiacbi.Yac#cbbbvbbbbacbi.Y#Vbn#V.oai#Y.B.Bbrbr.s#U#U#x#x#x.VaYbcbcaAbn.oaLbp#JbYaBaBaBbYaBbYaBbYaBaB",
"aBaBbYaBbYbYbYbYbYbYbY.J#d#daE.0.0#P.l#l.o.8avavbgbgbgbCbCbkbkbO#cbObk.YbXbDbObDbk.A#8.n#g#U.hbs.Qbsbsbc#R.c.B.c#U.c#Vbi.Ybiacacbiacbbbbbibiacbi.Y#V.o#V#Yai.B.B.B.Bbra2#UbP#x#0.V#xbs#g#gaA.o#b.#bJaBaBbYaBbYaBbYbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYbYbYbY.J##bGa#aEaD#QaD#l.8amav.nbgbgbTbCbkbibD.ubk#B#8.ubDbDbkbkbCbC#2aTaZbcbcaYbc#0af#Ubc.cbs.c.o#V.Y.Yacbibbac.Ybb#cbbac.Ybi#Vbn#V.c.oai.oaA.Bbr.c#U#Ubc#x#x#3aY#g.o.Q#b#b#xa0aDbYaBbYaBbYbYbYaBbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbI#dbIbG###daDaD#b.y.yavambgbg.nbC#8bkbDbk.u.ubk.ubDbk.aaCaCbC#2avaTaT.Qbs#gbsbcbcbcbs.o.o.o.Ybi.Ybiacbiacbibbbibbbiacbi.Ybn#Y.o#Y.o#Y.c.B.B.ca2#U#C#0#3#x.V#0.obs#H.VaGaj#dbYbYaBbYbYaBbYbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYbY.J#daD#J#dbGbI#d#QaD.o.8.ybgbgavbgbQaCbkbDbkbF#8bLbkbk.aaCbCbNaC#2#2avav#2.o.o.o#b.o.o.o.cbi.o#Ybi#Vbiacacbiacacbibbbibbbi.Ybi.oaA.c.oai.oaA.B.cbr#UbcbP#x#3.V#3#Aa6.p.O.OaG#JbYbYaBbYaBbYbYbYbYaBbYaBaB",
"aBaBbYaBbYbYbYaBbYbh.j#Jbp#HbG#d#d#J#H#l.oaHavambgbgav.naC.a.aaMbL.abLbkaCaXbnaCanaCbQaCbQ#2aX#P.o.o.o.obi.o.obi.o.obi#Vbi.Ybi.Ybi.Yacbiacbi#c.Ybi#V.o#YaA.o#Y.B.c.B.Bbcbc#C#3.V.V#H.Wa5#qaGbybpbYaBbYaBbYbYbYaBbYbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYbY.I#d.7#s#Q###dbJbp#laH.8amavbgavavbgaX.abLbNbL.abN.aaX#2bQaXaXaCaCaCbQaC#c#cbe#cbi#cbibi.obibibn.obi#Vbibiacbi.Ybiacbvac#c.YbiaiaA.caAaA.BaA.o.B.cbcbcbc#x#3#3aj#FbEaIaP.O#Q#JaBbYaBbYbI.JbYbYaBbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbY.j#JaVa8.Obp.V.OaH#laH.yambgavavam#jbNbNbL.a#IbjanbQ#PaX.aaX.a.aaCaCbkbvbvbv#c.f#c#tbi.Abibibibibibibibibibi.Ybi.Y.YacbiacbiaiaA.B.oaA.B.o.cbrbrbc#UbPbP#x#3.hbwbwaIaG.Oaj#JbpbpbJbp#dbIaBaBbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYbYbY#DbI.7aVaV.L#p#4.o.0aH.yamambQ#P#wav.a.R.abNbgbjaXaXbNaXaCbQ.AbC.D#Yaibkbv#cbibvbvbvbib2bibiaibibi.obibibibibi#Vai.Ybi.Ybk.A.AaA.B.BaA.BaA.Bbr#9bcbcbP#0#x#Obybwbwaga8ajaG#ua7#p#p.L#d.JaBbYbYaBbYaBaB",
"aBaBbYaBbYbYbYaBbYbYbYbY.J#J#J#s.La7#EbsaE.8.ybWbg#2#Pam.8bQ.RbLbQbgbQbQ.abQaXbQbgaA.N.c.c#v.c#V#caQbib2aiaiaA#Vbi.Ybibnbibibibibi#Vbi.ob2.A.YbibX.AaAbr.BaA.B.B.B#vbr#9bcbP#x#3.Sby#Nbw.E#qaga8#ua7aP#4a0bIbYaBaBbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbY.j#dbpaj.7bza6#Ha9#b.8bWambQav#PaXbQ#IbLbQbgbQaXaXavbgarbr#9.c.t.c.c.c.c#Ybi#Y.c.c.c.c.c.c#Y#Yaibibnbi.obnbi.oaAb2.A#8bk.A.D#o.B.B.BaAaA.Bbrak#9bPbc#x.V.l#m#F#Fbwbwbx#u#ua7bA#ZbJ.JbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYbYbY.J#d.7.7#sbz.#a9aH.y.Q#Lavav#2aXbNbN.abNbQbQbQbQam#n#S#CbB#C#U#7#7#7.cbc.c.c.c.c.cbc.cbc.c.c.c.obnbnbibibnbnaAbnaibCbXbCai#o#o#o#oaA#o#obr#9bc#9#0bP#3aLaPbw#Faabw.wa..Ea.#ZbJbIbYaBbYaBbYaBbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYbI#d#d#Ja0a8#PaHaH.y#Kbg#PbQaXbNbL.a.abQ.abQaNaJbcbcbcbcbc.c.c.c.c.c.c.c.c#7.c#7bqbcbqbqbcaf.caA.obnbibi#2aAbTaAaibC.DaAaA#o#o#o.n.y#oak#9#9bP#0#3#x.h.w#Fbwaaapaa.E#z#pbpbG.JaBbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYbYbY.JbI#J.7aG.o.8.o.y.yav#2aXbQbQ.abF.abNbQ.a.H.i#o#fbc.c.c.Q.c#Y#Y.c.c.c.c#V.c.c.c.c.cbcafbqafaf.c.cbnaX#2#K.naAbH.DbC.DaA.B#oaT.yaA#f#9#9#9#0#0#3#Oby#N#N#N#F.E#p.Oa0bJbI.JbYaBaBbYaBbYbYbYaBaB",
"bYaBbYbYbYaBbYbYbYaBbYbYaBbYbYbYbYbG#JaVaj#laHaH.y#K.naXbQbHbN.a.a.abQbQao.daoaA.B.B.B.c.c.o#V#V#V#V#V#V#V#V.c.c.c.c.cbc.cbcbc#Ubr.n#2av.n.R#6.vbH#6aA#o#o#obW.ybrak#9bP#X#3#x#Obybwbwbw#4#sa0ajaj#JaBbYaBaBbYaBbYaBbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbYaBbYbYbYbYbI#Ja0#l.8#L.y#K#K#2bgbgbNbF.abd.abQbHbHbHbHaobTaAaAai#V.obi#V#V.o#V#V.c.c.c.c.c.c.c.c.c.c.c.B.B.y.nbT.R.D#6bj#6#o#o#oaTbWaT#gak#9#0#X#3.Vbpay#Nbw#NaIa.#4a7#Z#JbYaBaBbYaBbYbYbYbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYaBaBbYbYbY#dbp#Q#l.8aT#Kav.nbQbHbN.a.abQbNbHbQbH.RbHbHbQbnbnbnbi.Ybibibibibibibi#V#V.c.c.c.c.BaAaA#6#6arbjbganbL.v.DbjaAar#o#obW.y.Q.Qbs#nbP#X#H#x#x.wbw.EbA.p#u#Z#Zaj#daBaBbYaBbYaBbYbYaBbYaBaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYbYbYbYbYbYbYbI#dbp##aHaH.y.yavbgam#IbNbN.a.abQbH.d.vbQbQbQbQbnbn.o#Y.o.c#V.o#V.o#Vbibi#V.oai.oaAaiai.da1bjaNbgaCbN.R.Dar#o.B#obWaTaT.Qax#n#X#0#O#3#O.LaIaIbx.p.p#uaG#sbJaBbYaBaBbYaBbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaBbYbYbYbY.J#J#Q.l#l.y#Lambgamam.abQ.abNbHbH.vbH.RbQbgbgbj.o.c.o.c.c#H.c#0.c.c#Y.o.oaAaAaAai.D.R.va1aobHbNbNbNbgbjaN.2aT#obWbWaH#waxbs#X#3#H.V#O.3aPaP#u.3aGag#ZajbIaBaBbYaBbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbYbYbYbYbYbYbYbYbY#d#daD#l.8#LamavambgambQbQbNbNbHbH.vbHbHaobjaNaN#o.o.c.o.c.o.c.o.o.c.o.c.BaAaiaA.v.v#6.Na1bCbQaCbQbHbjbW#oaTaT.y.Q.yax#X#X#0#O#3#H#x.L.O.O.O.7.7bp#dbI.UbYaBaBbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYbYaBbYaBbYbYbYbYbG#daD.8.yavavamaNambQbQbNbHbHbH.daoao#v#6.RbH.NaA.c.o.c.o.c.o.c.o.c.BaAaAbHbH#6.R.Na1.NbQaCbQbgaNbW.FaTaT.Q.y.y.8ax#X#X#O#O.V#O#x.7#x.7bJ#d#d#dbIbYaBaBbYaBbYbYbYaBbYbYaBbYaBaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYaBbYbYbYbYbYaBbYaBbYbGaD.8.8amamavbgambQambNbNbHbZaNaoaoaU.d.R.vbHaAaA.o.o.c.o.c.o#VbnaiaA.v.v#6#6#6#6b1#obn#2bQbgambWaT#waT.y.Q.Q#b.S#X#O#3.V#H#xbJa0.7.7#ObJbYaBaBbYaBaBaBbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYaBbYbYaBbYbYbYbYbYbI#d#l.8#l.8amamamaNambQbNbHbH.dao.H.dao.v.R.Zai.Ab2bnbi.obibnbnaib0.vbH.Rao#6#6ao#6aAaCbQbgbgambW#w#g#b.y#b#bax#X#O#O#O#xaL#x##.7.O.7#J#JaBbYaBaBbYaBbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbYbYbYbYaBbYbYaBbYaBbYbYbI#J#l.8am#lamambQambQbNbHbZbH.dao.d.d.vbH.v.Abkbibi#cbibibib2.Ab0.v.v.Raoaoa1aNaNbTaCbgbQambWaT#waT.8.y#b#b.S#X#O#OajaLaL#x#dbGbJbJ#J.UbYaBbYaBbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYaBbYbYaBbYbYbYbYbYbYbI#d#l.l.8amamamamambQbNaNbNbHaNbH.v.d.RbHb0.Abi#c#cbibibibi.A.Ab0.v.d.v.d.HaoaNbgbjbgav.nambW#waH#baT.yax#gaL#OaL.7#O.laLbJbI#d#d#JbYbYbYaBbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYbYbYbYbYbYbYaBbYbYbYbYbI#daD#l#l.8.8amambQambQbQbQaNbQbNbHbZbQbTbn.Abibibibibibibi.YbCb0.v.d.dao.HaoaNbgaNbTbjambWaT#w#w#bbWaH#b.S.SaLaj#x.l.l#3#d.JbI#d.UbYbYaBbYaBbYbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaBbYaBbYbYbYaBbYbYbIbGaL#l#l#l.8#lamamambQamambQbQbQbHbTbnbn.Abi#cbvbvbibibi#cbibnbC#6#6bHao.d#6bgaNbgbTamaTaT#waH#b.8.8.8.laL#Q#3#3#l.8aL#J.JbIbIbIbYaBbYaBbYbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbYbYbYbYbYbYbYaBbYbYbY.j.JbGaDaD#l#l.8.8.8aL.8amambQambQbQbgambnbnbnbvbv#ta4bvbibibibi.AaiaA#objbT.DbH#IbgbHbjam.QaTaTaH#w.8aHaHaL#Q#OaY.l#l.l#QbI.J.JbIbIbYbYbYaBbYbYbYbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYaBbYbYaBbYbYbYbYbY.j.JbIaD.laD#l.l#l.l.l.i.iamamamambgamaAanbn.obibvbia4bvbibvbibi.AbTaAbraA.n.DbjbjbHambWbWaT#g#waHaHax.l.l.l#OaY.S#P#l#Q#d.j.jbI.JbIbIbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYbYbYbYaBbYbYaBbYbY#D.j.j.JbGaDaLaDaDaD#l.l.l.i.iamamavavam.y.obiaAbi#cbvbv#cbv#cbi#cbiai.B#obW.ybjaNararbWbWaT#gaxax.l.l.l.laD#O.V#X#l#l#Q###D.j.J.JbI.JbIbIbYbYbYbYbYbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaBbYbYbYbY#..I#..j.j.j.j#daLaLaDaDaDaD.l.l.i#l.8am.8#L#g.Q#bbi.cbibi#cbibibibibibn.o.B.Q#K.ybW#o.i#w#f.8bW#bax.l.l.l#Q#QaL.V#XaH.0aDbI.j.j.J.J.J.JbIbIbI.JbYbYbYaBbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbYaBbYbYbYbYbYaBbY#.#..I.I.j.j.j.jbIaDaL#OaDaDaD.l.l.8.8.8.8#lav#L.Q#g.obi.o.o.obibi.o#Y.o.o.B#g.Q.y.y.Q.QaT#waT.8aHaH.l.l#Q#QaD#Q.VaL.8.0aDbIau.j.j.j.j.J.J.J.J.J.J.JbYbYbYbYaBbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbYbYbYaBbY.m.maO#.#..j#..j.j#..jaDaDaLaL#JaD#J#l.l.l.8#waH.o.o#bbs.o.o.o.o.o.o.o.o.o.c.o.Bbs#b.Q.y.Q#gaxaxax.l.l.l#Q#Q#J#J#JbJ#O#l.0aEbI#.#..j.j.j.j.J.J.JbIbIbI.J.jbYbYbYbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBaBbYaBbYbYbYaBbYbYbYaBbYaBbYbl.P.m#.#.#.#..I.j.j.j.j#.bI#laDaDaL#JaD#J#laL.8.l.8aH#b.obsbs#b.o.o.o.o.c.o.c.obsbsbs#b#b.y#b#g.Sax#Q#Q#Q#Q#J#J#J#Q#QaL#l#laD.Jau.j.j.j.j.j.j.j.J.J.J.J.J.J.J.jbYbYbYbYbYbYaBbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbYbYaBbYbYbY#T.P.P.maOaOaOaO.j#.#..j#..j.j.PbG#l#l#l#JaD#JaDaDaL#l.laH#baH.o#b#Hbs#H.o.o.o#b.obs.o#b#g#b#b.y#b#b.l#Q#QbJ#Q#JaD#J#J#QaD#la9aE.j#.#..j#..j.j.j.j.j.j.j.J.J.J.J.J.J.jbfbYbYaBbYbYbYaBbYbYbYaBbYaB",
"aBbYaBbYbYbYbYaBbYbYbY#Tbl.m.m#.aOaO#..I.j#.#..j#..j.j#.#..J#d#l#laDaDaD#JaDbJ#Q#Q#Q.l.laD.S#b#0.o#Q.o#Q#0#b#bbs#b#b#b#b#b.l#Q#Q#Q#Q#J#JaD#JaDaDaD#la9bGbRaO.I.j#..j.j#..j.j.j.j.J.j.J.J.j.J.J.J.J.J.jbfbYbYbYbYbYaBbYbYaBbY",
"bYaBbYbYbYaBbYbY#Tbl.P.maO#.aOaOaO#..P.j.P.j#.#.#..j.j.j.j.P.j#d#lbG#laDaD#JaD#JbJ#O#Q#Q#b#0#Q###H#Q#H#Q#Q#Q#b#Qbs#Q#Q#Q#QbJ#Q#J#J#J#JaD#JaDaD.laEaEbI#.#.#.#..j#..j#..j#..j.j.j.j.j.J.j.j.j.JbI.J.J.J.J.J.jbfaBbYbYbYaBbYaB",
"aBaBbYaBbYbY#Tbl.P.maO.m#..P#.aO.P#..j#..j.P#..j#..j#..j#.#.#..jbG#lbG#laD#daD#JbJbJbp#O#Q#H#Q#0#H#Q#H#Q#0#Q#H#Q#H#Q#HbJbJ#J#J#JaDaDaD#daDaDaDaEbGbRaO#.au.j#..j#..j#..j#..j.j.j.j.j.j.j.j.j.j.J.J.J.J.J.J.J.J.J.j#.bYbYaBaB",
"aBbYbYaBbl.P.m.m#..m.m.P.m.PaO.P#..P.j#.#..j#.#.#..j.j.j.j.j#..PbIbG#lbG#l#laD#JaD#JbJbJbJ#O#H#H#H#H#H#H#H#H#H#H#QbJbJ#JbJ#J#J#JaD#JaDaDaDaDaEbI.I.P#.#.#..j#.#..j#..j#..j#..j.j.j.j.j.j.j.j.j.j.J.J.J.J.J.J.J.J.J.JbfaWbYaB",
"aBbYaB.m#.#.aO.m.m.m.m.m.m.m.P.P#..j.j#..j#.#.#.#..j.j#..j#..j.P#.bI#da9#l#laDaD#J#J#J#J#ObJ#O#H#H#H#H#H#H#Q#H#QbJbJ#Q#J#JaD#JaD#daDaDaDaDbG.JaOaO#.#..j#.#..j#.#.#..j#..j.j.j.j.j.j.j.j.j.j.j.j.j.J.J.J.J.J.J.J.J.J.j.j#Dau",
".m#.#.#.aO.m.m.m.P.P.P.P.P.P#..P#.#..j#..j#.#..j#..j.j.j.j#.#..j#..P.j#lbGa9#lbG#laDaD#QbJbJbJ#ObJ#H#Q#Q#Q#Q#Q#QaD#JaDaDaDaDaDaDaD#laDaDbI.I.m#.#.#.#.#.#.#.#.#..j#.#..j#.#..j.j.j.j.j.j#..j.j.j.j.j.j.j.j.J.j.j.j.j.j.j.I.I",
"#.#.#.aOaO#..P.m.m.m.P.m.P.P.P#..j#..j#.#.#.#.#..j.j#..j#..j#..j#.#..PbIbG#la9#lbG#l#daDaDaDaD#QaDaDaD#QaDaDaDaDaD#l##aD##aEbG#lbG#QaD.j.P.P#.#.#.#.#.#.#.#.#.#.#.#..j#..j.j#..j.j.j.j.j#..j#..j.j.j.j.j.j.j.j.j.j#.#.#.#.#.",
".IaO#..P#..P#..m.Pbh.P.m.P.P#.#..j#..j#.#.#.#.#.#.#..j#..j#.#.#..j#.#..PbGbG#lbG#la9bG#lbG#l#l#l#l#l#l#laE#laEaEaEaE#la9a9bGa9aD#QbI.I.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..j#..j#..j.j.j#.#..j.j.j.j.j.j.j.j.j.j#..j#..j.I#.",
".maO.P#..P#..P#..P.Pbh.Pbh.P#..j#..j#.#.#.#.#.#.#..j#..j#.#..j#.#.#.#.#..P.J#d#lbGa9a9bG#lbGa9aEaEaEaE.0aEaEa9a9a9a9a#a9aE#laD#d.I.P.P.P#.#.#.#..P#.#.#.#.#.#.#.#.#.#..j#..j#..j#..j#.#.#..j#..j.j.j.j.j#..j#.#..j#..j#.#.#.",
".m#..m.P#..P#..mbhbh.P.P.P#.#..j.j#.#.#.#..P#.#.#.#..j#..j#.#.#.#.#.#.#..P.PaObGbG#lbGa9a#a#bGa9a9a9a9a9a9a9be.fa#a#a9bGbG#d.I.P.P.P.P#.#..m.P.P#..P#.#.#.#.#.#.#.#.#.#.#.#..j#..j#.#.#..j#.#.#.#.#.#.#.#.#..j#..j.j#.#.#.#.",
".m.P.P.m.P.P#..P#..Pbhbh.P#.#..j#.#.#.#..P#..P#.#..j#.#..j#.#.#.#.#.#.#..P.P.P.jbG#da9bGa9a#a9a9aEa#a9a#a#a#bea9a#a9##aD.J.P.P.P.P#..m.m.P.P.P#..P.P#.#.#.#.#.#.#.#.#.#..j#.#..j#.#.#.#.#.#.#.#.#.#..j#.#.#.#.#..j#.#.#.#.#.",
".m.m.m.P.m.P.P#..P#..P#.#.#..j.j#.#.#.#..P#.#.#.#.#.#..j#..j#.#.#.#..P.P#..P.P.P.P.jbGa9bGa#a9a#a9.0a9a9a9a9bea#bGbG.J.P.P.P.P.P.P.m.m.m.P.P.P.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..j#..j#.#.aO",
".P.P.P.P.Pbh.P#..P#.#.#.#.#..j#.#.#.#.#.#.#..P#.#.#..j#.#..j#.#.#.#..P#..P.P.P.P.P.P.PbIbGbGa9aE#P#la9a9a#a9bGbIbR.P#T#T.P.P.P.P#..P.P.P.P.P#..P#.#.#.#.#.#.#.#.#.#.#.#.#.#..j#.#.#.#.#.#.#.#.#.#.#.#..j#..j.j#..j#.#.#.#.#.",
".Pbhbh.P#..P#..P#.#.#.#.#..j#..j#.#.#.#.#.#.#.#.#..j#.#..j#..j#.#.#..P.P.P.P.P.P.P.P.P.PaObIbGaD#l#laEaEa#bI.I.Pbl#T.P.P.P.P.P.P.P.P.P.P.P.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P#.#.#..j#..j#..j#..j.j#.#.#.#.",
".P.P.P.P.P.P#..P#..P#.#.#.#.#.#.#.#.#.#..P#.#.#.#.#.#..j#.#.#.#.#.#..P#..P.P.P.P.P.P.P.P.P.P.I.ja#bG.JbRau.m#T#T#T#T#T.P.P.P.P.P.P.P.P.P.P#..P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..j#.#.#..P.P.P#..P#.#.#.#..j#.#..j#..j#.#.#.#.#.",
".Pbh.P#..P#..P#.#.#.#.#.#.#..j#.#.#..P#.#..P#.#.#.#.#.#.#.#..j#.#.#.#..P.P.P.P.P.P.P.P.PbI.J.P.P.I#D#.#.aubh.P#T.P#T.P.P.P.P.P.P.P.P.P.P.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P.P#..P.P.P#.#..j.j#.#.#..j#..j#.#.#.#.aO",
".P.P.P.P.P#.#..P#.#.#.#.#.#.#.#.#.#.#..P#..P#.#.#.#.#..j#..j#..j#.#.#.#..P.P.P.P.P.P.P#d#J#dbIbIbI.J.j.j.J.jbl.P#T.P.P.P.P.P.P.P.P.P.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P.P.P.P#..P#.#..j#.#.#..j#.#..j#..j.j#..P",
".P.P.P.P#..P#..P#.#.#.#.#.#.#.#.#..P#..P#..P.P#.#.#.#.#.#.#..j#..j#.#..P#..P.P.P.P.PbI.7.7.7.L.7.L.L.7#d.J.Jbh.P.P.P.P.P.P.P.P.P.P.P.P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P.P.P.P.P.P.P.P#.#.#..j.j.j#.#..j#..j#.#..P.m",
".Pbh.P.P.P#..P#..P#.#.#.#.#.#.#.#.#..P#..P.P#..P#.#.#.#.#..j#.#.#..j#.#.#..P#..P.P#.#J.7.7bU.7bU.L.7.7a0.7.7bfbh.P.P.P.P.P.P.P.P.P#.#..P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P.P.P#..P.P.P.P#..j#..j#.#.#..j#.#..j#.#.#.",
".P.Pbh.P.P.P#..P#.#.#.#.#.#.#.#..P#..P.P#..P.P#.#.#.#.#.#.#.#.#..j#.#.#.#.#..P#..P.7.L.7.L.7.L.L.7.7.7.7#J#d#d.P.P.P.P.P.P.P.P#..P#..P#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#..P.P.P.P.P.P.P.P.P.P#.#.#..j#..j#.#.#.#.#.#.#.#.#."
};

/* XPM */
static char *lf1_256[] = {
/* width height ncolors chars_per_pixel */
"110 150 256 2",
/* colors */
"   c #C39063",
" . c #433224",
" X c #A67F4D",
" o c #885729",
" O c #8E4B2F",
" + c #9B6A35",
" @ c #C59B72",
" # c #968B68",
" $ c #24170C",
" % c #573D1D",
" & c #856433",
" * c #8CA4AA",
" = c #051715",
" - c #6C5E42",
" ; c #A8CACC",
" : c #946C45",
" > c #87664C",
" , c #292114",
" < c #BED6D1",
" 1 c #020C08",
" 2 c #865220",
" 3 c #8D4B1D",
" 4 c #B4794D",
" 5 c #A06B36",
" 6 c #0B110A",
" 7 c #C08B5C",
" 8 c #856543",
" 9 c #89571C",
" 0 c #A2734F",
" q c #8D5937",
" w c #ADCDCD",
" e c #A06A43",
" r c #0D170F",
" t c #845F2E",
" y c #D1875C",
" u c #8E5D24",
" i c #99AFB6",
" p c #010E0D",
" a c #869BA0",
" s c #CB8156",
" d c #22312A",
" f c #A4BBC4",
" g c #9A5D33",
" h c #433C30",
" j c #ACD3CF",
" k c #845C3B",
" l c #A2713E",
" z c #6B5940",
" x c #BE7349",
" c c #CFEBE4",
" v c #544430",
" b c #0E0C09",
" n c #99906D",
" m c #B96B44",
" M c #AC7641",
" N c #877858",
" B c #2A170A",
" V c #8C6232",
" C c #362919",
" Z c #0B1B13",
" A c #D18E58",
" S c #040F0C",
" D c #38463F",
" F c #7C6743",
" G c #D19365",
" H c #9EBBC4",
" J c #6E746A",
" K c #050203",
" L c #7A5D41",
" P c #A67F5F",
" I c #5E726E",
" U c #42260A",
" Y c #835936",
" T c #7D583A",
" R c #BB794C",
" E c #0B140C",
" W c #987E5B",
" Q c #834215",
" ! c #7A704E",
" ~ c #321E0E",
" ^ c #79572C",
" / c #8D5E39",
" ( c #292726",
" ) c #1D160D",
" _ c #CB9162",
" ` c #333933",
" ' c #A39376",
" ] c #28261B",
" [ c #94562C",
" { c #7D5D33",
" } c #5B4A2C",
" | c #7B4A10",
".  c #18201F",
".. c #291D12",
".X c #B37347",
".o c #68431B",
".O c #96AAB5",
".+ c #201C13",
".@ c #D79467",
".# c #010E05",
".$ c #AE6B42",
".% c #524B44",
".& c #A27440",
".* c #515F5A",
".= c #8C6B48",
".- c #846C4A",
".; c #A88F6A",
".: c #021409",
".> c #5F5540",
"., c #887651",
".< c #615E4F",
".1 c #472004",
".2 c #6E481D",
".3 c #B7DBD8",
".4 c #76431B",
".5 c #AC5C39",
".6 c #2F302B",
".7 c #6A533A",
".8 c #A15B38",
".9 c #2E2C2A",
".0 c #684D38",
".q c #A99A7B",
".w c #95724D",
".e c #B5CECC",
".r c #5D4C37",
".t c #21201D",
".y c #02120F",
".u c #54350D",
".i c #9D6537",
".p c #7C3D10",
".a c #AB7348",
".s c #7A4E2F",
".d c #171C13",
".f c #8A8A70",
".g c #010704",
".h c #422B0F",
".j c #C47950",
".k c #291107",
".l c #C5DFD8",
".z c #513721",
".x c #2F261A",
".c c #B1C8CB",
".v c #A36540",
".b c #AEC4C8",
".n c #43453E",
".m c #7E572C",
".M c #ABBEC5",
".N c #8A6B3B",
".B c #9C7350",
".V c #956532",
".C c #010B07",
".Z c #0F1F18",
".A c #8D6634",
".S c #532C05",
".D c #000506",
".F c #9CB5C0",
".G c #8A7048",
".H c #240B05",
".J c #76593B",
".K c #04170D",
".L c #C88B5A",
".P c #966440",
".I c #DFFCF1",
".U c #A1784E",
".Y c #666756",
".T c #7A7663",
".R c #BD854F",
".E c #2F2A20",
".W c #7A6142",
".Q c #16170E",
".! c #835C2D",
".~ c #D99B71",
".^ c #645940",
"./ c #B37945",
".( c #946B37",
".) c #A5C2C5",
"._ c #212012",
".` c #BC865B",
".' c #070A09",
".] c #AA733C",
".[ c #835F3A",
".{ c #945C2D",
".} c #021511",
".| c #2F3530",
"X  c #A7C6CA",
"X. c #A4BEC7",
"XX c #967953",
"Xo c #513F2D",
"XO c #795226",
"X+ c #353F39",
"X@ c #956031",
"X# c #844C1D",
"X$ c #A5B5BE",
"X% c #AAA598",
"X& c #1F1109",
"X* c #28221F",
"X= c #1F2720",
"X- c #373127",
"X; c #897F5D",
"X: c #090707",
"X> c #02080A",
"X, c #C38054",
"X< c #D38E67",
"X1 c #7A482A",
"X2 c #AF8654",
"X3 c #958662",
"X4 c #9BB0C1",
"X5 c #957141",
"X6 c #A6C2CF",
"X7 c #A1785A",
"X8 c #956741",
"X9 c #AB7850",
"X0 c #B0D5D2",
"Xq c #341606",
"Xw c #9B6D4A",
"Xe c #000101",
"Xr c #434C46",
"Xt c #6E340A",
"Xy c #875533",
"Xu c #785338",
"Xi c #170907",
"Xp c #3B1F06",
"Xa c #A98868",
"Xs c #021106",
"Xd c #172014",
"Xf c #443112",
"Xg c #282C28",
"Xh c #1D1910",
"Xj c #693D12",
"Xk c #A06E48",
"Xl c #B27F53",
"Xz c #17110A",
"Xx c #B27E49",
"Xc c #768071",
"Xv c #9A6D38",
"Xb c #7A8E8C",
"Xn c #4F554E",
"Xm c #B5D6D3",
"XM c #AC7843",
"XN c #06201A",
"XB c #A17742",
"XV c #BB8055",
"XC c #6E4E27",
"XZ c #977442",
"XA c #97A3A5",
"XS c #BB7F4B",
"XD c #9A6A45",
"XF c #0B2822",
"XG c #C48757",
"XH c #87653C",
"XJ c #AC7046",
"XK c #D9F6EC",
"XL c #A97139",
"XP c #A66C40",
"XI c #8E5D2F",
"XU c #AF653F",
/* pixels */
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I c <.eX% iXA aXAXAXAXA.M.l c.lXKXKXKXK c.I.IXKXKXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK c.l.lX$Xc J.<.*XnXn.%Xr.nXrXrXn.<.*XcXbXbXb a <XK.l.c a.e.e < c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.l.bX$Xb I.Y.%.n hX+X-.9.9X-.9.9 ( (.9.9.9.nXn.%.* J.OX4XbXb I.Y JXc aXA.e c c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK < a aXcXn.nX-.|.9.9 (. .t.  ).t. . .Q.t..X*X- . h `.% JXbXb JXn.%.% JXc IXcXcXA <.lXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.l.b * * I D `.9.9 ( (X*.t =.  bX>.' =.  b.Q.t (X*.9 .X* (.9.* I.* h h.nXnXn.*.*XbXcXcXbX$.lXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK c.cX$XbXr.|.9X=.E.9.9 (.t.Q = = = b = = bXi =X*.tXi.EX*X*.H ( ( h.*.nX*X-.n.%.n.%.*.%.*.Y.Y JX%.lXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK.M.O a IXr `.9.9 (X*X*.t.t.  p = =X>X> b b. Xi bX&.QXz.kX*XiXhX*X*X*X+ ` ~X-.9.9X- h.n.nXn.<.* JXb a.l c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK.M.OXb IXrX+.|.9 (.+ b.Q.  =Xi.  = bXi = =X>. X&XiXh =.QXi.tX*Xi.t.tXi. X*.kX*.9.x.9 . h.n h.*XcXbXb I a.c cXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IX$ a a IXr `Xg (. .d. X> bXiX>.t.H.t b b bX>X>Xi. XiX* b. Xz.H..X> = bX& bXe ) C CX- ~.9 `.9 h.*XnXrXrXn.YXcXb.c c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.M * a I.*.|.9X=. . .t.H.k $X*. X*..Xi.Q bX:X>X>X>X>Xi. X:.HXiX*X>X>X>XiXiX: KXh ] ~.x C .X-X-X-.9 h.9X+.nXrXnXcXb i.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I <.) * I D.9.9 (.t.tX*.9.9.x.EX* (X*X*.t $.kXi.D KX: )Xz bX:XiX:Xi KX> K.DXeX:.gXsXz $ B..X* (X* C.9 ..9 .X- h.%.*XbXbXA.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I c.b * I D.|.9 ( (X*X*.t (X* $...k.HXzXzXi.+X&X:.DX>X>XiXi bX:X:X:XiX: KXeXe KX: bXiX&.k.k.Q.+.tX& $X*X*.xX* C.9.9.%Xn IXb i c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I < a IX+.9.6.9X=.E.9.t.t.tXhXi $.kX&XzXzXhX*Xh b.y 1X>.' b.' KX:XiXi bXe KXeXe.gXz.H..XiXi $.x $.... B B ~ C ~ C.x (.n.% JXbXb c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.) I D.6.9.9 (X*X* (.t.+ ) )X&.HX*X*X*.+X*..XiXi S.yX> EXi.'.gX: bXe KXeXe KXe.gXsXiXi KXiX& B.... ,.x C C C CX* C ~X* `.% IXbX$XK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I ;Xb IX+.|.9.9X*X*...dXh $..X*X*X*...E.EX* ,X* b.'.'.y p K bX: K K.g KXeXeXeXeXeXz bXeXe.QX& b 6XzX&.. ~.x C C C.x.x.x...x.9.n.YXc.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I < HXbX+X+ `Xg.E.xX*...t.QXhXi B.xX- C.EX-X*.k ) bX> KX>X> KX> K.D K.g.g KXeXeX:XiXi.gX:X:.g b 6XiXiXiXi...EX* $X*.x.. ) $ B.xX-.n.<XAXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I c.cXbXr `.|.EX* ,X*X*X*X*.tX*X*.t ~ ~ . (X- CX&X&.QX>.D.DX>X>.D p KXe K K K.gXi.H B.kXiXiX:X:XiX&.H.H.k BXq.xX-X- ( (.E.E.KXz )X*.n.n.<.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK.bXcXrX+.|Xg.EX*X*.+...+.+X* $.....kX* . (X*...kXi.+.'.D KX> 1.'X> K.D K K.DXi B ~ C BXiX:XiXiXiXi KXi.H.H $ B C.9X-X-.9.E.EXd.Q.Q `.%.nXb <.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.l i.c.O.*Xr.|.9Xg (.x...tX*.+.+...tXiXi.HXqX* ~X* ~...HX:Xi...Q.D KX>.D.D.D K.g bXe.HXq CXfX&.HXi.H KXeXiXiXiXiX&Xz $X&X&.E.E.x._X-.E._ ,.E.n.%.YXA.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.l a a * aXr.|.9XgXgX*X*Xh.+.t $ BXhXzXhXiXi.H.H.k.H.k.k.HXiXiX*X*.H.D.DXeXe KX>X:XiXi.H.k ~XfXq.k.k.HXiXi bXi.HXiXz B ,Xs.g.+.9 ]._ ,X- ].E (.E `.nXcX$.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.IXK a *X6Xb.*.|.9 (X=. .d.+.+.d )X&X&.tX*X*. XiXi.H...9X*.H.H.HXiXz.H.H.DXe.DXeXe.D.H.HXq.1.1XfXfXp U ~ ~.HXiXiXi B B K.k ,.+ 6X:.+.x 6._ C ,._._.. ].9Xn a <.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.IXK.MXb a IXn.| d (. X=.  r.+.Q =.Q bX&.+X*.tX&.H.H $.k C ~.HXqXq.H.+X&X:X:X: K.DXe.H.kXq.1.uXjXt.S.u.o %.1Xp.H.H.H.H.kXi.H.. ].dX>Xz ~ rXzXh , $Xh...+ ,.9.* JX$ c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.l I.*Xn DXg ( (.  =. .  =XzXz p pXzX&.t.t.tX* (...H.kXqXqXqXqXq...H.HX&.H.HXiXi.HXqXq.1Xt |XO |XjXO { ^.S.S.1XqXq.kXpXqXq...9 ].QXs B ).: r $._Xz $Xh.+X* h.n J.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I cXbXnXr.|.9 (.t.tXN =. .ZX> p pX> SX&.+.t.tX*.k...kXqXq ~Xq.1.1XqXq.k.kXq.HXi.HXq.1.1XpXt o o 2 2 /X@XD V | |.S.S.1XpXpXp ~X-.E.E BX&Xz.Q.Q.QXz._.Q EXhXd.dX*.|.% a.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.IX0 IXr.n.6X=.t.d.t =.y = =X>X>X> b.QXz $.+X*.9 ~ ~ ~ ~Xq.1.1.1.1.1.1Xq.1Xq.HXqXq.SXt.SXt 3 g.i [.( lX8X8.i 3 9.pXt.SXpXpXp ~ ..E.xX&X&XsXz )Xz E ) $._ r =.QXh `.%.*.M c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I cX..* DX+Xg. .Z.Z.  = = = pX>X>.DXiXzX&X&X* ~.x ~ . ~.1.1.1.1.1.S.1.1Xq.1.1.1.1Xj.2.4 3 Q [XkXPXv e eXv.i l.V.{ 2 |Xt UXpXpXp C.x C ,Xz )X&XzXz.#Xz )Xh 6.K.d._.  D.* J <.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I w IXr.|Xg. . .Z.'.  = =.' bX> pX> bXzXi $.x C ~ ..z.1.1.1.1.S.S.S.1.1.1.1Xt.SXtXyXI [X@ eXD.aXx XXM M l l.] 5.v u | |Xj U UXp C ~ , ~._ ).Q 6 6 6Xz b E.Q.Q = d (X+.* a.c c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I c IXr `Xg. .  Z = K = r.yX>X>X>X>.'.CX> b...xXq C U.S.1.SXtXtXtXt.SXtXtXt.p.pXt 3.vXk.aXMXxX9XMX9XxXxXxXM././ M M.V.4 u |.u.S.h.h ~ BX& ~ $._ EXzXz b.#Xs.QXz.Q (X*.9Xn I * <.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.IXK.O.*.|.6 (XF.  r SX> S.yX> 1X> p.'.'.g b b.kXq ~ U.1.1XtXtXt.p.p.p.p Q Q 3.{ [.{XPXlXV 7XxXVXGXxXxXSXSXSXSXS././XM.V 3X@ 9 |.S.h .Xp BXz ) B ).QX&X:Xs.#Xs 6Xi.Q._.  (X+ IXb.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I c IXr d dX=.  = =X>X> S S SX> p.'X:.D K.'X& ~XpXf.h.1.SXt | 3 9 3 9 3.5.5 5XJ.aXM.R 7  .L 7 7.L.L.RXl.RX,.RXSXSXS./ 5 [.iX@ |Xt.h.z CXq BXz.Q._ $Xz 6 6.#Xs.Q b.Q r rXgXg.* * a.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I w.*X+ dXg. .  =.yX>.y p p.'X>X> pX>X: bXi ~ ~.hXf.z.SXtX#XI.{.{ g.]./.]././XVXS 4 _.@ G G G A _ _.@.L.L.RXG s.RXS./ 5.i l 5 u |.SXfXf B.kX&XzX&X& 6 $ $.# 6Xh.Q.Q.K.Q (.| `XbXb.MXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.IXK I D d d (.  =X>X> r S.:X> S 6 E.'.D bXi.. ~Xq.hXf.SXt Q.{.iXPXP 4 RXSXGXGXVXG.R.L G G G.@.@.@.@ G G A _ AXG.RXGXS./ 5 5 5XL 5 9Xt.S.S C.H.k B.kXi $._ $.Q ,.QXz.:.KXz r.9.n.n.O i c.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.lXn.| dXF. . .  S.' S S S S SXzXz E bXsXz B BXp U.S.S.4XI 5.]./Xx.R.R 7.L.L.L.L 7 G G G.~.~.~.~.@ G _ G A A A A.RXS M.5XLXL.]XL.V |.u.u UXp B.k.H.HX&._ ).Q $ 6.#Xs E.'.y.t h.9Xb.M cXK.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I * D dXFXFX=. XN b S.y S.DX>.'XzX&X& bXz.k BXq.1.S.SXt 3 5 M 4XVXG.L.@ G G _ G _ G.~.~.~.~.~.~.~.~.~.~ A.@ G.L.L.R.R./.].].$./.].] u |.S.S UXp B.k B.kXp._Xz.#XsX:Xs.#.# r..X*.9.nXb.MXKXK.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.IXK.* d d d d. .  = = p.' = 1 1XiX&.kX&.kX&XqXqXp.1.SXt |.{.iXxXG 7.L _.@.~.@ G G _.@.~.~.~.~.~.~.~.~.~.~.@ G G G A.LXS.X.X.X m.X.]XL + 9Xj.S.1.1XpXq ~Xp B B.k 6Xz b.:Xi r.Q.+ b.tXrXb.M.l c.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I * D d d dXFXNXN = = SX>.' b 6 ) B $ B $XqXpXpXp.S.S | 9Xv M 4.`.L _ _.@.@.@ G _ G.~.~.~.~.~.~.~.~.~.~.~.~ A G G A A.R.]././ M./.]XLXL.V | |.S.SXpXpXpXpXp B BX&X&Xz.d E E.K.: 1.Q.9 I.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.IXK.* D.| d. . . . .t.+ E.#XiX& ) $ B.k.k B.1 UXp.S.SXt Q uXkXxXS.RXG G G G.@ G _X<.~.~.~.~.~.~.~.~.~.~.~.~ G G.~.@ A _.R.iXS././ MXLXLXLXL 9 |XtXt.SXpXp UXpXp ~ )Xz.Q.Q._ r r.'X>X>.  `.OXK.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.F D ` dXFXN. . . .t.t bXz $X& B B ~.kXp.S U U.S.SXt | u 5XJ./ 4.R A _ G _ _ _.~.~ @.~.~.~.~.~.~.~.~.@.@.~.~.@.@.~ A A.` gXl././.].].]XLXL 9 9 | |Xt.S U.1 U UXp ).:._.d ) ).g = =X>. .9.n.O.l.I.I.I.I.I.I.I.I.I.I.I.I",
".I.IXK I d dXFXN = =.t. .  ZX= , CXpXpXp.1 UXf.u U.1Xt.SXjXIXvXM.aXS RXSXGXG.L _ _.~X< @ G @.~.~.~.~.~.~.~ G G G.~.@.~ G.LXG.R.i.X./Xx.] M./XLXLXL u 9 | |XjXt.S U U.h ~Xz r._.Q.tXd p =.' b (.nXnX$.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I iX+ dXFXFXNXN.  r. X*. X* C .XfXf.u.u.SXjXfXp.SXt.u u.V.&XxXS.R.j.RXGXG.L    X<  .~ @ @ G G.@ A.@.@.@.@ G.~ G.@.@ G.LXGXS 5.$./ 4XMXJXLXLXLXLXL u 9 | |.pXt.u UXp._._Xs._ ]Xd.6 ZX>.'X> =.9XnX4.l.I.I.I.I.I.I.I.I.I.I.I",
".I.IXc dXFXFXFXF.  p.ZX*.t (.E .Xo %.u %Xj.u.S.h.S.SXt.4X5.&.X.RX,.R.R.L.L.L _.`   GX< G.~ @ _ A A G.@ G.@.@ A A.@.@.@ _ A sXSXL.$.].$XJXL MXLXLXLXLXL u 9 | | | |.uXfXf ~Xz ].6 d d.6 = p = p. .9XbXK.I.I.I.I.I.I.I.I.I.I.I",
".I.I.* dXFXFXFXF =X>.  (X= (.x ..zXf %.uXj |XjXj.uXt | |X5.aXM.R.R.RX,.RXGXGXG  X< _ @ @ @ G G A G A.L A.@ A A.@.@.@ A A.RXSXSXLXU MXLXLXL M MXLXLXL 5 5 9 9 9 | | |.u.u CXd ] `X+.|X-.|.}.y p =. .| a c.I.I.I.I.I.I.I.I.I.I",
".I H D dXFXF. . X>X>XgXg (X= ,.E %Xf | | | | &.N | 9 u 9XvXxXxXS.R.R.R.R.R.RXG.L   _ G _ _ _ _ A G.@ A A A A A G A A A A s.jXS mXUXLXL.]XL.]XLXL 5XL 5XL u 9 9 9 | |Xj %Xf ].+.n D.9X=XgXd.} = =. .9Xr a c.I.I.I.I.I.I.I.I.I",
".I aX+XFXF d. XNX>.Z.| (. Xd C .Xf %.2 | 9 u.N & 9.(.A.V MXM.R.R.RXxXS.R.RXSXS.RXG.L.RXG.L A _ G _ A A.@ A A A.@.@.@ A s.j.j.j./ mXLXL 5XLXL.]XLXLXL 5 5 5 u 9 9 9 |Xj %X-X-.Q.6XrX+X=XdXd Z.} =. .| I.O <.I.I.I.I.I.I.I.I.I",
".I I dXFXF dXN =X> (.6.+.d ].xXfXf.u.o | u u &.A.(XBXv l MXxXx.RXxXxXxXS.R.RXS.R.R.R.R.R.L.R.L A A A A A A A A A A A AXS A x x././ MXL 5XLXLXLXLXLXLXLXL 5XL 9 9 | |Xj % . C ].| D.|.|Xd rXd Z. . . .*.O c.I.I.I.I.I.I.I.I.I",
".I IXF d dXF = pX: (.t.t ] $ $ ~Xf.u | |.A.(.(.(XBXBXvXB MXxXxXx.RXMXx.RXS.RXSXS.R.R.R.R A A A A A.R A A A A A A A A A sXSXSXS x././XLXLXLXLXLXLXL.]XLXL 5 u u 9 9 |XjXf h C._XgX+ `.|X=.K.#.d.Z =XNX+ aXK.I.I.I.I.I.I.I.I.I",
".I I d dXFXF =Xs.QXd.t._._ 6._ UXf.o.2 9.AXv.(XvXB.&XBXM.]XMXxXxXx./XxXSXS.R.R.RXG A A A A.R A.R A.R A s A A.R A A A AXS.j AXSXS./XL./.]XLXLXL 5XLXLXLXL uXL u 9 9 | |.uXf CXd ,.9.9.|.|.: E.Q =XN = ( I <.I.I.I.I.I.I.I.I.I",
".I D DXFXFXF = =.+. X=XhXs 6 B.h %.2 | ^ uXvXZXBXZXvXM.].]XMXxXxXxXxXxXS.R.R.LXG.L A     _ A A A A AXS AXS s A A A A A AXS AXSXSXS.]././XL.]XLXLXL 5 5XL 5 u u 9 9 | |XfXf.EX=._.E.9.9 hXd ZXd Z. .  (XnX4 c.I.I.I.I.I.I.I.I",
".I D D dXF.  = r.tX=Xd.:.# 6._Xf %XC | u.A.NXZXZ.(XvXLXBXL.]XxXxXx.RXx.R 7 7 7.L 7 _ _ _ _.~ @ A A A A A A AXS A A A A.R A.R A.RXSXS././ M.].].]XLXL 5 5 5XL u 9 9 | |.uXf , ].. ,X* (.9._.K. . .Z.  (X+ I c.I.I.I.I.I.I.I.I",
".IX+ DXFXF. .} r.d.+ rXsXs 6 BXf.u.2 ^ &.A.(XZ.(.(XvXBXLXLXMXxXxXxX2Xx.R.` 7 7 _ _ @ G @.~.~ G G G A A A A A A A A A A AXG.L.R.RXS././XS M M.]XLXL 5 5 + u 5.V u 9 |.o.uXf._ $._ ].+.t.t ( Z.}.t.t.Q. .9.*Xm.I.I.I.I.I.I.I.I",
".IX+ DXFXF Z.y.:.QXh.: 6Xs 6._Xf.2XO 9 & & & u.A.(Xv +Xv.&XMXxXxXx.R.RXVXV.` 7 _   G @ G @.~ @.~.~.@ A.@X< A A.@ G.@.L 7XGXGXVXSXS M./Xx././XLXLXL u + 5 +Xv u 9XO ^ |.uXf._ ) (.9 =. . .t ] S.'.t. .  (.n.O c.I.I.I.I.I.I.I",
".I ` dXFXF.K.K E r.QXd 6Xs.g $XfXC ^ & &.A.A.A.(.(.( +XvXBXBXxXxXlXlXVXlXVXV.`   _X< _ @.~ @ G.~.~.@ GX< _X<X<X<X<  .L  .`.`X,XVXl././Xx 4./XMXL 5 5 u + u + V 9 2 ^.2.oXf ~.QXd (. .dXz E. .Q.g.d.ZXh (XrXb.c.I.I.I.I.I.I.I",
".IX+ dXFXN Z.y.K.d.+.dXs.C.gX& %XC ^ t &.A.N &.A.(X5XvXB l.&X9XlX9XlXlXl.`           _  .L 7 7   _.@ _ _X< _ 7.L _      .L.`XGX,XVXl 4 RXS 4 MXLXL 5 5 u u u t 9 9 ^.2.o.uXp.Q.QX=Xg.d.QX> S.K E.  =.d (Xn a c.I.I.I.I.I.I.I",
".I.|XFXFXN.}.:.KXdX= r.g.gXe $ % ^ { t & & & &.N.NXvXZXvX5.a.U X X 0XkX9X9.`Xa.`Xa.`.`.`.`.RXG.L   A _ _ _ _.`XV.` 7.`      .`.`X2.`Xx.RXxXx.a 5 + 5 5 u uXI t.!XO ^ |.o.u.h.:.:.tXg Z Z.: S.K r ZXN. .tXn a.l.I.I.I.I.I.I.I",
".I dXFXFXN.K 6 r.Z.  E KXe.g , } { ^ t t & t &.N.N.(.PX8XZXB.U.B.w /Xy.s OX1Xy g q.vXDX9XS R.RXG A 7 7.L.L 7XS.X RX9X9X7 0 0 0 0X9 X X.a 0 0 X 5 u u.{.V u.! t.m 2 ^.2XC.uXp E EX=XdXs.K.#.#Xs K = = p. .n.O.l.I.I.I.I.I.I.I",
".IXFXFXFXN.}.:Xs.d E 1.#.g K CXC { { & & & & t &.A t o o q.P :.=.= T.sX1.4X1X1.4X1 q.P eXP.X./.R.L.LX,XV.R.RXx.aXk eXDX8XyX1X1X1 q / /.PXk e e 5X@ u 9 uXI o.mX#XO.!.2.o %Xf.: 6 ] r.#.:.C.'.Q.:Xs.} = =X+.OXK.I.I.I.I.I.I.I",
".I dXFXFXN.}.K.: r E.y.C.# b CXC { ^ & { & F {.N tXyXHXH 8.w PXaXa W.= 8 T YXy 8 / q.P.i.v.$./ x RX,XS./././ M lXvX8X8 >XuX1XuXu.sX1Xu kXw.w q [ 9 2 o o 2XO 2XOXO ^.2.o %.h.#Xz._ rXe.g pXs 6 Z S S S. .9Xb.I.I.I.I.I.I.I.I",
".I dXFXFXF.}.:.: =.}.CX>.#Xz CXC ^XO { F & F { &.m.m /.B P PXaXaXaXa PXXXZ V q / Y & q.V + 5XJ./XSXVXV.RXM.].i.{XI V / / k k L.J k.=.B PXaXaX7.N.m 2 oXO | 9XO |XC ^XC.o %Xf.:Xz E.y p.g 1.# K S.K.K p r `Xb.I.I.I.I.I.I.I.I",
".IX+XFXFXN.}.y.}.Z.y S.#XsXz C } ^ ^ & & F F { ^ { 8.wXX W W W PX7.w.= kXuX# QX1XIXH V V.AXvXMXx.R.L.L.RXxXL.V 9 2 &.[ / / Y YXH :X7 PXaXaXa P WX5 t &XO |X#XO ^XC ^XC } %Xf EXs.K.: 6.#.C 1.: p.K.} =Xi hXb.I.I.I.I.I.I.I.I",
".IX+XFXFXN.} 1.K.Z =.y 6Xs.Q C.o { { F.N F.- F { F.GXXXX.N YXCXo.z h.nX- C.z.o.4.4 / / k.A.( lXx.R A.R.R./XL.V 9XO k.= YX1XjX1 % .XoXo v.0.s k.= :.N.N t 2.2XO.!XCXCXC.2 % C.K.:.: S 1.:.g 1.: p = = = =X+ *.I.I.I.I.I.I.I.I",
".I ` dXFXN.} S.y. X=.y.g.#Xh C }.J { { {.N.-.-.G.G.w.G.sXjXfX- ` ( `.n.n.|Xr.WX1.sXy 8 8 & t + MXS s.RXSXL 5 o |.s k k.s.2X1 -.n hX+ ..H.. ~ ..o.s k 8XH.!.m { ^ ^XC.o } }Xf ).:.y p 1X>X>.g.g p.y.Z. .  D.O.I.I.I.I.I.I.I.I",
".I ` dXFXN.}.}.K.Z =.y S 1.Q C } { { F & F.-.-.G.GXHX1.u.1Xf.< JX+.|.9.n.nXc.q L OXw.B.=XH t.VXL./XS A xXL u 3.pXu 8 k kX1XuXAXc D.6.tXg `.Y hXq.SXjX1 8 & & { {XuXCXC.2 % C._.K.:.: 1.# p SXs p p. XF dXnX4.I.I.I.I.I.I.I.I",
".I DXFXFXNXN.K =.Z = =.y.#.+ ..7 & { &.N.G.w.G.NXH.mX1.u.zX1 L >.<XnXn.*.%.T > k O.8X2.UX8 u uXL x xXS xXL 3.pX1 k.B : O O.PXaX;.%.%.n h.%X; L.1.1.S.p.s t Y { 8 { ^.2.2 %Xf._.:.#.g K.y 1.y.y.} = =. .|.*.c.I.I.I.I.I.I.I.I",
".I DXFXFXFXN S 6 =.Z =X> 6.+ CXC {.[ F.NXX XXZ.N &.!.m.JXu T > > >.T.TX7X7X7XwXwX7X9.`X2.N u 3XL x s.j xXL 3.pX#XwX9Xk :XwXw > > > N L >.Y LX1.o.S.S Q |.m Y.=.G & ^ |.o %Xf ) r.#.# S = 1.yX>.} = =. X+ I c.I.I.I.I.I.I.I.I",
"XK.* dXFXF.Z.}Xz.tXN.y 1.Q ) ..s { &.NX5XZXXXZ.A &.GXX.w > >X7 >.TX7X7XaX7X7XwXkX9X2X2X2.( u [XL x x A xXL u.pX1Xw PXlXlX7 0X7X7 P.f > > > > LX1.s o.! t o.AXZXZ.N tXO.2.oXf.Q.Q.#.y =Xe.g 1.#.K =.Z.  DXb.I.I.I.I.I.I.I.I.I",
".I I DXF dXN =.KXh.Z.y E E.Q .Xu ^ {.NXZ XX2 XXZXB.U X W.BXwXwXwX7 >X7 >X7X7X7X7X7 PX2XB &.{.5XL x x xXL.5.5 3 | [X7 PX7X7X9X7X7X7X7XwX7 > >.P > > :.GX5.NXZXZ.UXZ.A 2.2.oXf E.:XsXs =.#.g.y.y = ZXF.|Xr a.I.I.I.I.I.I.I.I.I",
"XK i.* D dXFXN =.Z =.y r E.+ hXCXu {.NXZX2X2X2 X XX2 XX2X2 PX7.BX7X7X7Xa 'Xa.qXa P XXB.( V V.5XL x m m mXL u Q | 2 /XkX7XaXaX<Xa P 0X7.BXwXwXwXw.B.wXXXXXX XX2 XXZ.AXO.2XCXf.Q.:.y.C = = 1 S.y =. XF.|.*.c.I.I.I.I.I.I.I.I.I",
".IXKXb D d dXF Z.ZXF.y S E , .XC ^ t.NXBX2X2X2X2X2X2X2X2X2X2X2Xa PXa.q @X%X<.q  XlX9XBX@XIXI.i.X x m x mXL 3 9 Q 3 [ : 0 PXa.q @XaXa PX7X7 0X9X7X7XXXXXX.UX2X2 XXZ.V 9.2.o .Xd.K.: K S r.: pXN.Z.tXF D a.I.I.I.I.I.I.I.I.I.I",
".I.I j.* D dXFXN.Z.Z.}.:Xz.. . }XO.!.(XB XX2X2 XX2X2X2X2.R.;.`.` @X< @ @Xa @Xa 4 4XB e g /XI.8XL x x x m m u 9 Q 3 o.P 0X7XaX< 'X<Xa.` P.` PX2 XX2 X.U.U W XX2X2XB.VXO | }XfXd.K.# K p.}.}.y =X= (.| a.l.I.I.I.I.I.I.I.I.I.I",
".I.I.I aXr dXFXN.Z.  = r )._ ..oXu {.AXBXxX2X2X2X2X2X2X2.`.`    XaX<XaX<Xa s P.jX9XP.P.i.AXI.iXU m x mXL.5 3 3 3 3 O qXk mX7XaX<X%X< @ @Xa  Xa.` PXl.U X XX2X2 X X + 9.o %.zXd.:Xs.g p p = rX>.  d IXm.I.I.I.I.I.I.I.I.I.I.I",
".I.I.IXKXbX+XFX=.t.  r r ) , ..0.s t.(XBXxXxX2X2 7X2X2X2.` 7.`Xa.`.`.`.j.`X,XV 4XJ e.i.PX@XI.{.5 m m m.5 u 3 Q 3 O O.8.v m.j.jX7X<XaX<X<X< @  .`.`XlX9XlX2X2XxXx.& uX#.4 %Xf._.#.#.g 1.: 6 r.yXFX+ a.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.IXK IXF d dXd r.Q ).+.zXCXu {X5XZ XXxXV 7 7X2 7 7 7  .`.`.`.j sXa.j.j.jXJ.$.v e +XI [.{.5.5 m m.5 3 3 Q 3 O [ O.8XU x m m.j sX<Xa.`    .`.`.`.`XlXSXxXxXM l.{ | | %Xf._XsXs.' S = 6.Q.}.9 I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.IXKXK D d.6XgXd.QXzX*.z.0Xu YX5X5.aX9XSX2X2.R.`.` 7  .` s.`X< s s.j.j.j.X.$ e.iXI u [ 3.5.5 m.5.5 3 3 Q 3 [ O.8.8.5 m m m.j.j.j y yX< y s  .`  XG.RXS./ M 5 u |Xj %Xf._.# 6 1 S.d.K 6 = D.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I IXF d ] ]Xd._.EXo.0Xu {.NX5Xk XXxX2.RXl.`XG.RXVXG s y s s.` s.j.j RXJ l g o 2 [.8 3.5.5 m.5 3 3.p Q 3 g.8.8.5 m.j m.j.j.j.` s yX<XV.`.`.`X,XGXSXM l + u |.4.uXf._XsXs.# E.d.KXs (.*.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.IXK i D.|X= C , ,X-Xo.7.7 {.A /.v.UXxXxXl 4XVX, RX,X, yX<X< y s s sX,X,.X.i oX# 2 [.5.5 m m m.5 3 Q.pXt O O.8.5 m m.j.j.j.j.j s y s sX,.`X,X,XV.R 4.].i.{ 2 |.o %Xf.QXs 1 p.} r.: = `.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I i.*X+ h h . C . v.> z {.[ q.PXkX9XxXl 4 4 x RX, sX<X<X<X< y yX<.`X,.X gX#X# 2.5.5 m m m m.5.5 3.pXtX# O.v m m.j.j.j.j.j y y y yX,.jXV.jXV.j R.XXP.V [ 2 |.o.z.h.QXsXs.:XzXs Z.|Xn.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I cXb.*.n.^.>.r vXo.>.>XuXuXH /XwXwXBX9X9.X 4 R.j.` yX<X<X<X<X<X<X<X<XV e [ 3 2 OXU x x x x x m.5 3.pXt.p O.8 m.j s s s.j y y y s y y.j.j.j m.X 4XP.v.{ 2X#.4.o % U.#.#Xs 6.k...| I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.IXK.I JXr ! ! F., F.>.>.7.J t.N :XB.U.UXPXJ.X 4.j sX<X<X<X<X<.~X<X<.jX9.8XyXy 2 [XP x y.~.~.@ m.5 3 Q.pXt.p O.5.j s y y y y y y y y.j.j mX9XU.$XJXP.i [X# |Xj % % CXsXe ~.hXfXo.*.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.<.TXX WXXXZ.J.>.^ - {XH :.w.UXB.aXk.X 4XV y.jX<X<.~.~X< s.j mXU.P V & 2 OXkXVX<.~.~.@ xXL u.p.p.p.p O.8 m.j y y y y y y y s.jX9 m mXU.v e.i.{ oX# |.o.oXf.hXsXz % }.r LXc.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I *XbX3 P PXXXB.W.r.>.7 {XH.= :XZ : e e.X RX,X, yX<X<X<X<X<.j m 0XU.P /.N {XO.PX9XV sX<.` x.i 3.p Q Q.p O.5.5 m.j yX< y y y y s.j x m 0.v.v.8.vXIXyX#.4.o.z.z.h.Q ~.s.G.W LXc.I.I.O.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.IX7X7 P XXZ.J.r.7.7 {XHXH.=.wX5XDXP.$ RXVX,X, sXaX<.j.5.5.5 m 0 q /.NXOX1 q.P.5X7X7X9.i O.4.4 O Q.p O.v.5.5 m s yX<X< y s.j x mXU 0XU.P.8 gXyXyXO.4.oXo .Xf B UXu.w > > J.I.I a.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I N 0X7Xk :.G.>.>.7.J {XH 8 :X5X8 e.$ 4 RXV.jXV.j.jXU.5.8.5X7 x qX1 o %XfXy >.PXw 0.v qX1.S.4Xy OXt O mXU.5 m.j y yX< y s.j mXUXU 0.vXw q OXy.mX1 | %.zXoXfXp.u q.B.PXu J.IXcXc.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.fXwXwX8XwXa -.>.7.J & F 8.= : : e.$XJ.jXV.jXV mX7.5.vXU.j mX9XkX#.4Xu F.z > > q q.P /.u ..zX1.pXt.5X7 m m m m.j yX< s.j.j.j.$.v.v.v.P [ [.!XyXO.4 % % h ..1X1 qXw k L.f.YXrXb.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.T TXw.P 0 P.W.r.7 ^ { &.N.N.N.(XvXJXJX9 4 4X9XU.5.8X7 m P m m.vXD.mXuXy.o.0 >XuX1 OX1.h kXyXtXtX1.5 0 m m m m.j s s s.j RX9.$.v.P g.P / qXyXOX#Xj %.zXo.z.zX1 O.PXu.% h.9.*.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.l.eX$ a.Y h .Xu /XD {Xo.^.7 ^ {.N FXH.G.NXDXkXJX9X9 m.v.8Xw mX7.jXV m 0.v 0 :.[XC.s.zX1X1X1X1.S.z.sX1.0 O OXU m m m x m.j.j s sXV RXJXP.v g /X8.A /Xy o |Xj %Xo.z ..0Xu k O ~. X=.nXbX$.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I cX$Xc I.*Xn DX- . . ... C F.r ^ ^.[.N &.G :XZXkX9.aXJ.8.P.v 0XV PX9 0 0XJXkXw.G.G { T T.0 }Xo.z }.sXuXu q >.8XU m mX9.j x.j.j.j.jXV R.XXP.v.P / /XH /XyXyX#Xj %.z h.z LXuX1.E. .9.9.%.YXb c.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I c.) aXA aXn.* DX- (X*.:.:X* -.^.0 { & &.N.N.=X5 0 0.&.v.8.vX9X9 0X9 0XkXw 0.BXX.GX5.N 8 >XuXuXuXu T TXu > >.P >Xw mX9 m x x m x.jXVXV 4.aXP.P g.P /XH / O o |Xj %XoXo . .X-X& =X=.9.| `.*X$.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.IXK c.I.IXAXnX+.|.|.9 (XF Z (.% z ^ {XH.N F.G.NXZ.UXBXv.i MXJ 0X7X9.BXwXw.w 0Xw.B.wX5.w.w.-.- > > > > 8 > > > >.v.v 0 m 0 mX9 m mX9 4 4Xx.aXJXv / q /.A q oX#.4Xj % v %XfXeXe.D ZX* (.9.*.O.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.IXKXbXr DX+ DXr `.6 , v -Xu { &.N.N.G.G.GXXX5XvXM.&Xk 0.B.U.w.=.w.w.BXB X.U.w.UX7X;XXX; N WXX.wXw.wXwXw >XwXw 0 0 0.XX9XJ.XXSXx./.a.& e / V /XIXy / 2 |Xj % h }XfXe.g.#.Z d D.* *.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.IXb DX+.nX+ h.E $ h FXC { & F.N.G., {.wXv.&XM.&XZ.wXXXX.w.GXZXZ.U.U.UXB.U PX2Xa PX7 PX3Xa X.w.wX7.B.BX7XwXwX7 0XkXJ.v.v.$ M./ MXJXv.V /.A oXyXI | |Xj.o v %._XN d dXr.*.Y I.M.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.IXKXc d dXgX-.E ]X&.6.Y.J { & & FXZ., F.[.(XxXM lXBXZXX.UXZX5X5X5XvXv l.i.8XkX9XlXl PX2 P.` XXk 0X7.B.B.BXw.B.BXw.UXk e.i.iXL M.a M e / t /.!.m 2 | |Xj % vXf._X+XnXrXn.*Xn a.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I H.* d dX= ( ].Q ( !.JXu {XH.N !XZX;X5XZXxXx lXZXXXZX5 &.s.m OX# O 3 O 3 O O.8 0XV.$.v.v.8.8.P.vXPXk.w.BXw.w.=.w.UXD.P.iXL.]XB MXv VXy.!XIXy o | | | % v hXdX-X+.n } D J.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.IXK.IXbXr.|XgX*Xd.t.^.J.J {.W.GXZXX W.UXB.aXx MXZ XXZ.A |.2.o.h .XtXt.p.p Q O O O.8 O O O O O 3 3 3 3 [X8 : :X5XZXZX8X8.V + 5 MXk.iX@XIXy.! & u 9 |Xj } }Xf._.EX-.n.n.*.O.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.IX0XbXn `Xg ]X=.t.%.W.J {.[.N.GXZ WXBXZ XXxXMXB XXZ.(.! / Y.sX1X1X1X1X1 Q.p Q O O Q Q Q.p.p.pXt.pXtXt.4 o tX8.U.wX5.N.AX@.V.& l +XIXI t t & t | |.o v v ]XdXd.E hXrXb.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.IXK.lXA.*XnX+X-.E ].n !.J.J 8 8.GXX X XX5XMX2X2XBXBXB +XvXv V Y OX1 O O.P.8 O.8 O O O O O 3 Q.p.pXtXtXt.S.S.S.4XHXZ.G :.AXIX@X5XZXv g qXI t & & |.2.o } }._.KXd hXrXb.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I c.3XA.YXrX+Xg h.< z T.[ 8.G.G X X.N.UXl.R XXBXB 5Xv l.( q q q O q q O mXwXw.5.5.v.5.5 O 3 Q Q.p.4Xt.4.4.p.2X8XZ.N.A.V.VX8Xv.i / V.!.! t o |.o } } h ]X- ` DXc.M.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.IXKXK iXb.*.nX+.> z L L F 8.GXZ.UX5 lX2X2XxXBXv 5Xv 5 e.A.V.(.P.P q.v.5.5X7.vX7 0Xw.8.8 3 Q Q Q QX1 O [ o o t.NX5.(X8 +.PXv.i.A &.!.!.m 2.2 } v v % d d D.YXA.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXb.*Xr.>.^.J.W 8 8 :X5.UX5XDXxXx XXMXBXvXv l lX8 :X5X8.PXDXw 0X7X7X7 mX7XUXw.8 O O O O O O [XI.{.i.A.(XZXZ.& +.(.(XI & t.!.m Y.m.2.oXo h D D.*.YXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I J.n.n.^ L L L 8.=XZ.UXZX5.UXxXMXBXL +Xv 5Xv lX5X5XZX5XwXw 0.vXwXUX7X7X7 0XwXD.iXI qX@ V.{.{ g.{.V +XvXBXB +.(XI t.! t.!.! t.m.2 } }.n }XKXKXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXA.*.n.> -.J L F.= : :XZX8XDXBXBXBXvXvXvXv lX5Xv.(X5.N.N 8 / k OXu O O O T.PX8.N V /.AX@.V g + u.{ +XvXBXBXv.A t o t V t.m ^XCXC } %X+.*.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I <XbXnXn.^ -.J.W 8.=XZ.w.NX5XZXZXZXBXv.(XvXvXvXv.(.(.N.(.NX8 kXuXuXuXuXu T { Y.!.! V /.A gX@ g.{ uXvXBXZXv.(.A.A t.!.! { { ^XC } } % ]Xr.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.)Xc.*.>.^ -.J F.=.wXZ :X5XZXZXZXvXZ.(XvXvXv.i + +Xv.i.(X@ / k k / k /XH / &.! tXI.V.V gX@ g u.{XvXZ.(.(.V V t.!.!.! Y.m.s } } v h ] ` J i.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXK.IXc.Y.^ - - L 8.GX5.GX5X5X5X5XZ.&XZXvXv + + +.i 5 5.i.i.P /.P / / / /X8.PX@X@.{X@.{.{.{.{.{.{.(XvXZ.(.A.A.m.m {.! {XuXC } v }Xf D.|XcX$.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.Y.>.^.< L F.-.G.N.NX5XZ.GXZXZ.(XvXvXv + + u 5 5 5.i.P.P.P.P.V g.P.i.i.V.{.{ u u u.{.{.{ VXvXv.(.(.A t.! ^ Y {XyXC.0 }Xo h hXrXrXb.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I J.<.>.^ -.W.N F.G.N.NXZXZXZXvXv.(Xv 5 u 5 5 g 5 g.i eXDXkXkXDXD e 5 5 u u u 5 u 9 9 u V.VXv.(.A.A u.!.mXu Y T ^XC } } . % hXr.*.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXb J.Y.^.> - L F F.N.N.G.NXZXZXZXZXvXZ.( 5XL uXL g 5.5Xk.BXk 0 eXkXD.v.i u 9 u u u 9 9 5 u +.V.(.A & t t ^ { YXuXC.0 } %.z h.* I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXKXbXc ! -.7.< - F F.G F &.N.G :XZXZXZXZXZXvXL 5 5.i.8.P.B.B 0XwXwXwXw 5.{.5 u 9.5 u u u u u V.(.A & & t.m.m.m.m.7.0 }XoXf %Xo I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I a *Xb ! ! -.^ -.W ! F.N F.- 8.=X8X5XZ.(X5XZXvX@ g.P.PXwX7X7X7X7XwXw.B 0.8 g u u u u u u 5.{.V.( V t t.!.m {.! T.s.0 %Xf % } v IX4.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I * iXb.Y ! ! -.> - F F F F 8 F 8.N.NX5XZ.NX8X5XH qXD.PX7X7X7Xa PX7 >X7.BXD 5.{ 3 u u 5 u 5.(.V V t.!.!.m.! ^Xu.s.0 }Xf %XC }.%Xn i.b.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I ; iXc ! ! ! !.>.>.Y F F F.W F.WXHXH.N.G.N.G.NXH 8X8 >Xw P PXa PX7X7.B >Xw.8XI 9 [ +.V 5 u.V &.!.! ^ ^.m ^Xu.7.0.r.u % }XCXC v I aX6.).I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.3 * I ! ! ! ! -.> z.Y - -.W F.W { F 8.G.=X5 8 k kXwXw >X7 PX7X7X7X7 >XwXD.PXyXy Y V.V.V V u 9.!.m.mXO ^Xu.0.0.r.z.z }XC.7.s.% I a *X$.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.e.lX6Xb.Y !X; N !.^.>.^.Y - - F -.J { F.G F.G.-XH Y q >.vX7X7X7 > >XwXwXw > qXy Y kXHXH t tXO 9.m.mXu.0.7.0.0.0.zXf % ^.J.J.J }.*XbX4.FX$.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.IXm.3 iX6Xc -X; !X;., F.^.>.^.Y - - - L F F F.N F.-.= /Xy q >.8 > > > >.P > q O q.s T.[.A {.m ^XO ^ ^XuXu.7.0.0 } %Xf }.J.[ L L T.0.|Xb.F a.).b.e.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I.I c <.3.c *X4 I.>X;X;X;., ! !.>.>.^ - - z - -.J.J F.W L 8 kXuXu q > O >.8 > O > O.sXuX1.s k.[ T ^XOXC.7XCXu.0.r.0 }Xo.z } L.W 8 8 L kXC.9 aX6 a a a.e <.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I c.l H.)X6 *.F IXnX;X;X;X;X; ! ! -.>.>.<.^.< - - - -.W k T T TXuXuXuXu L O >XuXuXu.sX1.sXu { T {Xu.7XC.7.r.r.r.r vXo.z } L > > > 8.[.[.0.9 a H a a * * <.l.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.I.I.I.I cX. j.)X6 *.O IXnX3X;X3X;X;.f ! ! -.^.>.^.^ - - - - F.W T L LXuXu.0Xu >Xu LXuXuXu.sXu.sXu {XuXu.r.7.r.r } } v v vXo.r.W.-.=.=.-.- 8.[.oX+X4X4 a * *.O.O < c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.I.I.IXKXK c c w.b fX6 i.f.n.>X;X;X; #X3 # # ! ! -.^.>.^.^.>.^ - - -.JXu LXu.<Xu.<Xu.0Xu.0XuXuXuXuXu.7Xu.7.7.>.r.r } v v.r v }.r.W.-.w.= >.,.w 8 TXoXnX6X4 a.OX4.O.O a.c < cXK.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.I.I.I.IXK c c.).bXmX6X6 HX6.)Xn v.>.,X;X3 # # #X3X; ! ! -.^.>.^.^.>.>.^ z z z L z L L.<Xu.<Xu.<Xu L.0Xu.7.0.r.0.r v.r v v.r.r.r v.r.W N N.w.,XXXX.= 8.!.z IX6.O a *X4X4X4 * * a *.e c.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.I.I.IXKXK c.l.F.).bX  w.)X .) f j.* } }.,X;X3 # #X3 #.fX;X; !.Y.^.^.^.^.>.^.> z z zXu.<.0.<.0.0.<.0 z.<.0 z.0.%.r v v v v }.r } } v.r.W NXXXX N WXXXX :.= O ` aX4 a aX4X4 HX4.F * a * a f.e.l.I.I.I.I.I.I.I.I.I.I.I.I.I",
".I.I.IXK c.l.F.F H H.)X6.) jX0 j.F.F.3 ! }.n !X3X3 n n n # nX;X; ! ! -.>.>.>.^.^.^.>.7.>.>.7.0.<.0.0.0.0.%.0.%.r.r v v.r.r } v.r } } }.r - NXX W W W W.B.w.,.PXC.*X6.O a aX4X4X4X4.F.O * *.O * a.M.c.l c.I.I.I.I.I.I.I.I.I.I",
"XK c c.F.F HX..)X  ;.)X6X6.3.3 j.F H.3Xc } } !X;X3 # n n n n nX;X; ! !.Y -.^.>.^.^ z.^ z z z.0.0.< z.>.0.0.>.0.r.r.r.r.r }.r.r.r } }.0 -.- N WXX W WX7.B.B.w k.%X4X4X4 a *X4X4X4 H.FX4 * *.O.O.O * * a.c < c.I.I.I.I.I.I.I.I",
".F.F H H.)X X .)X6X6X.X X6.3.3.3 H.F.3 a }.n !X;X3X2 n.; n n n nX;X; ! ! ! !.^.^.>.^.^.^.^ z.^ z z.7 z.<.> z.>.>.r.>.>.r.>.r } }.r.7.W ! W W W WX3X7XX.B.w.w LXbX6X4 * *.OX4X4X4X6X4X4 *.O.O.OX4 i.O a * *.b < c.I.I.I.I.I.I",
".).) f H.)X X .) HX6X. ;X6X0.3.3 H i j i.> v !X;X3 #.; n n ' n nX;X;X; ! ! ! ! ! -.< - - - - - z z.< z z.< z z.^.^.<.^.^.^.>.7 } z F.- N W W WXa WX7.B.B.B.P JX6X4X4 * *.OX4X4X4X4 HX4.OX4.O.OX4X$X4.O *.O.O *.c <.lXK.I.I.I",
".).bX..).b.c.bX X.X6X. w ;X6.3.3 j.FX6 j.< } FX; # n.; # n.q ' n n #X; ! ! ! ! !.T ! ! ! !.T ! !.T > ! > L !.Y ! !.Y F - - ^.^ - F.- W W W #Xa PX7.BX7.B.B >X4 <X4.O aX4X4X4X4X4X6 HX4.O.O.OX4X4X6X..F * *X4 fX$ iXA <.lXK.I",
".).).MX.X6 ; ; wX6.)X  j jX0.3.3 ;.F H.3Xc h !X;X3 #X3.; n n.q.q n.f.fX;X; !.T NX;X;Xc.f.T.,.T N.T N.T !.T.T., N ! ! F ! { -.J F.- N W W #Xa PX7X7X7XXX7XwXAX6X4.O *.O *X4X4X4X6X6X4X4.OX4X4.OX4X6.c.).O.OX4 fX$X$X$X$XA <.I",
"X X.X.X.X .b.b w wX6 ;X0X0X6.3.3 j H H j.)Xn zX;X3 # n.; n n.q n ' n #X;X;.,X; !X;X;X;.f.fX;X;.fX;X;X;X;X; N N.,.,.- F.W - { F.-XXXXXXX3Xa P PX9X7X7X7.B.fX6X6X4.O.O.OX4X4X4X6X4X6X6X4X4X4X4X4X4X.X6.MX$ *.O f.MX$ i.OXA <.I",
".).M.MX..M.b.b.eX0 w w.e j ;X0.3 j H.F ;.3Xb.>X; nX3X3.;.; n '.q n n n #X;X;.,X;X;X;X;.f.fX3 # nX;.fX;X;X;X;X;., !.- F.W { F 8.,XX.BXa.;.; PX9 P PX7X7X7X4 <X4.O.O *.OX4X4X6X6X4X6.FX4X4 fX4X4X$.MX6.b.M.O.OX$.M.MX$X$XA.e.I",
" f f.MX..)X..b jXm j.)X  wX Xm.3 j.).F H j j.Y ! n #X3 # n.; n.q.q n n # #X;X;X;X;X;.f nX;.f #.f n #.fX;XXX;.,.,., F F F F F.,XX W PXaXa P P P PXl P.f.OX6.MX4.O.OX4X4X4X4X6X4X4X6.FX4 HX..F.OX4X6X6.c.cX$.O.O.M.e.MX$ i.e.I",
"X$.M.).).).).b jXm j.)X  j jX0.3.3 H H H ;.3 i !X3.; n n.; ' ' n.q.q n n #.f.f.fX;X;.f n #.f n #X3X3.fX3X; WX; N !.- F.-.=.-XXX3.;Xa PXa P.` P P PXaX$.c.MX4X4.OX4X4X4X4X6X6X6X4X6.FX4X6X6 fX4 fX6.M.M.b.MX$.O.M.c.b.MX$.e.I",
"X.X. f fX.X..b jXmX0 w.c wX  w.3.3 ; H H ; j.3 a., # n ' n ' n.q.q.q.q n n n #.f.fX;.f # n #X3X;X;X3X3X3XXX;X;.,., !.-.G.=.,X3Xa.;XaXaXa PXaXl PXaX4 <X6X4X4.OX4X4X4X4X6X6X6X6X4X6X4X.X0X6 f i f.c.e.e.e.cX$XA.M.c.c.c.M <.I",
"X.X.X.X.X .)X  ;X0X0 w wX6X6 j.3.3 j H HX6 jXm.3 aX; n.q ' '.q.q n n.q.q n n n # # # # # # #X3 W #X3X3X3XX., N., !.,.G.-.= WXaXa.;XaXaXa PXa P 'X4 <.cX4X4.OX4X4X4X4X6X6X6X6X6X.X4X4X6X0.cX.X$X4.cXm < <.e.M.OX$.c.c <.M.l.I",
".).).).b.b.b ; ; w jX0X  wX0 jX0.3X0X6 H HX6 jX0Xm '.f '.q n.q.q.q.q.q.q.q n n n n # #X3 # #X3X3X3 #X3X;X;XX., N.,.,.,XX WXa.;.;.; @Xa  XaXaX%X4.cX6X6X4X4X4X4X6X4X4X6X6X6X6X6X4 f fX6XmX6.MX4X4X6Xm.e <.e.cX$X$.M.M.c.c c.I",
".)X .b.).b j.e j.b w j w jX0X0X0.3.3 ;X6 HX6X6 ; j jXA.f '.q.q.q.q.q.q.q.q.q n n n n # # #X3X3X3 #X3X3X;X;X; N., N N W W P '.;.;Xa @XaXaXaXA.M <X6X$X4X4X4X6X4X6X6X6X6X6X6X4X6 fX4X6.c.c.c.MX$X$.M.e.e < < <.MX%X$.c < < c.I",
"X X X .).b w j.e.)X .b w w wX0X0.3.3.3X6 HX6X6 j ; j.3X$.q '.q.q.q.q.q.q.q.q.q n.q n.q n n n #X3X3X3X;X3X;X;X3X;X3 WX3Xa.;.;.; @.qXa @ 'X4 <.cX6X4X4X4X4X4X4X6X6X6X6.3X6X6X6X6X4X4X6Xm.3 <.e.MX$X6 < < < < <.MX$X$ < < <XK.I",
"X .) f.) ;.) j j j j wX0 w w.3.3.3.3.3 j H HX6 j j jX0.3 jXAX%.q.q.qX% @X%.q.q.q n.q n ' n n # #X3X3X; WX3X3X3 #X3X3.;Xa.;.;.q.q @.qXA.M.3X6X4X4.OX4X4X6X6X6X6X6X6X0X6X6X0X6X4 HX6X6Xm.3 <.e.bX$X$.e < < < <.bX$X$.c < <XK.I",
"X X .).).).).e.e j.e.eXm j wX0 ; j.3.3X0X6X6 HX6X0X0X0X0X0.3.)X%.qX% @X%.q.q.q.q.q.q '.q n.; n n n n # #X3X3 n ' '.;.;.; @.q @.qX%.M < <X6X4X4X4X4X4X6X6X6X6.3X6.3X6X6.3X0X6X6X.X6.c.e.3 < <.MX$X$ < < < < <.bX$X$.M < <.I.I",
".) ;.).).b j j j w ; ; ; j wX0X0X6X0.3.3 jX6 HX6 ;.3X0 ; ;.) j j jX%X%X% @X%X%.q.q.q.q.q.q.q.; ' ' ' ' ' ' ' ' '.q.;.; @.q.qX%X$X6.3X6X4X4X4X4X4X6X6X6X6X6.3X6.3X6X6X6X6X6X.X..c.b.c <.3 <.e.e.MX$.c <.l < <.c.MX$.e.l <.I.I",
"X  ; w j j j.e j w.).) ; ;.) j j j j.3.3 j jX6X6X6X0.3X0 j ; ; j.3 j.)X%X%X%X% @X%.q.q.q.q.q.q.q.q.q.q.q.q.q.q.q.q.q.qX%X%X$.M.c.c fX4X4X4X4X6X6.3X6X6.3X6.3.3X6X6X6 jX6X6 HX .b.M < <.l < <.e.MX$.M < <.l < <.bX$.c < <.I.I",
".b.).).e j < j j w j j j ; ; j.3X0X0.3.3.3 j j HX6X6.3.3X0 jX6 H j j.3Xm j.) jX%X%X%X% @X% @.q.q.q.qX%.qX% @X%X%X%X%X$.M.c <.bX4X4X4X4X4X6.3X6.3.3.3X6.3X0.3.3X0X6X6 ;X. H w w.c.M.e < < <.e.e.eX$X$.e < < < < <.M.c < <.I.I"
};

#endif /* _TBOX_H_ */
