/**********************************************************************

	--- Qt Architect generated file ---

	File: xcardPersonalize.cpp
	Last generated: Fri Jun 28 10:48:20 2002

 *********************************************************************/

#include "xcardPersonalize.h"
#include "qmessagebox.h"
#include <stdio.h>
#include <string.h>

#define Inherited xcardPersonalizeData

xcardPersonalize::xcardPersonalize
(
 MSCLPTokenInfo tokenName,
 xcardMain *mainWin,
 QWidget* parent,
 const char* name
)
	:
	Inherited( parent, name )
{
  tokenList = tokenName;

  lineEdit_CurrentAdmin->setEchoMode(QLineEdit::Password);
  lineEdit_UserPINA->setEchoMode(QLineEdit::Password);
  lineEdit_UserPINB->setEchoMode(QLineEdit::Password);
  lineEdit_UnblockA->setEchoMode(QLineEdit::Password);
  lineEdit_UnblockB->setEchoMode(QLineEdit::Password);
  selector_numTries->setValue(5);
  lineEdit_ObjectMem->setText("8096");

  mainWindow = mainWin;
  
}

xcardPersonalize::~xcardPersonalize()
{
}


void xcardPersonalize::UseDefaultChecked()
{

  if ( checkbox_UseDefault->isChecked() == TRUE ) {
    lineEdit_CurrentAdmin->setDisabled(TRUE);
  } else {
    lineEdit_CurrentAdmin->setDisabled(FALSE);
  }

}

void xcardPersonalize::PersonalizeCancel()
{
  hide();
}

void xcardPersonalize::PersonalizeCreate()
{

  MSC_RV rv;
  MSCTokenConnection pConnection;
  MSCInitTokenParams initParams;
  MSCChar8 errorMessage[500];
  QString adminPin;
  QString userPinA;
  QString userPinB;
  QString unblockA;
  QString unblockB;
  QString objectMem;
  QString numTriesString;
  MSCULong32 numTries;
  MSCULong32 memorySize;
  bool isOK;
  int ret;

  ret = QMessageBox::warning( 0, "XCard II",
			  "You are about to DESTROY ALL data on this card !", 
			  "Continue", "Cancel", 0, 0, 1);
  if ( ret == 1 ) {
    return;
  }

  rv = MSCEstablishConnection(tokenList, MSC_SHARE_DIRECT, 0, 0,
			      &pConnection);
  if ( rv != MSC_SUCCESS ) {
    sprintf(errorMessage, "Connection Failure: %s", 
	    msc_error(rv));
    
    QMessageBox::information( 0, "XCard II",
			      errorMessage );
    return;
  }

  /* Check the parameters */

  adminPin = lineEdit_CurrentAdmin->text();
  userPinA = lineEdit_UserPINA->text();
  userPinB = lineEdit_UserPINB->text();
  unblockA = lineEdit_UnblockA->text();
  unblockB = lineEdit_UnblockB->text();
  objectMem = lineEdit_ObjectMem->text();

  numTriesString = selector_numTries->text();
  numTries       = numTriesString.toULong(&isOK, 10);


  if ( objectMem.isNull() ) {
    QMessageBox::critical( 0, "XCard II", "Please enter memory size" );     
    return;
  }



  if ( (adminPin.length() != 8 && checkbox_UseDefault->isChecked() == FALSE)
       || userPinA.length() != 8 || unblockA.length() != 8 ) {
    QMessageBox::critical( 0, "XCard II", "Pins must be 8 characters" );
    return;
  }
    

  if ( adminPin.isNull() && checkbox_UseDefault->isChecked() == FALSE ) {
    QMessageBox::critical( 0, "XCard II", "Please enter admin pin" );     
    return;
  }

  if ( userPinA.isNull() || userPinB.isNull() ) {
    QMessageBox::critical( 0, "XCard II", "Please enter user pin twice" );     
    return;
  }

  if ( unblockA.isNull() || unblockB.isNull() ) {
    QMessageBox::critical( 0, "XCard II", "Please enter unblock pin twice" );     
    return;
  }

  if ( QString::compare(userPinA, userPinB) ) {
    QMessageBox::critical( 0, "XCard II", "User pins do not match" );     
    return;
  }

  if ( QString::compare(unblockA, unblockB) ) {
    QMessageBox::critical( 0, "XCard II", "Unblock pins do not match" );     
    return;
  }

  memorySize = objectMem.toULong(&isOK, 10);
  initParams.objectMemory = memorySize;

  memcpy(initParams.transportKey, adminPin.latin1(), adminPin.length());
  memcpy(initParams.newTransportKey, adminPin.latin1(), adminPin.length());
  initParams.transportKeyLen = adminPin.length();
  initParams.newTransportKeyLen = adminPin.length();

  memcpy(initParams.defaultCHV, userPinA.latin1(), userPinA.length());
  initParams.defaultCHVLen = userPinA.length();
  initParams.defaultCHVTries = numTries;


  memcpy(initParams.defaultCHVUnblock, unblockA.latin1(), 
	 unblockA.length());
  initParams.defaultCHVUnblockSize = unblockA.length();
  initParams.defaultCHVUnblockTries = numTries;
  
  if ( checkbox_UseDefault->isChecked() == TRUE ) {
    memcpy(initParams.newTransportKey, "Muscle00", 8);
    initParams.newTransportKeyLen = 8;
    initParams.transportBehavior  = MSC_INIT_DEFAULT_KEY;
  } else {
    initParams.transportBehavior = MSC_INIT_USE_KEY;
  }

  rv = MSCWriteFramework(&pConnection, &initParams);  

  if ( rv != MSC_SUCCESS ) {
    snprintf(errorMessage, sizeof(errorMessage),
	     msc_error(rv));
    
    QMessageBox::information( this, "XCard II",
			      errorMessage );
    return;
  }


  if ( checkbox_UseDefault->isChecked() == TRUE ) {
    QMessageBox::information( this, "XCard II",
			      "Token personalized successfully\nYour new transport key is: Muscle00\nYou may change this in XCard" );
  } else {
    QMessageBox::information( this, "XCard II",
			      "Token personalized successfully" );
    mainWindow->XCUpdateList();
  }

  hide();
}
