/*
  XBubble - screens.c

  Copyright (C) 2002  Ivan Djelic <ivan@savannah.gnu.org>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>

#include "rgba.h"
#include "dialog.h"
#include "screens.h"
#include "game.h"

extern Display *display;
extern Window win;
extern Pixmap win_bg;

extern int win_width, win_height;
extern XFontStruct *title_font, *dialog_font, *menu_font;
extern char *player_name[][2];

#define SCREEN1_MENU {\
 "Single Player",\
 "Two Players",\
 "Player vs Computer",\
 "Challenge",\
 "Quit"\
}

#define SCREEN2_MENU {\
 "Very easy",\
 "Easy",\
 "Normal",\
 "Hard",\
 "Very hard"\
}

#define SCREEN3_MENU {\
 "Continue",\
 "End" \
}

#define SCREEN3_STATS {\
 " ",\
 "Game Wins",\
 "Round Wins",\
 "Percentage" \
}

#define SCREEN4_MENU { "1", "2", "3", "4", "5" }
#define SCREEN5_MENU SCREEN4_MENU

enum Screen1_Choice screen1() {
  char* menu[] = SCREEN1_MENU;
  int title_height, menu_height;
  int menu_x, menu_y, choice = 0;
  Window title;
  title_height = title_font->ascent + title_font->descent;
  get_menu_window_size( menu, 5, 0, &menu_x, &menu_height );
  title = create_dialog( win_width/2, ( win_height - menu_height )/2,
			 "XBubble", title_font, get_pixel( 0xff, 0xc4, 0xff),
			 0, 1.0 );
  menu_x = win_width/2;
  menu_y = ( win_height + title_height )/2;
  get_menu_choices( 5, menu, &menu_x, &menu_y, &choice, 1, False, False );
  XDestroyWindow( display, title );
  return choice;
}

enum Screen2_Choice screen2() {
  char* menu[] = SCREEN2_MENU;
  int title_height, menu_height;
  int menu_x, menu_y, choice = 2;
  Window title;
  title_height = dialog_font->ascent + dialog_font->descent;
  get_menu_window_size( menu, 5, 0, &menu_x, &menu_height );
  title = create_dialog( win_width/2, ( win_height - menu_height )/2,
			 "Select computer skill",
			 dialog_font, get_pixel( 0xff, 0xa4, 0), 0, 1.0 );
  menu_x = win_width/2;
  menu_y = ( win_height + title_height )/2;
  get_menu_choices( 5, menu, &menu_x, &menu_y, &choice, 1, False, True );
  XDestroyWindow( display, title );
  return choice;
}

enum Screen3_Choice screen3( enum GameMode mode, int *rounds, int *games ) {
  char* menu[] = SCREEN3_MENU;
  char stats[3][4][32] = { { "","","","" }, { "","","","" }, SCREEN3_STATS };
  char* pstats[3][4];
  int i, j, title_y, title_height, menu_height, width[3], height[3];
  int total_width, total_height, menu_x, menu_y, stats_x[3], stats_y;
  int nb_rounds, choice = S3_CONTINUE;
  unsigned long pixel[4];
  Window title, stats_box[3];
  nb_rounds = rounds[0] + rounds[1];
  for ( i = 0; i < 3; i++ )
    for ( j = 0; j < 4; j++ )
      pstats[i][j] = stats[i][j];
  pixel[0] = get_pixel( 0xff, 0xc0, 0xff );
  pixel[1] = get_pixel( 0xff, 0xff, 0x10 );
  pixel[2] = get_pixel( 0xdd, 0xdd, 0xdd );
  pixel[3] = get_pixel( 0xdd, 0xdd, 0xdd );
  for ( i = 0; i < 2; i++ ) {
    pstats[i][0] = player_name[mode][i];
    sprintf( stats[i][1], "%d", games[i] );
    sprintf( stats[i][2], "%d", rounds[i] );
    sprintf( stats[i][3], "%d", 100*rounds[i]/(( nb_rounds )? nb_rounds : 1 ));
    get_column_window_size( 4, pstats[i], menu_font, 1.5,&width[i],&height[i]);
  }
  get_column_window_size( 4, pstats[i], menu_font, 1.5, &width[2], &height[2]);
  get_menu_window_size( menu, 2, False, &menu_x, &menu_height );
  title_height = dialog_font->ascent + dialog_font->descent;
  total_width = width[0] + width[1] + width[2];
  total_height = title_height + height[0] + menu_height;
  title_y = ( win_height - total_height + title_height )/2;
  stats_y = title_y + ( title_height + height[0] )/2;
  menu_x = win_width/2;
  menu_y = stats_y + ( height[0] + menu_height )/2;
  stats_x[0] = ( win_width - total_width + width[0] )/2;
  stats_x[1] = ( win_width + total_width - width[1] )/2;
  stats_x[2] = stats_x[0] + ( width[0] + width[2] )/2;
  /* title window */
  title = create_dialog( win_width/2, title_y, "End of game", dialog_font,
			 get_pixel( 0xff, 0, 0xc4 ), 0, 1.0 );
  /* statistics windows */
  for ( i = 0; i < 3; i++ )
    stats_box[i] = create_column( stats_x[i], stats_y, 4, pstats[i], menu_font,
				  pixel, 1.0 );
  /* continue/end menu */
  get_menu_choices( 2, menu, &menu_x, &menu_y, &choice, 1, False, False );
  XDestroyWindow( display, title );
  for ( i = 0; i < 3; i++ )
    XDestroyWindow( display, stats_box[i] );
  return choice;
}

enum Screen4_Choice screen4( int * choice ) {
  int subtitle_y, footnote_y, menu_x[2], menu_y[2];
  int title_height, menu_width, menu_height, title_y;
  char* menu[5] = SCREEN4_MENU;
  Window title, subtitle1, subtitle2, footnote;

  title_height = 3*( dialog_font->ascent + dialog_font->descent )/2;
  get_menu_window_size( menu, 5, True, &menu_width, &menu_height );
  title_y = ( win_height - title_height - 4*menu_height )/2;
  subtitle_y = title_y + title_height;
  menu_x[0] = win_width/4;
  menu_y[0] = subtitle_y + ( title_height + menu_height )/2;
  menu_x[1] = 3*win_width/4;
  menu_y[1] = menu_y[0];
  footnote_y = menu_y[0] + 2*menu_height;
  choice[0] = 2;
  choice[1] = 2;
  /* title windows */
  title = create_dialog( win_width/2, title_y, "Select handicap level", 
			 dialog_font, get_pixel( 0xff, 0xa4, 0 ), 0, 1.0 );
  subtitle1 = create_dialog( menu_x[0], subtitle_y, "Player 1", 
			     dialog_font, get_pixel( 0xff, 0xff, 0xff ),0,1.0);
  subtitle2 = create_dialog( menu_x[1], subtitle_y, "Player 2", 
			     dialog_font, get_pixel( 0xff, 0xff, 0xff ),0,1.0);
  footnote = create_dialog( win_width/2, footnote_y, "Press fire to start", 
			    menu_font, get_pixel( 0xff, 0xff, 0 ), 0, 1.0 );
  get_menu_choices( 5, menu, menu_x, menu_y, choice, 2, True, True );
  XDestroyWindow( display, title );
  XDestroyWindow( display, subtitle1 );
  XDestroyWindow( display, subtitle2 );
  XDestroyWindow( display, footnote );
  return (( choice[0] < 0 )? S4_ESCAPE : S4_OK );
}

enum Screen5_Choice screen5() {
  int choice, subtitle_y, footnote_y, menu_x, menu_y;
  int title_height, menu_width, menu_height, title_y;
  char* menu[5] = SCREEN5_MENU;
  Window title, subtitle, footnote;

  title_height = 3*( dialog_font->ascent + dialog_font->descent )/2;
  get_menu_window_size( menu, 5, True, &menu_width, &menu_height );
  title_y = ( win_height - title_height - 4*menu_height )/2;
  subtitle_y = title_y + title_height;
  menu_x = win_width/2;
  menu_y = subtitle_y + ( title_height + menu_height )/2;
  footnote_y = menu_y + 2*menu_height;
  choice = 2;
  /* title windows */
  title = create_dialog( win_width/2, title_y, "Select handicap level", 
			 dialog_font, get_pixel( 0xff, 0xa4, 0 ), 0, 1.0 );
  subtitle = create_dialog( menu_x, subtitle_y, "Player 1", 
			    dialog_font, get_pixel( 0xff, 0xff, 0xff ),0,1.0);
  footnote = create_dialog( win_width/2, footnote_y, "Press fire to start", 
			    menu_font, get_pixel( 0xff, 0xff, 0 ), 0, 1.0 );
  get_menu_choices( 5, menu, &menu_x, &menu_y, &choice, 1, True, True );
  XDestroyWindow( display, title );
  XDestroyWindow( display, subtitle );
  XDestroyWindow( display, footnote );
  return choice;
}
