/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import org.xml.sax.SAXException;

public class NodeTestPattern
extends Pattern {
    private int nodeType;

    public NodeTestPattern(int n) {
        this.nodeType = n;
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws SAXException {
        return nodeInfo.isa(this.nodeType);
    }

    public int getType() {
        return this.nodeType;
    }

    public Name getName() {
        return null;
    }

    public String toString() {
        String string;
        switch (this.nodeType) {
            case 2: {
                string = "@*";
                break;
            }
            case 1: {
                string = "*";
                break;
            }
            case 3: {
                string = "text()";
                break;
            }
            case 0: {
                string = "node()";
                break;
            }
            case 4: {
                string = "/";
                break;
            }
            default: {
                string = "???";
            }
        }
        return string;
    }

    public boolean isRelative() {
        return false;
    }

    public double getDefaultPriority() {
        return -0.5;
    }
}

