/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ParserManager;
import com.icl.saxon.trax.TransformException;
import com.icl.saxon.trax.URIResolver;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements URIResolver {
    private URL theURL;
    private String parserClass;

    public void setParserClass(String string) {
        this.parserClass = string;
    }

    public void setURI(String string, String string2) throws TransformException {
        try {
            if (string == null) {
                this.theURL = new URL(string2);
            } else {
                URL uRL = StandardURIResolver.toURL(string);
                this.theURL = string2.length() == 0 ? uRL : StandardURIResolver.toURL(uRL, string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformException("Malformed URL " + string2, malformedURLException);
        }
    }

    public String getURI() {
        return this.theURL.toString();
    }

    public Node getDOMNode() {
        return null;
    }

    public InputSource getInputSource() {
        return new InputSource(this.theURL.toString());
    }

    public XMLReader getXMLReader() throws TransformException {
        try {
            if (this.parserClass == null) {
                return null;
            }
            return ParserManager.makeParser(this.parserClass);
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException);
        }
    }

    protected static URL toURL(String string) throws TransformException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformException("Malformed URL " + string);
        }
        return uRL;
    }

    protected static URL toURL(URL uRL, String string) throws TransformException {
        URL uRL2;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformException("Malformed URL " + string);
        }
        return uRL2;
    }
}

