/*-
# X-BASED ABACUS
#
#  AbacusP.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#  Abacus demo and neat pointers from
#  Copyright (c) 1991 - 1998	Luis Fernandes, elf@ee.ryerson.ca
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Abacus */

#ifndef _AbacusP_h
#define _AbacusP_h

#include "xwin.h"
#include "timer.h"
#include "Abacus.h"

#ifdef WINVER
#ifndef DEMOPATH
#ifdef UNIXDELIM
#define DEMOPATH "c:/WINDOWS"
#else
#define DEMOPATH "c:\\WINDOWS"
#endif
#endif

extern void DestroyAbacus(AbacusWidget w, HBRUSH brush);
extern void ResizeAbacus(AbacusWidget w);
extern void InitializeAbacus(AbacusWidget w, HBRUSH brush);
extern void ExposeAbacus(AbacusWidget w);
extern void HideAbacus(AbacusWidget w);
extern void SelectAbacus(AbacusWidget w, const int x, const int y);
extern void ReleaseAbacus(AbacusWidget w);
extern void ClearAbacus(AbacusWidget w);
extern void IncrementAbacus(AbacusWidget w);
extern void DecrementAbacus(AbacusWidget w);
extern void SpeedAbacus(AbacusWidget w);
extern void SlowAbacus(AbacusWidget w);
extern void SoundAbacus(AbacusWidget w);
extern void FormatAbacus(AbacusWidget w);
extern void RomanNumeralsAbacus(AbacusWidget w);
extern void SignAbacus(AbacusWidget w);
extern void QuarterAbacus(AbacusWidget w);
extern void QuarterPercentAbacus(AbacusWidget w);
extern void TwelfthAbacus(AbacusWidget w);
extern void AnomalyAbacus(AbacusWidget w);
extern void WatchAbacus(AbacusWidget w);
extern void EnterAbacus(AbacusWidget w);
extern void LeaveAbacus(AbacusWidget w);

extern void MoveAbacus(AbacusWidget w);
extern void SetAbacusString(AbacusWidget w, int reason, char *string);

extern void InitializeAbacusDemo(AbacusWidget w);
extern void ExposeAbacusDemo(AbacusWidget w);
extern void ClearAbacusDemo(AbacusWidget w);
extern void DemoAbacusDemo(AbacusWidget w);
extern void NextAbacusDemo(AbacusWidget w);
extern void RepeatAbacusDemo(AbacusWidget w);
extern void MoreAbacusDemo(AbacusWidget w);

#else

#ifdef VMS
#ifndef DEMOPATH
#define DEMOPATH "[.]"
#endif
#else
#ifndef DEMOPATH
#if 0
#define DEMOPATH "/usr/share/games/xabacus"
#endif
#define DEMOPATH "/usr/local/share/games/xabacus"
#endif
#endif

typedef struct _AbacusClassPart {
	int         ignore;
} AbacusClassPart;

typedef struct _AbacusClassRec {
	CoreClassPart coreClass;
	AbacusClassPart abacusClass;
} AbacusClassRec;

extern AbacusClassRec abacusClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif
#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define MAXDECKS 2
#define PLACESETTING 2
#define UP 1
#define DOWN 0
#define TOP 1
#define BOTTOM 0
#define CARRY 2	/* I guess it could be even more if you have a weird config
		   also need a space to hold null (not included) */
#define SPECIAL_PIECES 2 /* Pieces, PiecePercents */

/* Migrate to Locale */
#define DECIMAL_SEPARATOR '.'
#define GROUP_SEPARATOR ','

#define MAXLENFORMAT 9

#define LINES 4
#define CHARS 64

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define NEWPOS(dir,x) ((((dir)==UP)?-1:1)*(x))

typedef struct _DeckPart {
	int         number;
	Boolean     orientation;
	int         factor;
	int        *position;
	int         spaces;	/* spaces between beads */
	int         room;	/* spaces + number */
	Position    height;
	int         piece, piecePercent;
} DeckPart;

typedef struct _AbacusPart {
	DeckPart    decks[MAXDECKS];
	int         currentDeck, currentRail, currentPosition;
	int         rails;	/* number of columns of beads */
	int         decimalPosition, numDigits;
	int         base, displayBase;	/* 10 usually */
	int         shiftPercent, shiftAnomaly, shiftAnomalySq;
	int         groupSize, anomaly, anomalySq;
	int         delay, numSlices, mode;
	int         deck, rail, number;
	Position    width, midHeight, midBarY, railWidth;
	Point       frameSize, beadSize;
	Point       pos, delta, offset;
	Boolean     sign, romanNumerals;
	Boolean     mono, reverse, script, demo, focus, vertical, aux;
	Boolean     versionOnly;
	Boolean     slot, diamond, sound;
	char       *digits, *mathBuffer;
	FILE       *fp;
	GC          frameGC, borderGC, railGC, inverseGC;
	GC          beadShadeGC[5];
	Pixmap      bufferBead[2][2];
	TimeVal     oldTime;
#ifdef WINVER
	char        format[81], bumpSound[81], moveSound[81];
#else
	char       *format, *bumpSound, *moveSound;
	int         menu;
	Colormap    colormap;
	Pixel       foreground, background;
	Pixel       borderColor, beadColor, frameColor, railColor;
	XtCallbackList select;
#endif
} AbacusPart;

typedef struct _AbacusDemoPart {
	int         lessons;
	int         lessonLength, lessonCount;
	int         aux, deck, rail, number, lines;
	int         fontHeight;
	FILE       *fp;
	Boolean     query, started, framed;
	GC          foregroundGC;
#ifdef WINVER
	char        path[81];
#else
	GC          inverseGC;
	char       *path, *font;
	XFontStruct *fontInfo;
	Pixel       background, foreground;
	XtCallbackList select;
#endif
} AbacusDemoPart;

typedef struct _AbacusRec {
	CorePart    core;
	AbacusPart  abacus;
	AbacusDemoPart abacusDemo;
} AbacusRec;

extern void SetAbacus(AbacusWidget w, int reason);
extern void SetAbacusDemo(AbacusWidget w, int reason);
extern void SetAbacusMove(AbacusWidget w, int reason, int aux,
	int deck, int rail, int number);
extern int char2Int(char character);
extern char int2Char(int digit);

extern void dividePieces(char * buf, int base, int pieces,
	int mult, int places);
extern void shiftDecimal(char *buf, char *aBuf, int shift, int place);
extern void addStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void subStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void convertString(char * buf, char * inbuf,
	int base, int displayBase, int decimalPosition,
	int anomaly, int shiftAnomaly,
	int anomalySq, int shiftAnomalySq);

extern int sizeofRoman(int base, Boolean romanNumerals);
extern int string2Roman(char *buf, char *inbuf, int base);
extern void calculate(AbacusWidget w, char *buffer);

extern int baseToBottom(int base);

extern void ClearRails(AbacusWidget w);
#endif /* _AbacusP_h */
