/***************************************
  $Header: /home/amb/wwwoffle/RCS/ssl.c 1.6 1999/12/07 18:42:13 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.5c.
  SSL (Secure Socket Layer) Tunneling functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>

#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"
#include "misc.h"
#include "config.h"
#include "sockets.h"
#include "proto.h"


/*+ Set to the name of the proxy if there is one. +*/
static char *proxy=NULL;

/*+ The file descriptor of the server. +*/
static int server=-1;


/*++++++++++++++++++++++++++++++++++++++
  Open a connection to get a URL using SSL tunneling.

  char *SSL_Open Returns NULL on success, a useful message on error.

  URL *Url The URL to open (used for host only).
  ++++++++++++++++++++++++++++++++++++++*/

char *SSL_Open(URL *Url)
{
 char *msg=NULL;
 char *colon;
 char *server_host=NULL;
 int server_port=0;

 proxy=SSLProxy;
 if(IsLocalNetHost(Url->host))
    proxy=NULL;

 if(proxy)
   {
    server_host=(char*)malloc(strlen(proxy)+1);
    strcpy(server_host,proxy);
   }
 else
   {
    server_host=(char*)malloc(strlen(Url->host)+1);
    strcpy(server_host,Url->host);
   }

 if((colon=strchr(server_host,':')))
   {
    *colon++=0;
    if(*colon)
       server_port=atoi(colon);
   }

 /* Open the connection. */

 server=-1;

 if(server_port)
   {
    server=OpenClientSocket(server_host,server_port,ConnectTimeout);
    init_buffer(server);

    if(server==-1)
       msg=PrintMessage(Warning,"Cannot open the SSL connection to %s port %d; [%!s].",server_host,server_port);
   }
 else
    msg=PrintMessage(Warning,"No port given for the SSL connection to %s.",server_host);

 free(server_host);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Write to the server to request the URL and reply to the client.

  char *SSL_Request Returns NULL on success, a useful message on error.

  int client The client socket.

  URL *Url The URL to get (used for host only).

  Header *request_head The head of the HTTP request for the URL.
  ++++++++++++++++++++++++++++++++++++++*/

char *SSL_Request(int client,URL *Url,Header *request_head)
{
 char *msg=NULL;

 if(proxy)
   {
    char *head;

    MakeRequestAuthorised(proxy,request_head);

    request_head->size-=strlen(request_head->url)-strlen(Url->host);
    strcpy(request_head->url,Url->host);

    head=HeaderString(request_head);

    PrintMessage(ExtraDebug,"Outgoing Request Head (to proxy)\n%s",head);

    if(write_string(server,head)==-1)
       msg=PrintMessage(Warning,"Failed to write to remote SSL proxy [%!s].");

    free(head);
   }

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Perform the transfer between client and proxy/server.

  int client The client socket.
  ++++++++++++++++++++++++++++++++++++++*/

void SSL_Transfer(int client)
{
 int nfd=client>server?client+1:server+1;
 fd_set readfd;
 struct timeval tv;
 int nc,ns;
 char buffer[READ_BUFFER_SIZE];

 while(1)
   {
    nc=ns=0;

    FD_ZERO(&readfd);

    FD_SET(server,&readfd);
    FD_SET(client,&readfd);

    tv.tv_sec=SocketTimeout;
    tv.tv_usec=0;

    if(select(nfd,&readfd,NULL,NULL,&tv)<=0)
       return;

    if(FD_ISSET(client,&readfd))
      {
       nc=read_data(client,buffer,READ_BUFFER_SIZE);
       if(nc>0)
          write_data(server,buffer,nc);
      }
    if(FD_ISSET(server,&readfd))
      {
       ns=read_data(server,buffer,READ_BUFFER_SIZE);
       if(ns>0)
          write_data(client,buffer,ns);
      }

    if(nc==0 && ns==0)
       return;
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Close a connection opened using SSL.

  int SSL_Close Return 0 on success, -1 on error.
  ++++++++++++++++++++++++++++++++++++++*/

int SSL_Close(void)
{
 return(CloseSocket(server));
}
