/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "RemoteControl.h"

const int BORDER_SIZE = 5;

CRemoteControl::CRemoteControl(wxWindow* parent, int id) :
wxPanel(parent, id),
m_callsign(NULL),
m_report(NULL)
{
	wxStaticBoxSizer* sizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Information")), wxVERTICAL);

	wxStaticText* callsignLabel = new wxStaticText(this, -1, wxT("To Radio"));
	sizer->Add(callsignLabel, 0, wxLEFT | wxRIGHT | wxTOP | wxALIGN_LEFT, BORDER_SIZE);

	m_callsign = new CCallsignTextCtrl(this, Callsign_Remote, wxEmptyString, wxDefaultPosition, wxSize(125, -1));
	sizer->Add(m_callsign, 0, wxLEFT | wxRIGHT | wxALIGN_LEFT, BORDER_SIZE);

	wxStaticText* reportLabel = new wxStaticText(this, -1, wxT("Report"));
	sizer->Add(reportLabel, 0, wxLEFT | wxRIGHT | wxTOP | wxALIGN_LEFT, BORDER_SIZE);

	m_report = new CReportTextCtrl(this, Report_Remote, wxEmptyString, wxDefaultPosition, wxSize(125, -1));
	sizer->Add(m_report, 0, wxLEFT | wxRIGHT | wxBOTTOM | wxALIGN_LEFT, BORDER_SIZE);

	wxButton* updateButton = new wxButton(this, Button_Remote, wxT("Update"));
	sizer->Add(updateButton, 0, wxALL | wxALIGN_CENTRE, BORDER_SIZE);

	SetSizer(sizer);

	sizer->SetSizeHints(this);
}

CRemoteControl::~CRemoteControl()
{
}

wxString CRemoteControl::getCallsign() const
{
	return m_callsign->GetValue().MakeUpper();
}

wxString CRemoteControl::getReport() const
{
	return m_report->GetValue().MakeUpper();
}
