/* basic_actions.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: basic_actions.cc,v 1.27 2005/12/04 20:00:38 ralf Exp $ */

#include "basic_actions.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

/***********
  DNDAction
************/

const char *DNDAction::name="DNDAction";

bool DNDAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *DNDAction::getName()
{
  return name;
}

DNDAction::DNDAction() : FunctionProto()
{
}

DNDAction::~DNDAction()
{
}

DNDAction *DNDAction::duplicate() const
{
  DNDAction *dnda=new DNDAction();
  return dnda;
}

int DNDAction::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  // do nothing in case of DND
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodedndaction( msg );
    }
  }
  return 0;
}

const char *DNDAction::getDescription()
{
  return catalog.getLocaleCom(0);
}

void DNDAction::normalmodedndaction( ActionMessage *am )
{
  ListerMode *lm1;
  Lister *l1 = am->getWorker()->getActiveLister();
  NormalMode *nm=NULL;
  ActionMessage amsg( am->getWorker() );
  const FileEntry *fe = NULL;
  NM_specialsourceExt *ss1;

  switch ( am->mode ) {
    case ActionMessage::AM_MODE_DNDACTION:
      break;
    case ActionMessage::AM_MODE_SPECIAL:
      fe = am->getFE();
      if ( fe != NULL ) {
        WCFiletype *ft;
      
        amsg.mode = amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if ( ft == NULL ) {
          ft = wconfig->getnotyettype(); // not yet checked
        }
        if ( ft != NULL ) {
	  // FE is already a copy of the real FE so we don't need to make another copy
	  // but setFE does make a copy currently which doesn't hurt
          amsg.setFE( fe );
          amsg.flags = ft->getDNDActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = DNDAction::getActionList;
          am->getWorker()->interpret( ft->getDNDActions(), &amsg );
        }
      }
      break;
    case ActionMessage::AM_MODE_ONLYACTIVE:
    default:
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL)
          if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
      }
      if(nm!=NULL) {
        std::list<NM_specialsourceExt*> *files=new std::list<NM_specialsourceExt*>;
	std::list<NM_specialsourceExt*>::iterator it1;
        nm->getSelFiles( files,
                         ( am->mode == ActionMessage::AM_MODE_ONLYACTIVE ) ? NormalMode::NM_GETFILES_ONLYACTIVE :
                                                                             NormalMode::NM_GETFILES_SELORACT,
                         false );
        WCFiletype *ft;
        
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
        
        if(files->size()==0) {
          ft = wconfig->getvoidtype();
          if(ft!=NULL) {
            amsg.setFE( NULL );
            amsg.flags=ft->getDNDActionsGF();
	    amsg.filetype = ft;
	    amsg.getActionList = DNDAction::getActionList;
            am->getWorker()->interpret(ft->getDNDActions(),&amsg);
          }
        } else {
	  for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
	    ss1 = *it1;
            fe = ss1->entry();
            if(fe!=NULL) {
	      ft=fe->filetype;
	      if ( ft == NULL ) {
		if ( fe->isDir() == true ) ft = wconfig->getdirtype();
		else ft = wconfig->getnotyettype();
	      }
	      if(ft!=NULL) {
		// NM_specialsourceExt already contains a duplicated FE so we can use
		// it here without another copy
		amsg.setFE( fe );
		amsg.flags=ft->getDNDActionsGF();
		amsg.filetype = ft;
		amsg.getActionList = DNDAction::getActionList;
		am->getWorker()->interpret(ft->getDNDActions(),&amsg);
	      }
            }
            delete ss1;
          }
        }
        delete files;
      }
      break;
  }
}

List *DNDAction::getActionList( class WCFiletype *filetype, int id, WCGlobalFlags **return_flags )
{
  if ( filetype == NULL ) return NULL;
  
  if ( return_flags != NULL ) {
    *return_flags = filetype->getDNDActionsGF();
  }

  return filetype->getDNDActions();
}

/***************
 Ende DNDAction
****************/

/*******************
  DoubleClickAction
********************/

const char *DoubleClickAction::name="DoubleClickAction";

bool DoubleClickAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *DoubleClickAction::getName()
{
  return name;
}

DoubleClickAction::DoubleClickAction() : FunctionProto()
{
}

DoubleClickAction::~DoubleClickAction()
{
}

DoubleClickAction *DoubleClickAction::duplicate() const
{
  DoubleClickAction *ta=new DoubleClickAction();
  return ta;
}

int DoubleClickAction::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeddaction( msg );
    }
  } else normalmodeddaction( msg );
  return 0;
}

const char *DoubleClickAction::getDescription()
{
  return catalog.getLocaleCom(1);
}

void DoubleClickAction::normalmodeddaction( ActionMessage *am )
{
  ListerMode *lm1;
  Lister *l1;
  NormalMode *nm=NULL;
  ActionMessage amsg( am->getWorker() );
  const FileEntry *fe = NULL;
  NM_specialsourceExt *ss1;

  switch ( am->mode ) {
    case ActionMessage::AM_MODE_DNDACTION:
      l1 = am->dndmsg->getSourceLister();
      if(l1==NULL) return;
  
      fe = am->dndmsg->getFE();
      if(fe!=NULL) {
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if(ft==NULL) {
          if ( fe->isDir() == false ) ft = wconfig->getnotyettype(); // not yet checked
          else ft = wconfig->getdirtype(); // dir
        }
        if(ft!=NULL) {
	  // I need to make a copy of fe as DNDMsg->getFE returns a pointer to the actual FE
	  // setFE takes care of this at the moment
          amsg.setFE( fe );
          amsg.flags=ft->getDoubleClickActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = DoubleClickAction::getActionList;
          am->getWorker()->interpret(ft->getDoubleClickActions(),&amsg);
        }
      }
      break;
    case ActionMessage::AM_MODE_SPECIAL:
      fe = am->getFE();
      if ( fe != NULL ) {
        WCFiletype *ft;
      
        amsg.mode = amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if ( ft == NULL ) {
          ft = wconfig->getnotyettype(); // not yet checked
        }
        if ( ft != NULL ) {
	  // FE is already a copy of the real FE so we don't need to make another copy
	  // but setFE does make a copy currently which doesn't hurt
          amsg.setFE( fe );
          amsg.flags = ft->getDoubleClickActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = DoubleClickAction::getActionList;
          am->getWorker()->interpret( ft->getDoubleClickActions(), &amsg );
        }
      }
      break;
    case ActionMessage::AM_MODE_ONLYACTIVE:
    default:
      l1 = am->getWorker()->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL)
          if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
      }
      if(nm!=NULL) {
        std::list<NM_specialsourceExt*> *files = new std::list<NM_specialsourceExt*>;
	std::list<NM_specialsourceExt*>::iterator it1;
        nm->getSelFiles( files,
                         ( am->mode == ActionMessage::AM_MODE_ONLYACTIVE ) ? NormalMode::NM_GETFILES_ONLYACTIVE :
                                                                             NormalMode::NM_GETFILES_SELORACT,
                         false );
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
        if(files->size()==0) {
          ft = wconfig->getvoidtype();
          if(ft!=NULL) {
            amsg.setFE( NULL );
            amsg.flags=ft->getDoubleClickActionsGF();
	    amsg.filetype = ft;
	    amsg.getActionList = DoubleClickAction::getActionList;
            am->getWorker()->interpret(ft->getDoubleClickActions(),&amsg);
          }
        } else {
	  for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
	    ss1 = *it1;
            fe = ss1->entry();
            if(fe!=NULL) {
	      ft=fe->filetype;
	      if ( ft == NULL ) {
		if ( fe->isDir() == true ) ft = wconfig->getdirtype();
		else ft = wconfig->getnotyettype();
	      }
	      if(ft!=NULL) {
		// NM_specialsourceExt already contains a duplicated FE so we can use
		// it here without another copy
		amsg.setFE( fe );
		amsg.flags=ft->getDoubleClickActionsGF();
		amsg.filetype = ft;
		amsg.getActionList = DoubleClickAction::getActionList;
		am->getWorker()->interpret(ft->getDoubleClickActions(),&amsg);
	      }
            }
            delete ss1;
          }
        }
        delete files;
      }
      break;
  }
}

List *DoubleClickAction::getActionList( class WCFiletype *filetype, int id, WCGlobalFlags **return_flags )
{
  if ( filetype == NULL ) return NULL;
  
  if ( return_flags != NULL ) {
    *return_flags = filetype->getDoubleClickActionsGF();
  }

  return filetype->getDoubleClickActions();
}

/***************
 Ende DoubleClickAction
****************/

/***********
  ShowAction
************/

const char *ShowAction::name="ShowAction";

bool ShowAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ShowAction::getName()
{
  return name;
}

ShowAction::ShowAction() : FunctionProto()
{
}

ShowAction::~ShowAction()
{
}

ShowAction *ShowAction::duplicate() const
{
  ShowAction *ta=new ShowAction();
  return ta;
}

int ShowAction::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeshow( msg );
    }
  } else normalmodeshow( msg );
  return 0;
}

const char *ShowAction::getDescription()
{
  return catalog.getLocaleCom(2);
}

void ShowAction::normalmodeshow( ActionMessage *am )
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg( am->getWorker() );
  Lister *l1;
  const FileEntry *fe = NULL;
  NM_specialsourceExt *ss1;

  switch ( am->mode ) {
    case ActionMessage::AM_MODE_DNDACTION:
      l1 = am->dndmsg->getSourceLister();
      if(l1==NULL) return;
  
      fe = am->dndmsg->getFE();
      if(fe!=NULL) {
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if(ft==NULL) {
          if ( fe->isDir() == false ) ft = wconfig->getnotyettype(); // not yet checked
          else ft = wconfig->getdirtype(); // dir
        }
        if(ft!=NULL) {
	  // I need to make a copy of fe as DNDMsg->getFE returns a pointer to the actual FE
	  // setFE takes care of this at the moment
          amsg.setFE( fe );
          amsg.flags=ft->getShowActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = ShowAction::getActionList;
          am->getWorker()->interpret(ft->getShowActions(),&amsg);
        }
      }
      break;
    case ActionMessage::AM_MODE_SPECIAL:
      fe = am->getFE();
      if ( fe != NULL ) {
        WCFiletype *ft;
      
        amsg.mode = amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if ( ft == NULL ) {
          ft = wconfig->getnotyettype(); // not yet checked
        }
        if ( ft != NULL ) {
	  // FE is already a copy of the real FE so we don't need to make another copy
	  // but setFE does make a copy currently which doesn't hurt
          amsg.setFE( fe );
          amsg.flags = ft->getShowActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = ShowAction::getActionList;
          am->getWorker()->interpret( ft->getShowActions(), &amsg );
        }
      }
      break;
    case ActionMessage::AM_MODE_ONLYACTIVE:
    default:
      l1 = am->getWorker()->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL)
          if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
      }
      if(nm!=NULL) {
        std::list<NM_specialsourceExt*> *files = new std::list<NM_specialsourceExt*>;
	std::list<NM_specialsourceExt*>::iterator it1;
        nm->getSelFiles( files,
                         ( am->mode == ActionMessage::AM_MODE_ONLYACTIVE ) ? NormalMode::NM_GETFILES_ONLYACTIVE :
                                                                             NormalMode::NM_GETFILES_SELORACT,
                         false );
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
        if(files->size()==0) {
          ft = wconfig->getvoidtype();
          if(ft!=NULL) {
            amsg.setFE( NULL );
            amsg.flags=ft->getShowActionsGF();
	    amsg.filetype = ft;
	    amsg.getActionList = ShowAction::getActionList;
            am->getWorker()->interpret(ft->getShowActions(),&amsg);
          }
        } else {
	  for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
	    ss1 = *it1;
            fe = ss1->entry();
            if(fe!=NULL) {
	      ft=fe->filetype;
	      if ( ft == NULL ) {
		if ( fe->isDir() == true ) ft = wconfig->getdirtype();
		else ft = wconfig->getnotyettype();
	      }
	      if(ft!=NULL) {
		// NM_specialsourceExt already contains a duplicated FE so we can use
		// it here without another copy
		amsg.setFE( fe );
		amsg.flags=ft->getShowActionsGF();
		amsg.filetype = ft;
		amsg.getActionList = ShowAction::getActionList;
		am->getWorker()->interpret(ft->getShowActions(),&amsg);
	      }
            }
            delete ss1;
          }
        }
        delete files;
      }
      break;
  }
}

List *ShowAction::getActionList( class WCFiletype *filetype, int id, WCGlobalFlags **return_flags )
{
  if ( filetype == NULL ) return NULL;
  
  if ( return_flags != NULL ) {
    *return_flags = filetype->getShowActionsGF();
  }

  return filetype->getShowActions();
}

/***************
 Ende ShowAction
****************/

/***********
 RawShowAction
************/

const char *RawShowAction::name="RawShowAction";

bool RawShowAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RawShowAction::getName()
{
  return name;
}

RawShowAction::RawShowAction() : FunctionProto()
{
}

RawShowAction::~RawShowAction()
{
}

RawShowAction *RawShowAction::duplicate() const
{
  RawShowAction *ta=new RawShowAction();
  return ta;
}

int RawShowAction::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmoderawshow( msg );
    }
  } else normalmoderawshow( msg );
  return 0;
}

const char *RawShowAction::getDescription()
{
  return catalog.getLocaleCom(3);
}

void RawShowAction::normalmoderawshow( ActionMessage *am )
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg( am->getWorker() );
  Lister *l1;
  const FileEntry *fe = NULL;
  NM_specialsourceExt *ss1;

  switch ( am->mode ) {
    case ActionMessage::AM_MODE_DNDACTION:
      l1 = am->dndmsg->getSourceLister();
      if(l1==NULL) return;
  
      fe = am->dndmsg->getFE();
      if(fe!=NULL) {
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if(ft==NULL) {
          if ( fe->isDir() == false ) ft = wconfig->getnotyettype(); // not yet checked
          else ft = wconfig->getdirtype(); // dir
        }
        if(ft!=NULL) {
	  // I need to make a copy of fe as DNDMsg->getFE returns a pointer to the actual FE
	  // setFE takes care of this at the moment
          amsg.setFE( fe );
          amsg.flags=ft->getRawShowActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = RawShowAction::getActionList;
          am->getWorker()->interpret(ft->getRawShowActions(),&amsg);
        }
      }
      break;
    case ActionMessage::AM_MODE_SPECIAL:
      fe = am->getFE();
      if ( fe != NULL ) {
        WCFiletype *ft;
      
        amsg.mode = amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if ( ft == NULL ) {
          ft = wconfig->getnotyettype(); // not yet checked
        }
        if ( ft != NULL ) {
	  // FE is already a copy of the real FE so we don't need to make another copy
	  // but setFE does make a copy currently which doesn't hurt
          amsg.setFE( fe );
          amsg.flags = ft->getRawShowActionsGF();
	  amsg.filetype = ft;
	  amsg.getActionList = RawShowAction::getActionList;
          am->getWorker()->interpret( ft->getRawShowActions(), &amsg );
        }
      }
      break;
    case ActionMessage::AM_MODE_ONLYACTIVE:
    default:
      l1 = am->getWorker()->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL)
          if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
      }
      if(nm!=NULL) {
        std::list<NM_specialsourceExt*> *files = new std::list<NM_specialsourceExt*>;
	std::list<NM_specialsourceExt*>::iterator it1;
        nm->getSelFiles( files,
                         ( am->mode == ActionMessage::AM_MODE_ONLYACTIVE ) ? NormalMode::NM_GETFILES_ONLYACTIVE :
                                                                             NormalMode::NM_GETFILES_SELORACT,
                         false );
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
        if(files->size()==0) {
          ft = wconfig->getvoidtype();
          if(ft!=NULL) {
            amsg.setFE( NULL );
            amsg.flags=ft->getRawShowActionsGF();
	    amsg.filetype = ft;
	    amsg.getActionList = RawShowAction::getActionList;
            am->getWorker()->interpret(ft->getRawShowActions(),&amsg);
          }
        } else {
	  for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
	    ss1 = *it1;
            fe = ss1->entry();
            if(fe!=NULL) {
	      ft=fe->filetype;
	      if ( ft == NULL ) {
		if ( fe->isDir() == true ) ft = wconfig->getdirtype();
		else ft = wconfig->getnotyettype();
	      }
	      if(ft!=NULL) {
		// NM_specialsourceExt already contains a duplicated FE so we can use
		// it here without another copy
		amsg.setFE( fe );
		amsg.flags=ft->getRawShowActionsGF();
		amsg.filetype = ft;
		amsg.getActionList = RawShowAction::getActionList;
		am->getWorker()->interpret(ft->getRawShowActions(),&amsg);
	      }
            }
            delete ss1;
          }
        }
        delete files;
      }
      break;
  }
}

List *RawShowAction::getActionList( class WCFiletype *filetype, int id, WCGlobalFlags **return_flags )
{
  if ( filetype == NULL ) return NULL;
  
  if ( return_flags != NULL ) {
    *return_flags = filetype->getRawShowActionsGF();
  }

  return filetype->getRawShowActions();
}

/***************
 Ende RawShowAction
****************/

/***********
  UserAction
************/

const char *UserAction::name="UserAction";

bool UserAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *UserAction::getName()
{
  return name;
}

UserAction::UserAction() : FunctionProto()
{
  nr=0;
  hasConfigure = true;
}

UserAction::~UserAction()
{
}

UserAction *UserAction::duplicate() const
{
  UserAction *ta=new UserAction();
  ta->nr=nr;
  return ta;
}

int UserAction::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeuseraction( msg );
    }
  } else normalmodeuseraction( msg );
  return 0;
}

const char *UserAction::getDescription()
{
  return catalog.getLocaleCom(4);
}

void UserAction::normalmodeuseraction( ActionMessage *am )
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg( am->getWorker() );
  Lister *l1;
  const FileEntry *fe = NULL;
  NM_specialsourceExt *ss1;

  switch ( am->mode ) {
    case ActionMessage::AM_MODE_DNDACTION:
      l1 = am->dndmsg->getSourceLister();
      if(l1==NULL) return;
  
      fe = am->dndmsg->getFE();
      if(fe!=NULL) {
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if(ft==NULL) {
          if ( fe->isDir() == false ) ft = wconfig->getnotyettype(); // not yet checked
          else ft = wconfig->getdirtype(); // dir
        }
        if(ft!=NULL) {
	  // I need to make a copy of fe as DNDMsg->getFE returns a pointer to the actual FE
	  // setFE takes care of this at the moment
          amsg.setFE( fe );
          amsg.flags=ft->getUserActionsGF(nr);
	  amsg.filetype = ft;
	  amsg.getActionList = UserAction::getActionList;
	  amsg.getActionListID = nr;
          am->getWorker()->interpret(ft->getUserActions(nr),&amsg);
        }
      }
      break;
    case ActionMessage::AM_MODE_SPECIAL:
      fe = am->getFE();
      if ( fe != NULL ) {
        WCFiletype *ft;
      
        amsg.mode = amsg.AM_MODE_SPECIAL;
      
	if ( am->filetype != NULL ) ft = am->filetype;
	else ft = fe->filetype;
        if ( ft == NULL ) {
          ft = wconfig->getnotyettype(); // not yet checked
        }
        if ( ft != NULL ) {
	  // FE is already a copy of the real FE so we don't need to make another copy
	  // but setFE does make a copy currently which doesn't hurt
          amsg.setFE( fe );
          amsg.flags = ft->getUserActionsGF( nr );
	  amsg.filetype = ft;
	  amsg.getActionList = UserAction::getActionList;
	  amsg.getActionListID = nr;
          am->getWorker()->interpret( ft->getUserActions( nr ), &amsg );
        }
      }
      break;
    case ActionMessage::AM_MODE_ONLYACTIVE:
    default:
      l1 = am->getWorker()->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL)
          if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
      }
      if(nm!=NULL) {
        std::list<NM_specialsourceExt*> *files = new std::list<NM_specialsourceExt*>;
	std::list<NM_specialsourceExt*>::iterator it1;
        nm->getSelFiles( files,
                         ( am->mode == ActionMessage::AM_MODE_ONLYACTIVE ) ? NormalMode::NM_GETFILES_ONLYACTIVE :
                                                                             NormalMode::NM_GETFILES_SELORACT,
                         false );
        WCFiletype *ft;
      
        amsg.startLister=l1;
        amsg.mode=amsg.AM_MODE_SPECIAL;
      
        if(files->size()==0) {
          ft = wconfig->getvoidtype();
          if(ft!=NULL) {
            amsg.setFE( NULL );
            amsg.flags=ft->getUserActionsGF(nr);
	    amsg.filetype = ft;
	    amsg.getActionList = UserAction::getActionList;
	    amsg.getActionListID = nr;
            am->getWorker()->interpret(ft->getUserActions(nr),&amsg);
          }
        } else {
	  for ( it1 = files->begin(); it1 != files->end(); it1++ ) {
	    ss1 = *it1;
            fe = ss1->entry();
            if(fe!=NULL) {
	      ft=fe->filetype;
	      if ( ft == NULL ) {
		if ( fe->isDir() == true ) ft = wconfig->getdirtype();
		else ft = wconfig->getnotyettype();
	      }
	      if(ft!=NULL) {
		// NM_specialsourceExt already contains a duplicated FE so we can use
		// it here without another copy
		amsg.setFE( fe );
		amsg.flags=ft->getUserActionsGF(nr);
		amsg.filetype = ft;
		amsg.getActionList = UserAction::getActionList;
		amsg.getActionListID = nr;
		am->getWorker()->interpret(ft->getUserActions(nr),&amsg);
	      }
            }
            delete ss1;
          }
        }
        delete files;
      }
      break;
  }
}

int UserAction::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win;
  CycleButton *rcyb;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(4))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(4));
  win =new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  rcyb = (CycleButton*)ac1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 0, 0, AContainer::CINCW );
  rcyb->addOption(catalog.getLocale(255));
  rcyb->addOption(catalog.getLocale(256));
  rcyb->addOption(catalog.getLocale(257));
  rcyb->addOption(catalog.getLocale(258));
  rcyb->addOption(catalog.getLocale(259));
  rcyb->addOption(catalog.getLocale(260));
  rcyb->addOption(catalog.getLocale(261));
  rcyb->addOption(catalog.getLocale(262));
  rcyb->addOption(catalog.getLocale(263));
  rcyb->addOption(catalog.getLocale(264));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  rcyb->setOption(nr);
  
  ac1->readLimits();
  
  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( -1 );
  ac1_1->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_1->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, AContainer::CFIX );
  Button *cb = (Button*)ac1_1->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, AContainer::CFIX );

  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    nr=rcyb->getSelectedOption();
  }
  
  delete win;

  return endmode;
}

bool UserAction::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  
  WConfig::configPutPairNum( fh, "actionnumber", nr );
  return true;
}

int UserAction::getNr() const
{
  return nr;
}

void UserAction::setNr( int n )
{
  nr = n;
  if ( nr < 0 ) nr = 0;
  if ( nr > 9 ) nr = 9;
}

List *UserAction::getActionList( class WCFiletype *filetype, int id, WCGlobalFlags **return_flags )
{
  if ( filetype == NULL ) return NULL;
  
  if ( return_flags != NULL ) {
    *return_flags = filetype->getUserActionsGF( id );
  }

  return filetype->getUserActions( id );
}

/***************
 Ende UserAction
****************/

/*****************
 ChangeHiddenFlag
******************/

const char *ChangeHiddenFlag::name="ChangeHiddenFlag";

ChangeHiddenFlag::ChangeHiddenFlag() : FunctionProto()
{
  mode=0;
  hasConfigure = true;
}

ChangeHiddenFlag::~ChangeHiddenFlag()
{
}

ChangeHiddenFlag *ChangeHiddenFlag::duplicate() const
{
  ChangeHiddenFlag *ta=new ChangeHiddenFlag();
  ta->mode=mode;
  return ta;
}

bool ChangeHiddenFlag::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ChangeHiddenFlag::getName()
{
  return name;
}

int ChangeHiddenFlag::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          switch(mode) {
            case 1:
              nm1->setShowHiddenE(false);
              break;
            case 2:
              nm1->setShowHiddenE(true);
              break;
            default:
              nm1->toggleHiddenE();          
          }
        }
      }
    }
  }
  return 0;
}

bool ChangeHiddenFlag::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  switch ( mode ) {
    case 1:
      WConfig::configPutPair( fh, "hiddenfiles", "hide" );
      break;
    case 2:
      WConfig::configPutPair( fh, "hiddenfiles", "show" );
      break;
    default:
      WConfig::configPutPair( fh, "hiddenfiles", "toggle" );
      break;
  }
  return true;
}

const char *ChangeHiddenFlag::getDescription()
{
  return catalog.getLocaleCom(7);
}

int ChangeHiddenFlag::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win;
  CycleButton *rcyb;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(7))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(7));
  win=new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  rcyb = (CycleButton*)ac1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 0, 0, AContainer::CINCW );
  rcyb->addOption(catalog.getLocale(360));
  rcyb->addOption(catalog.getLocale(361));
  rcyb->addOption(catalog.getLocale(362));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(mode) {
    case 1:
      rcyb->setOption(1);
      break;
    case 2:
      rcyb->setOption(2);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  ac1->readLimits();
  
  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( -1 );
  ac1_1->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_1->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, AContainer::CFIX );
  Button *cb = (Button*)ac1_1->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, AContainer::CFIX );
  
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        mode=1;
        break;
      case 2:
        mode=2;
        break;
      default:
        mode=0;
        break;
    }
  }
  
  delete win;

  return endmode;
}

int ChangeHiddenFlag::getMode() const
{
  return mode;
}

void ChangeHiddenFlag::setMode( int m )
{
  mode = m;
  if ( mode < 0 ) mode = 0;
  if ( mode > 2 ) mode = 2;
}

/**********************
 Ende ChangeHiddenFlag
***********************/

