/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <locale.h>
#include <unistd.h>
#include "intern.h"
#include "qfunciones.h"
#include <qglobal.h>
#include "salidas.h"

#ifdef HAVE_KDELIBS3
//#include <locale.h>
#include <kuniqueapp.h>
#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include "KApplicationWindow.h"
#include "version.h"
//#include <klocale.h>
#else

#if QT_VERSION < 300
//#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#endif 

#include <qapplication.h>
#include <qtextcodec.h>
#include "QApplicationWindow.h"

#endif

#include "no-gui.cpp"  //por ahora esto va slo en la versin Qt

#ifdef HAVE_KDELIBS3
static KCmdLineOptions options[]=
{
	{ "conf <dir>", "directory where look for configuration files", 0 },
//    { "nogui", "behaves like the console application \"wordtrans\"",0 },
	{ 0, 0, 0 }
};
#endif


int main( int argc, char *argv[] ) {
	//Debug handler
	Salidas::installDebugHandler();


//#ifndef HAVE_KDELIBS3
//Nota: esto no va en la versin kde, por el tema de los locales
//a ver si se puede arreglar ms adelante

	//Lo primero de todo buscamos --nogui en las opciones
	if (argc>0) for (int c=1;c<argc;c++) {
        //printf("%s\n", argv[c]);
		if (strcmp(argv[c],"--nogui")==0) {
#ifdef HAVE_KDELIBS3
			int argc_falso = 0;
			char * arg_falso[] = { "kwordtrans" };
			KApplication ap( argc_falso, arg_falso, "kwordtrans", false, false );
#endif
			setLocales(); //Debe estar esto aqu?
			return no_gui( argc, argv );
		}
	}
//#endif

	//Estilos
#ifndef HAVE_KDELIBS3
#if QT_VERSION < 300
	QApplication::setStyle( new QPlatinumStyle );
//	QApplication::setStyle( new QWindowsStyle );
#else
	QApplication::setStyle( "platinum" );
#endif
#endif

#ifdef HAVE_KDELIBS3
	KAboutData info("kwordtrans", "kwordtrans", VERSION, 
                    "Multi Language Word Translator", KAboutData::License_GPL,
                    "(c) 2000, 2001 Ricardo Villalba", "", 
                    "http://wordtrans.sourceforge.net/",
                    "rvm@escomposlinux.org");
	info.addAuthor( "Ricardo Villalba", "Author", "rvm@escomposlinux.org", 
                    "http://members.nbci.com/rvmsoft/");
	KCmdLineArgs::init( argc, argv, &info );

	KCmdLineArgs::addCmdLineOptions( options );
	KCmdLineArgs *args=KCmdLineArgs::parsedArgs();

	//KUniqueApplication
	KUniqueApplication::addCmdLineOptions();
	
	if (!KUniqueApplication::start()) {
		puts("kwordtrans is already running!");
		exit(0);
	}
	KUniqueApplication a;
	//KApplication a;

	//Locales
	setLocales(); //En intern.h

	QString conf_dir=args->getOption("conf");
	if (conf_dir.isEmpty()) {
		conf_dir=QString::null;
		//debug("conf_dir est vaco");
	}
	else {
		warning( "Not using ~/.wordtrans as configuration directory. "
                   "Changes will be lost!!!");
	}

	/*
	debug("Idioma: '%s'", KGlobal::locale()->language().latin1() );
	KGlobal::locale()->setLanguage("es");
	debug("Idioma: '%s'", KGlobal::locale()->language().latin1() );
	*/
	//debug("Bug Address: '%s'", info.bugAddress().latin1() );
#else
	QApplication a( argc, argv );

	//Locales
	setLocales(); //En intern.h
	/*
	// translation file for Qt
	QTranslator qt( 0 );
	qt.load( QString( "qt_" ) + QTextCodec::locale(), "." );
	a.installTranslator( &qt );
	*/

	//Es necesario buscar la opcin --conf antes de crear dicts.
	QString conf_dir=QString::null;
	if (argc>0) for (int c=1;c<argc;c++) {
		if (strcmp(argv[c],"--conf")==0) {
			if (check_arg(argc,c)) {
				conf_dir= argv[++c];
				warning( "Not using ~/.wordtrans as configuration directory. "
                           "Changes will be lost!!!");
			}
		} 
		else
		if (strcmp(argv[c],"--help")==0) {
			puts( _("qwordtrans [--help] [--conf dir] [--nogui]").latin1());
			puts( _("   --help              show this helping message").latin1());
			puts( _("   --conf dir          directory where look for configuration files").latin1());
			puts( _("   --nogui             behaves like the console application \"wordtrans\"").latin1());
			puts( _("                       example: 'qwordtrans --nogui -d i2e car'").latin1());
			puts( _("                       is the same as 'wordtrans -d i2e car'").latin1());
			exit(0);
		}
	}
#endif

	QDiccionarios diccionarios( conf_dir );
	diccionarios.load();

	QApplicationWindow *mw = new QApplicationWindow(&diccionarios, true, 0,
                                                    "main_window",
                                                    Qt::WDestructiveClose);
	if ( mw->hayError() ) {
		printf( _("Fatal error. Exiting").latin1() );
		return 1;
	}

	//a.setMainWidget(mw);

#ifdef HAVE_KDELIBS3
	a.setTopWidget(mw);
#endif

	//mw->show();

	a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
	int resultado= a.exec();

	diccionarios.save_all_dicts();
	return resultado;
}

