#!/usr/bin/python

#
# Config file handling, and defaults...
#

try:
  import os, sys
  if os.path.exists('/usr/lib/woody'):
    sys.path.append('/usr/lib/woody')
  from woody_defs import *
except IOError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)
except ImportError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)


############################################################
# Config class:
#
def is_config(obj):
  return hasattr(obj,'is_config') and obj.is_config

class config:
  is_config = 1

  def __init__(self):
    import os
    self.options = {}
    self.colors = {}
    self.usrfilename = "%s/.%s.conf" % (os.environ["HOME"], program_name)
    self.globalfilename = "/etc/%s/%s.conf" % (program_name, program_name)
    self.namespace = {
      "options" : self.options,
      "colors" : self.colors
      }

  def load(self):
    import os.path
    for name in [self.globalfilename, self.usrfilename]:
      if os.path.exists(name):
        self.parse(name)

  def parse(self, filename):
    #print "parsing %s..." % filename
    
    try:
      execfile(filename, self.namespace)
    except:
      print "Error in config file %s" % filename
      import traceback, sys
      foo = traceback.format_exception(sys.exc_type,
                                       sys.exc_value,
                                       sys.exc_traceback)
      for item in foo:
        item = item[:-1]
        print item
      print "Press Enter to continue..."
      raw_input()
      


if __name__ == "__main__":
  print "Loading config..."
  cfg = config()
  cfg.load()
  print "Done loading config."
  
