/*
 *	wmnut.h  -- Header file for WMNUT
 *
 *
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2, or (at your option)
 * 	any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program (see the file COPYING); if not, write to the
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 *
 */

#define DELAY 10000L		/* Delay between refreshes (in microseconds) */

#define WMNUT_VERSION "0.09"


/* Communication status definition */

#define COM_LOST       0
#define COM_OK         1

/* General codes definition */

#define NOK            0
#define OK             1
#define OFF            0
#define ON             1

/* UPS status definition */

#define UPS_LOWBATT	0
#define UPS_ONBATT	1
#define UPS_ONLINE	2
#define UPS_OVERLOAD	3
 
/* structure to monitor an UPS unit */

/* typedef struct ups_info { */
/*   int        hostnumber; */
/*   char       *hostname; */
/*   const char driver_version[10]; */
/*   int        ac_line_status; */
/*   int        battery_status; */
/*   int        comm_status; */
/*   int        battery_flags; */
/*   int        battery_percentage; */
/*   int        battery_time; */
/*   int        battery_load; */
/*   int        using_minutes; */
/* } ups_info; */

typedef struct ups_info {
  int        hostnumber;
  char       *hostname;	       		/* upsname@hostname */
  const char driver_version[10];	/* */
  int        ups_status; /* !! ac_line_status !! */
  int        comm_status;
  int        battery_percentage;
  int        battery_load;		/* load on UPS output */
  int        battery_runtime; /* !! battery_time !! */
  int        using_minutes;		/* raw runtime is expressed in seconds (0) or in minutes (1) */
} ups_info;

/*
 * struct to monitor multiple hosts
 */

typedef struct my_nut_info {
  int hosts_number;  		/* total number of hosts */ 
  int curhosts_number; 		/* number of the currently displayed host */ 
  ups_info **Ups_list;
} my_nut_info;
