#ifndef WMGENERAL_H_INCLUDED
#define WMGENERAL_H_INCLUDED

  /***********/
 /* Defines */
/***********/

#define WMNUT_NAME "wmnut"

/* Configuration files */
#define MAINRC_FILE "/etc/wmnutrc"
#define RC_FILE     ".wmnutrc"


#define MAX_MOUSE_REGION (8)

#define TYPE_NULL	0
#define TYPE_INT	1
#define TYPE_FLOAT	2
#define TYPE_STRING	3
#define TYPE_BOOL	4

  /************/
 /* Typedefs */
/************/

union var {
  int   *integer;
  float *floater;
  char  *str;
  int   *bool;
};

typedef struct _rckeys rckeys;

struct _rckeys {
  /*const*/ char *label;
  int        type;
  union var  var;
};

typedef struct {
  Pixmap	pixmap;
  Pixmap	mask;
  XpmAttributes	attributes;
} XpmIcon;

  /*******************/
 /* Global variable */
/*******************/

Display		*display;

  /***********************/
 /* Function Prototypes */
/***********************/

void AddMouseRegion(int index, int left, int top, int right, int bottom);
int  CheckMouseRegion(int x, int y);

void openXwindow(int argc, char *argv[], char **, char *, int, int, int withdrawn);
void RedrawWindow(void);
void RedrawWindowXY(int x, int y);
void CheckX11Events();
void pressEvent(XButtonEvent *xev);

void copyXPMArea(int, int, int, int, int, int);
void copyXBMArea(int, int, int, int, int, int);
void setMaskXY(int, int);

void AddRcKey(rckeys *key, const char *label, int type, void *var);
void ParseRCFile(const char *filename, rckeys *keys);
/*  void ParseCMDLine(int argc, char *argv[]); */
void LoadRCFile(rckeys *keys);
void ReloadRCFile();

  /************/
 /* Datadefs */
/************/

#endif
