#!/usr/bin/perl
#
# This cgi script reads statistics html file created by wiplc and changes it 
# by:
#
#   1) Coloring the IP adress of the machine retreviewing the statistics
#      (requires that there is a colum with the IP address, ie a "ip4" colum
#       in the statistics)
#   2) Optionally filters out some colums, for example the IP address
#      to protect the privacy of the clients.
#
# From the browser this script should be called with something like:
#
#   redtable.cgi?type=in

# The following should be set to the directory where the statistics
# created by wiplc is placed
$htmldir="/var/www/wipl";

# The following should be a list of files in the directory
# above but without html extension:
@validfiles=("out","in");

# If the following is not commented out it's a list of colums that
# should be displayed:
@colums=(0,1,2,3,4,5,6);

#------------------------------------------------------------------------------

# Create a hash with colum numbers
if(defined(@colums)) {
  foreach $l (@colums) {
    $colhash{$l}=1;
  }
}

# Find the file to show:
if($ENV{QUERY_STRING}=~/.*type=(\w*)/) {;
  $type=$1;
}

$file=$htmldir."/".$validfiles[0]; # Default
foreach $l (@validfiles) {
  if($type eq $l) { 
    $file=$htmldir."/".$l;
  }
}

# Find the query IP address:
if($ENV{REMOTE_ADDR}=~/(\d*\.\d*\.\d*\.\d*)/) {
  $ipaddr=$1;
}

# Show the page

# Print head to http server:
print "Content-type: text/html\n\n";

# Open the file to start
open(FILE,$file.".html");


# And copy file to stdout with possible change
while($line=<FILE>) {
  # Remove end of line marker
  if($line =~ /(.*)/) {
    $line=$1;
  }
  
  # See if this line should be colored:
  if(index($line,"$ipaddr ")!=-1) {
    $color=1;
  } else {
    $color=0;
  }
    
  # Select colums:
  if(defined(%colhash)) {
    if(index($line,'|')!=-1) {
      $char='|';
      @cols=split('\|',$line);
    } elsif (index($line,'+')!=-1) {
      $char='+';
      @cols=split('\+',$line);
    } else {
      goto hans;
    }

    @result=();
    for($i=0; $i<scalar(@cols); $i++) {
      if(exists($colhash{$i})) {
        $result[scalar(@result)]=$cols[$i];
      }
    }
    $line=join($char,@result);
  }
  hans:
  
  # Print line:
  if($color) {
    print "<u><font color=#0000ff>$line</font></u>\n";
  } else {
    print "$line\n";
  }    
}
