#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <getopt.h>

#include "common.h"
#include "shmem.h"

main(int argc, char* argv[]) {
  char* ipcid=DEFAULT_DAEMONFILE;

  for(;;) {
    static option long_options[]=
      {
       {"daemon",1,0,'d'},
      };
     
     int c=getopt_long(argc,argv,"d:",long_options,0);
     if(c==EOF) break;
     
     switch(c) {
       case 'd':
         ipcid=optarg;
	 break;
	 
       // Error situations:
       case ':':
         fprintf(stderr,"Missing parameter for option\n");
	 return 1;
       case '?':
         return 1; // The getopt library prints an error message
	 break;	 
       default:
         // Should not happen, I guess
	 fprintf(stderr,"Error parsing commandline arguments\n");
	 return 1;
       
     }
  }
  
  int counterc=argc-optind;
  
  if(counterc<=0) {
    fprintf(stderr,"At least one counter must be specified\n");
    return 1;
  }
  
  int* counters=new int[counterc];
  
  for(int a=0; a<counterc; a++) {
    if(sscanf(argv[argc-counterc+a],"%i",&counters[a])!=1 ||
       counters[a]<0 || counters[a]>=maxcounterc) {
      fprintf(stderr,"Illegal counter: %s\n",argv[argc-counterc+a]);
      return 1;
    }
  }
  
  // Parameters are read.
  
  // Get IP address of the connecting maching:
  sockaddr_in from;
  unsigned fromlen=sizeof(from);
  
  if(getpeername(0,(sockaddr*)&from,&fromlen)<0) {
    fprintf(stderr,"Cannot get peername. Note that this program must be called from inetd.\n");
    return 1;
  }
  ip_addr fromip;
  fromip=from.sin_addr;
  
  // And then establish contact to the server:
  ShMemClient Mem0000;
  
  char* c=Mem0000.init(ipcid,1);
  if(c) {
    printf("101 Internal Error: %s\r\n",c);
    return 1;
  }
  
  // Start command read loop:
  char buf[80];
  for(;;) {
    if(!fgets(buf,sizeof(buf)-2,stdin)) {
      printf("102 Read error\r\n");
      return 1;
    }
    if(!strcmp(buf,"gos\r\n")) { // The user wants to read data:
      // Now set the variabels below from the server.      
      CardInfo ci;
      char CounterNames[maxcounterc][MaxCounterNameLen+1];
      timeval tv; 

      ServerMem* c=(ServerMem*)Mem0000.Lock();
      if(c==0) {
        printf("101 Internal Error: %s\r\n",LockErrString);
        return 1;
      }
            
      gettimeofday(&tv,0);
      memcpy(CounterNames,c->CounterNames,sizeof(CounterNames));
            
      int cardindex=-1;      
      
      for(int a=c->curcardc-1; a>=0; a--) {
	CardInfo& curci=c->cards[a];
	
	if(curci.ipaddr==fromip) {
          cardindex=a;
	  break;
        }
      }
      if(cardindex!=-1) 
        ci=c->cards[cardindex];
      else
        ci.setZero();
      Mem0000.UnLock(c);
  
      // Print the info
      printf("000 Counters: %i\r\n",counterc);
      printf("000 Time: %lu %lu\r\n",tv.tv_sec,tv.tv_usec);
       	  
      for(int b=0; b<counterc; b++) {
        printf("000 %s: %u:%u\r\n",
	  CounterNames[counters[b]],
          cardindex!=-1 ? unsigned(ci.Counters[counters[b]]>>32) : 0,
          cardindex!=-1 ? unsigned(ci.Counters[counters[b]] & int64(0xffffffff)) : 0);
      }
    } else if(!strcmp(buf,"quit\r\n")) {
      return 0;      
    } else {
      printf("100 Commands:\r\n"
             "100  gos  = Get Own Statistics. The time is in seconds and\r\n"
	     "100         micro seconds. The counters are given as two\r\n"
	     "100         32-bit decimal numbers.\r\n"	     
             "100  quit = Quit\r\n");
    }
    fflush(stdout);
  }
}
