'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: find.n,v 1.1.1.1 2001/07/08 17:45:38 jwhite Exp $
'\"
.so man.macros
.TH find n 3.0 itcl "[incr\ Tcl]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
find \- search for classes and objects
.SH SYNOPSIS
\fBfind \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBfind\fR command is used to find classes and objects
that are available in the current context.  A class or object is
"available" if its access command can be found in the current
namespace context or in the global namespace.  Therefore,
classes and objects created in the global namespace are
available to all other namespaces in a program.  Classes and
objects created in one namespace can also be imported into
another using the \fBnamespace import\fR command.
.PP
The \fIoption\fR argument determines what action is carried out
by the command.  The legal \fIoptions\fR (which may be abbreviated)
are:
.TP
\fBfind classes ?\fIpattern\fR?
Returns a list of classes found in the current namespace context.
If the optional \fIpattern\fR is specified, then the reported names
are compared using the rules of the "\fBstring match\fR" command,
and only matching names are reported.
.sp
If a class resides in the current namespace context, this command
reports its simple name--without any qualifiers.  However, if the
\fIpattern\fR contains \fB::\fR qualifiers, or if the class resides
in another context, this command reports its fully-qualified name.
.TP
\fBfind objects ?\fIpattern\fR? ?\fB-class \fIclassName\fR? ?\fB-isa \fIclassName\fR?
Returns a list of objects found in the current namespace context.
If the optional \fIpattern\fR is specified, then the reported names
are compared using the rules of the "\fBstring match\fR" command,
and only matching names are reported.
If the optional "\fB-class\fR" parameter is specified, this list is
restricted to objects whose most-specific class is \fIclassName\fR.
If the optional "\fB-isa\fR" parameter is specified, this list is
further restricted to objects having the given \fIclassName\fR
anywhere in their heritage.
.sp
If an object resides in the current namespace context, this command
reports its simple name--without any qualifiers.  However, if the
\fIpattern\fR contains \fB::\fR qualifiers, or if the object resides
in another context, this command reports its fully-qualified name.

.SH KEYWORDS
class, object, search, import
