if {[catch {package require Tcl 8.3} ErrMsg]} {
  error "Unable to load Tcl package: $ErrMsg"
}

if {[catch {package require Tk 8.3} ErrMsg]} {
  error "Unable to load Tk package: $ErrMsg"
}

if {[catch {package require Itcl 3.1} ErrMsg]} {
  error "Unable to load Itcl package: $ErrMsg"
}

if {[catch {package require Itk 3.1} ErrMsg]} {
  error "Unable to load Itk package: $ErrMsg"
}
namespace import -force itcl::*

if {[catch {package require Iwidgets 3.1} ErrMsg]} {
  error "Unable to load Iwidgets package: $ErrMsg"
}

##################################
# set some variables we depend on
##################################
set ::gFontFixed "Fixed -13"
set ::gFontProp "Helvetica -12"
set ::gTmpDir /tmp

# home
if {[info exists ::env(HOME)] && [file readable $::env(HOME)]} {
  set ::gHome $::env(HOME)
} else {
  set ::gHome /
}

# browse init dir
set ::gBrowseInitDir $::gHome

###########################################################################

namespace eval ::cwdialog {
  namespace export *

  variable ngLibPath [file dirname [info script]]
  variable ngLibVersion 0.1.0
  variable ngLibDataDir $ngLibPath/data

  variable ngWineFakeWinRoot $::env(HOME)/.wine/fake_windows
}

lappend auto_path [file join $cwdialog::ngLibPath scripts]
package provide Cwdialog $cwdialog::ngLibVersion
