#
# config.rb -- Default configurations.
#
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2000, 2001 TAKAHASHI Masayoshi, GOTOU Yuuzou
#
# $IPR: config.rb,v 1.28 2002/02/05 20:20:30 gotoyuzo Exp $

require 'webrick/version'
require 'webrick/httputils'
require 'webrick/utils'
require 'webrick/log'

module WEBrick
  module Config
    LIBDIR = File::dirname(__FILE__)

    # for GenericServer
    General = {
      :ServerName     => Utils::getservername,
      :Port           => nil,   # users MUST specifiy this!!
      :BindAddress    => nil,   # "0.0.0.0" or "::" or nil
      :ServerType     => nil,   # default: WEBrick::SimpleServer
      :StartThreads   => 5,     # number of working threads
      :Logger         => nil,   # default: WEBrick::Log.new
      :ServerSoftware => "WEBrick/#{WEBrick::VERSION} " +
                         "(Ruby/#{RUBY_VERSION}/#{RUBY_RELEASE_DATE})",
      :TempDir        => ENV['TMPDIR']||ENV['TMP']||ENV['TEMP']||'/tmp',
      :ListenImmediately => true,
    }

    # for HTTPServer, HTTPRequest, HTTPResponse ...

    HTTP = General.dup.update({
      :Port           => 80,
      :RequestTimeout => 30,
      :DocumentRoot   => nil,
      :HTTPVersion    => 1.1,
      :MimeTypes      =>
        HTTPUtils::load_mime_types(LIBDIR + "/mime.types"),
      :DirectoryIndex =>
        [ "index.html", "index.htm", "index.rhtml", "index.cgi" ],
      :DirectoryListEnable => true,
    })

  end
end
