# servers-lib.pl
# Common functions for managing servers

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

sub list_servers
{
local ($f, @rv);
opendir(DIR, $module_config_directory);
while($f = readdir(DIR)) {
	if ($f =~ /^(\d+)\.serv$/) {
		push(@rv, &get_server($1));
		}
	}
closedir(DIR);
return @rv;
}

# get_server(id)
sub get_server
{
local $serv;
$serv->{'id'} = $_[0];
&read_file("$module_config_directory/$_[0].serv", $serv) || return undef;
return $serv;
}

# save_server(&server)
sub save_server
{
&lock_file("$module_config_directory/$_[0]->{'id'}.serv");
&write_file("$module_config_directory/$_[0]->{'id'}.serv", $_[0]);
chmod(0600, "$module_config_directory/$_[0]->{'id'}.serv");
&unlock_file("$module_config_directory/$_[0]->{'id'}.serv");
}

# delete_server(id)
sub delete_server
{
&lock_file("$module_config_directory/$_[0].serv");
unlink("$module_config_directory/$_[0].serv");
&unlock_file("$module_config_directory/$_[0].serv");
}

# can_use_server(&server)
sub can_use_server
{
return 1 if ($access{'servers'} eq '*');
foreach $s (split(/\s+/, $access{'servers'})) {
	return 1 if ($_[0]->{'host'} eq $s);
	}
return 0;
}

@server_types = ( [ 'caldera', 'OpenLinux' ],
		  [ 'redhat', 'Redhat Linux' ],
		  [ 'suse', 'SuSE Linux' ],
		  [ 'debian', 'Debian Linux' ],
		  [ 'mandrake', 'Mandrake Linux' ],
		  [ 'msc', 'MSC.Linux' ],
		  [ 'linux', 'Linux' ],
		  [ 'freebsd', 'FreeBSD' ],
		  [ 'solaris', 'Solaris' ],
		  [ 'hpux', 'HP/UX' ],
		  [ 'sco', 'SCO' ],
		  [ 'mac', 'Macintosh' ],
		  [ 'irix', 'IRIX' ],
		  [ 'unknown', $text{'lib_other'} ] );


1;

