#!/usr/local/bin/perl
# edit_conf.cgi
# Display ha_conf options

require './heartbeat-lib.pl';
&header($text{'conf_title'}, "");
print "<hr>\n";

@conf = &get_ha_config();
print "<form action=save_conf.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'conf_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

$serial = &find("serial", \@conf);
print "<tr> <td><b>$text{'conf_serial'}</b></td>\n";
print "<td><select name=serial>\n";
opendir(DIR, "/dev");
printf "<option value='' %s>%s\n",
	$serial ? "" : "selected", $text{'conf_none'};
foreach $p (glob($config{'serials'})) {
	printf "<option %s>%s\n",
		$p eq $serial ? "selected" : "", $p;
	$sfound++ if ($p eq $serial);
	}
closedir(DIR);
print "<option selected>$serial\n" if ($serial && !$sfound);
print "</select></td>\n";

$baud = &find("baud", \@conf);
print "<td><b>$text{'conf_baud'}</b></td> <td>\n";
printf "<input type=radio name=baud_def value=1 %s> %s\n",
	$baud ? "" : "checked", $text{'default'};
printf "<input type=radio name=baud_def value=0 %s>\n",
	$baud ? "checked" : "";
printf "<input name=baud size=6 value='%s'></td> </tr>\n", $baud;

$udp = &find("udp", \@conf);
print "<tr> <td><b>$text{'conf_udp'}</b></td> <td>\n";
printf "<input type=radio name=udp_def value=1 %s> %s\n",
	$udp ? "" : "checked", $text{'conf_none'};
printf "<input type=radio name=udp_def value=0 %s>\n",
	$udp ? "checked" : "";
printf "<input name=udp size=6 value='%s'></td>\n", $udp;

$udpport = &find("udpport", \@conf);
print "<td><b>$text{'conf_udpport'}</b></td> <td>\n";
printf "<input type=radio name=udpport_def value=1 %s> %s\n",
	$udpport ? "" : "checked", $text{'default'};
printf "<input type=radio name=udpport_def value=0 %s>\n",
	$udpport ? "checked" : "";
printf "<input name=udpport size=6 value='%s'></td> </tr>\n", $udpport;

$keepalive = &find("keepalive", \@conf);
print "<tr> <td><b>$text{'conf_keepalive'}</b></td> <td>\n";
printf "<input type=radio name=keepalive_def value=1 %s> %s\n",
	$keepalive ? "" : "checked", $text{'default'};
printf "<input type=radio name=keepalive_def value=0 %s>\n",
	$keepalive ? "checked" : "";
printf "<input name=keepalive size=6 value='%s'> %s</td>\n",
	$keepalive, $text{'conf_secs'};

$deadtime = &find("deadtime", \@conf);
print "<td><b>$text{'conf_deadtime'}</b></td> <td>\n";
printf "<input type=radio name=deadtime_def value=1 %s> %s\n",
	$deadtime ? "" : "checked", $text{'default'};
printf "<input type=radio name=deadtime_def value=0 %s>\n",
	$deadtime ? "checked" : "";
printf "<input name=deadtime size=6 value='%s'> %s</td> </tr>\n",
	$deadtime, $text{'conf_secs'};

$watchdog = &find("watchdog", \@conf);
print "<tr> <td><b>$text{'conf_watchdog'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=watchdog_def value=1 %s> %s\n",
	$watchdog ? "" : "checked", $text{'conf_none'};
printf "<input type=radio name=watchdog_def value=0 %s>\n",
	$watchdog ? "checked" : "";
printf "<input name=watchdog size=25 value='%s'> %s</td> </tr>\n",
	$watchdog, &file_chooser_button("watchdog");

print "<tr> <td valign=top><b>$text{'conf_node'}</b></td> <td colspan=3>\n";
print "<textarea name=node rows=4 cols=40>",
	join("\n", &find("node", \@conf)),"</textarea></td> </tr>\n";

$logfile = &find("logfile", \@conf);
print "<tr> <td><b>$text{'conf_logfile'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=logfile_def value=1 %s> %s\n",
	$logfile ? "" : "checked", $text{'conf_none'};
printf "<input type=radio name=logfile_def value=0 %s>\n",
	$logfile ? "checked" : "";
printf "<input name=logfile size=40 value='%s'> %s</td> </tr>\n",
	$logfile, &file_chooser_button("logfile");

$logfacility = &find("logfacility", \@conf);
print "<tr> <td><b>$text{'conf_logfacility'}</b></td> <td>\n";
printf "<input type=radio name=logfacility_def value=1 %s> %s\n",
	$logfacility ? "" : "checked", $text{'default'};
printf "<input type=radio name=logfacility_def value=0 %s>\n",
	$logfacility ? "checked" : "";
if (&foreign_check("syslog")) {
	local %sconfig = &foreign_config("syslog");
	print "<select name=logfacility>\n";
	foreach $f (split(/\s+/, $sconfig{'facilities'})) {
		printf "<option %s>%s\n",
			$f eq $logfacility ? "selected" : "", $f;
		}
	print "</select>\n";
	}
else {
	printf "<input name=logfacility size=15 value='%s'>\n", $logfacility;
	}
print "</td>\n";

$initdead = &find("initdead", \@conf);
print "<td><b>$text{'conf_initdead'}</b></td> <td>\n";
printf "<input type=radio name=initdead_def value=1 %s> %s\n",
	$initdead ? "" : "checked", $text{'default'};
printf "<input type=radio name=initdead_def value=0 %s>\n",
	$initdead ? "checked" : "";
printf "<input name=initdead size=6 value='%s'> %s</td> </tr>\n",
	$initdead, $text{'conf_secs'};

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'conf_ok'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

