import java.awt.*;
import java.io.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import netscape.javascript.JSObject;

// A java filemanager that allows the user to manipulate files on the
// Webmin server. Layout is similar to the windows explorer - directory
// tree on the left, files on the right, action buttons on the top.
public class FileManager extends Applet
	implements CbButtonCallback, HierarchyCallback, MultiColumnCallback
{
	// top buttons
	CbButton open_b, view_b, edit_b, refresh_b, props_b,
		 copy_b, cut_b, paste_b, delete_b, new_b, upload_b, mkdir_b,
		 makelink_b, rename_b, share_b, search_b, acl_b, attr_b;

	// Directory tree
	Hierarchy dirs;
	FileNode root;
	Hashtable nodemap = new Hashtable();

	// File list
	MultiColumn files;
	TextField pathname;
	RemoteFile showing_files;

	// Copying and pasting
	String cut_buffer;
	boolean cut_mode;

	static final String monmap[] = { "Jan", "Feb", "Mar", "Apr",
					 "May", "Jun", "Jul", "Aug",
					 "Sep", "Oct", "Nov", "Dec" };
	String accroot[];
	Hashtable lang = new Hashtable();
	Hashtable stab = new Hashtable(),
		  ntab = new Hashtable();
	boolean sambamode;
	int nfsmode;
	String trust;

	boolean got_filesystems;
	Vector fslist = new Vector();

	public void init()
	{
	setLayout(new BorderLayout());
	StringTokenizer tok = new StringTokenizer(getParameter("root"), " ");
	accroot = new String[tok.countTokens()];
	for(int i=0; tok.hasMoreTokens(); i++)
		accroot[i] = tok.nextToken();
	trust = getParameter("trust");

	// download language strings
	String l[] = get_text("lang.cgi");
	for(int i=0; i<l.length; i++) {
		int eq = l[i].indexOf('=');
		if (eq >= 0)
			lang.put(l[i].substring(0, eq), l[i].substring(eq+1));
		}

	// list samba file shares
	String s[] = get_text("list_shares.cgi");
	if (s[0].equals("1")) {
		for(int i=1; i<s.length; i++) {
			SambaShare ss = new SambaShare(s[i]);
			stab.put(ss.path, ss);
			}
		sambamode = true;
		}

	// list NFS exports
	String e[] = get_text("list_exports.cgi");
	nfsmode = e.length == 0 ? 0 : Integer.parseInt(e[0]);
	if (nfsmode != 0) {
		for(int i=1; i<e.length; i++) {
			if (nfsmode == 1) {
				// Linux export
				LinuxExport le = new LinuxExport(e[i]);
				ntab.put(le.path, le);
				}
			else if (nfsmode == 2) {
				// Solaris share
				DFSAdminExport de = new DFSAdminExport(e[i]);
				ntab.put(de.path, de);
				}
			}
		}

	// list filesystems
	String f[] = get_text("filesystems.cgi");
	got_filesystems = f[0].equals("1");
	boolean acl_support = false,
		attr_support = false;
	if (got_filesystems) {
		for(int i=1; i<f.length; i++) {
			FileSystem fs = new FileSystem(f[i]);
			fslist.addElement(fs);
			if (fs.acls) acl_support = true;
			if (fs.attrs) attr_support = true;
			}
		}

	// create button panel
	BorderPanel top = new BorderPanel(2);
	top.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));

	Panel top1 = new Panel();
	top1.setLayout(new GridLayout(1, 0));
	top1.add(open_b = make_button("open.gif", text("top_open")));
	top1.add(view_b = make_button("view.gif", text("top_view")));
	top1.add(edit_b = make_button("edit.gif", text("top_edit")));
	top1.add(refresh_b = make_button("refresh.gif", text("top_refresh")));
	top1.add(props_b = make_button("props.gif", text("top_info")));
	if (acl_support)
		top1.add(acl_b = make_button("acl.gif", text("top_eacl")));
	if (attr_support)
		top1.add(attr_b = make_button("attr.gif", text("top_attr")));
	top1.add(search_b = make_button("search.gif", text("top_search")));
	top.add(top1);
	top.add(new Label(""));
	
	Panel top2 = new Panel();
	top2.setLayout(new GridLayout(1, 0));
	top2.add(delete_b = make_button("cancel.gif", text("top_delete")));
	top2.add(new_b = make_button("new.gif", text("top_new")));
	top2.add(upload_b = make_button("upload.gif", text("top_upload")));
	top2.add(mkdir_b = make_button("mkdir.gif", text("top_new")));
	if (!getParameter("follow").equals("1"))
		top2.add(makelink_b = make_button("makelink.gif",
					text("top_new")));
	top2.add(rename_b = make_button("rename.gif", text("top_rename")));
	if ((sambamode || nfsmode != 0) && getParameter("sharing").equals("1"))
		top2.add(share_b = make_button("share.gif", text("top_share")));
	top.add(top2);
	top.add(new Label(""));

	Panel top3 = new Panel();
	top3.setLayout(new GridLayout(1, 0));
	top3.add(copy_b = make_button("copy.gif", text("top_copy")));
	top3.add(cut_b = make_button("cut.gif", text("top_cut")));
	top3.add(paste_b = make_button("paste.gif", text("top_paste")));
	top.add(top3);
	add("North", top);

	// create directory tree
	BorderPanel left = new BorderPanel(2);
	left.setLayout(new BorderLayout());
	root = new FileNode(new RemoteFile(this, get_text("root.cgi")[0],null));
	left.add("Center", dirs = new Hierarchy(root, this));
	root.open = true; root.fill();

	// create file window
	BorderPanel right = new BorderPanel(2);
	right.setLayout(new BorderLayout());
	right.add("North", pathname = new TextField());
	//pathname.setFont(new Font("courier", Font.PLAIN, 8));
	String cols[] = { "", text("right_name"), text("right_size"),
			  text("right_user"), text("right_group"),
			  text("right_date") };
	float widths[] = { .07f, .33f, .15f, .15f, .15f, .15f };
	right.add("Center", files = new MultiColumn(cols, this));
	files.setWidths(widths);
	files.setDrawLines(false);
	show_files(root.file);

	ResizePanel mid = new ResizePanel(left, right, .3);
	add("Center", mid);

	// Go to the restricted directory
	String home = getParameter("home");
	if (home != null)
		find_directory(home, true);
	else if (!accroot[0].equals("/"))
		find_directory(accroot[0], true);
	}

	CbButton make_button(String f, String t)
	{
	if (size().width < 700 && size().width > 1)
		return new CbButton(get_image(f), this);
	else
		return new CbButton(get_image(f), t, CbButton.ABOVE, this);
	}

	// Gets an image from the images directory
	Image get_image(String img)
	{
	return getImage(getDocumentBase(), "images/"+img);
	}

	String[] get_text(String url)
	{
	try {
		long now = System.currentTimeMillis();
		if (url.indexOf('?') > 0) url += "&rand="+now;
		else url += "?rand="+now;
		url += "&trust="+trust;
		URL u = new URL(getDocumentBase(), url);
		Vector lv = new Vector();
		LineInputStream is = new LineInputStream(u.openStream());
		while(true)
			try { lv.addElement(is.gets()); }
			catch(EOFException eof) { break; }
		is.close();
		String rv[] = new String[lv.size()];
		lv.copyInto(rv);
		return rv;
		}
	catch(Exception e) {
		e.printStackTrace();
		//return null;
		String err[] = { e.getMessage() };
		return err;
		}
	}

	// Fill the multicolumn list with files from some directory
	boolean show_files(RemoteFile f)
	{
	RemoteFile fl[] = f.list();
	if (fl == null) return false;
	files.clear();
	Object rows[][] = new Object[fl.length+1][];
	long now = System.currentTimeMillis();

	// Create parent directory rows
	rows[0] = new Object[6];
	rows[0][0] = get_image("dir.gif");
	rows[0][1] = "..";
	rows[0][2] = rows[0][3] = rows[0][4] = rows[0][5] = "";

	// Create file rows
	Date n = new Date(now);
	for(int i=0; i<fl.length; i++) {
		Object row[] = rows[i+1] = new Object[6];
		if (fl[i].shared())
			row[0] = get_image("sdir.gif");
		else
			row[0] = get_image(RemoteFile.tmap[fl[i].type]);
		row[1] = fl[i].name;
		if (fl[i].size < 1000)
			row[2] = spad(fl[i].size, 5)+" B";
		else if (fl[i].size < 1000000)
			row[2] = spad(fl[i].size/1000, 5)+" kB";
		else
			row[2] = spad(fl[i].size/1000000, 5)+" MB";
		row[3] = fl[i].user;
		row[4] = fl[i].group;
		Date d = new Date(fl[i].modified);
		//if (now - fl[i].modified < 24*60*60*1000) {
		if (n.getDate() == d.getDate() &&
		    n.getMonth() == d.getMonth() &&
		    n.getYear() == d.getYear()) {
			// show as hour:min
			row[5] = pad(d.getHours(),2)+":"+
				 pad(d.getMinutes(),2);
			}
		//else if (now - fl[i].modified < 24*60*60*365*1000) {
		else if (n.getYear() == d.getYear()) {
			// show as day/mon
			row[5] = pad(d.getDate(),2)+"/"+
				 monmap[d.getMonth()];
			}
		else {
			// show as mon/year
			row[5] = monmap[d.getMonth()]+"/"+
				 pad(d.getYear()%100, 2);
			}
		}
	files.addItems(rows);
	showing_files = f;
	pathname.setText(f.path);
	return true;
	}

	String pad(int n, int s)
	{
	String rv = String.valueOf(n);
	while(rv.length() < s)
		rv = "0"+rv;
	return rv;
	}

	String spad(int n, int s)
	{
	String rv = String.valueOf(n);
	while(rv.length() < s)
		rv = " "+rv;
	return rv;
	}

	String trim_path(String p)
	{
	while(p.endsWith("/"))
		p = p.substring(0, p.length()-1);
	return p;
	}

	// openNode
	// Called when a node with children is opened
	public void openNode(Hierarchy h, HierarchyNode n)
	{
	FileNode fn = (FileNode)n;
	fn.fill();
	}

	// closeNode
	// Called when a node is closed
	public void closeNode(Hierarchy h, HierarchyNode n)
	{
	}

	// clickNode
	// Called when the user clicks on a node
	public void clickNode(Hierarchy h, HierarchyNode n)
	{
	FileNode fn = (FileNode)n;
	if (showing_files != fn.file)
		show_files(fn.file);
	}

	// doubleNode
	// Called when a user double-clicks on a node
	public void doubleNode(Hierarchy h, HierarchyNode n)
	{
	}

	// Called when a button is clicked
	public void click(CbButton b)
	{
	int s = files.selected();
	RemoteFile f = s < 1 ? null : (showing_files.list())[s-1];
	FileNode d = (FileNode)dirs.selected();
	if (b == edit_b) {
		// Open a window for editing the selected file
		if (f == null) return;
		if (f.type == 0 || f.type > 4)
			new ErrorWindow(text("edit_enormal"));
		else
			new EditorWindow(f, this);
		}
	else if (b == view_b) {
		// View the selected file in the browser
		if (f == null) return;
		if (f.type == 0 || f.type > 4)
			new ErrorWindow(text("view_enormal"));
		else
			show_file(f, false);
		}
	else if (b == open_b) {
		// Open the selected directory
		d.open = !d.open;
		d.fill();
		dirs.redraw();
		}
	else if (b == refresh_b) {
		// Refesh the selected directory (and thus any subdirs)
		d.known = false;
		d.file.list = null;
		d.fill();
		show_files(d.file);
		}
	else if (b == props_b) {
		// Display the properties window
		if (f == null) return;
		new PropertiesWindow(f, this);
		}
	else if (b == acl_b) {
		// Display the ACL window (if filesystem supports them)
		if (f == null) return;
		FileSystem filefs = find_filesys(f);
		if (filefs == null) return;
		if (filefs.acls)
			new ACLWindow(this, f);
		else
			new ErrorWindow(text("eacl_efs", filefs.mount));
		}
	else if (b == attr_b) {
		// Display the attributes window (if filesystem supports them)
		if (f == null) return;
		FileSystem filefs = find_filesys(f);
		if (filefs == null) return;
		if (filefs.acls)
			new AttributesWindow(this, f);
		else
			new ErrorWindow(text("attr_efs", filefs.mount));
		}
	else if (b == copy_b) {
		// Copy the selected file
		if (f == null) return;
		cut_buffer = f.path;
		cut_mode = false;
		}
	else if (b == cut_b) {
		// Cut the selected file
		if (f == null) return;
		cut_buffer = f.path;
		cut_mode = true;
		}
	else if (b == paste_b) {
		// Paste the copied file
		if (cut_buffer == null) {
			new ErrorWindow(text("paste_ecopy"));
			return;
			}
		int sl = cut_buffer.lastIndexOf('/');
		String cut_name = cut_buffer.substring(sl+1),
		       cut_dir = cut_buffer.substring(0, sl);
		RemoteFile cut_par = find_directory(cut_dir, false), cut_file;
		if (cut_par == null ||
		    (cut_file = cut_par.find(cut_name)) == null) {
			new ErrorWindow(text("paste_egone", cut_name));
			return;
			}

		// Check for an existing file
		RemoteFile already = showing_files.find(cut_name);
		String sp = showing_files.path;
		String dest_path = sp.equals("/") ? sp+cut_name
						  : sp+"/"+cut_name;
		if (already != null) {
			// File exists .. offer to rename
			new OverwriteWindow(this, already, cut_file);
			return;
			}
		
		// do the move or copy
		paste_file(cut_file, showing_files, dest_path, null);
		}
	else if (b == delete_b) {
		// Delete the selected file
		if (f == null) return;
		new DeleteWindow(this, f);
		}
	else if (b == new_b) {
		// Open a window for creating a file
		new EditorWindow(showing_files.path, this);
		}
	else if (b == upload_b) {
		// Call javascript to open an upload window
		try {
			JSObject win = JSObject.getWindow(this);
			String params[] = { showing_files.path };
			win.call("upload", params);
			}
		catch(Exception e) {
			new ErrorWindow(text("upload_efailed", e.getMessage()));
			}
		}
	else if (b == mkdir_b) {
		// Prompt for new directory
		new MkdirWindow(showing_files.path, this);
		}
	else if (b == makelink_b) {
		// Prompt for a new symlink
		new LinkWindow(showing_files.path, this);
		}
	else if (b == rename_b) {
		// Prompt for new filename
		if (f == null) return;
		new RenameWindow(this, f);
		}
	else if (b == share_b) {
		// Open a window for editing sharing options
		if (f == null || f.type != RemoteFile.DIR) return;
		new SharingWindow(f, this);
		}
	else if (b == search_b) {
		// Open window for finding a file
		new SearchWindow(showing_files.path, this);
		}
	}

	// Returns the object for some directory, or null if not found.
	RemoteFile find_directory(String p, boolean fill)
	{
	int l = p.length();
	boolean can = false;
	for(int r=0; r<accroot.length; r++) {
		int rl = accroot[r].length();
		if (accroot[r].equals("/"))
			can = true;
		else if (l >= rl && p.substring(0, rl).equals(accroot[r]))
			can = true;
		else if (l < rl && accroot[r].substring(0, l).equals(p))
			can = true;
		}
	if (!can) {
		new ErrorWindow(text("find_eaccess", p));
		return null;
		}
	FileNode posnode = root;
	RemoteFile pos = posnode.file;
	StringTokenizer tok = new StringTokenizer(p, "/");
	while(tok.hasMoreTokens()) {
		String fn = tok.nextToken();
		if (fn.equals("")) continue;
		RemoteFile fl[] = pos.list();
		if (fl == null) return null;
		if (fill) {
			posnode.open = true;
			posnode.fill();
			}
		boolean found = false;
		for(int i=0; i<fl.length; i++)
			if (fl[i].name.equals(fn)) {
				pos = fl[i];
				found = true;
				}
		if (!found) {
			new ErrorWindow(text("find_eexist", fn, p));
			return null;
			}
		if (pos.type != 0) {
			new ErrorWindow(text("find_edir", fn, p));
			return null;
			}
		if (fill)
			posnode = (FileNode)nodemap.get(pos);
		}
	if (fill) {
		if (show_files(pos)) {
			posnode.fill();
			posnode.open = true;
			dirs.select(posnode);
			dirs.redraw();
			}
		}
	return pos;
	}

	FileSystem find_filesys(RemoteFile f)
	{
	FileSystem filefs = null;
	for(int i=0; i<fslist.size(); i++) {
		FileSystem fs = (FileSystem)fslist.elementAt(i);
		int l = fs.mount.length();
		if (fs.mount.equals(f.path) ||
		    (f.path.length() >= l+1 &&
		     f.path.substring(0, l+1).equals(fs.mount+"/")) ||
		    fs.mount.equals("/")) {
			filefs = fs;
			}
		}
	return filefs;
	}

	public boolean action(Event e, Object o)
	{
	if (e.target == pathname) {
		// A new path was entered.. cd to it
		String p = pathname.getText().trim();
		if (p.equals("")) return true;
		find_directory(p, true);
		return true;
		}
	return false;
	}

        // singleClick
        // Called on a single click on a list item
        public void singleClick(MultiColumn list, int num)
	{
	}

        // doubleClick
        // Called upon double-clicking on a list item
        public void doubleClick(MultiColumn list, int num)
	{
	if (num == 0) {
		// Go to parent directory
		if (showing_files.directory != null) {
			((FileNode)nodemap.get(showing_files)).open = false;
			show_files(showing_files.directory);
			dirs.select((FileNode)nodemap.get(showing_files));
			dirs.redraw();
			}
		return;
		}
	RemoteFile d = (showing_files.list())[num-1];
	if (d.type == 0) {
		// Open this directory
		FileNode pn = (FileNode)nodemap.get(showing_files);
		pn.fill();
		pn.open = true;
		FileNode fn = (FileNode)nodemap.get(d);
		if (show_files(d)) {
			fn.fill();
			fn.open = true;
			dirs.select(fn);
			dirs.redraw();
			}
		}
	else if (d.type <= 4) {
		// Direct the browser to this file
		show_file(d, list.last_event.shiftDown());
		}
	}

	void show_file(RemoteFile f, boolean download)
	{
	try {
		if (download) {
			URL u = new URL(getDocumentBase(),
					"show.cgi"+urlize(f.path)+
					"?rand="+System.currentTimeMillis()+
					"&type=application%2Foctet%2Dstream"+
					"&trust="+trust);
			getAppletContext().showDocument(u);
			}
		else {
			URL u = new URL(getDocumentBase(),
					"show.cgi"+urlize(f.path)+
					"?rand="+System.currentTimeMillis()+
					"&trust="+trust);
			getAppletContext().showDocument(u, "show");
			}
		}
	catch(Exception e) { }
	}

	static String urlize(String s)
	{
	StringBuffer rv = new StringBuffer();
	for(int i=0; i<s.length(); i++) {
		char c = s.charAt(i);
		if (c < 16)
			rv.append("%0"+Integer.toString(c, 16));
		else if (!Character.isLetterOrDigit(c) && c != '/' &&
		    c != '.' && c != '_' && c != '-')
			rv.append("%"+Integer.toString(c, 16));
		else
			rv.append(c);
		}
	return rv.toString();
	}

	static String un_urlize(String s)
	{
	StringBuffer rv = new StringBuffer();
	for(int i=0; i<s.length(); i++) {
		char c = s.charAt(i);
		if (c == '%') {
			rv.append((char)Integer.parseInt(
				s.substring(i+1, i+3), 16));
			i += 2;
			}
		else
			rv.append(c);
		}
	return rv.toString();
	}

	public void upload_notify(String path_str, String info)
	{
	int sl = path_str.lastIndexOf('/');
	String par_str = path_str.substring(0, sl),
	       file_str = path_str.substring(sl+1);
	RemoteFile par = find_directory(par_str, false);
	RemoteFile upfile = par.find(file_str);
	if (upfile == null) {
		upfile = new RemoteFile(this, info, par);
		par.add(upfile);
		}
	show_files(showing_files);
	}

	public String text(String k, String p[])
	{
	String rv = (String)lang.get(k);
	if (rv == null) rv = "???";
	for(int i=0; i<p.length; i++) {
		int idx = rv.indexOf("$"+(i+1));
		if (idx != -1)
			rv = rv.substring(0, idx)+p[i]+rv.substring(idx+2);
		}
	return rv;
	}

	public String text(String k)
	{
	String p[] = { };
	return text(k, p);
	}

	public String text(String k, String p1)
	{
	String p[] = { p1 };
	return text(k, p);
	}

	public String text(String k, String p1, String p2)
	{
	String p[] = { p1, p2 };
	return text(k, p);
	}

	void paste_file(RemoteFile src, RemoteFile dir,
			String dest, RemoteFile already)
	{
	// Move or copy the actual file
	String[] rv = get_text((cut_mode ? "move.cgi" : "copy.cgi")+
			       "?from="+urlize(cut_buffer)+
			       "&to="+urlize(dest));
	if (rv[0].length() > 0) {
		new ErrorWindow(text(
			cut_mode ? "paste_emfailed"
				 : "paste_ecfailed", rv[0]));
		return;
		}
	RemoteFile file = new RemoteFile(this, rv[1], dir);
	if (already == null) {
		// Add to the parent directory
		dir.add(file);
		}
	else {
		// Update the existing file
		already.type = file.type;
		already.user = file.user;
		already.group = file.group;
		already.size = file.size;
		already.perms = file.perms;
		already.modified = file.modified;
		file = already;
		}
	if (cut_mode) {
		// Delete the old file
		src.directory.delete(src);
		}
	if (src.type == 0) {
		// Moving or copying a directory.. update the tree
		FileNode dest_par_node =
			(FileNode)nodemap.get(showing_files);
		dest_par_node.add(new FileNode(file));
		if (cut_mode) {
			FileNode cut_par_node =
				(FileNode)nodemap.get(src.directory);
			FileNode cut_file_node =
				(FileNode)nodemap.get(src);
			if (cut_par_node != null &&
			    cut_file_node != null)
				cut_par_node.ch.removeElement(
							cut_file_node);
			}
		dirs.redraw();
		}
	show_files(showing_files);
	if (cut_mode) {
		// Paste from the destination path from now on
		cut_mode = false;
		cut_buffer = dest;
		}

	}
}

// A node in the directory tree
class FileNode extends HierarchyNode
{
	FileManager parent;
	RemoteFile file;
	boolean known;

	FileNode(RemoteFile file)
	{
	this.file = file;
	parent = file.parent;
	im = parent.get_image(file.shared() ? "sdir.gif" : "dir.gif");
	ch = new Vector();
	text = file.name;
	parent.nodemap.put(file, this);
	}

	// Create the nodes for subdirectories
	void fill()
	{
	if (!known) {
		RemoteFile l[] = file.list();
		if (l == null) return;
		ch.removeAllElements();
		for(int i=0; i<l.length; i++)
			if (l[i].type == 0)
				ch.addElement(new FileNode(l[i]));
		parent.dirs.redraw();
		known = true;
		}
	}

	void add(FileNode n)
	{
	for(int i=0; i<=ch.size(); i++) {
		FileNode ni = i==ch.size() ? null : (FileNode)ch.elementAt(i);
		if (ni == null || ni.text.compareTo(n.text) > 0) {
			ch.insertElementAt(n, i);
			break;
			}
		}
	}

}

class RemoteFile
{
	static final int DIR = 0;
	static final int TEXT = 1;
	static final int IMAGE = 2;
	static final int BINARY = 3;
	static final int UNKNOWN = 4;
	static final int SYMLINK = 5;
	static final int DEVICE = 6;
	static final int PIPE = 7;
	static final String[] tmap = { "dir.gif", "text.gif", "image.gif",
				       "binary.gif", "unknown.gif",
				       "symlink.gif", "device.gif",
				       "pipe.gif" };

	FileManager parent;
	String path, name;
	int type;
	String user, group;
	int size;
	int perms;
	long modified;
	String linkto;
	RemoteFile list[];
	RemoteFile directory;

	// Parse a line of text to a file object
	RemoteFile(FileManager parent, String line, RemoteFile d)
	{
	this.parent = parent;
	StringTokenizer tok = new StringTokenizer(line, "\t");
	path = tok.nextToken();
	type = Integer.parseInt(tok.nextToken());
	user = tok.nextToken();
	group = tok.nextToken();
	size = Integer.parseInt(tok.nextToken());
	perms = Integer.parseInt(tok.nextToken());
	modified = Long.parseLong(tok.nextToken())*1000;
	if (type == 5) linkto = tok.nextToken();
	directory = d;
	if (path.equals("/")) name = "/";
	else name = path.substring(path.lastIndexOf('/')+1);
	}

	// Create a new, empty file object
	RemoteFile() { }

	// Returns a list of files in this directory
	RemoteFile[] list()
	{
	if (list == null) {
		String l[] = parent.get_text("list.cgi?dir="+
					     parent.urlize(path));
		if (l[0].length() > 0) {
			//list = new RemoteFile[0];
			// Error reading the remote directory!
			new ErrorWindow(parent.text("list_edir", path, l[0]));
			list = null;
			}
		else {
			list = new RemoteFile[l.length-3];
			for(int i=3; i<l.length; i++)
				list[i-3] = new RemoteFile(parent, l[i], this);
			}
		}
	return list;
	}

	RemoteFile find(String n)
	{
	RemoteFile l[] = list();
	if (l != null) {
		for(int i=0; i<l.length; i++)
			if (l[i].name.equals(n))
				return l[i];
		}
	return null;
	}

	void add(RemoteFile f)
	{
	RemoteFile nlist[] = new RemoteFile[list.length+1];
	int offset = 0;
	for(int i=0; i<list.length; i++) {
		if (list[i].name.compareTo(f.name) > 0 && offset == 0) {
			nlist[i] = f;
			offset++;
			}
		nlist[i+offset] = list[i];
		}
	if (offset == 0) nlist[list.length] = f;
	list = nlist;
	}

	void delete(RemoteFile f)
	{
	RemoteFile nlist[] = new RemoteFile[list.length-1];
	for(int i=0,j=0; i<list.length; i++)
		if (list[i] != f)
			nlist[j++] = list[i];
	list = nlist;
	}

	boolean shared()
	{
	return type == DIR &&
	       (parent.stab.get(path) != null ||
	        parent.ntab.get(path) != null);
	}
}

class EditorWindow extends FixedFrame implements CbButtonCallback
{
	TextField name;
	TextArea edit;
	CbButton save_b, cancel_b;
	RemoteFile file;
	FileManager filemgr;

	// Editing an existing file
	EditorWindow(RemoteFile f, FileManager p)
	{
	super(500, 300);
	file = f; filemgr = p;
	makeUI(false);
	setTitle(filemgr.text("edit_title", file.path));

	// Load the file
	try {
		URL u = new URL(filemgr.getDocumentBase(),
				"show.cgi"+filemgr.urlize(file.path)+
				"?rand="+System.currentTimeMillis()+
				"&trust="+filemgr.trust+"&edit=1");
		URLConnection uc = u.openConnection();
		int len = uc.getContentLength();
		InputStream is = uc.getInputStream();
		byte buf[];
		if (len >= 0) {
			// Length is known
			buf = new byte[uc.getContentLength()];
			int got = 0;
			while(got < buf.length)
				got += is.read(buf, got, buf.length-got);
			}
		else {
			// Length is unknown .. read till the end
			buf = new byte[0];
			while(true) {
			    byte data[] = new byte[16384];
			    int got;
			    try { got = is.read(data); }
			    catch(EOFException ex) { break; }
			    if (got <= 0) break;
			    byte nbuf[] = new byte[buf.length + got];
			    System.arraycopy(buf, 0, nbuf, 0, buf.length);
			    System.arraycopy(data, 0, nbuf, buf.length, got);
			    buf = nbuf;
			    }
			}
		System.out.println("buf size = "+buf.length);
		edit.setText(new String(buf, 0));
		is.close();
		file.size = buf.length;
		}
	catch(Exception e) { e.printStackTrace(); }
	}

	// Creating a new file
	EditorWindow(String f, FileManager p)
	{
	super(500, 300);
	filemgr = p;
	makeUI(true);
	setTitle(filemgr.text("edit_title2"));
	name.setText(f.equals("/") ? f : f+"/");
	name.select(name.getText().length(), name.getText().length());
	}

	void makeUI(boolean add_name)
	{
	setLayout(new BorderLayout());
	if (add_name) {
		Panel np = new Panel();
		np.setLayout(new BorderLayout());
		np.add("West", new Label(filemgr.text("edit_filename")));
		np.add("Center", name = new TextField());
		add("North", np);
		}
	add("Center", edit = new TextArea(20, 80));
	edit.setFont(new Font("courier", Font.PLAIN, 14));
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(save_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("save"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == save_b) {
		RemoteFile par = null, already = null;
		String save_path;
		if (file == null) {
			// Locate the filemgr directory
			save_path = filemgr.trim_path(name.getText());
			int sl = save_path.lastIndexOf('/');
			par = filemgr.find_directory(
					save_path.substring(0, sl), false);
			if (par == null) return;
			already = par.find(save_path.substring(sl+1));
			if (already != null &&
			    (already.type == 0 || already.type == 5)) {
				new ErrorWindow(
					filemgr.text("edit_eover", save_path));
				return;
				}
			}
		else save_path = file.path;

		// Save the file back again
		String s = edit.getText(), line;
		try {
			URL u = new URL(filemgr.getDocumentBase(),
					"save.cgi"+filemgr.urlize(save_path)+
					"?rand="+System.currentTimeMillis()+
					"&trust="+filemgr.trust);
			URLConnection uc = u.openConnection();
			uc.setDoOutput(true);
			OutputStream os = uc.getOutputStream();
			byte buf[] = new byte[s.length()];
			s.getBytes(0, buf.length, buf, 0);
			os.write(buf);
			os.close();
			LineInputStream is = new LineInputStream(
							uc.getInputStream());
			String err = is.gets();
			if (err.length() > 0) {
				new ErrorWindow(
					filemgr.text("edit_esave", err));
				is.close();
				return;
				}
			line = is.gets();
			is.close();
			}
		catch(Exception e) { e.printStackTrace(); return; }

		if (file == null) {
			// Create and insert or replace the file object
			file = new RemoteFile(filemgr, line, par);
			if (already != null) {
				// A file with this name exists
				already.type = file.type;
				already.user = file.user;
				already.group = file.group;
				already.size = file.size;
				already.perms = file.perms;
				already.modified = file.modified;
				}
			else {
				// Add to the list
				par.add(file);
				}
			}
		else {
			file.size = s.length();
			file.modified = System.currentTimeMillis();
			}
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else {
		// Just close
		dispose();
		}
	}
}

class PropertiesWindow extends FixedFrame implements CbButtonCallback
{
	RemoteFile file;
	FileManager filemgr;
	CbButton save_b, cancel_b;

	TextField linkto;
	TextField user, group;
	Checkbox setuid, setgid;
	PermissionsPanel user_p, group_p, other_p;
	Checkbox sticky;
	Choice rec_mode;

	PropertiesWindow(RemoteFile f, FileManager p)
	{
	file = f;
	filemgr = p;

	// Create UI
	setTitle(f.path);
	setLayout(new BorderLayout());
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(save_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("save"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);

	Panel mid = new Panel();
	mid.setLayout(new BorderLayout());
	TabbedPanel tab = null;
	add("Center", mid);

	// Create file details section
	Panel det = new LinedPanel(filemgr.text("info_file")),
	      dl = new Panel(), dr = new Panel();
	setup_leftright(det, dl, dr);
	add_item(filemgr.text("info_path"),
		new Label(file.path), dl, dr);
	add_item(filemgr.text("info_type"),
		new Label(filemgr.text("file_type"+file.type)), dl, dr);
	add_item(filemgr.text("info_size"),
		new Label(String.valueOf(file.size)),dl,dr);
	add_item(filemgr.text("info_mod"),
		new Label(String.valueOf(new Date(file.modified))), dl, dr);
	if (file.type == 5)
		add_item(filemgr.text("info_link"),
			 linkto = new TextField(file.linkto, 30), dl, dr);
	mid = add_panel(mid, det);

	// Create permissions section
	Panel per = new LinedPanel(filemgr.text("info_perms")),
	      pl = new Panel(), pr = new Panel();
	setup_leftright(per, pl, pr);
	add_item(filemgr.text("info_user"),
		 user_p = new PermissionsPanel(file, 64, filemgr), pl, pr);
	add_item(filemgr.text("info_group"),
		 group_p = new PermissionsPanel(file, 8, filemgr), pl, pr);
	add_item(filemgr.text("info_other"),
		 other_p = new PermissionsPanel(file, 1, filemgr), pl,pr);
	if (file.type == 0) {
		add_item(filemgr.text("info_sticky"), sticky = new Checkbox(
					filemgr.text("info_sticky2")), pl,pr);
		sticky.setState((file.perms&01000) != 0);
		}
	mid = add_panel(mid, per);

	// Create ownership section
	Panel own = new LinedPanel(filemgr.text("info_own")),
	      ol = new Panel(), or = new Panel();
	setup_leftright(own, ol, or);
	add_item(filemgr.text("info_user"),
		 user = new TextField(file.user, 10), ol, or);
	if (file.type != 0) {
		add_item(filemgr.text("info_setuid"),
			 setuid = new Checkbox(filemgr.text("info_setuid2")),
			 ol, or);
		setuid.setState((file.perms & 0x800) != 0);
		}
	add_item(filemgr.text("info_group"),
		 group = new TextField(file.group, 10), ol, or);
	if (file.type == 0)
		add_item(filemgr.text("info_setgid"),
		  setgid = new Checkbox(filemgr.text("info_setgid2")), ol, or);
	else
		add_item(filemgr.text("info_setgid"),
		  setgid = new Checkbox(filemgr.text("info_setgid3")), ol, or);
	setgid.setState((file.perms & 0x400) != 0);
	mid = add_panel(mid, own);

	if (file.type == 0) {
		// Create recursion section
		Panel rec = new LinedPanel(filemgr.text("info_apply"));
		rec.setLayout(new BorderLayout());
		rec_mode = new Choice();
		for(int i=1; i<=3; i++)
			rec_mode.addItem(filemgr.text("info_apply"+i));
		rec.add("Center", rec_mode);
		mid = add_panel(mid, rec);
		}

	pack();
	show();
	}

	Panel add_panel(Panel p, Component c)
	{
	p.add("North", c);
	Panel np = new Panel();
	np.setLayout(new BorderLayout());
	p.add("Center", np);
	return np;
	}

	public void click(CbButton b)
	{
	if (b == save_b) {
		// Update the file
		int perms = 0;
		if (setuid == null)
			perms |= (file.perms & 0x800);
		else
			perms |= (setuid.getState() ? 0x800 : 0);
		perms |= (setgid.getState() ? 0x400 : 0);
		perms |= user_p.getPerms();
		perms |= group_p.getPerms();
		perms |= other_p.getPerms();
		if (sticky == null)
			perms |= (file.perms & 01000);
		else
			perms |= (sticky.getState() ? 01000 : 0);
		int rec = 0;
		if (file.type == 0)
			rec = rec_mode.getSelectedIndex();
		String rv[] = filemgr.get_text(
			"chmod.cgi?path="+filemgr.urlize(file.path)+
			"&perms="+perms+"&user="+user.getText()+
			"&group="+group.getText()+"&rec="+rec+
			(linkto==null ? "" : "&linkto="+linkto.getText()));
		if (rv[0].length() > 0) {
			// Something went wrong
			new ErrorWindow(filemgr.text("info_efailed",
					file.path, rv[0]));
			}
		else {
			// Update all changed file objects
			if (linkto != null)
				file.linkto = linkto.getText();
			else if (rec == 0)
				update_file(file, perms, false);
			else if (rec == 1) {
				// Update files in this directory
				update_file(file, perms, false);
				recurse_files(file, perms, false);
				}
			else if (rec == 2) {
				// Update files and subdirs
                                update_file(file, perms, false);
				recurse_files(file, perms, true);
				}

			// Update directory list
			int os = filemgr.files.selected();
			filemgr.show_files(filemgr.showing_files);
			filemgr.files.select(os);
			dispose();
			}
		}
	else {
		// Just close
		dispose();
		}
	}

	void update_file(RemoteFile f, int perms, boolean perms_only)
	{
	f.user = user.getText();
	f.group = group.getText();
	if (perms_only)
		f.perms = (perms & 0777) | (f.perms & 037777777000);
	else
		f.perms = perms;
	}

	void recurse_files(RemoteFile f, int perms, boolean do_subs)
	{
	if (f.list == null) return;
	for(int i=0; i<f.list.length; i++) {
		RemoteFile ff = f.list[i];
		if (ff.type == 5) continue;
		else if (ff.type == 0) {
			if (do_subs) {
				update_file(ff, perms, false);
				recurse_files(ff, perms, true);
				}
			}
		else update_file(ff, perms, true);
		}
	}

	void setup_leftright(Panel m, Panel l, Panel r)
	{
	m.setLayout(new BorderLayout());
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", l);
	p.add("Center", r);
	l.setLayout(new GridLayout(0, 1));
	r.setLayout(new GridLayout(0, 1));
	m.add("North", p);
	}

	void add_item(String t, Component c, Panel l, Panel r)
	{
	l.add(new Label(t));
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", c);
	r.add(p);
	}

}

class PermissionsPanel extends Panel
{
	Checkbox read, write, exec;
	int base;

	PermissionsPanel(RemoteFile file, int base, FileManager filemgr)
	{
	int perms = file.perms;
	this.base = base;
	setLayout(new GridLayout(1, 3));
	add(read = new Checkbox(filemgr.text("info_read")));
	read.setState((perms&(base<<2)) != 0);
	add(write = new Checkbox(filemgr.text("info_write")));
	write.setState((perms&(base<<1)) != 0);
	add(exec = new Checkbox(
		filemgr.text(file.type==0 ? "info_list" : "info_exec")));
	exec.setState((perms&base) != 0);
	}

	int getPerms()
	{
	int rv = 0;
	rv |= (read.getState() ? (base<<2) : 0);
	rv |= (write.getState() ? (base<<1) : 0);
	rv |= (exec.getState() ? base : 0);
	return rv;
	}
}

class DeleteWindow extends FixedFrame implements CbButtonCallback
{
	CbButton delete_b, cancel_b;
	FileManager filemgr;
	RemoteFile file;

	DeleteWindow(FileManager p, RemoteFile f)
	{
	filemgr = p;
	file = f;
	setTitle(filemgr.text(f.type == 0 ? "delete_dtitle" : "delete_ftitle"));

	setLayout(new BorderLayout());
	add("Center", new MultiLabel(filemgr.text(
		f.type == 0 ? "delete_ddesc" : "delete_fdesc", f.path), 35));
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(delete_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("delete"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == delete_b) {
		// Delete the file or directory
		String rv[] = filemgr.get_text("delete.cgi?file="+
					       filemgr.urlize(file.path));
		if (rv[0].length() > 0)
			new ErrorWindow(filemgr.text("delete_efailed",
					file.path, rv[0]));
		else {
			// done the deed.. update data structures
			RemoteFile pf = file.directory;
			pf.delete(file);
			if (filemgr.showing_files == pf) {
				// Need to refresh the list as well..
				filemgr.show_files(pf);
				}

			FileNode node = (FileNode)filemgr.nodemap.get(file);
			FileNode pnode = (FileNode)filemgr.nodemap.get(pf);
			if (node != null) {
				// Take the directory out of the tree..
				pnode.ch.removeElement(node);
				filemgr.dirs.redraw();
				}
			}
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class MkdirWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	TextField dir;
	CbButton create_b, cancel_b;

	MkdirWindow(String d, FileManager p)
	{
	filemgr = p;
	setTitle(filemgr.text("mkdir_title"));
	setLayout(new BorderLayout());
	add("West", new Label(filemgr.text("mkdir_dir")));
	add("Center", dir = new TextField(d.equals("/") ? "/" : d+"/", 40));
	dir.select(dir.getText().length(), dir.getText().length());
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(create_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("create"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == create_b) {
		// Find the filemgr directory
		String path = dir.getText();
		path = filemgr.trim_path(path);
		int sl = path.lastIndexOf('/');
		RemoteFile par = filemgr.find_directory(
					path.substring(0, sl), false);
		if (par.find(path.substring(sl+1)) != null) {
			new ErrorWindow(filemgr.text("mkdir_eexists", path));
			return;
			}
		String rv[] = filemgr.get_text("mkdir.cgi?dir="+
					       filemgr.urlize(path));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("mkdir_efailed", rv[0]));
			return;
			}
		RemoteFile file = new RemoteFile(filemgr, rv[1], par);
		par.add(file);
		FileNode parnode = (FileNode)filemgr.nodemap.get(par);
		if (parnode != null) {
			// Update the tree
			parnode.add(new FileNode(file));
			filemgr.dirs.redraw();
			}
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else dispose();
	}
}

class LinkWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	TextField from, to;
	CbButton create_b, cancel_b;

	LinkWindow(String d, FileManager p)
	{
	filemgr = p;
	setLayout(new BorderLayout());
	setTitle(filemgr.text("link_title"));
	Panel l = new Panel(), r = new Panel();
	l.setLayout(new GridLayout(0, 1));
	l.add(new Label(filemgr.text("link_from")));
	l.add(new Label(filemgr.text("link_to")));
	r.setLayout(new GridLayout(0, 1));
	r.add(from = new TextField(d.equals("/") ? "/" : d+"/", 40));
	from.select(from.getText().length(), from.getText().length());
	r.add(to = new TextField());
	add("West", l); add("Center", r);
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(create_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("create"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == create_b) {
		// Check inputs
		String from_str = from.getText().trim();
		int sl = from_str.lastIndexOf('/');
		String par_str = from_str.substring(0, sl),
		       file_str = from_str.substring(sl+1);
		RemoteFile par = filemgr.find_directory(par_str, false);
		if (par == null) return;
		if (par.find(file_str) != null) {
			new ErrorWindow(filemgr.text("link_eexists", from_str));
			return;
			}

		// Create the actual link
		String rv[] = filemgr.get_text("makelink.cgi?from="+
					       filemgr.urlize(from_str)+"&to="+
					       filemgr.urlize(to.getText()));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("link_efailed", rv[0]));
			return;
			}
		RemoteFile file = new RemoteFile(filemgr, rv[1], par);
		par.add(file);
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class RenameWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	RemoteFile file;
	TextField oldname, newname;
	CbButton rename_b, cancel_b;

	RenameWindow(FileManager p, RemoteFile f)
	{
	filemgr = p; file = f;
	setLayout(new BorderLayout());
	setTitle(filemgr.text("rename_title", file.path));
	Panel l = new Panel(), r = new Panel();
	l.setLayout(new GridLayout(0, 1));
	l.add(new Label(filemgr.text("rename_old")));
	l.add(new Label(filemgr.text("rename_new")));
	r.setLayout(new GridLayout(0, 1));
	r.add(oldname = new TextField(file.name, 20));
	oldname.setEditable(false);
	r.add(newname = new TextField(file.name, 20));
	newname.select(file.name.length(), file.name.length());
	add("West", l); add("Center", r);

	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(rename_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("rename_ok"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == rename_b) {
		// Check for an existing file
		String newstr = newname.getText().trim();
		if (newstr.length() == 0) return;
		RemoteFile already = file.directory.find(newstr);
		if (already != null) {
			new ErrorWindow(filemgr.text("rename_eexists", newstr));
			return;
			}

		// Rename the real file
		int sl = file.path.lastIndexOf('/');
		String newpath = file.path.substring(0, sl)+"/"+newstr;
		String rv[] = filemgr.get_text(
				"rename.cgi?old="+filemgr.urlize(file.path)+
				"&new="+filemgr.urlize(newpath));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("rename_efailed", rv[0]));
			return;
			}

		// Update data structure
		file.name = newstr;
		file.path = newpath;
		file.directory.delete(file);
		file.directory.add(file);
		file.list = null;
		FileNode parnode = (FileNode)filemgr.nodemap.get(file.directory);
		FileNode filenode = (FileNode)filemgr.nodemap.get(file);
		if (parnode != null && filenode != null) {
			filenode.text = file.name;
			parnode.ch.removeElement(filenode);
			parnode.add(filenode);
			dispose();
			filemgr.dirs.redraw();
			}

		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class MultiLabel extends BorderPanel
{
	public MultiLabel(String s, int max)
	{
	this(s, max, 1);
	}

	public MultiLabel(String s, int max, int b)
	{
	super(b);
	Vector v = new Vector();
	StringTokenizer tok = new StringTokenizer(s.trim(), " \t");
	String line = null;
	while(tok.hasMoreTokens()) {
		String w = tok.nextToken();
		line = (line == null ? w : line+" "+w);
		if (line.length() > max || !tok.hasMoreTokens()) {
			v.addElement(line);
			line = null;
			}
		}
	setLayout(new GridLayout(v.size(), 0, 0, 0));
	for(int i=0; i<v.size(); i++)
		add(new Label((String)v.elementAt(i), Label.CENTER));
	}
}

class OverwriteWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	RemoteFile src, already;
	TextField newname;
	CbButton ok, cancel;

	OverwriteWindow(FileManager p, RemoteFile a, RemoteFile s)
	{
	filemgr = p; src = s; already = a;
	setLayout(new BorderLayout());
	setTitle(filemgr.text("over_title"));
	add("North",
	    new MultiLabel(filemgr.text("over_msg", already.path), 30, 0));
	add("West", new Label(filemgr.text("over_new")));
	add("East", newname = new TextField(a.name, 30));

	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(ok = new CbButton(filemgr.get_image("save.gif"),
				  filemgr.text("over_ok"),
				  CbButton.LEFT, this));
	bot.add(cancel = new CbButton(filemgr.get_image("cancel.gif"),
				  filemgr.text("cancel"),
				  CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == cancel)
		dispose();
	else if (b == ok && newname.getText().length() > 0) {
		// paste the file, but with a new name
		RemoteFile ap = already.directory;
		RemoteFile newalready = ap.find(newname.getText());
		if (newalready == src) {
			new ErrorWindow(filemgr.text("paste_eself"));
			return;
			}
		if (newalready != null && (newalready.type == 0 ||
					   newalready.type == 5)) {
			new ErrorWindow(
				filemgr.text("paste_eover", newalready.path));
			return;
			}
		String dpath = (ap.path.equals("/") ? "/" :
				ap.path+"/")+newname.getText();
		filemgr.paste_file(src, already.directory, dpath, newalready);
		dispose();
		}
	}
}

class SambaShare
{
	String path;
	boolean available;
	boolean writable;
	int guest;
	String comment;

	SambaShare(String l)
	{
	StringSplitter tok = new StringSplitter(l, ':');
	path = tok.nextToken();
	available = tok.nextToken().equals("1");
	writable = tok.nextToken().equals("1");
	guest = Integer.parseInt(tok.nextToken());
	comment = tok.nextToken();
	}

	SambaShare(String p, boolean a, boolean w, int g, String c)
	{
	path = p;
	available = a;
	writable = w;
	guest = g;
	comment = c;
	}

	String params()
	{
	return "path="+FileManager.urlize(path)+
	       "&available="+(available ? 1 : 0)+
	       "&writable="+(writable ? 1 : 0)+
	       "&guest="+guest+
	       "&comment="+FileManager.urlize(comment);
	}
}

class DFSAdminExport
{
	String path;
	String desc;
	String ro, rw, root;

	DFSAdminExport(String l)
	{
	StringSplitter tok = new StringSplitter(l, ':');
	path = tok.nextToken();
	ro = tok.nextToken();
	rw = tok.nextToken();
	root = tok.nextToken();
	desc = tok.nextToken();
	}

	DFSAdminExport(String p, String d, String ro, String rw, String root)
	{
	path = p;
	desc = d;
	this.ro = ro;
	this.rw = rw;
	this.root = root;
	}

	String[] split(String s)
	{
	StringTokenizer stok = new StringTokenizer(s, " ");
	String rv[] = new String[stok.countTokens()];
	for(int i=0; i<rv.length; i++)
		rv[i] = stok.nextToken();
	return rv;
	}

	String params()
	{
	return "path="+FileManager.urlize(path)+
	       "&ro="+FileManager.urlize(ro)+
	       "&rw="+FileManager.urlize(rw)+
	       "&root="+FileManager.urlize(root)+
	       "&desc="+FileManager.urlize(desc);
	}
}

class LinuxExport
{
	String path;
	String host[];
	boolean ro[];
	int squash[];

	LinuxExport(String l)
	{
	StringSplitter tok = new StringSplitter(l, ':');
	path = tok.nextToken();
	int c = tok.countTokens() / 3;
	host = new String[c];
	ro = new boolean[c];
	squash = new int[c];
	for(int i=0; tok.hasMoreTokens(); i++) {
		host[i] = tok.nextToken();
		ro[i] = tok.nextToken().equals("1");
		squash[i] = Integer.parseInt(tok.nextToken());
		}
	}

	LinuxExport(String p, String h[], String r[], String s[])
	{
	path = p;
	}

	String params()
	{
	String rv = "path="+FileManager.urlize(path)+
		    "&count="+host.length;
	for(int i=0; i<host.length; i++) {
		rv += "&host"+i+"="+FileManager.urlize(host[i]);
		rv += "&ro"+i+"="+(ro[i] ? 1 : 0);
		rv += "&squash"+i+"="+squash[i];
		}
	return rv;
	}
}

class SharingWindow extends FixedFrame implements CbButtonCallback
{
	CbButton save_b, cancel_b;
	RemoteFile file;
	FileManager filemgr;
	SambaShare sshare;
	DFSAdminExport dexport;
	LinuxExport lexport;
	Checkbox samba_on, samba_off;
	Checkbox writable_on, writable_off;
	Checkbox available_on, available_off;
	Checkbox guest_on, guest_off, guest_only;
	TextField comment;

	TextField desc;
	Checkbox nfs_on, nfs_off;
	TextField rwhosts, rohosts, roothosts;
	Checkbox rw[] = new Checkbox[3], ro[] = new Checkbox[3],
		 root[] = new Checkbox[3];

	TextField host[];
	Choice lro[], squash[];

	SharingWindow(RemoteFile f, FileManager p)
	{
	file = f; filemgr = p;
	setTitle(filemgr.text("share_title", file.path));
	sshare = (SambaShare)filemgr.stab.get(file.path);
	Object nshare = filemgr.ntab.get(file.path);
	if (filemgr.nfsmode == 1)
		lexport = (LinuxExport)nshare;
	else if (filemgr.nfsmode == 2)
		dexport = (DFSAdminExport)nshare;

	// setup UI
	setLayout(new BorderLayout());
	Panel samba = new Panel(), sl = new Panel(), sr = new Panel();
	samba.setLayout(new BorderLayout());
	Panel st = new Panel();
	st.setLayout(new GridLayout(2, 1));
	CheckboxGroup sg = new CheckboxGroup();
	st.add(samba_off = new Checkbox(filemgr.text("share_soff"), sg, 
				       sshare == null));
	st.add(samba_on = new Checkbox(filemgr.text("share_son"), sg,
					sshare != null));
	samba.add("North", st);

	Panel stop = new LinedPanel(filemgr.text("share_sheader"));
	setup_leftright(stop, sl, sr);

	comment = new TextField(sshare == null ? "" : sshare.comment, 25);
	add_item(filemgr.text("share_comment"), comment, sl, sr);

	Panel ap = new Panel();
	ap.setLayout(new GridLayout(1, 0));
	CheckboxGroup ag = new CheckboxGroup();
	ap.add(available_on = new Checkbox(filemgr.text("yes"), ag,
					  sshare == null || sshare.available));
	ap.add(available_off = new Checkbox(filemgr.text("no"), ag,
					  sshare != null && !sshare.available));
	add_item(filemgr.text("share_available"), ap, sl, sr);

	Panel wp = new Panel();
	wp.setLayout(new GridLayout(1, 0));
	CheckboxGroup wg = new CheckboxGroup();
	wp.add(writable_on = new Checkbox(filemgr.text("yes"), wg,
					  sshare == null || sshare.writable));
	wp.add(writable_off = new Checkbox(filemgr.text("no"), wg,
					   sshare != null && !sshare.writable));
	add_item(filemgr.text("share_writable"), wp, sl, sr);

	Panel gp = new Panel();
	gp.setLayout(new GridLayout(1, 0));
	CheckboxGroup gg = new CheckboxGroup();
	gp.add(guest_only = new Checkbox(filemgr.text("share_only"), gg,
				sshare != null && sshare.guest == 2));
	gp.add(guest_on = new Checkbox(filemgr.text("yes"), gg,
				sshare == null || sshare.guest == 1));
	gp.add(guest_off = new Checkbox(filemgr.text("no"), gg,
			 	sshare != null && sshare.guest == 0));
	add_item(filemgr.text("share_guest"), gp, sl, sr);

	samba.add("Center", stop);

	// Setup NFS UI
	Panel nfs = new Panel(), nl = new Panel(), nr = new Panel();
	nfs.setLayout(new BorderLayout());
	Panel nt = new Panel();
	nt.setLayout(new GridLayout(2, 1));
	CheckboxGroup ng = new CheckboxGroup();
	nt.add(nfs_off = new Checkbox(filemgr.text("share_noff"), ng, 
				      nshare == null));
	nt.add(nfs_on = new Checkbox(filemgr.text("share_non"), ng,
				     nshare != null));
	nfs.add("North", nt);

	Panel ntop = new LinedPanel(filemgr.text("share_nheader"));
	setup_leftright(ntop, nl, nr);
	if (filemgr.nfsmode == 1) {
		// Linux export mode
		nl.setLayout(new GridLayout(0, 1, 2, 2));
		nr.setLayout(new GridLayout(0, 1, 2, 2));
		nl.add(new Label(filemgr.text("share_host")));
		nr.add(new Label(filemgr.text("share_opts")));
		int c = lexport==null ? 0 : lexport.host.length;
		host = new TextField[c+1];
		lro = new Choice[c+1];
		squash = new Choice[c+1];
		for(int i=0; i<c; i++) {
			host[i] = new TextField(lexport.host[i], 20);
			lro[i] = robox(lexport.ro[i]);
			squash[i] = squashbox(lexport.squash[i]);
			nl.add(host[i]);
			nr.add(opts_panel(lro[i], squash[i]));
			}
		host[c] = new TextField("", 20);
		lro[c] = robox(false);
		squash[c] = squashbox(1);
		nl.add(host[c]);
		nr.add(opts_panel(lro[c], squash[c]));
		}
	else if (filemgr.nfsmode == 2) {
		// Solaris share mode
		desc = new TextField(dexport == null ? "" : dexport.desc, 25);
		add_item(filemgr.text("share_desc"), desc, nl, nr);

		rohosts = add_hosts(filemgr.text("share_ro"),
				    dexport == null ? "-" : dexport.ro,
				    ro, nl, nr);
		rwhosts = add_hosts(filemgr.text("share_rw"),
				    dexport == null ? "-" : dexport.rw,
				    rw, nl, nr);
		roothosts = add_hosts(filemgr.text("share_root"),
				    dexport == null ? "-" : dexport.root,
				    root, nl, nr);
		root[1].getParent().remove(root[1]);
		}
	else if (filemgr.nfsmode == 3) {
		}
	nfs.add("Center", ntop);

	// Add the appropriate tabs
	if (filemgr.sambamode && filemgr.nfsmode != 0) {
		TabbedPanel tab = new TabbedPanel();
		tab.addItem(filemgr.text("share_samba"), samba);
		tab.addItem(filemgr.text("share_nfs"), nfs);
		add("Center", tab);
		}
	else if (filemgr.sambamode)
		add("Center", samba);
	else if (filemgr.nfsmode != 0)
		add("Center", nfs);

	// Create save and cancel buttons
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(save_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("save"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == save_b) {
		// Update samba settings on server
		if (sshare != null && samba_on.getState()) {
			// Updating share
			sshare.available = available_on.getState();
			sshare.writable = writable_on.getState();
			sshare.guest = guest_only.getState() ? 2 :
				       guest_on.getState() ? 1 : 0;
			sshare.comment = comment.getText();
			String rv[] = filemgr.get_text(
				"save_share.cgi?"+sshare.params());
			}
		else if (sshare != null) {
			// Deleting share
			String rv[] = filemgr.get_text(
				"save_share.cgi?delete=1&"+sshare.params());
			filemgr.stab.remove(sshare.path);
			}
		else if (samba_on.getState()) {
			// Creating share
			sshare = new SambaShare(file.path,
						available_on.getState(),
						writable_on.getState(),
						guest_only.getState() ? 2 :
						guest_on.getState() ? 1 : 0,
						comment.getText());
			filemgr.stab.put(sshare.path, sshare);
			String rv[] = filemgr.get_text(
				"save_share.cgi?new=1&"+sshare.params());
			}

		// Update NFS settings on server
		if (filemgr.nfsmode == 1) {
			if (lexport != null && nfs_on.getState()) {
				// Updating export
				export_options(lexport);
				String rv[] = filemgr.get_text(
					"save_export.cgi?"+lexport.params());
				}
			else if (lexport != null) {
				// Deleting export
				String rv[] = filemgr.get_text(
				  "save_export.cgi?delete=1&"+lexport.params());
				filemgr.ntab.remove(lexport.path);
				}
			else if (nfs_on.getState()) {
				// Creating export
				lexport = new LinuxExport(file.path, null,
							  null, null);
				export_options(lexport);
				String rv[] = filemgr.get_text(
				  "save_export.cgi?new=1&"+lexport.params());
				filemgr.ntab.put(lexport.path, lexport);
				}
			}
		else if (filemgr.nfsmode == 2) {
			if (dexport != null && nfs_on.getState()) {
				// Updating share
				dexport.desc = desc.getText();
				dexport.ro = ro[0].getState() ? "-" :
					     ro[1].getState() ? "" :
					     rohosts.getText();
				dexport.rw = rw[0].getState() ? "-" :
					     rw[1].getState() ? "" :
					     rwhosts.getText();
				dexport.root = root[0].getState() ? "-" :
					       roothosts.getText();
				String rv[] = filemgr.get_text(
					"save_export.cgi?"+dexport.params());
				}
			else if (dexport != null) {
				// Deleting share
				String rv[] = filemgr.get_text(
				  "save_export.cgi?delete=1&"+dexport.params());
				filemgr.ntab.remove(dexport.path);
				}
			else if (nfs_on.getState()) {
				// Creating new share
				dexport = new DFSAdminExport(file.path,
					desc.getText(),
					ro[0].getState() ? "-" :
					ro[1].getState() ? "" :
					rohosts.getText(),
					rw[0].getState() ? "-" :
					rw[1].getState() ? "" :
					rwhosts.getText(),
					root[0].getState() ? "-" :
					roothosts.getText());
				String rv[] = filemgr.get_text(
				    "save_export.cgi?new=1&"+dexport.params());
				filemgr.ntab.put(dexport.path, dexport);
				}
			}
		else if (filemgr.nfsmode == 3) {
			}

		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}

	void setup_leftright(Panel m, Panel l, Panel r)
	{
	m.setLayout(new BorderLayout());
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", l);
	p.add("Center", r);
	l.setLayout(new GridLayout(0, 1));
	r.setLayout(new GridLayout(0, 1));
	m.add("North", p);
	}

	void add_item(String t, Component c, Panel l, Panel r)
	{
	l.add(new Label(t));
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", c);
	r.add(p);
	}

	TextField add_hosts(String name, String v, Checkbox cb[],
			    Panel l, Panel r)
	{
	Panel p = new Panel();
	p.setLayout(new GridLayout(1, 3));
	CheckboxGroup g = new CheckboxGroup();
	p.add(cb[0] = new Checkbox(filemgr.text("share_none"), g,
				   v.equals("-")));
	p.add(cb[1] = new Checkbox(filemgr.text("share_all"), g,
				   v.length() == 0));
	p.add(cb[2] = new Checkbox(filemgr.text("share_listed"), g,
				   v.length() > 1));
	add_item(name, p, l, r);
	TextField t = new TextField(v.equals("-") ? "" : v, 25);
	add_item("", t, l, r);
	return t;
	}

	Choice squashbox(int s)
	{
	Choice rv = new Choice();
	rv.addItem(filemgr.text("share_s0"));
	rv.addItem(filemgr.text("share_s1"));
	rv.addItem(filemgr.text("share_s2"));
	rv.select(s);
	return rv;
	}

	Choice robox(boolean r)
	{
	Choice rv = new Choice();
	rv.addItem(filemgr.text("share_lrw"));
	rv.addItem(filemgr.text("share_lro"));
	rv.select(r ? 1 : 0);
	return rv;
	}

	Panel opts_panel(Component ro, Component squash)
	{
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	System.out.println("adding "+ro+" "+squash);
	p.add("West", ro);
	p.add("East", squash);
	return p;
	}

	void export_options(LinuxExport e)
	{
	int c = 0;
	for(int i=0; i<host.length; i++)
		if (host[i].getText().length() > 0)
			c++;
	e.host = new String[c];
	e.ro = new boolean[c];
	e.squash = new int[c];
	for(int i=0,j=0; i<host.length; i++) {
		if (host[i].getText().trim().length() > 0) {
			e.host[j] = host[i].getText();
			e.ro[j] = lro[i].getSelectedIndex() == 1;
			e.squash[j] = squash[i].getSelectedIndex();
			j++;
			}
		}
	}

}

class SearchWindow extends FixedFrame
	implements CbButtonCallback,MultiColumnCallback
{
	TabbedPanel tab;
	MultiColumn list;
	CbButton search_b, cancel_b;
	FileManager filemgr;
	TextField dir, match, user, group;
	Checkbox uany, usel, gany, gsel;
	Choice type;
	Checkbox sany, smore, sless;
	TextField more, less;
	Checkbox xon, xoff;
	String types[] = { "", "f", "d", "l", "p" };
	RemoteFile results[];

	SearchWindow(String d, FileManager p)
	{
	filemgr = p;
	setTitle(filemgr.text("search_title"));

	// setup UI
	setLayout(new BorderLayout());
	tab = new TabbedPanel();
	Panel search = new Panel();
	search.setLayout(new BorderLayout());
	tab.addItem(filemgr.text("search_crit"), search);
	Panel l = new Panel(), r = new Panel();
	l.setLayout(new GridLayout(0, 1));
	r.setLayout(new GridLayout(0, 1));

	String cols[] = { "", filemgr.text("right_name"),
			  filemgr.text("right_size") };
	float widths[] = { .07f, .78f, .15f };
	list = new MultiColumn(cols, this);
	list.setWidths(widths);
	list.setDrawLines(false);
	tab.addItem(filemgr.text("search_list"), list);

	add_item(filemgr.text("search_dir"), dir = new TextField(d, 30), l, r);

	add_item(filemgr.text("search_match"), match = new TextField(20), l, r);

	Panel up = new Panel();
	up.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
	CheckboxGroup ug = new CheckboxGroup();
	up.add(uany = new Checkbox(filemgr.text("search_any"), ug, true));
	up.add(usel = new Checkbox("", ug, false));
	up.add(user = new TextField(10));
	add_item(filemgr.text("search_user"), up, l, r);

	Panel gp = new Panel();
	gp.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
	CheckboxGroup gg = new CheckboxGroup();
	gp.add(gany = new Checkbox(filemgr.text("search_any"), gg, true));
	gp.add(gsel = new Checkbox("", gg, false));
	gp.add(group = new TextField(10));
	add_item(filemgr.text("search_group"), gp, l, r);

	type = new Choice();
	for(int i=0; i<types.length; i++)
		type.addItem(filemgr.text("search_types_"+types[i]));
	add_item(filemgr.text("search_type"), type, l, r);

	CheckboxGroup sg = new CheckboxGroup();
	add_item(filemgr.text("search_size"),
		 sany = new Checkbox(filemgr.text("search_any"), sg, true),
		 l, r);
	Panel mp = new Panel();
	mp.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
	mp.add(smore = new Checkbox(filemgr.text("search_more"), sg, false));
	mp.add(more = new TextField(10));
	add_item("", mp, l, r);
	Panel lp = new Panel();
	lp.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
	lp.add(sless = new Checkbox(filemgr.text("search_less"), sg, false));
	lp.add(less = new TextField(10));
	add_item("", lp, l, r);

	CheckboxGroup xg = new CheckboxGroup();
	Panel xp = new Panel();
	xp.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
	xp.add(xoff = new Checkbox(filemgr.text("yes"), xg, true));
	xp.add(xon = new Checkbox(filemgr.text("no"), xg, false));
	add_item(filemgr.text("search_xdev"), xp, l, r);

	search.add("West", l); search.add("East", r);
	add("Center", tab);

	// Create search and cancel buttons
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(search_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("search_ok"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	void add_item(String t, Component c, Panel l, Panel r)
	{
	l.add(new Label(t));
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", c);
	r.add(p);
	}

	public void click(CbButton b)
	{
	if (b == cancel_b)
		dispose();
	else if (b == search_b) {
		// validate inputs and build search URL
		String url = "search.cgi";
		String d = dir.getText().trim();
		if (d.length() == 0 || d.charAt(0) != '/') {
			new ErrorWindow(filemgr.text("search_edir"));
			return;
			}
		url += "?dir="+filemgr.urlize(d);
		String mt = match.getText().trim();
		if (mt.length() == 0) {
			new ErrorWindow(filemgr.text("search_ematch"));
			return;
			}
		url += "&match="+filemgr.urlize(mt);
		if (type.getSelectedIndex() > 0)
			url += "&type="+types[type.getSelectedIndex()];
		if (usel.getState()) {
			String u = user.getText().trim();
			if (u.length() == 0) {
				new ErrorWindow(filemgr.text("search_euser"));
				return;
				}
			url += "&user="+filemgr.urlize(u);
			}
		if (gsel.getState()) {
			String g = group.getText().trim();
			if (g.length() == 0) {
				new ErrorWindow(filemgr.text("search_egroup"));
				return;
				}
			url += "&group="+filemgr.urlize(g);
			}
		if (smore.getState()) {
			String m = more.getText().trim();
			try { Integer.parseInt(m); }
			catch(Exception e) {
				new ErrorWindow(filemgr.text("search_esize"));
				return;
				}
			url += "&size=%2B"+m+"c";
			}
		else if (sless.getState()) {
			String l = less.getText().trim();
			try { Integer.parseInt(l); }
			catch(Exception e) {
				new ErrorWindow(filemgr.text("search_esize"));
				return;
				}
			url += "&size=%2D"+l+"c";
			}
		if (xon.getState())
			url += "&xdev=1";

		// send off the search
		setCursor(WAIT_CURSOR);
		String f[] = filemgr.get_text(url);
		if (f[0].length() > 0) {
			new ErrorWindow(f[0]);
			return;
			}
		Object rows[][] = new Object[f.length-1][];
		results = new RemoteFile[f.length-1];
		for(int i=1; i<f.length; i++) {
			RemoteFile r = new RemoteFile(filemgr, f[i], null);
			results[i-1] = r;
			Object row[] = rows[i-1] = new Object[3];
			row[0] = filemgr.get_image(RemoteFile.tmap[r.type]);
			row[1] = r.path;
			if (r.size < 1000)
				row[2] = filemgr.spad(r.size, 5)+" B";
			else if (r.size < 1000000)
				row[2] = filemgr.spad(r.size/1000, 5)+" kB";
			else
				row[2] = filemgr.spad(r.size/1000000, 5)+" MB";
			}
		list.clear();
		list.addItems(rows);
		tab.select(filemgr.text("search_list"));
		setCursor(DEFAULT_CURSOR);
		}
	}

	public void singleClick(MultiColumn list, int num)
	{
	}

	// go to the directory of the double-clicked file
	public void doubleClick(MultiColumn list, int num)
	{
	RemoteFile f = results[num];
	int sl = f.path.lastIndexOf('/');
	String dir = sl == 0 ? "/" : f.path.substring(0, sl);
	filemgr.find_directory(dir, true);
	RemoteFile l[] = filemgr.showing_files.list();
	for(int i=0; i<l.length; i++) {
		if (l[i].name.equals(f.name)) {
			// select the file in the list
			filemgr.files.select(i+1);
			filemgr.files.scrollto(i+1);
			break;
			}
		}
	dispose();
	}
}

class FileSystem
{
	String mount;
	String dev;
	String type;
	String opts[];
	boolean acls;
	boolean attrs;

	FileSystem(String l)
	{
	StringSplitter tok = new StringSplitter(l, ' ');
	mount = tok.nextToken();
	dev = tok.nextToken();
	type = tok.nextToken();
	String optstr = tok.nextToken();
	acls = tok.nextToken().equals("1");
	attrs = tok.nextToken().equals("1");
	StringTokenizer tok2 = new StringTokenizer(optstr, ",");
	opts = new String[tok2.countTokens()];
	for(int i=0; i<opts.length; i++)
		opts[i] = tok2.nextToken();
	}
}

class ACLEntry
{
	FileManager filemgr;
	RemoteFile file;
	boolean def;
	String type;
	String owner;
	boolean read, write, exec;

	ACLEntry(String l, ACLWindow w)
	{
	filemgr = w.filemgr;
	file = w.file;
	StringSplitter tok = new StringSplitter(l, ':');
	type = tok.nextToken();
	if (type.equals("default")) {
		def = true;
		type = tok.nextToken();
		}
	if (!type.equals("mask") && !type.equals("other")) {
		owner = tok.nextToken();
		if (owner.length() == 0)
			owner = null;
		}
	String rwx = tok.nextToken();
	if (rwx.length() == 0)
		rwx = tok.nextToken();	// getfacl outputs a blank owner for mask
					// and other on some systems
	read = (rwx.charAt(0) == 'r');
	write = (rwx.charAt(1) == 'w');
	exec = (rwx.charAt(2) == 'x');
	}

	ACLEntry(ACLWindow w)
	{
	filemgr = w.filemgr;
	file = w.file;
	}

	String[] getRow()
	{
	String rv[] = new String[3];
	rv[0] = type;
	if (def) rv[0] = "default "+rv[0];
	if (type.equals("mask") || type.equals("other")) rv[1] = "";
	else if (owner != null) rv[1] = owner;
	else if (type.equals("user")) rv[1] = filemgr.text("eacl_user", file.user);
	else rv[1] = filemgr.text("eacl_group", file.group);
	rv[2] = "";
	if (read) rv[2] += filemgr.text("info_read")+" ";
	if (write) rv[2] += filemgr.text("info_write")+" ";
	if (exec) rv[2] += filemgr.text("info_exec")+" ";
	return rv;
	}

	public String toString()
	{
	String rv = def ? "default:" : "";
	rv += type+":";
	if (!type.equals("mask") && !type.equals("other"))
		rv += (owner == null ? "" : owner)+":";
	rv += (read ? 'r' : '-');
	rv += (write ? 'w' : '-');
	rv += (exec ? 'x' : '-');
	return rv;
	}
}

class ACLEditor extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	ACLWindow aclwin;
	ACLEntry acl;
	boolean creating;
	CbButton ok, del;
	Checkbox read, write, exec;
	TextField owner;

	// Editing an existing ACL entry
	ACLEditor(ACLWindow w, ACLEntry a)
	{
	aclwin = w;
	filemgr = aclwin.filemgr;
	acl = a;
	creating = false;
	makeUI();
	}

	// Creating a new ACL entry
	ACLEditor(ACLWindow w, String type, boolean def)
	{
	aclwin = w;
	filemgr = aclwin.filemgr;
	acl = new ACLEntry(aclwin);
	acl.def = def;
	acl.type = type;
	creating = true;
	makeUI();
	}

	void makeUI()
	{
	setTitle(filemgr.text(creating ? "eacl_create" : "eacl_edit"));
	setLayout(new BorderLayout());
	Panel left = new Panel();
	left.setLayout(new GridLayout(0, 1));
	add("West", left);
	Panel right = new Panel();
	right.setLayout(new GridLayout(0, 1));
	add("East", right);

	left.add(new Label(filemgr.text("eacl_acltype")));
	TextField type;
	right.add(type = new TextField((acl.def ? "default " : "")+acl.type, 20));
	type.setEditable(false);

	if (!acl.type.equals("mask") && !acl.type.equals("other")) {
		left.add(new Label(filemgr.text("eacl_aclname")));
		if (creating || acl.owner != null) {
			// Only allow the adding or editing of ACLs on a user
			owner = new TextField(acl.owner == null ? "" : acl.owner,
					      20);
			right.add(owner);
			}
		else {
			// Just day that this ACL is on the owner
			String str;
			if (acl.type.equals("user"))
				str = filemgr.text("eacl_user", aclwin.file.user);
			else
				str = filemgr.text("eacl_group", aclwin.file.group);
			TextField o = new TextField(str);
			o.setEditable(false);
			right.add(o);
			}
		}

	left.add(new Label(filemgr.text("eacl_aclperms")));
	Panel pp = new Panel();
	pp.setLayout(new FlowLayout(FlowLayout.RIGHT));
	pp.add(read = new Checkbox(filemgr.text("info_read"), null, acl.read));
	pp.add(write = new Checkbox(filemgr.text("info_write"), null, acl.write));
	pp.add(exec = new Checkbox(filemgr.text("info_exec"), null, acl.exec));
	right.add(pp);

	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(ok = new CbButton(filemgr.get_image("save.gif"),
				  filemgr.text("save"),
				  CbButton.LEFT, this));
	if (!creating && (acl.owner != null || acl.def))
		bot.add(del = new CbButton(filemgr.get_image("cancel.gif"),
					   filemgr.text("delete"),
					   CbButton.LEFT, this));
	add("South", bot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == ok) {
		// Update or add the ACL entry
		if (owner != null) {
			String o = owner.getText().trim();
			if (o.length() == 0) {
				new ErrorWindow(filemgr.text("eacl_eowner"));
				return;
				}
			acl.owner = owner.getText();
			}
		acl.read = read.getState();
		acl.write = write.getState();
		acl.exec = exec.getState();
		if (creating) {
			// Add to the ACL table
			aclwin.acllist.addElement(acl);
			aclwin.acltable.addItem(acl.getRow());
			}
		else {
			// Update the table
			int idx = aclwin.acllist.indexOf(acl);
			aclwin.acltable.modifyItem(acl.getRow(), idx);
			}
		dispose();
		}
	else if (b == del) {
		// Remove this entry
		int idx = aclwin.acllist.indexOf(acl);
		aclwin.acllist.removeElementAt(idx);
		aclwin.acltable.deleteItem(idx);
		dispose();
		}
	}
}

class ACLWindow extends FixedFrame implements CbButtonCallback,MultiColumnCallback
{
	FileManager filemgr;
	RemoteFile file;
	Vector acllist = new Vector();

	CbButton ok, cancel, add;
	Choice addtype;
	MultiColumn acltable;

	ACLWindow(FileManager p, RemoteFile f)
	{
	super(400, 300);
	setTitle(p.text("eacl_title", f.path));
	filemgr = p;
	file = f;

	// Get the ACLs
	String a[] = filemgr.get_text(
			"getfacl.cgi?file="+filemgr.urlize(file.path));
	if (a[0].length() != 0) {
		new ErrorWindow(filemgr.text("eacl_eacls", a[0]));
		return;
		}

	// Create the UI
	setLayout(new BorderLayout());
	String titles[] = { filemgr.text("eacl_acltype"),
			    filemgr.text("eacl_aclname"),
			    filemgr.text("eacl_aclperms") };
	acltable = new MultiColumn(titles, this);
	for(int i=1; i<a.length; i++) {
		ACLEntry acl = new ACLEntry(a[i], this);
		acllist.addElement(acl);
		acltable.addItem(acl.getRow());
		}
	add("Center", acltable);
	Panel abot = new Panel();
	abot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	abot.add(add = new CbButton(filemgr.get_image("add.gif"),
				   filemgr.text("eacl_add"),
				   CbButton.LEFT, this));
	String acltypes[] = { "user", "group",
			      "default user", "default group", "default other",
			      "mask" };
	abot.add(addtype = new Choice());
	for(int i=0; i<acltypes.length; i++)
		addtype.addItem(acltypes[i]);
	abot.add(new Label(" "));
	abot.add(ok = new CbButton(filemgr.get_image("save.gif"),
				   filemgr.text("save"),
				   CbButton.LEFT, this));
	abot.add(cancel = new CbButton(filemgr.get_image("cancel.gif"),
				       filemgr.text("cancel"),
				       CbButton.LEFT, this));
	add("South", abot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == ok) {
		// Save the ACLs
		String aclstr = "";
		for(int i=0; i<acllist.size(); i++)
			aclstr += (ACLEntry)acllist.elementAt(i)+"\n";
		System.out.println(aclstr);
		String rv[] = filemgr.get_text("setfacl.cgi?file="+
						filemgr.urlize(file.path)+
						"&acl="+filemgr.urlize(aclstr));
		if (rv[0].length() > 0)
			new ErrorWindow(filemgr.text("eacl_efailed",
				file.path, rv[0]));
		else
			dispose();
		}
	else if (b == add) {
		// Open a window for a new ACL entry
		String t = addtype.getSelectedItem();
		String d = "default ";
		boolean def = t.startsWith(d);
		if (def)
			t = t.substring(d.length());
		if (t.equals("mask")) {
			// Only allow one mask
			for(int i=0; i<acllist.size(); i++)
				if (((ACLEntry)acllist.elementAt(i)).
				    type.equals(t)) {
					new ErrorWindow(filemgr.text("eacl_emask"));
					return;
					}
			}
		new ACLEditor(this, t, def);
		}
	else if (b == cancel) {
		// Don't save
		dispose();
		}
	}

	// Bring up an editor for an ACL
        public void doubleClick(MultiColumn list, int num)
	{
	int idx = list.selected();
	if (idx >= 0) {
		ACLEntry e = (ACLEntry)acllist.elementAt(idx);
		new ACLEditor(this, e);
		}
	}

        public void singleClick(MultiColumn list, int num)
	{
	}

}

class AttributesWindow extends FixedFrame
	implements CbButtonCallback,MultiColumnCallback
{
	FileManager filemgr;
	RemoteFile file;
	Vector attrlist = new Vector();

	CbButton ok, cancel, add;
	MultiColumn attrtable;

	AttributesWindow(FileManager p, RemoteFile f)
	{
	super(400, 300);
	setTitle(p.text("attr_title", f.path));
	filemgr = p;
	file = f;

	// Get the attributes
	String a[] = filemgr.get_text(
			"getattrs.cgi?file="+filemgr.urlize(file.path));
	if (a[0].length() != 0) {
		new ErrorWindow(filemgr.text("attr_eattrs", a[0]));
		return;
		}

	// Create the UI
	setLayout(new BorderLayout());
	String titles[] = { filemgr.text("attr_name"),
			    filemgr.text("attr_value") };
	attrtable = new MultiColumn(titles, this);
	for(int i=1; i<a.length; i++) {
		FileAttribute at = new FileAttribute(a[i], filemgr);
		attrlist.addElement(at);
		attrtable.addItem(at.getRow());
		}
	add("Center", attrtable);
	Panel abot = new Panel();
	abot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	abot.add(add = new CbButton(filemgr.get_image("add.gif"),
				   filemgr.text("attr_add"),
				   CbButton.LEFT, this));
	abot.add(new Label(" "));
	abot.add(ok = new CbButton(filemgr.get_image("save.gif"),
				   filemgr.text("save"),
				   CbButton.LEFT, this));
	abot.add(cancel = new CbButton(filemgr.get_image("cancel.gif"),
				       filemgr.text("cancel"),
				       CbButton.LEFT, this));
	add("South", abot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == ok) {
		// Save the attributes
		String pstr = "";
		for(int i=0; i<attrlist.size(); i++) {
			FileAttribute at = (FileAttribute)attrlist.elementAt(i);
			pstr += "&name"+i+"="+filemgr.urlize(at.name)+
			        "&value"+i+"="+filemgr.urlize(at.value);
			}
		String rv[] = filemgr.get_text("setattrs.cgi?file="+
						filemgr.urlize(file.path)+pstr);
		if (rv[0].length() > 0)
			new ErrorWindow(filemgr.text("attr_efailed",
				file.path, rv[0]));
		else
			dispose();
		}
	else if (b == add) {
		// Open a window for a new ACL entry
		new AttributeEditor(this);
		}
	else if (b == cancel) {
		// Don't save
		dispose();
		}
	}

	// Bring up an editor for an ACL
        public void doubleClick(MultiColumn list, int num)
	{
	int idx = list.selected();
	if (idx >= 0) {
		FileAttribute at = (FileAttribute)attrlist.elementAt(idx);
		new AttributeEditor(this, at);
		}
	}

        public void singleClick(MultiColumn list, int num)
	{
	}

}

class FileAttribute
{
	String name;
	String value;

	FileAttribute(String l, FileManager f)
	{
	int eq = l.indexOf('=');
	name = f.un_urlize(l.substring(0, eq));
	value = f.un_urlize(l.substring(eq+1));
	}

	FileAttribute(String n, String v)
	{
	name = n;
	value = v;
	}

	String[] getRow()
	{
	return new String[] { name, value };
	}
}

class AttributeEditor extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	AttributesWindow attrwin;
	FileAttribute attr;
	boolean creating;
	CbButton ok, del;
	TextField name;
	TextArea value;

	AttributeEditor(AttributesWindow w, FileAttribute a)
	{
	attrwin = w;
	attr = a;
	filemgr = w.filemgr;
	creating = false;
	makeUI();
	}

	AttributeEditor(AttributesWindow w)
	{
	attrwin = w;
	attr = new FileAttribute("", "");
	filemgr = w.filemgr;
	creating = true;
	makeUI();
	}

	void makeUI()
	{
	setTitle(filemgr.text(creating ? "attr_create" : "attr_edit"));
	setLayout(new BorderLayout());

	Panel top = new Panel();
	top.setLayout(new GridLayout(1, 2));
	top.add(new Label(filemgr.text("attr_name")));
	top.add(name = new TextField(attr.name, 20));
	add("North", top);

	Panel mid = new Panel();
	mid.setLayout(new GridLayout(1, 2));
	mid.add(new Label(filemgr.text("attr_value")));
	mid.add(value = new TextArea(attr.value, 5, 20));
	add("Center", mid);

	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(ok = new CbButton(filemgr.get_image("save.gif"),
				  filemgr.text("save"),
				  CbButton.LEFT, this));
	if (!creating)
		bot.add(del = new CbButton(filemgr.get_image("cancel.gif"),
					   filemgr.text("delete"),
					   CbButton.LEFT, this));
	add("South", bot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == ok) {
		// Update or add the attribute
		if (name.getText().length() == 0) {
			new ErrorWindow(filemgr.text("attr_ename"));
			return;
			}
		attr.name = name.getText();
		attr.value = value.getText();
		if (creating) {
			// Add to the attribs table
			attrwin.attrlist.addElement(attr);
			attrwin.attrtable.addItem(attr.getRow());
			}
		else {
			// Update the table
			int idx = attrwin.attrlist.indexOf(attr);
			attrwin.attrtable.modifyItem(attr.getRow(), idx);
			}
		dispose();
		}
	else if (b == del) {
		// Remove this entry
		int idx = attrwin.attrlist.indexOf(attr);
		attrwin.attrlist.removeElementAt(idx);
		attrwin.attrtable.deleteItem(idx);
		dispose();
		}
	}
}

