#!/usr/local/bin/perl
# save_acl.cgi
# Save access control options for some module

require './acl-lib.pl';
&ReadParse();
if ($in{'_acl_group'}) {
	$access{'groups'} || &error($text{'acl_egroup'});
	$who = $in{'_acl_group'};
	}
else {
	foreach $u (&list_users()) {
		$me = $u if ($u->{'name'} eq $base_remote_user);
		}
	@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
		$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
				       ( &list_modules(), "" );
	&indexof($in{'_acl_mod'}, @mcan) >= 0 || &error($text{'acl_emod'});
	&can_edit_user($in{'_acl_user'}) || &error($text{'acl_euser'});
	$who = $in{'_acl_user'};
	}

&error_setup($text{'acl_err'});
$maccess{'noconfig'} = $in{'noconfig'};
if (-r "../$in{'_acl_mod'}/acl_security.pl") {
	&foreign_require($in{'_acl_mod'}, "acl_security.pl");
	if ($in{'_acl_mod'}) {
		eval "\%$in{'_acl_mod'}::in = \%in";
		}
	else {
		%global::in = %in;
		}
	&foreign_call($in{'_acl_mod'}, "acl_security_save", \%maccess, \%in);
	}
&lock_file("$config_directory/$in{'_acl_mod'}/$who.acl");
&write_file("$config_directory/$in{'_acl_mod'}/$who.acl",
	    \%maccess);
&unlock_file("$config_directory/$in{'_acl_mod'}/$who.acl");
%minfo = $in{'_acl_mod'} ? &get_module_info($in{'_acl_mod'})
			 : ( 'desc' => $text{'index_global'} );

if ($in{'_acl_group'}) {
	# Recursively update the ACL for all member users and groups
	@ulist = &list_users();
	@glist = &list_groups();
	($group) = grep { $_->{'name'} eq $in{'_acl_group'} } @glist;
	&set_acl_files(\@ulist, \@glist, $in{'_acl_mod'}, $group->{'members'});
	}

$in{'moddesc'} = $minfo{'desc'};
&webmin_log("acl", undef, $who, \%in);
&redirect("");

# set_acl_files(&allusers, &allgroups, module, &members)
sub set_acl_files
{
foreach $m (@{$_[3]}) {
	local ($u) = grep { $_->{'name'} eq $m } @{$_[0]};
	local ($g) = grep { $_->{'name'} eq $m } @{$_[1]};
	if ($u || $g) {
		local $n = $u ? $u->{'name'} : $g->{'name'};
		&lock_file("$config_directory/$_[2]/$n.acl");
		&write_file("$config_directory/$_[2]/$n.acl", \%maccess);
		&unlock_file("$config_directory/$_[2]/$n.acl");
		}
	if ($g) {
		&set_acl_files($_[0], $_[1], $_[2], $g->{'members'});
		}
	}
}

