#!/usr/local/bin/perl
# Show all drives and their SMART status

require './smart-status-lib.pl';
&ReadParse();

# Make sure SMART commands are installed
if (!&has_command($config{'smartctl'})) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);
	&ui_print_endpage(
		&ui_config_link('index_ecmd',
		        [ "<tt>$config{'smartctl'}</tt>", undef ]));
	}

# Show the version
$ver = &get_smart_version();
if (!$ver) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);
	&ui_print_endpage(
		&ui_config_link('index_ecmd2',
		        [ "<tt>$config{'smartctl'}</tt>", undef ]));
	}
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
		 &help_search_link("smartctl", "man", "doc", "google"),
		 undef, undef,
		 &text('index_version', $ver));

# Get list of drives
@drives = grep { $_->{'type'} eq 'ide' } &fdisk::list_disks_partitions();
@drives = sort { $a->{'device'} cmp $b->{'device'} } @drives;
if (!@drives) {
	&ui_print_endpage($text{'index_eide'});
	}

if ($config{'mode'} == 1) {
	# Just show one drive, selected from menu
	print &ui_form_start("index.cgi");
	print "<b>$text{'index_show'}</b>\n";
	print &ui_select("drive", $in{'drive'},
			 [ map { [ $_->{'device'},
				   $_->{'desc'}.($_->{'model'} ? " ($_->{'model'})" : "") ] } @drives ]);
	print &ui_submit($text{'index_ok'}),"\n";
	print &ui_form_end();

	if ($in{'drive'}) {
		($d) = grep { $_->{'device'} eq $in{'drive'} } @drives;
		&show_drive($d);
		}
	}
else {
	# Show all IDE drives
	foreach $d (@drives) {
		&show_drive($d);
		}
	}

&ui_print_footer("/", $text{'index'});

# show_drive(&drive)
sub show_drive
{
print &ui_form_start("action.cgi");
print &ui_hidden("drive", $_[0]->{'device'});
print &ui_table_start(&text('index_drive', "<tt>$_[0]->{'device'}</tt>"),
		      undef, 2);
local $st = &get_drive_status($_[0]->{'device'});
print &ui_table_row($text{'index_desc'},
		    $_[0]->{'desc'});
if ($_[0]->{'cylsize'}) {
	print &ui_table_row($text{'index_size'},
		    &nice_size($_[0]->{'cylinders'}*$_[0]->{'cylsize'}));
	}
if ($_[0]->{'model'}) {
	print &ui_table_row($text{'index_model'},
			    $_[0]->{'model'});
	}
print &ui_table_row($text{'index_support'},
		    $st->{'support'} ? $text{'yes'} : $text{'no'});
print &ui_table_row($text{'index_enabled'},
		    $st->{'enabled'} ? $text{'yes'} : $text{'no'});
if ($st->{'support'} && $st->{'enabled'}) {
	if ($st->{'errors'}) {
		print &ui_table_row($text{'index_errors'},
				    "<font color=#ff0000>".
				    &text('index_ecount', $st->{'errors'}).
				    "</font>");
		}
	print &ui_table_row($text{'index_check'},
			    $st->{'check'} ? $text{'yes'} : "<font color=#ff0000>$text{'no'}</font>");
	if ($config{'attribs'}) {
		print &ui_table_hr();
		local $a;
		foreach $a (@{$st->{'attribs'}}) {
			next if ($a->[0] =~ /UDMA CRC Error Count/i); # too long
			print &ui_table_row($a->[0],
				$a->[2] =~ /^\s*(seconds|minutes|hours|days|months|years|weeks)\s*/i || !$a->[2] ? $a->[1]." ".$a->[2] : $a->[2]);
			}
		}
	}
print &ui_table_end();
print &ui_form_end([ [ "short", $text{'index_short'} ],
		     [ "ext", $text{'index_ext'} ],
		     [ "data", $text{'index_data'} ] ]);
}

