/**************************************************************************
* Generic, native, relational database
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "iteratorcore.h"

using namespace RDB;

IndexIteratorCore::IndexIteratorCore( TableData* data ) :
    m_data( data ),
    m_hash( 0 ),
    m_bucket( 0 )
{
}

IndexIteratorCore::~IndexIteratorCore()
{
}

bool IndexIteratorCore::next()
{
    while ( m_hash < m_data->m_size ) {
        if ( !m_bucket )
            m_bucket = m_data->m_buckets[ m_hash ];
        else
            m_bucket = m_bucket->m_links[ m_data->m_dim ].m_next;
        if ( m_bucket )
            return true;
        m_hash++;
    }
    return false;
}

ForeignIteratorCore::ForeignIteratorCore( TableData* data, int key ) :
    m_data( data ),
    m_key( key ),
    m_bucket( 0 )
{
}

ForeignIteratorCore::~ForeignIteratorCore()
{
}

bool ForeignIteratorCore::next()
{
    if ( !m_bucket ) {
        uint hash = m_key % m_data->m_size;
        m_bucket = m_data->m_buckets[ hash ];
    } else {
        m_bucket = m_bucket->m_links[ m_data->m_dim ].m_next;
    }
    while ( m_bucket ) {
        if ( m_bucket->m_row->key( m_data->m_dim ) == m_key )
            return true;
        m_bucket = m_bucket->m_links[ m_data->m_dim ].m_next;
    }
    return false;
}
