/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ABSTRACTVALUEEDITOR_H
#define ABSTRACTVALUEEDITOR_H

#include <QWidget>
#include <QPointer>

class QWidget;

namespace WebIssues
{

/**
* Delegate for editing attribute values.
*
* This delegate creates a widget for editing attribute values and provides
* an interface to read and change the current value.
*
* This is an abstract class. Use the ValueEditorFactory to create
* delegates for given attribute types.
*
* Inherited classes must implement the setValue() and value() methods.
*/
class AbstractValueEditor : public QObject
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    AbstractValueEditor( QObject* parent );

    /**
    * Destructor.
    */
    ~AbstractValueEditor();

public:
    /**
    * Return the widget created by this delegate.
    */
    QWidget* widget() const { return m_widget; };

public:
    /**
    * Set the current value of the editor's widget to @p value.
    */
    virtual void setValue( const QString& value ) = 0;

    /**
    * Return the current value of the editor's widget.
    */
    virtual QString value() = 0;

protected:
    /**
    * Called by inherited classes to set the editor's widget.
    */
    void setWidget( QWidget* widget );

private:
    QPointer<QWidget> m_widget;
};

}

#endif
