var webdeveloper_editCSSIntervalId      = null;
var webdeveloper_editCSSSelectedTab     = 0;
var webdeveloper_editCSSUpdateFrequency = 500;

// Applies the CSS
function webdeveloper_applyCSS()
{
    var contentDocument    = webdeveloper_getContentDocument();
    var headElementList    = contentDocument.getElementsByTagName("head");
    var styleElement       = null;
    var styleElementParent = contentDocument.documentElement;
    var styleText          = null;
    var textBox            = null;
    var textBoxes          = document.getElementById("webdeveloper-edit-css-tab-panels").getElementsByTagName("textbox");
    var textBoxesLength    = textBoxes.length;

    // If there is a head element
    if(headElementList.length > 0)
    {
        styleElementParent = headElementList[0];
    }

    // Loop through the text boxes
    for(var i = 0; i < textBoxesLength; i++)
    {
        styleElement = contentDocument.getElementById("webdeveloper-edit-css-style-" + i);
        textBox      = textBoxes[i];
        styleText    = textBox.value;

        // If the strip import preference is not set or is set to true
        if(!webdeveloper_isPreferenceSet("webdeveloper.edit.css.import.strip") || webdeveloper_getBooleanPreference("webdeveloper.edit.css.import.strip", true))
        {
            styleText = styleText.replace(new RegExp("@import.*?;", "gi"), "");
        }

        // If the style element does not exist
        if(!styleElement)
        {
            styleElement = contentDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-edit-css-style-" + i);
            styleElement.setAttribute("type", "text/css");
            styleElement.setAttribute("xml:base", textBox.getAttribute("webdeveloper-base"));
            styleElementParent.appendChild(styleElement);
        }

        // If the style text is not the same as the style element content
        if(styleText != styleElement.innerHTML)
        {
            webdeveloper_removeAllChildNodes(styleElement);
            styleElement.appendChild(contentDocument.createTextNode(styleText));
        }
    }
}

// Clear the CSS
function webdeveloper_clearCSS()
{
    webdeveloper_getSelectedPanel().firstChild.value = "";
}

// Reinitializes the sidebar when the page changes
function webdeveloper_editCSSContentPageLoad(event)
{
    var eventTarget    = event.target;
    var originalTarget = event.originalTarget;

    // If the page is the target and the URI matches
    if(originalTarget && eventTarget && eventTarget.contentDocument && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content" && originalTarget.documentURI == eventTarget.contentDocument.documentURI)
    {
        // If the CSS stick preference is not set to true
        if(!webdeveloper_getBooleanPreference("webdeveloper.edit.stick", true))
        {
            webdeveloper_resetCSS();
        }
    }
}

// Handles a browser tab being selected
function webdeveloper_editCSSMainTabSelect(event)
{
    var browser     = window.top.getBrowser();
    var selectedTab = browser.mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_editCSSSelectedTab)
    {
        var browsers      = browser.browsers;
        var browserLength = browsers.length;

        // If the previous selected tab equals the browser length
        if(webdeveloper_editCSSSelectedTab == browserLength)
        {
            webdeveloper_editCSSSelectedTab = browserLength - 1;
        }

        webdeveloper_resetDocument(browsers[webdeveloper_editCSSSelectedTab].contentDocument);

        webdeveloper_editCSSSelectedTab = selectedTab;

        // If the CSS stick preference is not set to true
        if(!webdeveloper_getBooleanPreference("webdeveloper.edit.stick", true))
        {
            webdeveloper_resetCSS();
        }
    }
}

// Enables a style sheet
function webdeveloper_enableStyleSheet(styleSheet)
{
    // If the style sheet is a valid style sheet and is not an alternate style sheet
    if(webdeveloper_isValidStyleSheet(styleSheet) && !webdeveloper_isAlternateStyleSheet(styleSheet))
    {
        var cssRule        = null;
        var cssRules       = styleSheet.cssRules;
        var cssRulesLength = cssRules.length;
        var importRule     = Components.interfaces.nsIDOMCSSRule.IMPORT_RULE;

        // Loop through the the style sheet rules
        for(var i = 0; i < cssRulesLength; i++)
        {
            cssRule = cssRules[i];

            // If this is an import rule
            if(cssRule.type == importRule)
            {
                webdeveloper_enableStyleSheet(cssRule.styleSheet);
            }
        }

        styleSheet.disabled = false;
    }
}

// Returns the selected panel
function webdeveloper_getSelectedPanel()
{
    var selectedPanel = document.getElementById("webdeveloper-edit-css-tab-box").selectedPanel;

    // If the selected panel is not set
    if(!selectedPanel)
    {
        selectedPanel = document.getElementById("webdeveloper-edit-css-tab-panels").firstChild;
    }

    return selectedPanel;
}

// Returns the selected tab
function webdeveloper_getSelectedTab()
{
    var selectedTab = document.getElementById("webdeveloper-edit-css-tab-box").selectedTab;

    // If the selected tab is not set
    if(!selectedTab)
    {
        selectedTab = document.getElementById("webdeveloper-edit-css-tabs").firstChild;
    }

    return selectedTab;
}

// Initializes the edit CSS sidebar
function webdeveloper_initializeEditCSS()
{
    var browser    = window.top.getBrowser();
    var mainTabBox = browser.mTabBox;

    webdeveloper_editCSSSelectedTab     = mainTabBox.selectedIndex;
    webdeveloper_editCSSUpdateFrequency = webdeveloper_getIntegerPreference("webdeveloper.edit.update.frequency", true);

    mainTabBox.addEventListener("select", webdeveloper_editCSSMainTabSelect, true);
    window.top.addEventListener("load", webdeveloper_editCSSContentPageLoad, true);

    webdeveloper_updateStickCSS();
    webdeveloper_retrieveCSS();

    // If the update frequency is greater than 0
    if(webdeveloper_editCSSUpdateFrequency > 0)
    {
        webdeveloper_editCSSIntervalId = window.setInterval(webdeveloper_applyCSS, webdeveloper_editCSSUpdateFrequency);
    }
}

// Loads new CSS
function webdeveloper_loadCSS()
{
    var filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_loadStyleSheet"), filePicker.modeOpen);

    // If the user selected a style sheet
    if(filePicker.show() == filePicker.returnOK)
    {
        var inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
        var scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

        inputStream.init(filePicker.file, 0x01, 00444, null);
        scriptableStream.init(inputStream);

        webdeveloper_getSelectedPanel().firstChild.value = scriptableStream.read(scriptableStream.available());

        scriptableStream.close();
        inputStream.close();
    }
}

// Resets the edited CSS
function webdeveloper_resetCSS()
{
    webdeveloper_removeAllChildNodes(document.getElementById("webdeveloper-edit-css-tab-panels"));
    webdeveloper_removeAllChildNodes(document.getElementById("webdeveloper-edit-css-tabs"));
    webdeveloper_resetDocument(webdeveloper_getContentDocument());
    webdeveloper_retrieveCSS();
}

// Resets the specified document
function webdeveloper_resetDocument(contentDocument)
{
    var styleElement     = null;
    var styleElements    = contentDocument.getElementsByTagName("style");
    var styleSheet       = null;
    var styleSheetList   = webdeveloper_getStyleSheetsForDocument(contentDocument, true, false);
    var styleSheetLength = styleSheetList.length;

    // Loop through the style elements
    for(var i = 0; i < styleElements.length; i++)
    {
        styleElement = styleElements[i];

        // If the style element has an id starting with webdeveloper-edit-css-style-
        if(styleElement.hasAttribute("id") && styleElement.getAttribute("id").indexOf("webdeveloper-edit-css-style-") == 0)
        {
            styleElement.parentNode.removeChild(styleElement);
            i--;
        }
    }

    // Loop through the style sheets
    for(i = 0; i < styleSheetLength; i++)
    {
        styleSheet = styleSheetList[i];

        // If the style sheet is a valid style sheet, is for the screen and is not an alternate style sheet
        if(webdeveloper_isValidStyleSheet(styleSheet) && webdeveloper_isMediaStyleSheet(styleSheet, "screen") && !webdeveloper_isAlternateStyleSheet(styleSheet))
        {
           styleSheet.disabled = false;
        }
    }

}

// Retrieves the CSS from the current page
function webdeveloper_retrieveCSS()
{
    var contentDocument  = webdeveloper_getContentDocument();
    var documentURL      = contentDocument.documentURI;
    var inlineStylesText = "";
    var result           = null;
    var results          = new Array();
    var resultsLength    = null;
    var stringBundle     = document.getElementById("webdeveloper-string-bundle");
    var styleElement     = null;
    var styleSheet       = null;
    var styleSheetList   = webdeveloper_getStyleSheetsForDocument(contentDocument, true, false);
    var styleSheetLength = styleSheetList.length;
    var tab              = null;
    var tabPanel         = null;
    var tabs             = document.getElementById("webdeveloper-edit-css-tabs");
    var tabPanels        = document.getElementById("webdeveloper-edit-css-tab-panels");
    var textBox          = null;
    var textBoxStyle     = "";
    var url              = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);

    url.spec = documentURL;

    // If the edit CSS background color preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.background"))
    {
        textBoxStyle += "background-color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.background", true) + " !important; ";
    }

    // If the edit CSS text color preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.text"))
    {
        textBoxStyle += "color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.text", true) + " !important; ";
    }

    // If the edit CSS font preference is set
    if(webdeveloper_isPreferenceSet("webdeveloper.edit.font.size"))
    {
        textBoxStyle += "font-size: " + webdeveloper_getIntegerPreference("webdeveloper.edit.font.size", true) + "px !important; ";
    }

    textBoxStyle = textBoxStyle.trim();

    // Loop through the style sheets
    for(var i = 0; i < styleSheetLength; i++)
    {
        styleSheet = styleSheetList[i];

        // If this is a valid style sheet, is for the screen, is not an alternate style sheet, is not disabled and is not an inline style sheet
        if(webdeveloper_isValidStyleSheet(styleSheet) && webdeveloper_isMediaStyleSheet(styleSheet, "screen") && !webdeveloper_isAlternateStyleSheet(styleSheet) && !styleSheet.disabled && styleSheet.href != documentURL)
        {
            results = webdeveloper_retrieveStyleSheetDetails(styleSheet, textBoxStyle, results);
        }
    }

    styleSheetList   = contentDocument.getElementsByTagName("style");
    styleSheetLength = styleSheetList.length;

    // Loop through the inline style sheets
    for(i = 0; i < styleSheetLength; i++)
    {
        styleElement = styleSheetList[i];
        styleSheet   = styleElement.sheet;

        // If this is a valid style sheet, is for the screen and is not disabled
        if(webdeveloper_isValidStyleSheet(styleSheet) && webdeveloper_isMediaStyleSheet(styleSheet, "screen") && !styleSheet.disabled)
        {
            inlineStylesText += styleElement.innerHTML.trim() + "\n\n";

            styleSheet.disabled = true;
        }
    }

    // If there are inline styles
    if(inlineStylesText != "")
    {
        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        tab.setAttribute("label", stringBundle.getString("webdeveloper_embeddedStyles"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("value", inlineStylesText);
        textBox.setAttribute("webdeveloper-base", url.directory);

        // If the edit CSS wrap preference is not set to true
        if(!webdeveloper_getBooleanPreference("webdeveloper.edit.wrap", true))
        {
            textBox.setAttribute("wrap", "off");
        }

        tabPanel.appendChild(textBox);

        results.push(new Array(tab, tabPanel));
    }

    resultsLength = results.length;

    // Loop through the results
    for(i = 0; i < resultsLength; i++)
    {
        result = results[i];

        tabPanels.appendChild(result[1]);
        tabs.appendChild(result[0]);
    }

    // If there are no tabs
    if(tabs.childNodes.length == 0)
    {
        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        tab.setAttribute("label", stringBundle.getString("webdeveloper_editCSS"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("webdeveloper-base", url.directory);

        // If the edit CSS wrap preference is not set to true
        if(!webdeveloper_getBooleanPreference("webdeveloper.edit.wrap", true))
        {
            textBox.setAttribute("wrap", "off");
        }

        tabPanel.appendChild(textBox);
        tabPanels.appendChild(tabPanel);
        tabs.appendChild(tab);
    }

    tabs.selectedIndex = 0;

    webdeveloper_applyCSS();
}

// Retrieves the style sheet details
function webdeveloper_retrieveStyleSheetDetails(styleSheet, textBoxStyle, results)
{
    var styleSheetHref = styleSheet.href;
    var position       = styleSheetHref.lastIndexOf("/");
    var stylesText     = webdeveloper_retrieveSource(styleSheetHref);
    var tab            = document.createElement("tab");
    var tabPanel       = document.createElement("tabpanel");
    var textBox        = document.createElement("textbox");
    var url            = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);

    url.spec = styleSheetHref;

    tab.setAttribute("label", url.fileName);
    textBox.setAttribute("flex", "1");
    textBox.setAttribute("multiline", "true");
    textBox.setAttribute("style", textBoxStyle);
    textBox.setAttribute("value", stylesText);
    textBox.setAttribute("webdeveloper-base", url.directory);

    // If the edit CSS wrap preference is not set to true
    if(!webdeveloper_getBooleanPreference("webdeveloper.edit.wrap", true))
    {
        textBox.setAttribute("wrap", "off");
    }

    tabPanel.appendChild(textBox);

    results.push(new Array(tab, tabPanel));

    styleSheet.disabled = true;

    return results;
}

// Saves the CSS
function webdeveloper_saveCSS()
{
    var filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var result       = null;
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var styleText    = webdeveloper_getSelectedPanel().firstChild.value;

    filePicker.defaultExtension = "css";
    filePicker.defaultString    = webdeveloper_getSelectedTab().getAttribute("label");

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_saveStyleSheet"), filePicker.modeSave);

    result = filePicker.show();

    // If the user selected a style sheet
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        var file         = filePicker.file;
        var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

        // If the file does not exist
        if(!file.exists())
        {
            file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 00644);
        }

        outputStream.init(file, 0x04 | 0x08 | 0x20, 00644, null);

        outputStream.write(styleText, styleText.length);
        outputStream.close();
    }
}

// Toggles sticking the CSS
function webdeveloper_toggleStickCSS()
{
    webdeveloper_setBooleanPreference("webdeveloper.edit.stick", !webdeveloper_getBooleanPreference("webdeveloper.edit.stick", true));

    webdeveloper_updateStickCSS();
}

// Unloads edit CSS
function webdeveloper_unloadEditCSS()
{
    webdeveloper_resetDocument(webdeveloper_getContentDocument());
    window.clearInterval(webdeveloper_editCSSIntervalId);

    // Try to remove the event listener
    try
    {
        window.top.getBrowser().mTabBox.removeEventListener("select", webdeveloper_editCSSMainTabSelect, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    // Try to remove the event listener
    try
    {
        window.top.removeEventListener("load", webdeveloper_editCSSContentPageLoad, true);
    }
    catch(exception)
    {
        // Do nothing
    }
}

// Updates the stick CSS button
function webdeveloper_updateStickCSS()
{
    var element      = document.getElementById("webdeveloper-stick-sidebar");
    var label        = null;
    var stick        = webdeveloper_getBooleanPreference("webdeveloper.edit.stick", true);
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the element exists
    if(element)
    {
        // If sticking the CSS
        if(stick)
        {
            label = stringBundle.getString("webdeveloper_unstick");

            element.setAttribute("class", "unstick webdeveloper-sidebar-button");
            element.setAttribute("tooltiptext", label);
        }
        else
        {
            label = stringBundle.getString("webdeveloper_stick");

            element.setAttribute("class", "webdeveloper-sidebar-button");
            element.setAttribute("tooltiptext", label);
        }
    }
}