// Clears the cache
function webdeveloper_clearCache()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearCacheConfirmation")))
    {
        var cacheInterface = Components.interfaces.nsICache;
        var cacheService   = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService);

        try
        {
            cacheService.evictEntries(cacheInterface.STORE_ON_DISK);
            cacheService.evictEntries(cacheInterface.STORE_IN_MEMORY);

            // If the hide informational dialogs preference is not set
            if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
            {
                webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearCache"), stringBundle.getString("webdeveloper_clearCacheResult"));
            }
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Clears the history
function webdeveloper_clearHistory()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearHistoryConfirmation")))
    {
        webdeveloper_removeAllFromHistory();

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearHistory"), stringBundle.getString("webdeveloper_clearHistoryResult"));
        }
    }
}

// Clears the HTTP authentication
function webdeveloper_clearHTTPAuthentication()
{
    var authenticationManager = Components.classes["@mozilla.org/network/http-auth-manager;1"].getService(Components.interfaces.nsIHttpAuthManager);

    authenticationManager.clearAll();

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearHTTPAuthentication"), stringBundle.getString("webdeveloper_clearHTTPAuthenticationResult"));
    }
}

// Allows the user to edit the HTML of the current page
function webdeveloper_editHTML()
{
    toggleSidebar("webdeveloper-edit-html-sidebar", true);
}

// Linearizes all elements
function webdeveloper_linearizePage(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/linearize_page.css", "webdeveloper-linearize-page", applyStyle);
}

// Makes all the frames resizable
function webdeveloper_makeFramesResizable()
{
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var frame           = null;
    var framesList      = null;
    var framesLength    = null;
    var pageDocument    = null;
    var resizableFrames = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        framesList   = pageDocument.getElementsByTagName("frame");
        framesLength = framesList.length;

        // Loop through all the frames
        for(var j = 0; j < framesLength; j++)
        {
            frame = framesList[j];

            // If the frame has a no resize attribute
            if(frame.hasAttribute("noresize"))
            {
                frame.removeAttribute("noresize");
                resizableFrames++;
            }
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_makeFramesResizable");

        // If one frame was made resizable
        if(resizableFrames == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_makeFramesResizableSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_makeFramesResizableMultipleResult", [resizableFrames]));
        }
    }
}

// Shows all hidden elements
function webdeveloper_showHiddenElements()
{
    var computedStyle   = null;
    var display         = null;
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var element         = null;
    var hiddenElements  = new Array("area", "base", "basefont", "head", "meta", "param", "script", "style", "title");
    var pageDocument    = null;
    var tagName         = null;
    var treeWalker      = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument.body, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((element = treeWalker.nextNode()) != null)
        {
            computedStyle = element.ownerDocument.defaultView.getComputedStyle(element, null);

            // If the computed style is set
            if(computedStyle)
            {
                display = computedStyle.getPropertyCSSValue("display");
                tagName = element.tagName;

                // If this element has a display and tag name, the display is set to none and the tag name is not script
                if(display && tagName && display.cssText == "none" && !webdeveloper_contains(hiddenElements, tagName.toLowerCase()))
                {
                    element.style.display = "";
                }
            }
        }
    }
}

// Shows the window chrome
function webdeveloper_showWindowChrome()
{
    var browserWindow     = null;
    var windowEnumeration = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

    // Loop through the open windows
    while(windowEnumeration.hasMoreElements())
    {
        browserWindow = windowEnumeration.getNext();

        browserWindow.locationbar.visible = true;
        browserWindow.menubar.visible     = true;
        browserWindow.personalbar.visible = true;
        browserWindow.statusbar.visible   = true;
        browserWindow.toolbar.visible     = true;
    }
}

// Renders the page for a small screen
function webdeveloper_smallScreenRendering(element, applyStyle)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var styleSheetList = new Array();

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        styleSheetList = styleSheetList.concat(webdeveloper_getStyleSheetsForDocument(documentList[i], false, false));
    }

    // If there is a handheld style sheet
    if(webdeveloper_hasStyleSheetForMedia(styleSheetList, "handheld"))
    {
        webdeveloper_displayCSSMediaType("handheld", !element.getAttribute("checked"));
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-small-screen-rendering", applyStyle);
    }
    else
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/small_screen_rendering.css", "webdeveloper-small-screen-rendering", applyStyle);
    }
}

// Toggles all links on the page between visited and unvisited
function webdeveloper_toggleVisitedLinks(visited)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var href           = null;
    var link           = null;
    var linkLength     = null;
    var linkList       = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        linkList     = pageDocument.getElementsByTagName("a");
        linkLength   = linkList.length;

        // Loop through all the links
        for(var j = 0; j < linkLength; j++)
        {
            link = linkList[j];
            href = link.href;

            // If this link has an href
            if(href)
            {
                // If marking links as visited
                if(visited)
                {
                    webdeveloper_addToHistory(href);
                }
                else
                {
                    webdeveloper_removeFromHistory(href);
                }

                // Force the browser to recheck the history by changing the href
                link.href = "";
                link.href = href;
            }
        }
    }
}
// Updates the clear private data menu
function webdeveloper_updateClearPrivateDataMenu(suffix)
{
    webdeveloper_configureElement(document.getElementById("webdeveloper-clear-all-private-data-" + suffix), "disabled", !document.getElementById("sanitizeItem"));
}

// Updates the miscellaneous menu
function webdeveloper_updateMiscellaneousMenu(suffix)
{
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-line-guides-" + suffix), "checked", "webdeveloper-display-line-guides");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-ruler-" + suffix), "checked", "webdeveloper-display-ruler");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-linearize-page-" + suffix), "checked", "webdeveloper-linearize-page");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-show-comments-" + suffix), "checked", "webdeveloper-show-comments");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-small-screen-rendering-" + suffix), "checked", "webdeveloper-small-screen-rendering");
}

// View the response headers
function webdeveloper_viewResponseHeaders()
{
    var headerElement     = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var preElement        = null;
    var request           = new XMLHttpRequest();
    var responseHeaders   = null;
    var title             = document.getElementById("webdeveloper-string-bundle").getFormattedString("webdeveloper_viewResponseHeadersTitle", [oldURL]);

    // This must be done to make generated content render
    request.open("get", oldURL, false);
    request.send("");
    responseHeaders = request.getAllResponseHeaders();

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement = generatedDocument.createElement("h1");
    headerElement.appendChild(generatedDocument.createTextNode(title));
    generatedDocument.body.appendChild(headerElement);

    preElement = generatedDocument.createElement("pre");
    preElement.appendChild(generatedDocument.createTextNode(responseHeaders + "\n" + request.status + " " + request.statusText));
    generatedDocument.body.appendChild(preElement);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
