// $Workfile: S508LDR.H $  $Date: 2/25/98 7:58a $ - Copyright (C) 1996,1997 by jbm Electronics, Inc.

/*------------------------------------ REVISION HISTORY ----------------------------------------------------------------

  02/15/97 - (dl ) File created.

------------------------------------------------------------------------------------------------------------------------*/



#ifndef  __S508LDR_H
 #define  __S508LDR_H

 #pragma pack(1)  // Ensure compiler uses byte alignment for all structures, enums and unions!

 #include "gtypes.h"     // Defines UBYTE, etc.  Requires the symbol 'OS2' defined via compile options!

#ifdef OS2
 #include "gioctls.hpp"  // Generic OS/2 IOCtl symbolic definitions.
#endif

 #define SDLA_CATEGORY     0xFF    // Type of OS/2 IOCtls to issue on behalf of the SDLA.

 #define MAX_DATA_LGTH     1024    // Maximum data length for data associated with the various commands.

 #define WINDOW_SIZE       0x2000  // Size of the adapter memory window

 #define ADAPTER_SEG_SIZE  0x2000

 #define SET               0x01

 #define RESET             0x00

 #define ZERO              0x00

 #define ADAPTER_SIGNATURE 0x11

 // Common Memory & I/O offset values for s508

 #define WRITE_CCTL                    0x00     // Main card control register

 #define WRITE_WCTL                    0x01     // HOST mem window

 #define WRITE_VCTL                    0x02     // Vector into card memory

 #define READ_RLIPC                    0x00     // Host < Local CPU comm register

 #define READ_ID                       0x02     // Main card ID register

 #define ADAPTER_BASE_MEMORY           0x0000   // Start of adapter memory

 #define CODE_BASE_ADDR                0x0100   // Starting address for the adapter code

 #define PHYSADDR_CTL_BLOCK_OFF        0xE000

 #define WIN_CONTROL_BLOCK_OFF         0x0000


 // card window settings (8K window to PC)
 // bits 0-2 of configuration byte written to WCTL register (port base address + 1)
 #define PC_OFF_00_1F              0x00
 #define PC_OFF_20_3F              0x01
 #define PC_OFF_40_5F              0x02
 #define PC_OFF_60_7F              0x03
 #define PC_OFF_80_9F              0x04
 #define PC_OFF_A0_BF              0x05
 #define PC_OFF_C0_DF              0x06
 #define PC_OFF_E0_FF              0x07


 // card 64K segment address settings
 // bits 3-4 of configuration byte written to port (base address + 1)
 #define SEG_A                     0x00
 #define SEG_D                     0x08
 #define SEG_C                     0x10
 #define SEG_E                     0x18


 // Return codes from frame relay interface commands

 // Specific return codes from commands

 //     Constant Expression         Code     Issuing Command

 #define COMMAND_SUCCESSFUL         0x00   // Non-specific

 // My return codes

 //     Constant Expression         Code     Issuing Command

 #define INVALID_IOPORT             0x10
 #define INVALID_MEMORY_SEG         0x20
 #define NO_DRIVER_LOADED           0x30

 #pragma pack() // Let compiler revert to its default structure alignment.

#endif  // __S508LDR_H
