/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "mainWindow.h"

@implementation MainWindow 

- (void) layoutWindow
{
	NSScrollView* downloadView;
	NSScrollView* uploadView;
	NSView* upView;
	NSTableColumn* FileNameColumn;
	NSTableColumn* FileSizeColumn;
	NSTableColumn* FileStatusColumn;
	NSTableColumn* FileNameColumnUp;
	NSTableColumn* FileSizeColumnUp;
	NSTableColumn* FileStatusColumnUp;
	NSSplitView* splitView;

	NSTabView* filelistView;
	NSTabViewItem* tabDownload;
	NSTabViewItem* tabUpload;

	Connect = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (5, 525, 70, 70)]);
	Bookmarks = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (80, 525, 70, 70)]);
	Get = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (155, 525, 70, 70)]);
	Put = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (230, 525, 70, 70)]);

	splitView = [[NSSplitView alloc] initWithFrame: NSMakeRect (0,0,640,525)];

	upView = [[NSView alloc] initWithFrame: NSMakeRect (5,5,590,400)];

	localView = AUTORELEASE([[NSBrowser alloc] initWithFrame: NSMakeRect (5,0,250,395)]); 
	remoteView = AUTORELEASE([[NSBrowser alloc] initWithFrame: NSMakeRect (345,0,240,395)]);

	lmkdir = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (260, 360, 80, 20)]);
	rmkdir = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (260, 335, 80, 20)]);
	ldelete = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (260, 310, 80, 20)]);
	rdelete   = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect (260, 285, 80, 20)]);

	//filelistView = ([[NSTabView alloc] initWithFrame: NSMakeRect (0,0,0,120)]);
	filelistView = ([[NSTabView alloc] initWithFrame: NSMakeRect (0,0,0,120)]);
	tabDownload = [[NSTabViewItem alloc] initWithIdentifier: nil];
	tabUpload = [[NSTabViewItem alloc] initWithIdentifier: nil];
	Downloads = AUTORELEASE ([[NSTableView alloc] initWithFrame: NSMakeRect (0,0, 640, 100)]);
  	downloadView = AUTORELEASE([[NSScrollView alloc] initWithFrame: NSMakeRect (0,0, 640, 100)]);
	Uploads = AUTORELEASE ([[NSTableView alloc] initWithFrame: NSMakeRect (0,0, 640, 100)]);
  	uploadView = AUTORELEASE([[NSScrollView alloc] initWithFrame: NSMakeRect (0,0, 640, 100)]);


	[localView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable | NSViewMaxXMargin ];
	[remoteView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable | NSViewMinXMargin ];


	FileNameColumn = [[NSTableColumn alloc] initWithIdentifier: @"Name"];
	AUTORELEASE (FileNameColumn);
	[FileNameColumn setEditable: NO];
	[[FileNameColumn headerCell] setStringValue: @"Name"];
	[[FileNameColumn headerCell] setAlignment: NSCenterTextAlignment];
	[FileNameColumn setMinWidth: 170];

	FileSizeColumn = [[NSTableColumn alloc] initWithIdentifier: @"Size"];
	AUTORELEASE (FileSizeColumn);
	[FileSizeColumn setEditable: NO];
	[[FileSizeColumn headerCell] setStringValue: @"Size"];
	[[FileSizeColumn headerCell] setAlignment: NSCenterTextAlignment];
	[FileSizeColumn setMinWidth: 60];

	FileStatusColumn = [[NSTableColumn alloc] initWithIdentifier: @"Status"];
	AUTORELEASE (FileStatusColumn);
	[FileStatusColumn setEditable: NO];
	[[FileStatusColumn headerCell] setStringValue: @"Status"];
	[[FileStatusColumn headerCell] setAlignment: NSCenterTextAlignment];
	[FileStatusColumn setMinWidth: 60];

	FileNameColumnUp = [[NSTableColumn alloc] initWithIdentifier: @"Name"];
	AUTORELEASE (FileNameColumnUp);
	[FileNameColumnUp setEditable: NO];
	[[FileNameColumnUp headerCell] setStringValue: @"Name"];
	[[FileNameColumnUp headerCell] setAlignment: NSCenterTextAlignment];
	[FileNameColumnUp setMinWidth: 170];

	FileSizeColumnUp = [[NSTableColumn alloc] initWithIdentifier: @"Size"];
	AUTORELEASE (FileSizeColumnUp);
	[FileSizeColumnUp setEditable: NO];
	[[FileSizeColumnUp headerCell] setStringValue: @"Size"];
	[[FileSizeColumnUp headerCell] setAlignment: NSCenterTextAlignment];
	[FileSizeColumnUp setMinWidth: 60];

	FileStatusColumnUp = [[NSTableColumn alloc] initWithIdentifier: @"Status"];
	AUTORELEASE (FileStatusColumnUp);
	[FileStatusColumnUp setEditable: NO];
	[[FileStatusColumnUp headerCell] setStringValue: @"Status"];
	[[FileStatusColumnUp headerCell] setAlignment: NSCenterTextAlignment];
	[FileStatusColumnUp setMinWidth: 60];

	[Downloads addTableColumn: FileNameColumn];
	[Downloads addTableColumn: FileSizeColumn];
	[Downloads addTableColumn: FileStatusColumn];
	[Downloads setAutoresizesAllColumnsToFit: YES];
	
	//[downloadView setRulersVisible: YES];
      	//[downloadView setHasHorizontalScroller:NO];
      	[downloadView setHasVerticalScroller:YES];
        [downloadView setDocumentView: Downloads];
	[downloadView setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable ];
	[Downloads sizeToFit];

	[Uploads addTableColumn: FileNameColumnUp];
	[Uploads addTableColumn: FileSizeColumnUp];
	[Uploads addTableColumn: FileStatusColumnUp];
	[Uploads setAutoresizesAllColumnsToFit: YES];
	
	//[uploadView setRulersVisible: YES];
      	//[uploadView setHasHorizontalScroller:NO];
      	[uploadView setHasVerticalScroller:YES];
        [uploadView setDocumentView: Uploads];
	[uploadView setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable ];
	[Uploads sizeToFit];

	[tabDownload setLabel: @"Download"];
	[tabDownload setView: downloadView];
	[tabUpload setLabel: @"Upload"];
	[tabUpload setView: uploadView];
	[filelistView addTabViewItem: tabDownload];
	[filelistView addTabViewItem: tabUpload];
	[filelistView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable | NSViewMaxXMargin ];

	[Connect setTitle: _(@"Disconnected")];
	[Connect setFont:[NSFont systemFontOfSize: 8]];
	[Connect setImagePosition: NSImageAbove];
	[Connect setImage: [NSImage imageNamed: @"Disconnect.tiff"]];
	[Connect setAutoresizingMask: NSViewMinYMargin];

	[Bookmarks setTitle: _(@"Bookmarks")];
	[Bookmarks setFont:[NSFont systemFontOfSize: 8]];
	[Bookmarks setImagePosition: NSImageAbove];
	[Bookmarks setImage: [NSImage imageNamed: @"Bookmarks.tiff"]];
	[Bookmarks setAutoresizingMask: NSViewMinYMargin];

	[Get setTitle: _(@"Get files")];
	[Get setFont:[NSFont systemFontOfSize: 8]];
	[Get setImagePosition: NSImageAbove];
	[Get setImage: [NSImage imageNamed: @"Get.tiff"]];
	[Get setAutoresizingMask: NSViewMinYMargin];

	[Put setTitle: _(@"Put files")];
	[Put setFont:[NSFont systemFontOfSize: 8]];
	[Put setImagePosition: NSImageAbove];
	[Put setImage: [NSImage imageNamed: @"Put.tiff"]];
	[Put setAutoresizingMask: NSViewMinYMargin];

	[lmkdir setTitle: @"<- Make Dir"];
	[lmkdir setAutoresizingMask: NSViewMinYMargin | NSViewMinXMargin | NSViewMaxXMargin ];
	[rmkdir setTitle: @"Make Dir ->"];
	[rmkdir setAutoresizingMask: NSViewMinYMargin | NSViewMinXMargin | NSViewMaxXMargin ];
	[ldelete setTitle: @"<- Delete"];
	[ldelete setAutoresizingMask: NSViewMinYMargin | NSViewMinXMargin | NSViewMaxXMargin ];
	[rdelete setTitle: @"Delete ->"];
	[rdelete setAutoresizingMask: NSViewMinYMargin | NSViewMinXMargin | NSViewMaxXMargin ];

	[upView addSubview: localView];
	[upView addSubview: remoteView];
	[upView addSubview: lmkdir];
	[upView addSubview: rmkdir];
	[upView addSubview: ldelete];
	[upView addSubview: rdelete];
	[splitView addSubview: upView];
	[splitView addSubview: filelistView];
	[splitView adjustSubviews];
	[splitView setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];

	
	[[self contentView] addSubview:Connect];
	[[self contentView] addSubview:Bookmarks];
	[[self contentView] addSubview:Get];
	[[self contentView] addSubview:Put];
	[[self contentView] addSubview:splitView];
	
	//[[self contentView] addSubview: upView];
	//[[self contentView] addSubview: localView];
	//[[self contentView] addSubview: filelistView];
	        
}

- (NSBrowser*) localView
{ 
	return localView;
}

- (NSBrowser*) remoteView
{
	return remoteView;
}

- (NSButton*) lmkdir
{
	return lmkdir;
}

- (NSButton*) rmkdir
{
	return rmkdir;
}

- (NSButton*) ldelete
{
	return ldelete;
}

- (NSButton*) rdelete
{
	return rdelete;
}

- (NSButton*) edit
{
	return edit;
}

- (NSButton*) Connect
{
	return Connect;
}

- (NSButton*) Bookmarks
{
	return Bookmarks;
}

- (NSButton*) Get
{
	return Get;
}

- (NSButton*) Put
{
	return Put;
}

- (NSTableView*) Downloads {
	return Downloads;
}
- (NSTableView*) Uploads {
	return Uploads;
}

@end

