#include "myctype.h"
#include "indep.h"
#include "Str.h"
#include "parsetag.h"

char *
tag_get_value(struct parsed_tagarg *t, char *arg)
{
    for (; t; t = t->next) {
	if (!strcasecmp(t->arg, arg))
	    return t->value;
    }
    return NULL;
}

int
tag_exists(struct parsed_tagarg *t, char *arg)
{
    for (; t; t = t->next) {
	if (!strcasecmp(t->arg, arg))
	    return 1;
    }
    return 0;
}

struct parsed_tagarg *
cgistr2tagarg(char *cgistr)
{
    int n;
    struct parsed_tagarg *t0, *t;
    Str tmp;

    t = t0 = NULL;
    do {
	t = New(struct parsed_tagarg);
	t->next = t0;
	t0 = t;
	n = strcspn(cgistr, "=&");
	t->arg = (tmp = form_unquote_charp_n(cgistr, n)) ? tmp->ptr : allocStr(cgistr, n);
	cgistr += n;
	t->value = NULL;
	if (*cgistr == '\0')
	    return t;
	else if (*cgistr == '=') {
	    cgistr++;
	    n = strcspn(cgistr, "&");
	    t->value = (tmp = form_unquote_charp_n(cgistr, n)) ? tmp->ptr : allocStr(cgistr, n);
	}
	else if (*cgistr == '&')
	    cgistr++;
    } while (*cgistr);
    return t;
}
