/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkX3DExporterFIWriter.h,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __vtkX3DExporterFIWriter_h
#define __vtkX3DExporterFIWriter_h

#include "vtkX3DExporterWriter.h"

class vtkX3DExporterFIByteWriter;
class vtkX3DExporterFINodeInfoStack;
class vtkZLibDataCompressor;

class VTK_HYBRID_EXPORT vtkX3DExporterFIWriter : public vtkX3DExporterWriter
{
public:
  static vtkX3DExporterFIWriter *New();
  vtkTypeRevisionMacro(vtkX3DExporterFIWriter, vtkX3DExporterWriter);
  void PrintSelf(ostream& os, vtkIndent indent);

  virtual void CloseFile();
  virtual int OpenFile(const char* file);


  //void Write(const char* str);

  virtual void Flush();

  void StartDocument();
  void EndDocument();

  // Elements
  void StartNode(int elementID);
  void EndNode();

  // Attributes
  // SFString / MFString
  //void SetField(int attributeID, const vtkstd::string &value);
  void SetField(int attributeID, const char*, bool mfstring = false);
  // SFInt32
  void SetField(int attributeID, int);
  // SFFloat
  void SetField(int attributeID, float);
  // SFDouble
  void SetField(int attributeID, double);
  // SFBool
  void SetField(int attributeID, bool);

  // For MFxxx attributes
  void SetField(int attributeID, int type, const double* a);
  void SetField(int attributeID, int type, vtkDataArray* a);
  void SetField(int attributeID, const double* values, size_t size);

  // MFInt32
  void SetField(int attributeID, int type, vtkCellArray* a);
  void SetField(int attributeID, const int* values, size_t size, bool image = false);

  int GetEncodingMethod();

  // Description:
  // Use fastest instead of best compression
  vtkSetClampMacro(Fastest, int, 0, 1);
  vtkBooleanMacro(Fastest, int);
  vtkGetMacro(Fastest, int);
protected:
  vtkX3DExporterFIWriter();
  ~vtkX3DExporterFIWriter();


private:
  void StartAttribute(int attributeID, bool literal, bool addToTable = false);
  void EndAttribute();

  void CheckNode(bool callerIsAttribute = true);
  bool IsLineFeedEncodingOn;

  //int Depth;
  vtkX3DExporterFIByteWriter* Writer;
  vtkX3DExporterFINodeInfoStack* InfoStack;
  vtkZLibDataCompressor* Compressor;

  int Fastest;

  vtkX3DExporterFIWriter(const vtkX3DExporterFIWriter&); // Not implemented.
  void operator=(const vtkX3DExporterFIWriter&); // Not implemented.

};

#endif

