// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// File:        field.h - interface to field editor under InterViews 3.1
//
// Created:     10 Mar 94   Michael Pichler
//
// Changed:     26 Jan 95   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_field31_h
#define harmony_widgets_field31_h

#include "libwidgets.h"

#include "fieldb.h"

class FieldEditorAction31;


//<class>
//
// Name: FieldEditor31
//
// Purpose: Glyph for editing a line of text
//          portation of IV's fieldeditor to InterViews 3.1
//
// Style name: FieldEditor (alias EditLabel)
//
// attributes:
//
// - font            label font
// - foreground      label foreground colour
// - flat            glyph background (inset frame)
// - cursorColor     cursor colour (default: foreground)
// - selectionColor  colour of selection bar (default: foreground)
// - inverseColor    colour of selected char's (default: background)
//
//</class>


class FieldEditor31: public FieldBrowser
{
  public:
    FieldEditor31(
      WidgetKit*, Style*,               // kit, style
      const char* sample = 0,           // initial string (can be changed with field)
      FieldEditorAction31* = nil,       // action (for accept, cancel, special)
      const char* special = 0,          // special chars
      const char* accept = "\r",        // acceptance chars
      const char* cancel = "\007\033",  // cancel chars
      int hide = 0,                     // flag for input hiding
      char hidechar = '\0'              // substitute hide char
    );
    virtual ~FieldEditor31();

    virtual void field(const char*);    // set text string, scroll to end

    const char* field() const           // get current string
    { return FieldBrowser::field (); }  // (otherwise hidden by field(..))
    // inherited from FieldBrowser:
    // const char* string() const;      // (for backward compatibility)

    void showModifications(int onoff);
    int modified() const;
    void clearModification();

    // InputHandler
    virtual void keystroke(const Event&);
    virtual InputHandler* focus_in();
    virtual void focus_out();

    // FieldBrowser
    virtual void pasteSelection(const Event&);

  private:
    void modifying ();

    FieldEditorAction31* action_;
    char* special_;
    char* accept_;
    char* cancel_;
    int delbackward_;

};  // FieldEditor31


// FieldEditorAction31

class FieldEditorAction31: public Resource
{
  protected:
    FieldEditorAction31();
    virtual ~FieldEditorAction31();

  public:
    virtual void accept(FieldEditor31*, char) = 0;
    virtual void cancel(FieldEditor31*, char) = 0;
    virtual void special(FieldEditor31*, char) = 0;
};


// FieldEditorCallback31

#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __FieldEditorCallback31(T) T##_FieldEditorCallback31
#define FieldEditorCallback31(T) __FieldEditorCallback31(T)
#define __FieldEditorMemberFunction31(T) T##_FieldEditorMemberFunction31
#define FieldEditorMemberFunction31(T) __FieldEditorMemberFunction31(T)
#else
#define __FieldEditorCallback31(T) T/**/_FieldEditorCallback31
#define FieldEditorCallback31(T) __FieldEditorCallback31(T)
#define __FieldEditorMemberFunction31(T) T/**/_FieldEditorMemberFunction31
#define FieldEditorMemberFunction31(T) __FieldEditorMemberFunction31(T)
#endif

/* note: order of arguments of FieldEditorCallback31: accept, cancel, special */

#define declareFieldEditorCallback31(T) \
typedef void (T::*FieldEditorMemberFunction31(T))(FieldEditor31*, char); \
class FieldEditorCallback31(T) : public FieldEditorAction31 { \
public: \
    FieldEditorCallback31(T)( \
	T*, FieldEditorMemberFunction31(T) accept, \
	FieldEditorMemberFunction31(T) cancel, \
	FieldEditorMemberFunction31(T) special  \
    ); \
    virtual ~FieldEditorCallback31(T)(); \
\
    virtual void accept(FieldEditor31*, char); \
    virtual void cancel(FieldEditor31*, char); \
    virtual void special(FieldEditor31*, char); \
private: \
    T* obj_; \
    FieldEditorMemberFunction31(T) accept_; \
    FieldEditorMemberFunction31(T) cancel_; \
    FieldEditorMemberFunction31(T) special_; \
};

#define implementFieldEditorCallback31(T) \
FieldEditorCallback31(T)::FieldEditorCallback31(T)( \
    T* obj, FieldEditorMemberFunction31(T) accept, \
    FieldEditorMemberFunction31(T) cancel, \
    FieldEditorMemberFunction31(T) special \
) { \
    obj_ = obj; \
    accept_ = accept; \
    cancel_ = cancel; \
    special_ = special; \
} \
\
FieldEditorCallback31(T)::~FieldEditorCallback31(T)() { } \
\
void FieldEditorCallback31(T)::accept(FieldEditor31* f, char c) \
{ if (accept_ != nil) (obj_->*accept_)(f, c); } \
void FieldEditorCallback31(T)::cancel(FieldEditor31* f, char c) \
{ if (cancel_ != nil) (obj_->*cancel_)(f, c); } \
void FieldEditorCallback31(T)::special(FieldEditor31* f, char c) \
{ if (special_ != nil) (obj_->*special_)(f, c); } 

// note: cxx needs explicit comparison with nil for member functions


#endif
