#ifndef VRENGD

#include <GL/gl.h>

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "parse.h"
#include "col.h"
#include "text.h"

#include "texfont.h"	/* TexFont */


const WClass Text::wclass(TEXT_TYPE, "Text", Text::creator);


/* create a text from a fileline */
void Text::creator(char *l)
{
  new Text(l);
}

Text::Text(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  if (*l == '"') {
    l++;
    strcpy(string, l);
    while ((l = strtok(NULL, SEP)) != NULL) {
      strcat(string, " ");
      strcat(string, l);
      if (string[strlen(string) - 1] == '"') {
        string[strlen(string) - 1] = '\0';
        break;
      }
    }
    if (string[strlen(string) - 1] == '"')
      string[strlen(string) - 1] = '\0';
    string[TEXT_MAXLEN - 1] = '\0';
  }

#if 0
  //l += strlen(string);
  l = strtok(NULL, SEP);
  if (l)
    soh = parseGeometry(l);
#endif

  nature.bbable = VR_NO_BB;
  nature.selectable = VR_NO_SELECTABLE;
  nature.renderable = VR_SPECIAL_RENDER;
  nature.collision = COL_NEVER;

  initializeObject(this, TEXT_TYPE, VR_STILL);

  if ((txf = getTexfontFromCache(name.url)) == NULL) {
    trace(DBG_FORCE, "Problem loading %s", name.url);
    return;
  }

  //DAX glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

#if !defined(WITH_TINYGL)	/* mipmaps missing */
  txfEstablishTexture(txf, 0, GL_TRUE);
#else
  txfEstablishTexture(txf, 0, GL_FALSE);
#endif
#ifdef DEBUG_TEXT
  int width, max_ascent, max_descent;
  txfGetStringMetrics(this->txf, this->string, strlen(this->string), &width, &max_ascent, &max_descent);
  trace(DBG_FORCE, "txfGetStringMetrics: string=%s width=%d ascent=%d descent=%d", this->string, width, max_ascent, max_descent);
#endif
} 

/* Begin piece of code: Copyright (c) Mark J. Kilgard, 1997. */
void Text::render()
{
  static float material_green[4] = {0, 1, 0, 1};

  glDisable(GL_LIGHTING);	/* No lighting on texts */
  glEnable(GL_TEXTURE_2D);
  txfBindFontTexture(txf);	/* Bellot the best! */
  glEnable(GL_ALPHA_TEST);
#if !defined(WITH_TINYGL)	/* glAlphaFunc missing */
  glAlphaFunc(GL_GEQUAL, 0.5);	/* elimine tout alpha > 0.5 */
#endif
  glDisable(GL_CULL_FACE);	/* to see both faces */
  glPushMatrix();
  glTranslatef(pos.x, pos.y, pos.z);
  glRotatef(RADIAN2DEGREE(pos.az), 0, 0, 1);
  glRotatef(RADIAN2DEGREE(pos.ax), 1, 0, 0);
  glScalef(1 / 60.0, 1 / 60.0, 1 / 60.0);

#if !defined(WITH_TINYGL)	/* glAlphaFunc missing */
  glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, material_green);
#endif
  glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, material_green);

  txfRenderString(txf, string, (int) strlen(string));
#if !defined(WITH_TINYGL)	/* glTexEnvf missing */
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
#else
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
#endif
  glPopMatrix();
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_ALPHA_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);	/* resore lighting */
}
/* End piece of code: Copyright (c) Mark J. Kilgard, 1997. */

void Text::quit()
{
#if 0 //TO SEE
  txfUnloadFont(txf);
#endif
}

void textInitFuncList(void) { }

#endif /* !VRENGD */
