#ifndef DART_H
#define DART_H

#define DART_TYPE	16
#define DART_NAME	"Dart"
#define	DART_INIT	dartInitFuncList
#define DART_LASTING	0.03	/* 30 ms */
#define DART_PROPS	5

#define DART_PROPHNAME	0
#define DART_PROPXY	1
#define DART_PROPZ	2
#define DART_PROPAZ	3
#define DART_PROPHIT	4

#define DART_SPEED	5.0	// 7 m/s
#define DART_TTL	3.0	// 3 sec
#define DART_DELTAZ	0.05	// 5 cm

/* dart geometry */
#define DART_GEOMETRY	"0.25,0.01,0.01"
#define DART_COLOR	"0,0,0"	// black

/* actions */
#define DART_CREAT	0


class Dart: public WObject {
public:
  float lspeed;		// linear speed
  char hit;		// hit: no=0, yes=1

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Dart(WObject *, void *, time_t, time_t);
  Dart(u_int8 type_id, struct _NetObjectId noid, struct _Payload *);

  static WObject * replicator(u_int8 type_id,
                              struct _NetObjectId noid, Payload *pp);
  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual boolean updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void whenWallIntersect(WObject *pold, V3 *norm);
};

void DART_INIT(void);

#endif /* DART_H */
