#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"
#include "parse.h"
#include "user.h"
#include "caul.h"
#include "zv.h"		/* parseGeometry */
#include "move.h"	/* GRAVITY */
#include "ball.h"

#include "gui.h"	/* selectedObjectDeletion */
#include "defaults.h"	/* DEF_BALL_GIF */
#include "payload.h"	/* Payload */


const WClass Ball::wclass(BALL_TYPE, "Ball", NULL, Ball::replicator);


/* update times arrays */
void Ball::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = (float) (sec - move.sec) + (float) (usec - move.usec) / 1e6;
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    move.ttl = 0;
    move.sec = move.usec = 0;
  }
}

/* systeme d'equations regissant les mouvements imposes */
void Ball::changePosition(float lasting)
{
  pos.x += lasting * move.lspeed.v[0];
  pos.y += lasting * move.lspeed.v[1];
  pos.z += lasting * move.lspeed.v[2];
  pos.az += lasting * move.aspeed.v[0];
  pos.ay += lasting * move.aspeed.v[1];
}

/* systeme d'equations regissant les mouvements permanents */
void Ball::changePermanent(float lasting)
{
  pos.z -= lasting * GRAVITY;
  pos.az += lasting * BALL_ASPEED;
  pos.ay += lasting * BALL_ASPEED;
}

/* condition to make position changes  */
boolean Ball::change()
{
  return (move.ttl > BALL_REMAINT) ? TRUE : FALSE;
}

/* push */
static
void ballPush(Ball *po, void *data, time_t sec, time_t usec)
{
  po->move.lspeed.v[0] = (double)(Cos((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[1] = (double)(Sin((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[2] = 0;
  po->move.aspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->move.sec = sec;
  po->move.usec = usec;
  po->move.ttl = po->ttl;
}

/* pull */
static
void ballPull(Ball *po, void *data, time_t sec, time_t usec)
{
  po->move.lspeed.v[0] = - (double)(Cos((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[1] = - (double)(Sin((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[2] = 0;
  po->move.aspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->move.sec = sec;
  po->move.usec = usec;
  po->move.ttl = po->ttl;
}

/* shoot */
static
void ballShoot(Ball *po, void *data, time_t sec, time_t usec)
{
  po->move.lspeed.v[0] = (double)(Cos((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[1] = (double)(Sin((float)worlds->plocaluser->pos.az))* po->lspeed;
  po->move.lspeed.v[2] = BALL_ZSPEED;
  po->move.aspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->move.aspeed.v[2] = 0;
  po->move.sec = sec;
  po->move.usec = usec;
  po->move.ttl = po->ttl;
}

/* destroy */
static
void ballDestroy(Ball *po, void *data, time_t sec, time_t usec)
{
  deleteObjectFromGrid(po);
  mobilelist = deleteObjectFromList(po, mobilelist);
  deleteSolidFromList(po->soh);
  declareObjDeletion((NetObject*) po);
  deleteNetObject((NetObject*) po);
  selectedObjectDeletion(po->soh);
  delete po;
}

/* creation: this method is invisible: called by the cauldron */
static
void ballCreate(Cauldron *pcauldron, void *data, time_t sec, time_t usec)
{
  new Ball(pcauldron, data, sec, usec);
}

Ball::Ball(WObject *pcauldron, void *data, time_t sec, time_t usec)
{
  char geom[BUFSIZ];

#if HAVE_DRAND48
  pos.x = pcauldron->pos.x + (float)drand48() * 2 -1;
  pos.y = pcauldron->pos.y + (float)drand48() * 2 -1;
#else
  pos.x = pcauldron->pos.x;
  pos.y = pcauldron->pos.y;
#endif
  pos.z = pcauldron->pos.z + BALL_ORIGZ;
  sprintf(geom, "sphere,radius=%f,diffuse=%s,texture=%s",
          BALL_RADIUS, BALL_COLOR, DEF_BALL_GIF);
  soh = parseGeometry(geom);

  initializeObject(this, BALL_TYPE, VR_MOBILE);
  maxlasting[BALL_TYPE] = BALL_LASTING;

  lspeed = BALL_LSPEED;
  ttl = BALL_FLYTTL;
  origz = pos.z;
  move.ttl = 0.0;
  move.perm_sec = sec;
  move.perm_usec = usec;
  nature.persistency = TRUE;

  noh.nbprop = BALL_PROPS;
  propertiesnumber[BALL_TYPE] = BALL_PROPS;
  createNetObject((NetObject*) this, VR_VOLATILE);
  //DAX declareObjCreation(&(worlds->plocaluser->noh));
  trace(DBG_WMGT, "ball-create: z=%.2f", pos.z);
}

/* ball creation from the network */
WObject *Ball::replicator(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  return new Ball(type_id, noid, pp);
}

Ball::Ball(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  noh.type = type_id;
  noh.noid = noid;

  char geom[BUFSIZ];
  sprintf(geom, "sphere,radius=%f,diffuse=%s,texture=%s",
          BALL_RADIUS, BALL_COLOR, DEF_BALL_GIF);
  soh = parseGeometry(geom);

  initializeObject(this, BALL_TYPE, VR_MOBILE);
  setAllProperties(&(this->noh), pp);
  initBB(this->pos);

  lspeed = BALL_LSPEED;
  ttl = BALL_FLYTTL;
  move.ttl = 0.0;
  move.perm_sec = -1;
} 

/* ball update to the network */
boolean Ball::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;
  
  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    declareObjDelta(&(noh), BALL_PROPXY);
    change = TRUE;
  }
  if (ABSF(pos.z - oldpos.z) > BALL_DELTAZ) {
    declareObjDelta(&(noh), BALL_PROPZ);
    change = TRUE;
  }
  if (pos.az != oldpos.az)
    change = TRUE;
  if (pos.ay != oldpos.ay)
    change = TRUE;
  return change;
}

/* object intersection: jump */
void Ball::whenIntersect(WObject *pcur, WObject *pold)
{
  pcur->pos.z += BALL_RADIUS;
  updateObjectIn3D(pcur);
  updateBB(pcur);
}

void ballInitFuncList(void)
{
  setFuncList[BALL_PROPXY][BALL_TYPE].pf = WO_PAYLOAD set_xy;
  setFuncList[BALL_PROPZ][BALL_TYPE].pf = WO_PAYLOAD set_z;
  setFuncList[BALL_PROPAZ][BALL_TYPE].pf = WO_PAYLOAD set_az;
  setFuncList[BALL_PROPHNAME][BALL_TYPE].pf = WO_PAYLOAD set_hname;
  setFuncList[BALL_PROPAY][BALL_TYPE].pf = WO_PAYLOAD set_ay;
  getFuncList[BALL_PROPXY][BALL_TYPE].pf = WO_PAYLOAD get_xy;
  getFuncList[BALL_PROPZ][BALL_TYPE].pf = WO_PAYLOAD get_z;
  getFuncList[BALL_PROPAZ][BALL_TYPE].pf = WO_PAYLOAD get_az;
  getFuncList[BALL_PROPHNAME][BALL_TYPE].pf = WO_PAYLOAD get_hname;
  getFuncList[BALL_PROPAY][BALL_TYPE].pf = WO_PAYLOAD get_ay;

  setMethodFunc(BALL_TYPE, BALL_PUSH, WO_ACTION ballPush, "Push");
  setMethodFunc(BALL_TYPE, BALL_PULL, WO_ACTION ballPull, "Pull");
  setMethodFunc(BALL_TYPE, BALL_SHOOT, WO_ACTION ballShoot, "Shoot");
  setMethodFunc(BALL_TYPE, BALL_KILL, WO_ACTION ballDestroy, "Destroy");
  setMethodFunc(BALL_TYPE, BALL_CREAT, WO_ACTION ballCreate, "");
}

#endif /* !VRENGD */
