/*---------------------------------------------------------------------------*\

    FILE....: MESSAGES.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/11/97

    Constants that define the message types and lengths.  Messages are used
    to communicate between the DSP and the PC.

    Note: Exact same version of this file must be used by both firmware
    and driver to ensure DSP and PC are speaking the same language!

\*---------------------------------------------------------------------------*/

#ifndef __MESSAGES__
#define __MESSAGES__

/*-------------------------------------------------------------------------*\

			       DEFINES

\*-------------------------------------------------------------------------*/

/*
   CONVENTIONS:
   ------------

   1. Mesage originating at PC have a prefix PC_, messages from DSP have the
      prefix DSP_.
   2. The next word in the message usually describes the DSP module the
      message in coming from/going to.
*/

/* PC -> DSP messages -----------------------------------------------------*/

#include "messages_pc_dsp.h"

/* DSP -> PC messages -----------------------------------------------------*/

#include "messages_dsp_pc.h"

/* error message defines */
//XXX Long obsolete, last understood (but not used) by V4PCI.
#if 0
#define	TONED_TABLE	0	/* error downloading TONED state table	  */
#define	TONEG_BUSY	1	/* tone generator busy			  */
#define	CONFIG_SZIDENT	2	/* object identifer too big		  */
#define	CONFIG_SZCH	3	/* channel number too big		  */
#define	CONFIG_CLASS	4	/* bad class				  */
#define	CONFIG_MEM	5	/* out of memory 			  */
#define	CONFIG_WIRE	6	/* invalid wire 			  */
#define	CONFIG_INPS	7	/* two many inputs to object		  */
#define	CONFIG_IT	8	/* Error during config_iterate		  */
#define	CONFIG_MESS	9	/* error passing message to object	  */
#define	VPBMAIN_MESSAGE	10	/* unknown message type	in dispatcher	  */
#define	CONFIG_NWIRE	11	/* invalid wire while disconnecting	  */
#endif

/* configuration object types, used to define signal processing objects */

#define CODEC_AD	0	/* codec A/D (signal into VPB)		  */
#define CODEC_DA	1	/* codec D/A (signal out of VPB)	  */
#define	FIFO_UP		2	/* transfers signal from VPB to PC	  */
#define	FIFO_DOWN	3	/* transfers signal form PC to VPB	  */
#define	TONEG		4	/* tone generator			  */
#define	DTMF		5	/* dtmf decoder				  */
#define	CPFILTER	6	/* call progress filter			  */
#define LIN2ALAW	7	/* linear to alaw	 		  */
#define ALAW2LIN	8	/* alaw to linear			  */
#define LIN2MULAW	9	/* linear to mu-law	 		  */
#define MULAW2LIN	10	/* mu-law to linear			  */
#define LIN2ADPCM	11	/* linear to Oki ADPCM	 		  */
#define ADPCM2LIN	12	/* Oki ADPCM to linear			  */
#define	TONED		13	/* tone detector			  */
#define	ECHO		14	/* echo canceller			  */
#define	DELAY		15	/* one frame delay			  */
#define	ADC_8K		16	/* VLC A-to-D decimated to 8kSps	  */
#define	VOX		17	/* Voice-operated switch (crude grunt det */
#define	AGC		18	/* Automatic gain control		  */
#define PACK		19	/* Packs 4 adpcm codes into 16bits	  */
#define UNPACK		20	/* Unpacks 16bits into 4 adpcm codes   	  */
#define PACKED_FIFO_UP	21	/* Transfers packed ADPCM to PC	  	  */
#define PACKED_TEST_SOURCE  22  /* Known source for testing pack\unpack	  */
#define ADC_24K		23	/* VLC ADC at 24kSps			  */
#define FIFO_UP_24K	24	/* Transfers 24kHz signals to PC	  */
#define FIRD		25	/* Low pass decimating FIR Filter  	  */
#define DEC24K_TO_8K	26	/* Simple decimation by 3		  */
#define FIFO_DOWN_24K	27	/* Transfers 24kHz signals to VLC	  */
#define PACKED_FIFO_DOWN    28	/* Transfers packed samples from PC to DSP*/
#define FIXGAIN		29	/* fixed gain block			  */
#define SCP_ENC		30	/* Speech codec processer encoder         */
#define SCP_DEC		31	/* Speech codec processer decoder         */
#define ADDER		32	/* two-input adder                        */

/* parameters for programming Call progress detectors, see CALLPROG.H */
//XXX These are now VPB_* enums in vpbapi.h
//#define	TIMER 	0
//#define	RISING	1
//#define	FALLING	2

#endif	/* #ifndef __MESSAGES__	*/
