
// vbthresh.h
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Kosh Banerjee

/*********************************************************************
* vbthresh.h                                                         *
* Include file for vbthresh.cpp.                                     *
* K. Banerjee  02/05/2001                                            *
*                                                                    *
* This is the header file for the vbthresh utility. The vbthresh     *
* utility is used to threshold the initial 4D data file.             *
*********************************************************************/

#ifndef VBTHRESH_H
#define VBTHRESH_H

/*********************************************************************
* Required system include files:                                     *
*********************************************************************/
#include <iostream>
#include <fstream>
#include <unistd.h>
#include <cstring>
#include <cstdlib>
#include <limits>
#include <climits>
#include <ctime>
#include "utils.h"

/*********************************************************************
* Remaining needed include files:                                    *
*********************************************************************/
#include "vb_common_incs.h"
#include "vbutil.h"

/* >>>>>>>>>>>>           FUNCTION PROTOTYPES          <<<<<<<<<<<< */

/*********************************************************************
* Function to process a time series.                                 *
*********************************************************************/
void processData(Tes& theTes, const int cutOff);

/*********************************************************************
* Function to print out usage information.                           *
*********************************************************************/
void usage(const unsigned short exitValue, char *progName);

/*********************************************************************
* Function to determine the thresh hold cut off value if the         *
* histogram method is being implemented.                             *
*********************************************************************/
unsigned int determineCutOff(const int binSize, Tes& theTes);

/* >>>>>>>>>>>>          END FUNCTION PROTOTYPES       <<<<<<<<<<<< */

/*********************************************************************
* Required constants:                                                *
*                                                                    *
* TES_FILE_NAME_LEN - specifies the allowed length of the 4D data    *
*                     file name.                                     *
*********************************************************************/
const int TES_FILE_NAME_LEN = 256;

#endif // VBTHRESH_H
