.\" Copyright (c) 1994-1999 Silicon Graphics, Inc. All Rights Reserved.
.\"
.\" The contents of this file are subject to the CID Font Code Public Licence
.\" Version 1.0 (the "License"). You may not use this file except in compliance
.\" with the Licence. You may obtain a copy of the License at Silicon Graphics,
.\" Inc., attn: Legal Services, 2011 N. Shoreline Blvd., Mountain View, CA
.\" 94043 or at http://www.sgi.com/software/opensource/cid/license.html.
.\"
.\" Software distributed under the License is distributed on an "AS IS" basis.
.\" ALL WARRANTIES ARE DISCLAIMED, INCLUDING, WITHOUT LIMITATION, ANY IMPLIED
.\" WARRANTIES OF MERCHANTABILITY, OF FITNESS FOR A PARTICULAR PURPOSE OR OF
.\" NON-INFRINGEMENT. See the License for the specific language governing
.\" rights and limitations under the License.
.\"
.\" The Original Software is CID font code that was developed by Silicon
.\" Graphics, Inc.
.\"
.\" $XFree86: xc/programs/mkcfm/mkcfm.man,v 1.2 1999/05/15 12:10:37 dawes Exp $
.TH MKCFM 1 "Release 1.0" "CID Fonts Version 1.0"
.SH NAME
mkcfm - create summaries of font metric files in CID font directories
.SH SYNOPSIS
.B "mkcfm"
[\fICID-font-directory-name\fP]
.SH DESCRIPTION
There is usually only one CID font directory on the X font path. It is
usually called \fI/usr/X11R6/lib/X11/fonts/CID\fP. If you do not specify
an argument, \fImkcfm\fP will try to go through the subdirectories of
that directory, and create one summary of font metric files for each
CIDFont (character descriptions) file and each CMap (Character Maps) file
it finds. The summaries of font metric files are put in the existing CFM
subdirectory. The CFM subdirectories are created when CID-keyed fonts
are installed.
.PP
If you specify a CID font directory as an argument, \fImkcfm\fP will try
to go through the subdirectories of that directory, and create one summary
of font metric files for each CIDFont file and each CMap file it finds.
.I mkcfm
will calculate the summaries of the font metric files stored in AFM 
subdirectories of the CID font directory.
.PP
Those summaries are needed by the rasterizer of CID-keyed fonts to
speed up the response to X font calls. If those files do not exist, CID
rasterizer will have to go through usually large font metric files, and
calculate the summaries itself each time the font is called. You will
notice a substantial wait on a call to a large CID-keyed font.
.SH FILES
.TP 15
.B .afm files
Each CID-keyed font file is supposed to have a font metric file
(.afm file). \fImkcfm\fP creates summary files (.cfm files) of those
font metric files. \fImkcfm\fP should be run whenever a change is
made to the files stored in the subdirectories of the CID font
directory. For example, it should be run when new CID fonts are installed.
.TP 15
.B .cfm files
Summaries of font metric (.afm) files created by \fImkcfm\fP.
.SH "SEE ALSO"
The rasterizer for CID-keyed fonts in the directory
\fIxc/lib/font/Type1\fP.
