<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:fn="fn"
                exclude-result-prefixes="xs fn">
    
    <xsl:output indent="yes" encoding="US-ASCII"/>
    
    <xsl:param name="csv"/>
    
    <xsl:function name="fn:getTokens" as="xs:string+">
        <xsl:param name="str" as="xs:string"/>
        <xsl:analyze-string select="concat($str, ',')" regex='(("[^"]*")+|[^,]*),'>
            <xsl:matching-substring>
                <xsl:sequence select='replace(regex-group(1), "^""|""$|("")""", "$1")'/>
            </xsl:matching-substring>
        </xsl:analyze-string>
    </xsl:function>
    
    <xsl:template match="/" name="main">

        <xsl:variable name="lines" select="tokenize($csv, '&#xa;|&#xd;')" as="xs:string+"/>
        <xsl:variable name="elemNames" select="fn:getTokens($lines[1])" as="xs:string+"/>

        <root>
            <xsl:for-each select="$lines[position() > 1]">
                <xsl:if test="string-length(.) > 0">
                    <row>
                        <xsl:variable name="lineItems" select="fn:getTokens(.)" as="xs:string+"/>
                        <xsl:for-each select="$elemNames">
                            <xsl:variable name="pos" select="position()"/>
                            <elem name="{.}">
                                <xsl:value-of select="$lineItems[$pos]"/>
                            </elem>
                        </xsl:for-each>
                    </row>
                </xsl:if>
            </xsl:for-each>
        </root>
    </xsl:template>
</xsl:stylesheet>
