/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SUBSTRATEDEFINITION_H
#define SUBSTRATEDEFINITION_H

#include <qstring.h>
#include <Types.h>

class QDomElement;
class QTextStream;

class SubstrateDefinition
{
public:
  SubstrateDefinition();
  ~SubstrateDefinition();

  enum SubstrateType { stripline,
		       microstrip };

  bool changed() const;
  void clearChanged();
  SubstrateType type() const;
  TReal er() const;
  TReal height() const;
  TReal thickness() const;
  TReal rho() const;

  void setType( SubstrateType );
  void setEr( TReal );
  void setHeight( TReal );
  void setThickness( TReal );
  void setRho( TReal );
  
  void writeToStream( const QString& name, QTextStream& stream );
  bool readFromDOM( QDomElement& element );

private:
  bool hasChanged_;
  SubstrateType type_;
  TReal er_;
  TReal h_;
  TReal t_;
  TReal rho_;
};

#endif
