/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef UTILS_H
#define UTILS_H

#include <Types.h>

//#include <DataPoint.h>

#include <qlist.h>
#include <qrect.h>
#include <qstring.h>

class QPoint;
class Matrix;
class DataPoint;
class QTextStream;

class Utils
{
 public:
  static bool testStream( QTextStream& stream, const QString& expected );
  static QString replaceWhiteSpace( const QString& str );
  static QString reinsertWhiteSpace( const QString& str );

  static void getFirstPart( QString& source, QString& dest );
  
  static QRect makeRect(const QPoint&, const QPoint&);
  static void growRect(QRect&, int);
  static void snapToGrid(QPoint& point, int gridSpacing);
  static void rotatePoint90Degccw(QPoint&);

  static void buildFrequencyVector( Vector& vector, 
				    TReal startFreq,
				    TReal stopFreq,
				    bool  linear );

  static void findParametersInData( TReal frequency,
				    QList<DataPoint>& data,
				    Matrix& matrix );

  static void convertZtoS( Matrix& z, Matrix& zo, Matrix& s );
  static void convertStoZ( Matrix& z, Matrix& zo, Matrix& s );
  static void convertStoY( Matrix& s, Matrix& zo, Matrix& y );

  static TReal stern( Matrix &z, TComplex& z1, TComplex &z2 );
  static TReal linvill( Matrix &y );

  static TReal getNumericRangePart( QString str, int pos );

 private:
  Utils();  //forbidden
};

#endif
